from cc3d.core.PySteppables import *
import parameters as p
import numpy as np

class falling_cellSteppable(SteppableBasePy):

    def __init__(self,frequency=1):
        SteppableBasePy.__init__(self,frequency)

    def start(self):
        # make some graphs of position, velocity, ...
        self.plot_win1 = self.add_new_plot_window(title='Position',grid=False, 
                            x_axis_title='MonteCarlo Step (MCS)',
                            y_axis_title='Height', x_scale_type='linear', y_scale_type='linear')
        self.plot_win1.add_plot("Pos", style='Lines', color='red', size=2)
        
        self.plot_win2 = self.add_new_plot_window(title='Velocity',grid=False, 
                            x_axis_title='MonteCarlo Step (MCS)',
                            y_axis_title='Velocity (pix/mcs)', x_scale_type='linear', y_scale_type='linear')
        self.plot_win2.add_plot("avgVel", style='Lines', color='blue',  size=2)
        self.plot_win2.add_plot("Vel",    style='Lines', color='green', size=2)
        
        # np array to hold the history of the cell's position
        self.pos=np.zeros(100000)
        self.vel=np.zeros(100000)
        
        # intial forces on the cell
        for cell in self.cell_list:
            cell.lambdaVecX = p.xForce
            cell.lambdaVecY = p.yForce  # force component pointing along Y axis - towards negative Y's
            cell.lambdaVecZ = p.zForce

        
    def step(self,mcs):
        # iterating over all cells in simulation        
        for cell in self.cell_list:
            # log the cell's current position and velocity 
            self.pos[mcs]=cell.yCOM
            self.vel[mcs]=self.pos[mcs] - self.pos[mcs-1]
            if mcs % 50 == 0:
                for cell in self.cell_list:
                    # arguments are (name of the data series, x, y)
                    self.plot_win1.add_data_point("Pos", mcs, cell.yCOM)  # plot the cell's position on the graph
                    if mcs >= 500:
                        self.plot_win2.add_data_point("avgVel", mcs, (cell.yCOM - p.startYcom)/mcs) # plot the cell's averagae velocity
                        # average velocity over last 500 mcs
                        av=np.average(self.vel[mcs-499:mcs+1])
                        self.plot_win2.add_data_point("Vel", mcs, av)  # plot the cell's recent velocity
                if cell.yCOM < 5:  
                    self.stop_simulation()   # stop when the cell hits the floor

            # Make sure ExternalPotential plugin is loaded
            # Treating the CC3D "force" as an equation of motion. 
            # A CC3D "force" creates a constant cell velocity (assuming nothing is in the cell's way)
            # To get the cell to accelerate as it falls need to increase the CC3D "force". 
            # CC3D_force = CC3D_force + acceleration  (e.g., Gravity
            # velocity  =  velocty    + acceleration*dt
            cell.lambdaVecY = cell.lambdaVecY + p.acceleration  # force component pointing along Y axis - towards negative Y's

