'''
Parameters for the falling cell simulation
jps Sept 2020

This demonstrates that a constant CC3D "force" gives a constant cell velocity.
A varying "force" is required to get the cell to accelerate like it would in free fall.
For the second case, to model hitting something, the "force" could need to be zeroed when a collision occurred.

COM = center of mass
'''

modelXdim = 100  # width of the C3D model in pixels
modelYdim = 1000 # height of the C3D model in pixels

cellRad = 10  # cell radius in pixels  
startYcom = int(modelYdim - cellRad - 30)  # starting position of the cell's COM in the CC3D model

xForce = 0.0 # initial force in the -X direction
zForce = 0.0 # initial force in the -Z direction

model_type = 'constant'  # pick one or the other
model_type = 'accelerate'

if model_type == 'constant':
    # demonstrate a constant "CC3D force" on a the cell gives a constant velocity
    # this gives a position versus time (mcs) plot that is linear and the cell has a constant (though noisy) velocity
    yForce = 2.0 # initial force in the -Y direction 
    acceleration = 0.0 # per mcs
elif model_type == 'accelerate':
    # demonstrate an increasing "CC3D force" on a the cell needed to give an accelerating cell velocity
    # this gives a position versus time (mcs) plot that is not linear and the velocity of the cell increases.
    yForce = 0.0 # initial force in the -Y direction   1
    acceleration = 1e-4  # per mcs

