def configure_simulation():

    from cc3d.core.XMLUtils import ElementCC3D
    import parameters as p  #####  parameters for this simulation are in this file
    
    CompuCell3DElmnt=ElementCC3D("CompuCell3D",{"Revision":"20200815","Version":"4.2.3"})
    
    MetadataElmnt=CompuCell3DElmnt.ElementCC3D("Metadata")
    # Basic properties simulation
    MetadataElmnt.ElementCC3D("NumberOfProcessors",{},"4")
    MetadataElmnt.ElementCC3D("DebugOutputFrequency",{},"500")
    # MetadataElmnt.ElementCC3D("NonParallelModule",{"Name":"Potts"})
    
    PottsElmnt=CompuCell3DElmnt.ElementCC3D("Potts")
    # Basic properties of CPM (GGH) algorithm
    PottsElmnt.ElementCC3D("Dimensions",{"x":p.modelXdim,"y":p.modelYdim,"z":"1"})
    PottsElmnt.ElementCC3D("Steps",{},"100000")
    PottsElmnt.ElementCC3D("Temperature",{},"10.0")
    PottsElmnt.ElementCC3D("NeighborOrder",{},"1")
    
    PluginElmnt=CompuCell3DElmnt.ElementCC3D("Plugin",{"Name":"CellType"})
    # Listing all cell types in the simulation
    PluginElmnt.ElementCC3D("CellType",{"TypeId":"0","TypeName":"Medium"})
    PluginElmnt.ElementCC3D("CellType",{"TypeId":"1","TypeName":"acell"})
    
    PluginElmnt_1=CompuCell3DElmnt.ElementCC3D("Plugin",{"Name":"CenterOfMass"})  # Module tracking center of mass of each cell
    PluginElmnt_2=CompuCell3DElmnt.ElementCC3D("Plugin",{"Name":"PixelTracker"})  # Module tracking pixels of each cell
    PluginElmnt_3=CompuCell3DElmnt.ElementCC3D("Plugin",{"Name":"BoundaryPixelTracker"})# Module tracking boundary pixels of each cell
    PluginElmnt_3.ElementCC3D("NeighborOrder",{},"1")
    
    PluginElmnt_4=CompuCell3DElmnt.ElementCC3D("Plugin",{"Name":"Volume"})
    PluginElmnt_4.ElementCC3D("VolumeEnergyParameters",{"CellType":"acell","LambdaVolume":"2.0","TargetVolume":(p.cellRad*2)**2})

    PluginElmnt_5=CompuCell3DElmnt.ElementCC3D("Plugin",{"Name":"Surface"})
    PluginElmnt_5.ElementCC3D("SurfaceEnergyParameters",{"CellType":"acell","LambdaSurface":"0.5","TargetSurface":(p.cellRad*2)*4})

    PluginElmnt_6=CompuCell3DElmnt.ElementCC3D("Plugin",{"Name":"ExternalPotential"})
    # External force applied to cell. Each cell type has different force.
    # For more flexible specification of the constraint (done in Python) please use ExternalPotential plugin without specifying per-type parameters
    # Algorithm options are: PixelBased, CenterOfMassBased
    PluginElmnt_6.ElementCC3D("Algorithm",{},"PixelBased")
    ###PluginElmnt_1.ElementCC3D("ExternalPotentialParameters",{"CellType":"acell","x":p.xForce,"y":p.yForce,"z":"0.0"})

    SteppableElmnt1=CompuCell3DElmnt.ElementCC3D("Steppable",{"Type":"BlobInitializer"})
    # Initial layout of cells in the form of spherical (circular in 2D) blob
    RegionElmnt1=SteppableElmnt1.ElementCC3D("Region")
    RegionElmnt1.ElementCC3D("Center",{"x":int(p.modelXdim/2 - p.cellRad),"y":p.startYcom,"z":"0"})
    RegionElmnt1.ElementCC3D("Radius",{},p.cellRad)
    RegionElmnt1.ElementCC3D("Gap",{},"0")
    RegionElmnt1.ElementCC3D("Width",{},2*p.cellRad-1)
    RegionElmnt1.ElementCC3D("Types",{},"acell")

    CompuCellSetup.setSimulationXMLDescription(CompuCell3DElmnt)    
            
from cc3d import CompuCellSetup

configure_simulation()            
            
from falling_cellSteppables import falling_cellSteppable
CompuCellSetup.register_steppable(steppable=falling_cellSteppable(frequency=1))

CompuCellSetup.run()
