
def configureSimulation(sim):
    import CompuCellSetup
    from XMLUtils import ElementCC3D
    
    CompuCell3DElmnt=ElementCC3D("CompuCell3D",{"Revision":"20160414","Version":"3.7.5"})
    
    PottsElmnt=CompuCell3DElmnt.ElementCC3D("Potts")
    
    # Basic properties of CPM (GGH) algorithm
    PottsElmnt.ElementCC3D("Dimensions",{"x":"200","y":"500","z":"1"})
    PottsElmnt.ElementCC3D("Steps",{},"10000")
    PottsElmnt.ElementCC3D("Temperature",{},"10.0")
    PottsElmnt.ElementCC3D("NeighborOrder",{},"3")
    #md=CompuCe.ElementCC3D("Metadata")
    #md.ElementCC3D("NumberOfProcessors",{},4)
   
    
    PluginElmnt=CompuCell3DElmnt.ElementCC3D("Plugin",{"Name":"CellType"})
    
    # Listing all cell types in the simulation
    PluginElmnt.ElementCC3D("CellType",{"TypeId":"0","TypeName":"Medium"})
    PluginElmnt.ElementCC3D("CellType",{"TypeId":"1","TypeName":"normal"})
    
    CompuCell3DElmnt.ElementCC3D("Plugin",{"Name":"Volume"})
    
    PluginElmnt_1=CompuCell3DElmnt.ElementCC3D("Plugin",{"Name":"CenterOfMass"})
    
    # Module tracking center of mass of each cell
    
    PluginElmnt_2=CompuCell3DElmnt.ElementCC3D("Plugin",{"Name":"NeighborTracker"})
    
    # Module tracking neighboring cells of each cell
    
    PluginElmnt_3=CompuCell3DElmnt.ElementCC3D("Plugin",{"Name":"Contact"})
    # Specification of adhesion energies
    PluginElmnt_3.ElementCC3D("Energy",{"Type1":"Medium","Type2":"Medium"},"10.0")
    PluginElmnt_3.ElementCC3D("Energy",{"Type1":"Medium","Type2":"normal"},"10.0")
    PluginElmnt_3.ElementCC3D("Energy",{"Type1":"normal","Type2":"normal"},"10.0")
    PluginElmnt_3.ElementCC3D("NeighborOrder",{},"1")
    
    PluginElmnt_4=CompuCell3DElmnt.ElementCC3D("Plugin",{"Name":"FocalPointPlasticity"})
    
    # Specification of focal point junctions
    # We separetely specify links between members of same cluster - InternalParameters and members of different clusters Parameters. When not using compartmental  cells comment out InternalParameters specification
    # To modify FPP links individually for each cell pair uncomment line below
    # PluginElmnt_4.ElementCC3D("Local")
    # Note that even though you may manipulate lambdaDistance, targetDistance and maxDistance using Python you still need to set activation energy from XML level
    # See CC3D manual for details on FPP plugin 
    
    ParametersElmnt=PluginElmnt_4.ElementCC3D("Parameters",{"Type1":"normal","Type2":"normal"})
    ParametersElmnt.ElementCC3D("Lambda",{},"10")
    ParametersElmnt.ElementCC3D("ActivationEnergy",{},"-50")
    ParametersElmnt.ElementCC3D("TargetDistance",{},"7")
    ParametersElmnt.ElementCC3D("MaxDistance",{},"20")
    ParametersElmnt.ElementCC3D("MaxNumberOfJunctions",{"NeighborOrder":"1"},"0")
    #fppLaw=PluginElmnt_4.ElementCC3D("LinkConstituentLaw",{})

    #fppLaw.ElementCC3D("Expression",{},"Lambda*abs(Length-TargetLength)")
   
    
    PluginElmnt_4.ElementCC3D("NeighborOrder",{},"1")
    
    SteppableElmnt=CompuCell3DElmnt.ElementCC3D("Steppable",{"Type":"BlobInitializer"})
    
    # Initial layout of cells in the form of spherical (circular in 2D) blob
    RegionElmnt=SteppableElmnt.ElementCC3D("Region")
    RegionElmnt.ElementCC3D("Center",{"x":"100","y":"250","z":"0"})
    RegionElmnt.ElementCC3D("Radius",{},"50")
    RegionElmnt.ElementCC3D("Gap",{},"0")
    RegionElmnt.ElementCC3D("Width",{},"10")
    RegionElmnt.ElementCC3D("Types",{},"normal")

    bwpd=CompuCell3DElmnt.ElementCC3D("Steppable",{"Type":"BoxWatcher"})
    bwpd.ElementCC3D("XMargin",{},2)
    bwpd.ElementCC3D("YMargin",{},2)
    bwpd.ElementCC3D("ZMargin",{},2)
   
    
    CompuCellSetup.setSimulationXMLDescription(CompuCell3DElmnt)    
    
    

            
    CompuCellSetup.setSimulationXMLDescription(CompuCell3DElmnt)
            
import sys
from os import environ
from os import getcwd
import string

sys.path.append(environ["PYTHON_MODULE_PATH"])


import CompuCellSetup


sim,simthread = CompuCellSetup.getCoreSimulationObjects()
        
configureSimulation(sim)            
                
# add extra attributes here
            
CompuCellSetup.initializeSimulationObjects(sim,simthread)
# Definitions of additional Python-managed fields go here
        
#Add Python steppables here
steppableRegistry=CompuCellSetup.getSteppableRegistry()
        
from blob_convergeSteppables import blob_convergeSteppable
steppableInstance=blob_convergeSteppable(sim,_frequency=1)
steppableRegistry.registerSteppable(steppableInstance)
        
CompuCellSetup.mainLoop(sim,simthread,steppableRegistry)
        
        