
from PySteppables import *
import CompuCell
import sys
import random
from math import sqrt
class blob_convergeSteppable(SteppableBasePy):    

    def __init__(self,_simulator,_frequency=1):
        SteppableBasePy.__init__(self,_simulator,_frequency)
    def start(self):
        self.maxLinks=3
        self.link_lifetime=10.0
        self.link_num=2.0
        self.link_create=self.link_num/self.link_lifetime
        self.link_kill=1.0/self.link_lifetime
        self.cos_theta_range=1.0#equal to 1 implies 45 degrees, less than 1 implies narrow angle
        #any code in the start function runs before MCS=0
        for cell in self.cellList:
            cell.targetVolume=100
            cell.lambdaVolume=5.0
            
        self.pW=self.addNewPlotWindow(_title='# of links',_xAxisTitle='MonteCarlo Step (MCS)',_yAxisTitle='Variables', _xScaleType='linear',_yScaleType='linear')
        self.pW.addPlot('nlinks',_style='Dots',_color='red',_size=5)
        
        
        self.pW1=self.addNewPlotWindow(_title='xhigh',_xAxisTitle='MonteCarlo Step (MCS)',_yAxisTitle='Variables', _xScaleType='linear',_yScaleType='linear')
        self.pW1.addPlot('xheight',_style='Dots',_color='red',_size=5)
        self.pW1.addPlot('yheight',_style='Dots',_color='blue',_size=5)
        
        
        self.pW2=self.addNewPlotWindow(_title='aspect',_xAxisTitle='MonteCarlo Step (MCS)',_yAxisTitle='Variables', _xScaleType='linear',_yScaleType='linear')
        
        self.pW2.addPlot('aspect_rat',_style='Dots',_color='black',_size=5)
    def step(self,mcs):        
        
        for cell in self.cellList:
            for neighbor , commonSurfaceArea in self.getCellNeighborDataList(cell):                
                if neighbor:
                    #get center of mass
                    xdist=abs(cell.xCOM-neighbor.xCOM)    
                    ydist=abs(cell.yCOM-neighbor.yCOM)
                    dist=max(sqrt(xdist**2+ydist**2),10)
                    if(ydist<self.cos_theta_range*xdist):
                        
                            if(random.random()<self.link_create):
                                self.focalPointPlasticityPlugin.createFocalPointPlasticityLink(cell,neighbor,60,dist-5.0,200)
                                # Make sure FocalPointPlacticity plugin is loaded
                                #visiting all focal links cell 'cell' has with other cells
                                
        self.nlinks_2=0
        for cell in self.cellList:
            for fppd in self.getFocalPointPlasticityDataList(cell):
                if(random.random()<self.link_kill):
                    self.focalPointPlasticityPlugin.deleteFocalPointPlasticityLink(cell,fppd.neighborAddress)		
                else:
                    self.nlinks_2+=1
        self.nlinks_2/=2.0        
                
        self.pW.addDataPoint("nlinks",mcs,self.nlinks_2) # arguments are (name of the data series, x, y)
                                
        ymin=self.dim.y
        ymax=0
        
        xmin=self.dim.x
        xmax=0
        for cell in self.cellList:
            ymax=max(ymax,cell.yCOM)    
            ymin=min(ymin,cell.yCOM)
            xmax=max(xmax,cell.xCOM)
            xmin=min(xmin,cell.xCOM)
        
        ylen=ymax-ymin
        xlen=xmax-xmin
        aspect=1.0*ylen/(xlen)
        self.pW1.addDataPoint("xheight",mcs,xlen)    
        self.pW1.addDataPoint("yheight",mcs,ylen)
        self.pW2.addDataPoint("aspect_rat",mcs,aspect)
        
    def finish(self):
        # Finish Function gets called after the last MCS
        pass
        