<?xml version="1.0" encoding="UTF-8"?>
<!-- generated with COPASI 4.16 (Build 104) (http://www.copasi.org) at 2017-07-28 21:32:37 UTC -->
<?oxygen RNGSchema="http://www.copasi.org/static/schema/CopasiML.rng" type="xml"?>
<COPASI xmlns="http://www.copasi.org/static/schema" versionMajor="4" versionMinor="16" versionDevel="104" copasiSourcesModified="0">
  <ListOfFunctions>
    <Function key="Function_13" name="Mass action (irreversible)" type="MassAction" reversible="false">
      <MiriamAnnotation>
<rdf:RDF xmlns:CopasiMT="http://www.copasi.org/RDF/MiriamTerms#" xmlns:dcterms="http://purl.org/dc/terms/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#">
   <rdf:Description rdf:about="#Function_13">
   <CopasiMT:is rdf:resource="urn:miriam:obo.sbo:SBO:0000041" />
   </rdf:Description>
   </rdf:RDF>
      </MiriamAnnotation>
      <Comment>
        <body xmlns="http://www.w3.org/1999/xhtml">
<b>Mass action rate law for first order irreversible reactions</b>
<p>
Reaction scheme where the products are created from the reactants and the change of a product quantity is proportional to the product of reactant activities. The reaction scheme does not include any reverse process that creates the reactants from the products. The change of a product quantity is proportional to the quantity of one reactant.
</p>
</body>
      </Comment>
      <Expression>
        k1*PRODUCT&lt;substrate_i&gt;
      </Expression>
      <ListOfParameterDescriptions>
        <ParameterDescription key="FunctionParameter_81" name="k1" order="0" role="constant"/>
        <ParameterDescription key="FunctionParameter_79" name="substrate" order="1" role="substrate"/>
      </ListOfParameterDescriptions>
    </Function>
    <Function key="Function_40" name="Function for J01" type="UserDefined" reversible="false">
      <MiriamAnnotation>
<rdf:RDF xmlns:dcterms="http://purl.org/dc/terms/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <rdf:Description rdf:about="#Function_40">
    <dcterms:created>
      <rdf:Description>
        <dcterms:W3CDTF>2017-07-28T16:13:09Z</dcterms:W3CDTF>
      </rdf:Description>
    </dcterms:created>
  </rdf:Description>
</rdf:RDF>
      </MiriamAnnotation>
      <Expression>
        QGut/VArt*(CArt*VArt)
      </Expression>
      <ListOfParameterDescriptions>
        <ParameterDescription key="FunctionParameter_258" name="CArt" order="0" role="substrate"/>
        <ParameterDescription key="FunctionParameter_264" name="QGut" order="1" role="constant"/>
        <ParameterDescription key="FunctionParameter_254" name="VArt" order="2" role="volume"/>
      </ListOfParameterDescriptions>
    </Function>
    <Function key="Function_41" name="Function for J02" type="UserDefined" reversible="false">
      <MiriamAnnotation>
<rdf:RDF xmlns:dcterms="http://purl.org/dc/terms/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <rdf:Description rdf:about="#Function_41">
    <dcterms:created>
      <rdf:Description>
        <dcterms:W3CDTF>2017-07-28T16:13:10Z</dcterms:W3CDTF>
      </rdf:Description>
    </dcterms:created>
  </rdf:Description>
</rdf:RDF>
      </MiriamAnnotation>
      <Expression>
        kGutabs*(AGutlumen*VGutLumen)
      </Expression>
      <ListOfParameterDescriptions>
        <ParameterDescription key="FunctionParameter_262" name="AGutlumen" order="0" role="substrate"/>
        <ParameterDescription key="FunctionParameter_267" name="VGutLumen" order="1" role="volume"/>
        <ParameterDescription key="FunctionParameter_265" name="kGutabs" order="2" role="constant"/>
      </ListOfParameterDescriptions>
    </Function>
    <Function key="Function_42" name="Function for J03" type="UserDefined" reversible="false">
      <MiriamAnnotation>
<rdf:RDF xmlns:dcterms="http://purl.org/dc/terms/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <rdf:Description rdf:about="#Function_42">
    <dcterms:created>
      <rdf:Description>
        <dcterms:W3CDTF>2017-07-28T16:12:57Z</dcterms:W3CDTF>
      </rdf:Description>
    </dcterms:created>
  </rdf:Description>
</rdf:RDF>
      </MiriamAnnotation>
      <Expression>
        QCardiac/VLung*(CLung*VLung)
      </Expression>
      <ListOfParameterDescriptions>
        <ParameterDescription key="FunctionParameter_270" name="CLung" order="0" role="substrate"/>
        <ParameterDescription key="FunctionParameter_268" name="QCardiac" order="1" role="constant"/>
        <ParameterDescription key="FunctionParameter_246" name="VLung" order="2" role="volume"/>
      </ListOfParameterDescriptions>
    </Function>
    <Function key="Function_43" name="Function for J04" type="UserDefined" reversible="false">
      <MiriamAnnotation>
<rdf:RDF xmlns:dcterms="http://purl.org/dc/terms/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <rdf:Description rdf:about="#Function_43">
    <dcterms:created>
      <rdf:Description>
        <dcterms:W3CDTF>2017-07-28T16:13:12Z</dcterms:W3CDTF>
      </rdf:Description>
    </dcterms:created>
  </rdf:Description>
</rdf:RDF>
      </MiriamAnnotation>
      <Expression>
        QCardiac/VVen*(CVen*VVen)
      </Expression>
      <ListOfParameterDescriptions>
        <ParameterDescription key="FunctionParameter_273" name="CVen" order="0" role="substrate"/>
        <ParameterDescription key="FunctionParameter_271" name="QCardiac" order="1" role="constant"/>
        <ParameterDescription key="FunctionParameter_266" name="VVen" order="2" role="volume"/>
      </ListOfParameterDescriptions>
    </Function>
    <Function key="Function_44" name="Function for J06" type="UserDefined" reversible="false">
      <MiriamAnnotation>
<rdf:RDF xmlns:dcterms="http://purl.org/dc/terms/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <rdf:Description rdf:about="#Function_44">
    <dcterms:created>
      <rdf:Description>
        <dcterms:W3CDTF>2017-07-28T16:13:14Z</dcterms:W3CDTF>
      </rdf:Description>
    </dcterms:created>
  </rdf:Description>
</rdf:RDF>
      </MiriamAnnotation>
      <Expression>
        QRest/VRest*(CRest*VRest)*Ratioblood2plasma/(KRest2plasma*Fraction_unbound_plasma)
      </Expression>
      <ListOfParameterDescriptions>
        <ParameterDescription key="FunctionParameter_276" name="CRest" order="0" role="substrate"/>
        <ParameterDescription key="FunctionParameter_282" name="Fraction_unbound_plasma" order="1" role="constant"/>
        <ParameterDescription key="FunctionParameter_280" name="KRest2plasma" order="2" role="constant"/>
        <ParameterDescription key="FunctionParameter_274" name="QRest" order="3" role="constant"/>
        <ParameterDescription key="FunctionParameter_278" name="Ratioblood2plasma" order="4" role="constant"/>
        <ParameterDescription key="FunctionParameter_269" name="VRest" order="5" role="volume"/>
      </ListOfParameterDescriptions>
    </Function>
    <Function key="Function_45" name="Function for J07" type="UserDefined" reversible="false">
      <MiriamAnnotation>
<rdf:RDF xmlns:dcterms="http://purl.org/dc/terms/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <rdf:Description rdf:about="#Function_45">
    <dcterms:created>
      <rdf:Description>
        <dcterms:W3CDTF>2017-07-28T16:13:01Z</dcterms:W3CDTF>
      </rdf:Description>
    </dcterms:created>
  </rdf:Description>
</rdf:RDF>
      </MiriamAnnotation>
      <Expression>
        QLiver/VArt*(CArt*VArt)
      </Expression>
      <ListOfParameterDescriptions>
        <ParameterDescription key="FunctionParameter_275" name="CArt" order="0" role="substrate"/>
        <ParameterDescription key="FunctionParameter_283" name="QLiver" order="1" role="constant"/>
        <ParameterDescription key="FunctionParameter_279" name="VArt" order="2" role="volume"/>
      </ListOfParameterDescriptions>
    </Function>
    <Function key="Function_46" name="Function for J08" type="UserDefined" reversible="false">
      <MiriamAnnotation>
<rdf:RDF xmlns:dcterms="http://purl.org/dc/terms/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <rdf:Description rdf:about="#Function_46">
    <dcterms:created>
      <rdf:Description>
        <dcterms:W3CDTF>2017-07-28T16:13:03Z</dcterms:W3CDTF>
      </rdf:Description>
    </dcterms:created>
  </rdf:Description>
</rdf:RDF>
      </MiriamAnnotation>
      <Expression>
        CLmetabolism*(CLiver*VLiver)/(Kliver2plasma*Fraction_unbound_plasma)/VLiver
      </Expression>
      <ListOfParameterDescriptions>
        <ParameterDescription key="FunctionParameter_281" name="CLiver" order="0" role="substrate"/>
        <ParameterDescription key="FunctionParameter_272" name="CLmetabolism" order="1" role="constant"/>
        <ParameterDescription key="FunctionParameter_289" name="Fraction_unbound_plasma" order="2" role="constant"/>
        <ParameterDescription key="FunctionParameter_287" name="Kliver2plasma" order="3" role="constant"/>
        <ParameterDescription key="FunctionParameter_285" name="VLiver" order="4" role="volume"/>
      </ListOfParameterDescriptions>
    </Function>
    <Function key="Function_47" name="Function for J09" type="UserDefined" reversible="false">
      <Expression>
        QGut/VGut*(CGut*VGut)
      </Expression>
      <ListOfParameterDescriptions>
        <ParameterDescription key="FunctionParameter_277" name="CGut" order="0" role="substrate"/>
        <ParameterDescription key="FunctionParameter_290" name="QGut" order="1" role="constant"/>
        <ParameterDescription key="FunctionParameter_286" name="VGut" order="2" role="volume"/>
      </ListOfParameterDescriptions>
    </Function>
    <Function key="Function_48" name="Function for J10" type="UserDefined" reversible="false">
      <Expression>
        (QLiver+QGut)/VLiver*(CLiver*VLiver)*Ratioblood2plasma/(Kliver2plasma*Fraction_unbound_plasma)
      </Expression>
      <ListOfParameterDescriptions>
        <ParameterDescription key="FunctionParameter_295" name="CLiver" order="0" role="substrate"/>
        <ParameterDescription key="FunctionParameter_301" name="Fraction_unbound_plasma" order="1" role="constant"/>
        <ParameterDescription key="FunctionParameter_299" name="Kliver2plasma" order="2" role="constant"/>
        <ParameterDescription key="FunctionParameter_288" name="QGut" order="3" role="constant"/>
        <ParameterDescription key="FunctionParameter_291" name="QLiver" order="4" role="constant"/>
        <ParameterDescription key="FunctionParameter_297" name="Ratioblood2plasma" order="5" role="constant"/>
        <ParameterDescription key="FunctionParameter_293" name="VLiver" order="6" role="volume"/>
      </ListOfParameterDescriptions>
    </Function>
    <Function key="Function_49" name="Function for J11" type="UserDefined" reversible="false">
      <Expression>
        QKidney/VArt*(CArt*VArt)
      </Expression>
      <ListOfParameterDescriptions>
        <ParameterDescription key="FunctionParameter_294" name="CArt" order="0" role="substrate"/>
        <ParameterDescription key="FunctionParameter_302" name="QKidney" order="1" role="constant"/>
        <ParameterDescription key="FunctionParameter_298" name="VArt" order="2" role="volume"/>
      </ListOfParameterDescriptions>
    </Function>
    <Function key="Function_50" name="Function for J12" type="UserDefined" reversible="false">
      <Expression>
        Qgfr/VKidney*(CKidney*VKidney)/Kkidney2plasma
      </Expression>
      <ListOfParameterDescriptions>
        <ParameterDescription key="FunctionParameter_303" name="CKidney" order="0" role="substrate"/>
        <ParameterDescription key="FunctionParameter_305" name="Kkidney2plasma" order="1" role="constant"/>
        <ParameterDescription key="FunctionParameter_292" name="Qgfr" order="2" role="constant"/>
        <ParameterDescription key="FunctionParameter_300" name="VKidney" order="3" role="volume"/>
      </ListOfParameterDescriptions>
    </Function>
    <Function key="Function_51" name="Function for J13" type="UserDefined" reversible="false">
      <Expression>
        QKidney/VKidney*(CKidney*VKidney)*Ratioblood2plasma/(Kkidney2plasma*Fraction_unbound_plasma)
      </Expression>
      <ListOfParameterDescriptions>
        <ParameterDescription key="FunctionParameter_307" name="CKidney" order="0" role="substrate"/>
        <ParameterDescription key="FunctionParameter_313" name="Fraction_unbound_plasma" order="1" role="constant"/>
        <ParameterDescription key="FunctionParameter_311" name="Kkidney2plasma" order="2" role="constant"/>
        <ParameterDescription key="FunctionParameter_306" name="QKidney" order="3" role="constant"/>
        <ParameterDescription key="FunctionParameter_309" name="Ratioblood2plasma" order="4" role="constant"/>
        <ParameterDescription key="FunctionParameter_284" name="VKidney" order="5" role="volume"/>
      </ListOfParameterDescriptions>
    </Function>
  </ListOfFunctions>
  <Model key="Model_4" name="Sluka2015_Acetaminophen_PBPK" simulationType="time" timeUnit="h" volumeUnit="l" areaUnit="m²" lengthUnit="m" quantityUnit="mol" type="deterministic" avogadroConstant="6.02214179e+023">
    <MiriamAnnotation>
<rdf:RDF
   xmlns:CopasiMT="http://www.copasi.org/RDF/MiriamTerms#"
   xmlns:dcterms="http://purl.org/dc/terms/"
   xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
   xmlns:vCard="http://www.w3.org/2001/vcard-rdf/3.0#">
  <rdf:Description rdf:about="#Model_4">
    <dcterms:bibliographicCitation>
      <rdf:Bag>
        <rdf:li>
          <rdf:Description>
            <CopasiMT:isDescribedBy rdf:resource="http://identifiers.org/pubmed/20421935"/>
          </rdf:Description>
        </rdf:li>
      </rdf:Bag>
    </dcterms:bibliographicCitation>
    <dcterms:created>
      <rdf:Description>
        <dcterms:W3CDTF>2015-02-04T11:47:58Z</dcterms:W3CDTF>
      </rdf:Description>
    </dcterms:created>
    <dcterms:creator>
      <rdf:Bag>
        <rdf:li>
          <rdf:Description>
            <vCard:EMAIL>jsluka@indiana.edu</vCard:EMAIL>
            <vCard:N>
              <rdf:Description>
                <vCard:Family>Sluka</vCard:Family>
                <vCard:Given>James</vCard:Given>
              </rdf:Description>
            </vCard:N>
            <vCard:ORG>
              <rdf:Description>
                <vCard:Orgname>Indiana University</vCard:Orgname>
              </rdf:Description>
            </vCard:ORG>
          </rdf:Description>
        </rdf:li>
        <rdf:li>
          <rdf:Description>
            <vCard:EMAIL>fuxiao@umail.iu.edu</vCard:EMAIL>
            <vCard:N>
              <rdf:Description>
                <vCard:Family>Fu</vCard:Family>
                <vCard:Given>Xiao</vCard:Given>
              </rdf:Description>
            </vCard:N>
            <vCard:ORG>
              <rdf:Description>
                <vCard:Orgname>Indiana University</vCard:Orgname>
              </rdf:Description>
            </vCard:ORG>
          </rdf:Description>
        </rdf:li>
      </rdf:Bag>
    </dcterms:creator>
    <dcterms:modified>
      <rdf:Description>
        <dcterms:W3CDTF>2015-02-12T14:04:44Z</dcterms:W3CDTF>
      </rdf:Description>
    </dcterms:modified>
    <CopasiMT:is>
      <rdf:Bag>
        <rdf:li rdf:resource="http://identifiers.org/ncit/C15967"/>
      </rdf:Bag>
    </CopasiMT:is>
    <CopasiMT:is>
      <rdf:Bag>
        <rdf:li rdf:resource="http://identifiers.org/ncit/C54386"/>
      </rdf:Bag>
    </CopasiMT:is>
  </rdf:Description>
</rdf:RDF>

    </MiriamAnnotation>
    <Comment>
      <body xmlns="http://www.w3.org/1999/xhtml">
    <h1>Basic PBPK (Physiologically Based PharmacoKinetic) model of Acetaminophen.</h1>
    <p>This is a basic model of Acetaminophen (APAP, Paracetamol) pharmacokinetics in humans. Many of the model parameters 
            (compartment volumes, volumetric flow rates, etc.) are scaled allometrically based on the body weight (BW) raised to the
			3/4 power. Because of that, the assigned values of many of the parameters are recalculated at run time and are different 
			than the default values for the particular entity (e.g., the volume of a compartment and the volumetric flow rate between compartments).</p>
    <p>APAP dose is initially given in grams (APAP_Dose_gram), which is converted to moles via the APAP molecular weight (APAP_MW).
			APAP quantities throughout the rest of the models are given in moles.</p>
    <p>The base parameters are for a 70Kg human and a pharmacological oral dose of 1.4 gram of APAP. Metabolism is modelled as a single ODE in the liver compartment and the metabolite does not leave that compartment.</p>
    <p>This model is loosely based on the model of Wambaugh and Shaw (PLoS Comput Biol. 2010 Apr 22;6(4):e1000756. doi: 10.1371/journal.pcbi.1000756. Pubmed ID: PMID- 20421935) with the following changes:</p>
    <ol>
      <li>The lung lumen compartment was omitted.</li>
      <li>A kidney compartment was added.</li>
      <li>Glomerular Filtration is from the kidney compartment.</li>
      <li>The APAP dose was changed to 1.4g.</li>
      <li>The gut adsorption rate constant (KGutabs),  tissue partition coefficients and liver metabolism rate constant (CLmetabolism) were fit using the human        <i>in vivo</i>
            data of Critchley (Critchley, J. A., Critchley, L. A. H., Anderson, P. J., and Tomlinson, B. 2005  Journal of clinical pharmacy and therapeutics, 30(2), 179-184).        </li>
    <li>
      <b>To model the extensive re-adsorption of APAP from the kidney tubules back into the blood the QGfr value is modified. This was done by 
				changing the scaling parameter QGFR_ref value from 0.31 to 0.039, resulting in a decrease in the QGfr value of 8 fold (from 7.2 L/hr to 0.91 L/hr).</b>
    </li>
  </ol>
  <p>The parameters in this file are the      <b>REFSIM</b>
          parameters from our publication.      </p>
</body>
    </Comment>
    <ListOfCompartments>
      <Compartment key="Compartment_1" name="VArt" simulationType="fixed" dimensionality="3">
        <MiriamAnnotation>
<rdf:RDF xmlns:CopasiMT="http://www.copasi.org/RDF/MiriamTerms#" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <rdf:Description rdf:about="#Compartment_1">
    <CopasiMT:is>
      <rdf:Bag>
        <rdf:li rdf:resource="http://identifiers.org/ncit/C78729" />
        <rdf:li rdf:resource="http://identifiers.org/obo.fma/FMA:83066" />
      </rdf:Bag>
    </CopasiMT:is>
  </rdf:Description>
</rdf:RDF>
        </MiriamAnnotation>
        <Comment>
          <body xmlns="http://www.w3.org/1999/xhtml">
    <p>Volume of the arterial blood. Note that this value is modified by allometric scaling in an initial 
				assignment or rule equation.</p>
  </body>
        </Comment>
        <InitialExpression>
          &lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[VTotal],Reference=InitialValue&gt;*&lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[VArt_fraction_VTotal],Reference=InitialValue&gt;
        </InitialExpression>
      </Compartment>
      <Compartment key="Compartment_3" name="VGut" simulationType="fixed" dimensionality="3">
        <MiriamAnnotation>
<rdf:RDF xmlns:CopasiMT="http://www.copasi.org/RDF/MiriamTerms#" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <rdf:Description rdf:about="#Compartment_3">
    <CopasiMT:is>
      <rdf:Bag>
        <rdf:li rdf:resource="http://identifiers.org/obo.fma/FMA%3A7199" />
      </rdf:Bag>
    </CopasiMT:is>
  </rdf:Description>
</rdf:RDF>
        </MiriamAnnotation>
        <Comment>
          <body xmlns="http://www.w3.org/1999/xhtml">
    <p>Perfusable volume of the Gut (small intestine). 
				The compartment volume is allometrically scaled and is assigned in an initialAssignment.</p>
  </body>
        </Comment>
        <InitialExpression>
          &lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[VTotal],Reference=InitialValue&gt;*&lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[VGut_fraction_VTotal],Reference=InitialValue&gt;
        </InitialExpression>
      </Compartment>
      <Compartment key="Compartment_5" name="VGutLumen" simulationType="fixed" dimensionality="3">
        <MiriamAnnotation>
<rdf:RDF xmlns:CopasiMT="http://www.copasi.org/RDF/MiriamTerms#" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <rdf:Description rdf:about="#Compartment_5">
    <CopasiMT:is>
      <rdf:Bag>
        <rdf:li rdf:resource="http://identifiers.org/obo.fma/FMA%3A45677" />
      </rdf:Bag>
    </CopasiMT:is>
  </rdf:Description>
</rdf:RDF>
        </MiriamAnnotation>
        <Comment>
          <body xmlns="http://www.w3.org/1999/xhtml">
    <p>Lumen of the Gut. Note that the volume is arbitrary.</p>
  </body>
        </Comment>
      </Compartment>
      <Compartment key="Compartment_7" name="VLung" simulationType="fixed" dimensionality="3">
        <MiriamAnnotation>
<rdf:RDF xmlns:CopasiMT="http://www.copasi.org/RDF/MiriamTerms#" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <rdf:Description rdf:about="#Compartment_7">
    <CopasiMT:is>
      <rdf:Bag>
        <rdf:li rdf:resource="http://identifiers.org/obo.fma/FMA%3A7195" />
      </rdf:Bag>
    </CopasiMT:is>
  </rdf:Description>
</rdf:RDF>
        </MiriamAnnotation>
        <Comment>
          <body xmlns="http://www.w3.org/1999/xhtml">
    <p>Perfusable volume of the Lungs.
				The compartment volume is allometrically scaled and is assigned in an initialAssignment.</p>
  </body>
        </Comment>
        <InitialExpression>
          &lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[VTotal],Reference=InitialValue&gt;*&lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[VLung_fraction_VTotal],Reference=InitialValue&gt;
        </InitialExpression>
      </Compartment>
      <Compartment key="Compartment_9" name="VVen" simulationType="fixed" dimensionality="3">
        <MiriamAnnotation>
<rdf:RDF xmlns:CopasiMT="http://www.copasi.org/RDF/MiriamTerms#" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <rdf:Description rdf:about="#Compartment_9">
    <CopasiMT:is>
      <rdf:Bag>
        <rdf:li rdf:resource="http://identifiers.org/ncit/C78730" />
        <rdf:li rdf:resource="http://identifiers.org/obo.fma/FMA%3A83067" />
      </rdf:Bag>
    </CopasiMT:is>
  </rdf:Description>
</rdf:RDF>
        </MiriamAnnotation>
        <Comment>
          <body xmlns="http://www.w3.org/1999/xhtml">
    <p>Volume of the venous blood.
				The compartment volume is allometrically scaled and is assigned in an initialAssignment.</p>
  </body>
        </Comment>
        <InitialExpression>
          &lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[VTotal],Reference=InitialValue&gt;*&lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[VVen_fraction_VTotal],Reference=InitialValue&gt;
        </InitialExpression>
      </Compartment>
      <Compartment key="Compartment_11" name="VRest" simulationType="fixed" dimensionality="3">
        <MiriamAnnotation>
<rdf:RDF xmlns:CopasiMT="http://www.copasi.org/RDF/MiriamTerms#" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <rdf:Description rdf:about="#Compartment_11">
    <CopasiMT:is>
      <rdf:Bag>
        <rdf:li rdf:resource="http://identifiers.org/obo.fma/FMA%3A20394" />
      </rdf:Bag>
    </CopasiMT:is>
  </rdf:Description>
</rdf:RDF>
        </MiriamAnnotation>
        <Comment>
          <body xmlns="http://www.w3.org/1999/xhtml">
    <p>Perfusable volume of the Rest of the body, that is, all tissues and blood volumes not 
				explicitly described by other compartments.
				The compartment volume is allometrically scaled and is assigned in an initialAssignment.</p>
  </body>
        </Comment>
        <InitialExpression>
          &lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[VTotal],Reference=InitialValue&gt;-&lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Compartments[VArt],Reference=InitialVolume&gt;-&lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Compartments[VGut],Reference=InitialVolume&gt;-&lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Compartments[VKidney],Reference=InitialVolume&gt;-&lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Compartments[VLiver],Reference=InitialVolume&gt;-&lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Compartments[VLung],Reference=InitialVolume&gt;-&lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Compartments[VVen],Reference=InitialVolume&gt;
        </InitialExpression>
      </Compartment>
      <Compartment key="Compartment_13" name="VLiver" simulationType="fixed" dimensionality="3">
        <MiriamAnnotation>
<rdf:RDF xmlns:CopasiMT="http://www.copasi.org/RDF/MiriamTerms#" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <rdf:Description rdf:about="#Compartment_13">
    <CopasiMT:is>
      <rdf:Bag>
        <rdf:li rdf:resource="http://identifiers.org/obo.fma/FMA%3A7197" />
      </rdf:Bag>
    </CopasiMT:is>
  </rdf:Description>
</rdf:RDF>
        </MiriamAnnotation>
        <Comment>
          <body xmlns="http://www.w3.org/1999/xhtml">
    <p>Perfusable volume of the Liver.
				The compartment volume is allometrically scaled and is assigned in an initialAssignment.</p>
  </body>
        </Comment>
        <InitialExpression>
          &lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[VTotal],Reference=InitialValue&gt;*&lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[VLiver_fraction_VTotal],Reference=InitialValue&gt;
        </InitialExpression>
      </Compartment>
      <Compartment key="Compartment_15" name="VKidney" simulationType="fixed" dimensionality="3">
        <MiriamAnnotation>
<rdf:RDF xmlns:CopasiMT="http://www.copasi.org/RDF/MiriamTerms#" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <rdf:Description rdf:about="#Compartment_15">
    <CopasiMT:is>
      <rdf:Bag>
        <rdf:li rdf:resource="http://identifiers.org/obo.fma/FMA%3A7203" />
      </rdf:Bag>
    </CopasiMT:is>
  </rdf:Description>
</rdf:RDF>
        </MiriamAnnotation>
        <Comment>
          <body xmlns="http://www.w3.org/1999/xhtml">
    <p>Perfusable volume of the Kidney.
		        The compartment volume is allometrically scaled and is assigned in an initialAssignment.</p>
  </body>
        </Comment>
        <InitialExpression>
          &lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[VTotal],Reference=InitialValue&gt;*&lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[VKidney_fraction_VTotal],Reference=InitialValue&gt;
        </InitialExpression>
      </Compartment>
      <Compartment key="Compartment_17" name="VKidneyTubules" simulationType="fixed" dimensionality="3">
        <MiriamAnnotation>
<rdf:RDF xmlns:CopasiMT="http://www.copasi.org/RDF/MiriamTerms#" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <rdf:Description rdf:about="#Compartment_17">
    <CopasiMT:is>
      <rdf:Bag>
        <rdf:li rdf:resource="http://identifiers.org/obo.fma/FMA%3A15627" />
      </rdf:Bag>
    </CopasiMT:is>
  </rdf:Description>
</rdf:RDF>
        </MiriamAnnotation>
        <Comment>
          <body xmlns="http://www.w3.org/1999/xhtml">
    <p>Kidney (renal) Tubules (lumen). This, like the gut lumen, is treated as a volumeless compartment.</p>
  </body>
        </Comment>
      </Compartment>
    </ListOfCompartments>
    <ListOfMetabolites>
      <Metabolite key="Metabolite_1" name="CArt" simulationType="reactions" compartment="Compartment_1">
        <MiriamAnnotation>
<rdf:RDF xmlns:CopasiMT="http://www.copasi.org/RDF/MiriamTerms#" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <rdf:Description rdf:about="#Metabolite_1">
    <CopasiMT:is>
      <rdf:Bag>
        <rdf:li rdf:resource="http://identifiers.org/obo.chebi/CHEBI%3A46195" />
      </rdf:Bag>
    </CopasiMT:is>
  </rdf:Description>
</rdf:RDF>
        </MiriamAnnotation>
        <Comment>
          <body xmlns="http://www.w3.org/1999/xhtml">
    <p>Amount of APAP in the arteries of the gut in moles.</p>
  </body>
        </Comment>
      </Metabolite>
      <Metabolite key="Metabolite_3" name="CGut" simulationType="reactions" compartment="Compartment_3">
        <MiriamAnnotation>
<rdf:RDF xmlns:CopasiMT="http://www.copasi.org/RDF/MiriamTerms#" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <rdf:Description rdf:about="#Metabolite_3">
    <CopasiMT:is>
      <rdf:Bag>
        <rdf:li rdf:resource="http://identifiers.org/obo.chebi/CHEBI%3A46195" />
      </rdf:Bag>
    </CopasiMT:is>
  </rdf:Description>
</rdf:RDF>
        </MiriamAnnotation>
        <Comment>
          <body xmlns="http://www.w3.org/1999/xhtml">
    <p>Amount of APAP in the gut (small intestine) blood in moles.</p>
  </body>
        </Comment>
      </Metabolite>
      <Metabolite key="Metabolite_5" name="AGutlumen" simulationType="reactions" compartment="Compartment_5">
        <MiriamAnnotation>
<rdf:RDF xmlns:CopasiMT="http://www.copasi.org/RDF/MiriamTerms#" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <rdf:Description rdf:about="#Metabolite_5">
    <CopasiMT:is>
      <rdf:Bag>
        <rdf:li rdf:resource="http://identifiers.org/obo.chebi/CHEBI%3A46195" />
      </rdf:Bag>
    </CopasiMT:is>
  </rdf:Description>
</rdf:RDF>
        </MiriamAnnotation>
        <Comment>
          <body xmlns="http://www.w3.org/1999/xhtml">
    <p>Amount of APAP in the lumen of the gut in moles.</p>
  </body>
        </Comment>
        <InitialExpression>
          &lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[APAP_Dose],Reference=InitialValue&gt;/&lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Compartments[VGutLumen],Reference=InitialVolume&gt;
        </InitialExpression>
      </Metabolite>
      <Metabolite key="Metabolite_7" name="CLung" simulationType="reactions" compartment="Compartment_7">
        <MiriamAnnotation>
<rdf:RDF xmlns:CopasiMT="http://www.copasi.org/RDF/MiriamTerms#" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <rdf:Description rdf:about="#Metabolite_7">
    <CopasiMT:is>
      <rdf:Bag>
        <rdf:li rdf:resource="http://identifiers.org/obo.chebi/CHEBI%3A46195" />
      </rdf:Bag>
    </CopasiMT:is>
  </rdf:Description>
</rdf:RDF>
        </MiriamAnnotation>
        <Comment>
          <body xmlns="http://www.w3.org/1999/xhtml">
    <p>Amount of APAP in the lung blood in moles.</p>
  </body>
        </Comment>
      </Metabolite>
      <Metabolite key="Metabolite_9" name="CVen" simulationType="reactions" compartment="Compartment_9">
        <MiriamAnnotation>
<rdf:RDF xmlns:CopasiMT="http://www.copasi.org/RDF/MiriamTerms#" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <rdf:Description rdf:about="#Metabolite_9">
    <CopasiMT:is>
      <rdf:Bag>
        <rdf:li rdf:resource="http://identifiers.org/obo.chebi/CHEBI%3A46195" />
      </rdf:Bag>
    </CopasiMT:is>
  </rdf:Description>
</rdf:RDF>
        </MiriamAnnotation>
        <Comment>
          <body xmlns="http://www.w3.org/1999/xhtml">
    <p>Amount of APAP in the venous blood in moles.</p>
  </body>
        </Comment>
      </Metabolite>
      <Metabolite key="Metabolite_11" name="CRest" simulationType="reactions" compartment="Compartment_11">
        <MiriamAnnotation>
<rdf:RDF xmlns:CopasiMT="http://www.copasi.org/RDF/MiriamTerms#" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <rdf:Description rdf:about="#Metabolite_11">
    <CopasiMT:is>
      <rdf:Bag>
        <rdf:li rdf:resource="http://identifiers.org/obo.chebi/CHEBI%3A46195" />
      </rdf:Bag>
    </CopasiMT:is>
  </rdf:Description>
</rdf:RDF>
        </MiriamAnnotation>
        <Comment>
          <body xmlns="http://www.w3.org/1999/xhtml">
    <p>Amount of APAP in the &quot;rest of the body&quot; in moles.</p>
  </body>
        </Comment>
      </Metabolite>
      <Metabolite key="Metabolite_13" name="CLiver" simulationType="reactions" compartment="Compartment_13">
        <MiriamAnnotation>
<rdf:RDF xmlns:CopasiMT="http://www.copasi.org/RDF/MiriamTerms#" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <rdf:Description rdf:about="#Metabolite_13">
    <CopasiMT:is>
      <rdf:Bag>
        <rdf:li rdf:resource="http://identifiers.org/obo.chebi/CHEBI%3A46195" />
      </rdf:Bag>
    </CopasiMT:is>
  </rdf:Description>
</rdf:RDF>
        </MiriamAnnotation>
        <Comment>
          <body xmlns="http://www.w3.org/1999/xhtml">
    <p>Amount of APAP in the liver blood in moles.</p>
  </body>
        </Comment>
      </Metabolite>
      <Metabolite key="Metabolite_15" name="CMetabolized" simulationType="reactions" compartment="Compartment_13">
        <MiriamAnnotation>
<rdf:RDF xmlns:CopasiMT="http://www.copasi.org/RDF/MiriamTerms#" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <rdf:Description rdf:about="#Metabolite_15">
    <CopasiMT:is>
      <rdf:Bag>
        <rdf:li rdf:resource="http://identifiers.org/cas/103-90-2" />
        <rdf:li rdf:resource="http://identifiers.org/kegg.compound/C06804" />
        <rdf:li rdf:resource="http://identifiers.org/obo.chebi/CHEBI%3A46195" />
        <rdf:li rdf:resource="http://identifiers.org/pubchem.substance/9023" />
      </rdf:Bag>
    </CopasiMT:is>
  </rdf:Description>
</rdf:RDF>
        </MiriamAnnotation>
      </Metabolite>
      <Metabolite key="Metabolite_17" name="CKidney" simulationType="reactions" compartment="Compartment_15">
        <MiriamAnnotation>
<rdf:RDF xmlns:CopasiMT="http://www.copasi.org/RDF/MiriamTerms#" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <rdf:Description rdf:about="#Metabolite_17">
    <CopasiMT:is>
      <rdf:Bag>
        <rdf:li rdf:resource="http://identifiers.org/obo.chebi/CHEBI%3A46195" />
      </rdf:Bag>
    </CopasiMT:is>
  </rdf:Description>
</rdf:RDF>
        </MiriamAnnotation>
        <Comment>
          <body xmlns="http://www.w3.org/1999/xhtml">
    <p>Amount of APAP in the kidney blood in moles.</p>
  </body>
        </Comment>
      </Metabolite>
      <Metabolite key="Metabolite_19" name="CTubules" simulationType="reactions" compartment="Compartment_17">
        <MiriamAnnotation>
<rdf:RDF xmlns:CopasiMT="http://www.copasi.org/RDF/MiriamTerms#" xmlns:dcterms="http://purl.org/dc/terms/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <rdf:Description rdf:about="#Metabolite_19">
    <dcterms:created>
      <rdf:Description>
        <dcterms:W3CDTF>2017-07-11T15:23:46Z</dcterms:W3CDTF>
      </rdf:Description>
    </dcterms:created>
    <CopasiMT:is>
      <rdf:Bag>
        <rdf:li rdf:resource="http://identifiers.org/obo.chebi/CHEBI%3A46195" />
      </rdf:Bag>
    </CopasiMT:is>
  </rdf:Description>
</rdf:RDF>
        </MiriamAnnotation>
        <Comment>
          <body xmlns="http://www.w3.org/1999/xhtml">
    <p>Amount of APAP in the Kidney Tubules in moles.</p>
  </body>
        </Comment>
      </Metabolite>
    </ListOfMetabolites>
    <ListOfModelValues>
      <ModelValue key="ModelValue_0" name="APAP_Dose_grams" simulationType="fixed">
        <Comment>
          <body xmlns="http://www.w3.org/1999/xhtml">
    <p>APAP dose in grams.</p>
  </body>
        </Comment>
      </ModelValue>
      <ModelValue key="ModelValue_1" name="APAP_MW" simulationType="fixed">
        <Comment>
          <body xmlns="http://www.w3.org/1999/xhtml">
    <p>Acetaminophen molecular weight in grams/mole.</p>
  </body>
        </Comment>
      </ModelValue>
      <ModelValue key="ModelValue_2" name="APAP_Dose" simulationType="fixed">
        <Comment>
          <body xmlns="http://www.w3.org/1999/xhtml">
    <p>Acetaminophen dose in moles.  = APAP_Dose_grams/APAP_MW. Note that this value is assigned by an initial assignment or rule equation.</p>
  </body>
        </Comment>
        <InitialExpression>
          &lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[APAP_Dose_grams],Reference=InitialValue&gt;/&lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[APAP_MW],Reference=InitialValue&gt;
        </InitialExpression>
      </ModelValue>
      <ModelValue key="ModelValue_3" name="BW" simulationType="fixed">
        <MiriamAnnotation>
<rdf:RDF xmlns:CopasiMT="http://www.copasi.org/RDF/MiriamTerms#" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <rdf:Description rdf:about="#ModelValue_3">
    <CopasiMT:is>
      <rdf:Bag>
        <rdf:li rdf:resource="http://identifiers.org/ncit/C81328" />
      </rdf:Bag>
    </CopasiMT:is>
  </rdf:Description>
</rdf:RDF>
        </MiriamAnnotation>
        <Comment>
          <body xmlns="http://www.w3.org/1999/xhtml">
    <p>Body weight, in Kg. This value, raised to the 3/4 power, is used in the allometric scaling equations</p>
  </body>
        </Comment>
      </ModelValue>
      <ModelValue key="ModelValue_4" name="BW_ref" simulationType="fixed">
        <Comment>
          <body xmlns="http://www.w3.org/1999/xhtml">
    <p>De-dimensionalization factor for the allometric scaling. Removes the non-integer exponent of the BW^(3/4) scaling factor in the allometric equations.</p>
  </body>
        </Comment>
      </ModelValue>
      <ModelValue key="ModelValue_5" name="Cardiac_flow_ref" simulationType="fixed">
        <Comment>
          <body xmlns="http://www.w3.org/1999/xhtml">
    <p>Total cardiac output reference value for individual of BW=BW_ref (70Kg) for allometric scaling. In Litres/hour.</p>
  </body>
        </Comment>
      </ModelValue>
      <ModelValue key="ModelValue_6" name="QCardiac" simulationType="assignment">
        <MiriamAnnotation>
<rdf:RDF xmlns:CopasiMT="http://www.copasi.org/RDF/MiriamTerms#" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <rdf:Description rdf:about="#ModelValue_6">
    <CopasiMT:is>
      <rdf:Bag>
        <rdf:li rdf:resource="http://identifiers.org/snomedct/64346006" />
      </rdf:Bag>
    </CopasiMT:is>
  </rdf:Description>
</rdf:RDF>
        </MiriamAnnotation>
        <Comment>
          <body xmlns="http://www.w3.org/1999/xhtml">
    <p>Cardiac blood flow in Litres/hr. (aka arterial blood flow or QArt).
Note that this value is modified by allometric scaling in an 
				initial assignment or rule equation.</p>
  </body>
        </Comment>
        <Expression>
          &lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[Cardiac_flow_ref],Reference=Value&gt;*(&lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[BW],Reference=Value&gt;/&lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[BW_ref],Reference=Value&gt;)^0.75
        </Expression>
      </ModelValue>
      <ModelValue key="ModelValue_7" name="QGut_fraction_QCardiac" simulationType="fixed">
        <Comment>
          <body xmlns="http://www.w3.org/1999/xhtml">
    <p>Allometric scaling coefficient for fraction of cardiac output (QCardiac) that flows through the Gut (QGut).</p>
  </body>
        </Comment>
      </ModelValue>
      <ModelValue key="ModelValue_8" name="QGut" simulationType="assignment">
        <Comment>
          <body xmlns="http://www.w3.org/1999/xhtml">
    <p>Volumetric blood flow through the gut in Litres/hour. Note that this value is modified by allometric scaling in 
				an initial assignment or rule equation.</p>
  </body>
        </Comment>
        <Expression>
          &lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[QCardiac],Reference=Value&gt;*&lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[QGut_fraction_QCardiac],Reference=Value&gt;
        </Expression>
      </ModelValue>
      <ModelValue key="ModelValue_9" name="QLiver_fraction_QCardiac" simulationType="fixed">
        <Comment>
          <body xmlns="http://www.w3.org/1999/xhtml">
    <p>Allometric scaling coefficient for fraction of cardiac output (QCardiac) that flows through the Liver (QLiver).</p>
  </body>
        </Comment>
      </ModelValue>
      <ModelValue key="ModelValue_10" name="QLiver" simulationType="assignment">
        <Comment>
          <body xmlns="http://www.w3.org/1999/xhtml">
    <p>Perfusable volume of the Liver in Litres/hr. Note that this value is modified by allometric scaling in an initial 
assignment or rule equation.</p>
  </body>
        </Comment>
        <Expression>
          &lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[QCardiac],Reference=Value&gt;*&lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[QLiver_fraction_QCardiac],Reference=Value&gt;
        </Expression>
      </ModelValue>
      <ModelValue key="ModelValue_11" name="QKidney_fraction_QCardiac" simulationType="fixed">
        <Comment>
          <body xmlns="http://www.w3.org/1999/xhtml">
    <p>Allometric scaling coefficient for fraction of cardiac output (QCardiac) that flows through the Kidney (QKidney).</p>
  </body>
        </Comment>
      </ModelValue>
      <ModelValue key="ModelValue_12" name="QKidney" simulationType="assignment">
        <Comment>
          <body xmlns="http://www.w3.org/1999/xhtml">
    <p>Kidney blood flow in Litres/hr. Note that this value is modified by allometric scaling 
				in an initial assignment or rule equation.</p>
  </body>
        </Comment>
        <Expression>
          &lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[QCardiac],Reference=Value&gt;*&lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[QKidney_fraction_QCardiac],Reference=Value&gt;
        </Expression>
      </ModelValue>
      <ModelValue key="ModelValue_13" name="QRest" simulationType="assignment">
        <Comment>
          <body xmlns="http://www.w3.org/1999/xhtml">
    <p>Blood throw through all other tissues, Litres/hour.  Note that this value is modified by allometric scaling in an 
				initial assignment or rule equation.</p>
  </body>
        </Comment>
        <Expression>
          &lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[QCardiac],Reference=Value&gt;-&lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[QGut],Reference=Value&gt;-&lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[QKidney],Reference=Value&gt;-&lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[QLiver],Reference=Value&gt;
        </Expression>
      </ModelValue>
      <ModelValue key="ModelValue_14" name="QGFR_ref" simulationType="fixed">
        <Comment>
          <body xmlns="http://www.w3.org/1999/xhtml">
    <p>Qgfr coefficient for allometric scaling.</p>
    <p>
      <b>NOTE:
      The normal value for this parameter is 21.7L/hr.</b>
              The value shown here reflects the extensive re-adsorption of APAP from the kidney tubules back into the blood.</p>
  </body>
        </Comment>
      </ModelValue>
      <ModelValue key="ModelValue_15" name="Qgfr" simulationType="assignment">
        <MiriamAnnotation>
<rdf:RDF xmlns:CopasiMT="http://www.copasi.org/RDF/MiriamTerms#" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <rdf:Description rdf:about="#ModelValue_15">
    <CopasiMT:is>
      <rdf:Bag>
        <rdf:li rdf:resource="http://identifiers.org/efo/0005208" />
      </rdf:Bag>
    </CopasiMT:is>
  </rdf:Description>
</rdf:RDF>
        </MiriamAnnotation>
        <Comment>
          <body xmlns="http://www.w3.org/1999/xhtml">
    <p>Granulocyte filtration rate in Litres/hour. Note that this value is modified by allometric scaling in 
				an initial assignment or rule equation. In addition, this vlue is greatly reduced to simulate resorption of APAP from the tubules in the kidney.</p>
  </body>
        </Comment>
        <Expression>
          &lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[QGFR_ref],Reference=Value&gt;*(&lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[BW],Reference=Value&gt;/&lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[BW_ref],Reference=Value&gt;)^0.75
        </Expression>
      </ModelValue>
      <ModelValue key="ModelValue_16" name="kGutabs" simulationType="fixed">
        <MiriamAnnotation>
<rdf:RDF xmlns:dcterms="http://purl.org/dc/terms/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <rdf:Description rdf:about="#ModelValue_16">
    <dcterms:created>
      <rdf:Description>
        <dcterms:W3CDTF>2017-07-11T15:05:39Z</dcterms:W3CDTF>
      </rdf:Description>
    </dcterms:created>
  </rdf:Description>
</rdf:RDF>
        </MiriamAnnotation>
      </ModelValue>
      <ModelValue key="ModelValue_17" name="CLmetabolism" simulationType="fixed">
        <MiriamAnnotation>
<rdf:RDF xmlns:CopasiMT="http://www.copasi.org/RDF/MiriamTerms#" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <rdf:Description rdf:about="#ModelValue_17">
    <CopasiMT:is>
      <rdf:Bag>
        <rdf:li rdf:resource="http://identifiers.org/biomodels.sbo/SBO:0000022" />
      </rdf:Bag>
    </CopasiMT:is>
  </rdf:Description>
</rdf:RDF>
        </MiriamAnnotation>
        <Comment>
          <body xmlns="http://www.w3.org/1999/xhtml">
    <p>Rate of metabolism of APAP in the liver. This single kinetic constant represents both Phase I (e.g., Cyp-2E1) and Phase II (glucurondiation and sulfation) metabolism.</p>
  </body>
        </Comment>
      </ModelValue>
      <ModelValue key="ModelValue_18" name="Fraction_unbound_plasma" simulationType="fixed">
        <Comment>
          <body xmlns="http://www.w3.org/1999/xhtml">
    <p>Fraction of compound in plasma that is not bound by plasma proteins.</p>
  </body>
        </Comment>
      </ModelValue>
      <ModelValue key="ModelValue_19" name="Ratioblood2plasma" simulationType="fixed">
        <Comment>
          <body xmlns="http://www.w3.org/1999/xhtml">
    <p>Ratio of the compound amount in (total) blood vs. plasma.</p>
  </body>
        </Comment>
      </ModelValue>
      <ModelValue key="ModelValue_20" name="Kliver2plasma" simulationType="fixed">
        <Comment>
          <body xmlns="http://www.w3.org/1999/xhtml">
    <p>Partition coefficient for compound between the Liver and the blood plasma.</p>
  </body>
        </Comment>
      </ModelValue>
      <ModelValue key="ModelValue_21" name="Kkidney2plasma" simulationType="fixed">
        <Comment>
          <body xmlns="http://www.w3.org/1999/xhtml">
    <p>Partition coefficient for compound between the Kidney and the blood plasma.</p>
  </body>
        </Comment>
      </ModelValue>
      <ModelValue key="ModelValue_22" name="KRest2plasma" simulationType="fixed">
        <MiriamAnnotation>
<rdf:RDF xmlns:dcterms="http://purl.org/dc/terms/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <rdf:Description rdf:about="#ModelValue_22">
    <dcterms:created>
      <rdf:Description>
        <dcterms:W3CDTF>2017-07-11T15:13:21Z</dcterms:W3CDTF>
      </rdf:Description>
    </dcterms:created>
  </rdf:Description>
</rdf:RDF>
        </MiriamAnnotation>
        <Comment>
          <body xmlns="http://www.w3.org/1999/xhtml">
    <p>Partition coefficient for compound between the Rest (of body) and the blood plasma.</p>
  </body>
        </Comment>
      </ModelValue>
      <ModelValue key="ModelValue_23" name="VTotal_ref" simulationType="fixed">
        <Comment>
          <body xmlns="http://www.w3.org/1999/xhtml">
    <p>Total perfusable volume of the body coefficient for allometric scaling. This is the lean fraction of Body Weight.</p>
  </body>
        </Comment>
      </ModelValue>
      <ModelValue key="ModelValue_24" name="VTotal" simulationType="assignment">
        <Comment>
          <body xmlns="http://www.w3.org/1999/xhtml">
    <p>Total perfusable volume of the body in Litres. Note that this value is modified by allometric scaling in an initial assignment or rule equation.</p>
  </body>
        </Comment>
        <Expression>
          &lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[VTotal_ref],Reference=Value&gt;*(&lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[BW],Reference=Value&gt;/&lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[BW_ref],Reference=Value&gt;)
        </Expression>
      </ModelValue>
      <ModelValue key="ModelValue_25" name="VLiver_fraction_VTotal" simulationType="fixed">
        <Comment>
          <body xmlns="http://www.w3.org/1999/xhtml">
    <p>Allometric scaling coefficient for fraction of total perfusable volume of the body (VTotal) represented by the Liver  (VLiver).</p>
  </body>
        </Comment>
      </ModelValue>
      <ModelValue key="ModelValue_26" name="VArt_fraction_VTotal" simulationType="fixed">
        <Comment>
          <body xmlns="http://www.w3.org/1999/xhtml">
    <p>Allometric scaling coefficient for fraction of cardiac output (QCardiac) that flows through the Arteries (QArt).</p>
  </body>
        </Comment>
      </ModelValue>
      <ModelValue key="ModelValue_27" name="VLung_fraction_VTotal" simulationType="fixed">
        <Comment>
          <body xmlns="http://www.w3.org/1999/xhtml">
    <p>Allometric scaling coefficient for fraction of total perfusable volume of the body (VTotal) represented by the Lungs (VLung).</p>
  </body>
        </Comment>
      </ModelValue>
      <ModelValue key="ModelValue_28" name="VVen_fraction_VTotal" simulationType="fixed">
        <Comment>
          <body xmlns="http://www.w3.org/1999/xhtml">
    <p>Allometric scaling coefficient for fraction of total perfusable volume of the body (VTotal) represented by the Veins (VVen).</p>
  </body>
        </Comment>
      </ModelValue>
      <ModelValue key="ModelValue_29" name="VGut_fraction_VTotal" simulationType="fixed">
        <Comment>
          <body xmlns="http://www.w3.org/1999/xhtml">
    <p>Allometric scaling coefficient for fraction of total perfusable volume of the body (VTotal) represented by the Gut/stomach/small intestine (VGut).</p>
  </body>
        </Comment>
      </ModelValue>
      <ModelValue key="ModelValue_30" name="VKidney_fraction_VTotal" simulationType="fixed">
        <Comment>
          <body xmlns="http://www.w3.org/1999/xhtml">
    <p>Allometric scaling coefficient for fraction of total perfusable volume of the body (VTotal) represented by the Kidneys (VKidney).</p>
  </body>
        </Comment>
      </ModelValue>
    </ListOfModelValues>
    <ListOfReactions>
      <Reaction key="Reaction_0" name="J01" reversible="false" fast="false">
        <MiriamAnnotation>
<rdf:RDF xmlns:dcterms="http://purl.org/dc/terms/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <rdf:Description rdf:about="#Reaction_0">
    <dcterms:created>
      <rdf:Description>
        <dcterms:W3CDTF>2017-07-28T16:12:06Z</dcterms:W3CDTF>
      </rdf:Description>
    </dcterms:created>
  </rdf:Description>
</rdf:RDF>
        </MiriamAnnotation>
        <Comment>
          <body xmlns="http://www.w3.org/1999/xhtml">
    <p>Blood born transfer of compound from the Arterial compartment (CArt) to the Gut (CGut) in moles/hour.</p>
  </body>
        </Comment>
        <ListOfSubstrates>
          <Substrate metabolite="Metabolite_1" stoichiometry="1"/>
        </ListOfSubstrates>
        <ListOfProducts>
          <Product metabolite="Metabolite_3" stoichiometry="1"/>
        </ListOfProducts>
        <ListOfConstants>
          <Constant key="Parameter_4407" name="QGut" value="74.4164"/>
        </ListOfConstants>
        <KineticLaw function="Function_40">
          <ListOfCallParameters>
            <CallParameter functionParameter="FunctionParameter_258">
              <SourceParameter reference="Metabolite_1"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_264">
              <SourceParameter reference="ModelValue_8"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_254">
              <SourceParameter reference="Compartment_1"/>
            </CallParameter>
          </ListOfCallParameters>
        </KineticLaw>
      </Reaction>
      <Reaction key="Reaction_1" name="J02" reversible="false" fast="false">
        <Comment>
          <body xmlns="http://www.w3.org/1999/xhtml">
    <p>First order adsorption of compound  from the lumen of the gut (AGutlumen) to the gut compartment (CGut) in mole/hour.</p>
  </body>
        </Comment>
        <ListOfSubstrates>
          <Substrate metabolite="Metabolite_5" stoichiometry="1"/>
        </ListOfSubstrates>
        <ListOfProducts>
          <Product metabolite="Metabolite_3" stoichiometry="1"/>
        </ListOfProducts>
        <ListOfConstants>
          <Constant key="Parameter_4408" name="kGutabs" value="1.5"/>
        </ListOfConstants>
        <KineticLaw function="Function_41">
          <ListOfCallParameters>
            <CallParameter functionParameter="FunctionParameter_262">
              <SourceParameter reference="Metabolite_5"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_267">
              <SourceParameter reference="Compartment_5"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_265">
              <SourceParameter reference="ModelValue_16"/>
            </CallParameter>
          </ListOfCallParameters>
        </KineticLaw>
      </Reaction>
      <Reaction key="Reaction_2" name="J03" reversible="false" fast="false">
        <MiriamAnnotation>
<rdf:RDF xmlns:dcterms="http://purl.org/dc/terms/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <rdf:Description rdf:about="#Reaction_2">
    <dcterms:created>
      <rdf:Description>
        <dcterms:W3CDTF>2017-07-28T16:12:49Z</dcterms:W3CDTF>
      </rdf:Description>
    </dcterms:created>
  </rdf:Description>
</rdf:RDF>
        </MiriamAnnotation>
        <Comment>
          <body xmlns="http://www.w3.org/1999/xhtml">
    <p>Blood born transfer of compound from the Lung compartment (CLung) to the Arterial blood compartment (CArt) in moles/hour.</p>
  </body>
        </Comment>
        <ListOfSubstrates>
          <Substrate metabolite="Metabolite_7" stoichiometry="1"/>
        </ListOfSubstrates>
        <ListOfProducts>
          <Product metabolite="Metabolite_1" stoichiometry="1"/>
        </ListOfProducts>
        <ListOfConstants>
          <Constant key="Parameter_4409" name="QCardiac" value="363.007"/>
        </ListOfConstants>
        <KineticLaw function="Function_42">
          <ListOfCallParameters>
            <CallParameter functionParameter="FunctionParameter_270">
              <SourceParameter reference="Metabolite_7"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_268">
              <SourceParameter reference="ModelValue_6"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_246">
              <SourceParameter reference="Compartment_7"/>
            </CallParameter>
          </ListOfCallParameters>
        </KineticLaw>
      </Reaction>
      <Reaction key="Reaction_3" name="J04" reversible="false" fast="false">
        <MiriamAnnotation>
<rdf:RDF xmlns:dcterms="http://purl.org/dc/terms/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <rdf:Description rdf:about="#Reaction_3">
    <dcterms:created>
      <rdf:Description>
        <dcterms:W3CDTF>2017-07-28T15:55:40Z</dcterms:W3CDTF>
      </rdf:Description>
    </dcterms:created>
  </rdf:Description>
</rdf:RDF>
        </MiriamAnnotation>
        <Comment>
          <body xmlns="http://www.w3.org/1999/xhtml">
    <p>Blood born transfer of compound from the Venous compartment (CVen) to the Lung compartment (CLung) in moles/hour.</p>
  </body>
        </Comment>
        <ListOfSubstrates>
          <Substrate metabolite="Metabolite_9" stoichiometry="1"/>
        </ListOfSubstrates>
        <ListOfProducts>
          <Product metabolite="Metabolite_7" stoichiometry="1"/>
        </ListOfProducts>
        <ListOfConstants>
          <Constant key="Parameter_4410" name="QCardiac" value="363.007"/>
        </ListOfConstants>
        <KineticLaw function="Function_43">
          <ListOfCallParameters>
            <CallParameter functionParameter="FunctionParameter_273">
              <SourceParameter reference="Metabolite_9"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_271">
              <SourceParameter reference="ModelValue_6"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_266">
              <SourceParameter reference="Compartment_9"/>
            </CallParameter>
          </ListOfCallParameters>
        </KineticLaw>
      </Reaction>
      <Reaction key="Reaction_4" name="J05" reversible="false" fast="false">
        <Comment>
          <body xmlns="http://www.w3.org/1999/xhtml">
    <p>Blood born transfer of compound from the Arterial compartment (CArt) to the Rest of the body compartment (CRest) in moles/hour.</p>
  </body>
        </Comment>
        <ListOfSubstrates>
          <Substrate metabolite="Metabolite_1" stoichiometry="1"/>
        </ListOfSubstrates>
        <ListOfProducts>
          <Product metabolite="Metabolite_11" stoichiometry="1"/>
        </ListOfProducts>
        <ListOfConstants>
          <Constant key="Parameter_4411" name="k1" value="188.8"/>
        </ListOfConstants>
        <KineticLaw function="Function_13">
          <ListOfCallParameters>
            <CallParameter functionParameter="FunctionParameter_81">
              <SourceParameter reference="ModelValue_13"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_79">
              <SourceParameter reference="Metabolite_1"/>
            </CallParameter>
          </ListOfCallParameters>
        </KineticLaw>
      </Reaction>
      <Reaction key="Reaction_5" name="J06" reversible="false" fast="false">
        <MiriamAnnotation>
<rdf:RDF xmlns:dcterms="http://purl.org/dc/terms/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <rdf:Description rdf:about="#Reaction_5">
    <dcterms:created>
      <rdf:Description>
        <dcterms:W3CDTF>2017-07-28T15:48:33Z</dcterms:W3CDTF>
      </rdf:Description>
    </dcterms:created>
  </rdf:Description>
</rdf:RDF>
        </MiriamAnnotation>
        <Comment>
          <body xmlns="http://www.w3.org/1999/xhtml">
    <p>Blood born transfer of compound from the Rest compartment (CRest) to the Venous compartment (CVen) in moles/hour.</p>
  </body>
        </Comment>
        <ListOfSubstrates>
          <Substrate metabolite="Metabolite_11" stoichiometry="1"/>
        </ListOfSubstrates>
        <ListOfProducts>
          <Product metabolite="Metabolite_9" stoichiometry="1"/>
        </ListOfProducts>
        <ListOfConstants>
          <Constant key="Parameter_4412" name="Fraction_unbound_plasma" value="0.8"/>
          <Constant key="Parameter_4413" name="KRest2plasma" value="1.6"/>
          <Constant key="Parameter_4414" name="QRest" value="188.8"/>
          <Constant key="Parameter_4415" name="Ratioblood2plasma" value="1.09"/>
        </ListOfConstants>
        <KineticLaw function="Function_44">
          <ListOfCallParameters>
            <CallParameter functionParameter="FunctionParameter_276">
              <SourceParameter reference="Metabolite_11"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_282">
              <SourceParameter reference="ModelValue_18"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_280">
              <SourceParameter reference="ModelValue_22"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_274">
              <SourceParameter reference="ModelValue_13"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_278">
              <SourceParameter reference="ModelValue_19"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_269">
              <SourceParameter reference="Compartment_11"/>
            </CallParameter>
          </ListOfCallParameters>
        </KineticLaw>
      </Reaction>
      <Reaction key="Reaction_6" name="J07" reversible="false" fast="false">
        <Comment>
          <body xmlns="http://www.w3.org/1999/xhtml">
    <p>Blood born transfer of compound from the Arterial compartment (CArt) to the Liver compartment (CLiver) in moles/hour.</p>
  </body>
        </Comment>
        <ListOfSubstrates>
          <Substrate metabolite="Metabolite_1" stoichiometry="1"/>
        </ListOfSubstrates>
        <ListOfProducts>
          <Product metabolite="Metabolite_13" stoichiometry="1"/>
        </ListOfProducts>
        <ListOfConstants>
          <Constant key="Parameter_4416" name="QLiver" value="19.4209"/>
        </ListOfConstants>
        <KineticLaw function="Function_45">
          <ListOfCallParameters>
            <CallParameter functionParameter="FunctionParameter_275">
              <SourceParameter reference="Metabolite_1"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_283">
              <SourceParameter reference="ModelValue_10"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_279">
              <SourceParameter reference="Compartment_1"/>
            </CallParameter>
          </ListOfCallParameters>
        </KineticLaw>
      </Reaction>
      <Reaction key="Reaction_7" name="J08" reversible="false" fast="false">
        <MiriamAnnotation>
<rdf:RDF xmlns:dcterms="http://purl.org/dc/terms/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <rdf:Description rdf:about="#Reaction_7">
    <dcterms:created>
      <rdf:Description>
        <dcterms:W3CDTF>2017-07-28T15:57:59Z</dcterms:W3CDTF>
      </rdf:Description>
    </dcterms:created>
  </rdf:Description>
</rdf:RDF>
        </MiriamAnnotation>
        <Comment>
          <body xmlns="http://www.w3.org/1999/xhtml">
    <p>Metabolism of compound in the Liver compartment (CLiver) to metabolites (CMetabolized) in moles/hour. The metabolites stay in the liver compartment. This single first order ODE represents both Phase I (Cyp-P450 2E1, 1A2) and Phase II (glucuronidation and sulfation) reactions.</p>
  </body>
        </Comment>
        <ListOfSubstrates>
          <Substrate metabolite="Metabolite_13" stoichiometry="1"/>
        </ListOfSubstrates>
        <ListOfProducts>
          <Product metabolite="Metabolite_15" stoichiometry="1"/>
        </ListOfProducts>
        <ListOfConstants>
          <Constant key="Parameter_4417" name="CLmetabolism" value="9.5"/>
          <Constant key="Parameter_4418" name="Fraction_unbound_plasma" value="0.8"/>
          <Constant key="Parameter_4419" name="Kliver2plasma" value="1"/>
        </ListOfConstants>
        <KineticLaw function="Function_46">
          <ListOfCallParameters>
            <CallParameter functionParameter="FunctionParameter_281">
              <SourceParameter reference="Metabolite_13"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_272">
              <SourceParameter reference="ModelValue_17"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_289">
              <SourceParameter reference="ModelValue_18"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_287">
              <SourceParameter reference="ModelValue_20"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_285">
              <SourceParameter reference="Compartment_13"/>
            </CallParameter>
          </ListOfCallParameters>
        </KineticLaw>
      </Reaction>
      <Reaction key="Reaction_8" name="J09" reversible="false" fast="false">
        <MiriamAnnotation>
<rdf:RDF xmlns:dcterms="http://purl.org/dc/terms/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <rdf:Description rdf:about="#Reaction_8">
    <dcterms:created>
      <rdf:Description>
        <dcterms:W3CDTF>2017-07-28T16:12:47Z</dcterms:W3CDTF>
      </rdf:Description>
    </dcterms:created>
  </rdf:Description>
</rdf:RDF>
        </MiriamAnnotation>
        <Comment>
          <body xmlns="http://www.w3.org/1999/xhtml">
    <p>Blood born transfer of compound from the Gut compartment (CGut) to the Liver compartment (CLiver) in moles/hour.</p>
  </body>
        </Comment>
        <ListOfSubstrates>
          <Substrate metabolite="Metabolite_3" stoichiometry="1"/>
        </ListOfSubstrates>
        <ListOfProducts>
          <Product metabolite="Metabolite_13" stoichiometry="1"/>
        </ListOfProducts>
        <ListOfConstants>
          <Constant key="Parameter_4420" name="QGut" value="74.4164"/>
        </ListOfConstants>
        <KineticLaw function="Function_47">
          <ListOfCallParameters>
            <CallParameter functionParameter="FunctionParameter_277">
              <SourceParameter reference="Metabolite_3"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_290">
              <SourceParameter reference="ModelValue_8"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_286">
              <SourceParameter reference="Compartment_3"/>
            </CallParameter>
          </ListOfCallParameters>
        </KineticLaw>
      </Reaction>
      <Reaction key="Reaction_9" name="J10" reversible="false" fast="false">
        <Comment>
          <body xmlns="http://www.w3.org/1999/xhtml">
    <p>Blood born transfer of compound from the Liver compartment (CLiver) to the Venous compartment (CVen)  in moles/hour.</p>
  </body>
        </Comment>
        <ListOfSubstrates>
          <Substrate metabolite="Metabolite_13" stoichiometry="1"/>
        </ListOfSubstrates>
        <ListOfProducts>
          <Product metabolite="Metabolite_9" stoichiometry="1"/>
        </ListOfProducts>
        <ListOfConstants>
          <Constant key="Parameter_4421" name="Fraction_unbound_plasma" value="0.8"/>
          <Constant key="Parameter_4422" name="Kliver2plasma" value="1"/>
          <Constant key="Parameter_4423" name="QGut" value="74.4164"/>
          <Constant key="Parameter_4424" name="QLiver" value="19.4209"/>
          <Constant key="Parameter_4425" name="Ratioblood2plasma" value="1.09"/>
        </ListOfConstants>
        <KineticLaw function="Function_48">
          <ListOfCallParameters>
            <CallParameter functionParameter="FunctionParameter_295">
              <SourceParameter reference="Metabolite_13"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_301">
              <SourceParameter reference="ModelValue_18"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_299">
              <SourceParameter reference="ModelValue_20"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_288">
              <SourceParameter reference="ModelValue_8"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_291">
              <SourceParameter reference="ModelValue_10"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_297">
              <SourceParameter reference="ModelValue_19"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_293">
              <SourceParameter reference="Compartment_13"/>
            </CallParameter>
          </ListOfCallParameters>
        </KineticLaw>
      </Reaction>
      <Reaction key="Reaction_10" name="J11" reversible="false" fast="false">
        <Comment>
          <body xmlns="http://www.w3.org/1999/xhtml">
    <p>Blood born transfer of compound from the Arterial compartment (CArt) to the Kidney compartment (CKidney)  in moles/hour.</p>
  </body>
        </Comment>
        <ListOfSubstrates>
          <Substrate metabolite="Metabolite_1" stoichiometry="1"/>
        </ListOfSubstrates>
        <ListOfProducts>
          <Product metabolite="Metabolite_17" stoichiometry="1"/>
        </ListOfProducts>
        <ListOfConstants>
          <Constant key="Parameter_4426" name="QKidney" value="80.3697"/>
        </ListOfConstants>
        <KineticLaw function="Function_49">
          <ListOfCallParameters>
            <CallParameter functionParameter="FunctionParameter_294">
              <SourceParameter reference="Metabolite_1"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_302">
              <SourceParameter reference="ModelValue_12"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_298">
              <SourceParameter reference="Compartment_1"/>
            </CallParameter>
          </ListOfCallParameters>
        </KineticLaw>
      </Reaction>
      <Reaction key="Reaction_11" name="J12" reversible="false" fast="false">
        <Comment>
          <body xmlns="http://www.w3.org/1999/xhtml">
    <p>Transfer of compound from the Kidney compartment (CKidney) to the Kidney tubules  (species CTubules 
				in the compartment &quot;KidenyTubules&quot;) in moles/hour.</p>
  </body>
        </Comment>
        <ListOfSubstrates>
          <Substrate metabolite="Metabolite_17" stoichiometry="1"/>
        </ListOfSubstrates>
        <ListOfProducts>
          <Product metabolite="Metabolite_19" stoichiometry="1"/>
        </ListOfProducts>
        <ListOfConstants>
          <Constant key="Parameter_4427" name="Kkidney2plasma" value="1"/>
          <Constant key="Parameter_4428" name="Qgfr" value="0.943818"/>
        </ListOfConstants>
        <KineticLaw function="Function_50">
          <ListOfCallParameters>
            <CallParameter functionParameter="FunctionParameter_303">
              <SourceParameter reference="Metabolite_17"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_305">
              <SourceParameter reference="ModelValue_21"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_292">
              <SourceParameter reference="ModelValue_15"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_300">
              <SourceParameter reference="Compartment_15"/>
            </CallParameter>
          </ListOfCallParameters>
        </KineticLaw>
      </Reaction>
      <Reaction key="Reaction_12" name="J13" reversible="false" fast="false">
        <Comment>
          <body xmlns="http://www.w3.org/1999/xhtml">
    <p>Blood born transfer of compound from the Kidney compartment (CKidney) to the Venous compartment (CVen)  in moles/hour.</p>
  </body>
        </Comment>
        <ListOfSubstrates>
          <Substrate metabolite="Metabolite_17" stoichiometry="1"/>
        </ListOfSubstrates>
        <ListOfProducts>
          <Product metabolite="Metabolite_9" stoichiometry="1"/>
        </ListOfProducts>
        <ListOfConstants>
          <Constant key="Parameter_4429" name="Fraction_unbound_plasma" value="0.8"/>
          <Constant key="Parameter_4430" name="Kkidney2plasma" value="1"/>
          <Constant key="Parameter_4431" name="QKidney" value="80.3697"/>
          <Constant key="Parameter_4432" name="Ratioblood2plasma" value="1.09"/>
        </ListOfConstants>
        <KineticLaw function="Function_51">
          <ListOfCallParameters>
            <CallParameter functionParameter="FunctionParameter_307">
              <SourceParameter reference="Metabolite_17"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_313">
              <SourceParameter reference="ModelValue_18"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_311">
              <SourceParameter reference="ModelValue_21"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_306">
              <SourceParameter reference="ModelValue_12"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_309">
              <SourceParameter reference="ModelValue_19"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_284">
              <SourceParameter reference="Compartment_15"/>
            </CallParameter>
          </ListOfCallParameters>
        </KineticLaw>
      </Reaction>
    </ListOfReactions>
    <ListOfModelParameterSets activeSet="ModelParameterSet_0">
      <ModelParameterSet key="ModelParameterSet_0" name="Initial State">
        <ModelParameterGroup cn="String=Initial Time" type="Group">
          <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK" value="0" type="Model" simulationType="time"/>
        </ModelParameterGroup>
        <ModelParameterGroup cn="String=Initial Compartment Sizes" type="Group">
          <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Compartments[VArt]" value="1.4994" type="Compartment" simulationType="fixed">
            <InitialExpression>
              &lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[VTotal],Reference=InitialValue&gt;*&lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[VArt_fraction_VTotal],Reference=InitialValue&gt;
            </InitialExpression>
          </ModelParameter>
          <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Compartments[VGut]" value="1.1046" type="Compartment" simulationType="fixed">
            <InitialExpression>
              &lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[VTotal],Reference=InitialValue&gt;*&lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[VGut_fraction_VTotal],Reference=InitialValue&gt;
            </InitialExpression>
          </ModelParameter>
          <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Compartments[VGutLumen]" value="1" type="Compartment" simulationType="fixed"/>
          <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Compartments[VLung]" value="0.5082" type="Compartment" simulationType="fixed">
            <InitialExpression>
              &lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[VTotal],Reference=InitialValue&gt;*&lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[VLung_fraction_VTotal],Reference=InitialValue&gt;
            </InitialExpression>
          </ModelParameter>
          <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Compartments[VVen]" value="3.4104" type="Compartment" simulationType="fixed">
            <InitialExpression>
              &lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[VTotal],Reference=InitialValue&gt;*&lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[VVen_fraction_VTotal],Reference=InitialValue&gt;
            </InitialExpression>
          </ModelParameter>
          <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Compartments[VRest]" value="33.4698" type="Compartment" simulationType="fixed">
            <InitialExpression>
              &lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[VTotal],Reference=InitialValue&gt;-&lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Compartments[VArt],Reference=InitialVolume&gt;-&lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Compartments[VGut],Reference=InitialVolume&gt;-&lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Compartments[VKidney],Reference=InitialVolume&gt;-&lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Compartments[VLiver],Reference=InitialVolume&gt;-&lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Compartments[VLung],Reference=InitialVolume&gt;-&lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Compartments[VVen],Reference=InitialVolume&gt;
            </InitialExpression>
          </ModelParameter>
          <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Compartments[VLiver]" value="1.7136" type="Compartment" simulationType="fixed">
            <InitialExpression>
              &lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[VTotal],Reference=InitialValue&gt;*&lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[VLiver_fraction_VTotal],Reference=InitialValue&gt;
            </InitialExpression>
          </ModelParameter>
          <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Compartments[VKidney]" value="0.294" type="Compartment" simulationType="fixed">
            <InitialExpression>
              &lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[VTotal],Reference=InitialValue&gt;*&lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[VKidney_fraction_VTotal],Reference=InitialValue&gt;
            </InitialExpression>
          </ModelParameter>
          <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Compartments[VKidneyTubules]" value="1" type="Compartment" simulationType="fixed"/>
        </ModelParameterGroup>
        <ModelParameterGroup cn="String=Initial Species Values" type="Group">
          <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Compartments[VArt],Vector=Metabolites[CArt]" value="0" type="Species" simulationType="reactions"/>
          <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Compartments[VGut],Vector=Metabolites[CGut]" value="0" type="Species" simulationType="reactions"/>
          <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Compartments[VGutLumen],Vector=Metabolites[AGutlumen]" value="5.576057212962963e+021" type="Species" simulationType="reactions">
            <InitialExpression>
              &lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[APAP_Dose],Reference=InitialValue&gt;/&lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Compartments[VGutLumen],Reference=InitialVolume&gt;
            </InitialExpression>
          </ModelParameter>
          <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Compartments[VLung],Vector=Metabolites[CLung]" value="0" type="Species" simulationType="reactions"/>
          <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Compartments[VVen],Vector=Metabolites[CVen]" value="0" type="Species" simulationType="reactions"/>
          <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Compartments[VRest],Vector=Metabolites[CRest]" value="0" type="Species" simulationType="reactions"/>
          <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Compartments[VLiver],Vector=Metabolites[CLiver]" value="0" type="Species" simulationType="reactions"/>
          <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Compartments[VLiver],Vector=Metabolites[CMetabolized]" value="0" type="Species" simulationType="reactions"/>
          <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Compartments[VKidney],Vector=Metabolites[CKidney]" value="0" type="Species" simulationType="reactions"/>
          <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Compartments[VKidneyTubules],Vector=Metabolites[CTubules]" value="0" type="Species" simulationType="reactions"/>
        </ModelParameterGroup>
        <ModelParameterGroup cn="String=Initial Global Quantities" type="Group">
          <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[APAP_Dose_grams]" value="1.4" type="ModelValue" simulationType="fixed"/>
          <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[APAP_MW]" value="151.2" type="ModelValue" simulationType="fixed"/>
          <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[APAP_Dose]" value="0.009259259259259259" type="ModelValue" simulationType="fixed">
            <InitialExpression>
              &lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[APAP_Dose_grams],Reference=InitialValue&gt;/&lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[APAP_MW],Reference=InitialValue&gt;
            </InitialExpression>
          </ModelParameter>
          <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[BW]" value="70" type="ModelValue" simulationType="fixed"/>
          <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[BW_ref]" value="1" type="ModelValue" simulationType="fixed"/>
          <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[Cardiac_flow_ref]" value="15" type="ModelValue" simulationType="fixed"/>
          <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[QCardiac]" value="363.0068238740381" type="ModelValue" simulationType="assignment"/>
          <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[QGut_fraction_QCardiac]" value="0.205" type="ModelValue" simulationType="fixed"/>
          <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[QGut]" value="74.4163988941778" type="ModelValue" simulationType="assignment"/>
          <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[QLiver_fraction_QCardiac]" value="0.0535" type="ModelValue" simulationType="fixed"/>
          <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[QLiver]" value="19.42086507726104" type="ModelValue" simulationType="assignment"/>
          <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[QKidney_fraction_QCardiac]" value="0.2214" type="ModelValue" simulationType="fixed"/>
          <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[QKidney]" value="80.36971080571205" type="ModelValue" simulationType="assignment"/>
          <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[QRest]" value="188.7998490968872" type="ModelValue" simulationType="assignment"/>
          <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[QGFR_ref]" value="0.039" type="ModelValue" simulationType="fixed"/>
          <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[Qgfr]" value="0.943817742072499" type="ModelValue" simulationType="assignment"/>
          <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[kGutabs]" value="1.5" type="ModelValue" simulationType="fixed"/>
          <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[CLmetabolism]" value="9.5" type="ModelValue" simulationType="fixed"/>
          <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[Fraction_unbound_plasma]" value="0.8" type="ModelValue" simulationType="fixed"/>
          <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[Ratioblood2plasma]" value="1.09" type="ModelValue" simulationType="fixed"/>
          <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[Kliver2plasma]" value="1" type="ModelValue" simulationType="fixed"/>
          <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[Kkidney2plasma]" value="1" type="ModelValue" simulationType="fixed"/>
          <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[KRest2plasma]" value="1.6" type="ModelValue" simulationType="fixed"/>
          <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[VTotal_ref]" value="0.6" type="ModelValue" simulationType="fixed"/>
          <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[VTotal]" value="42" type="ModelValue" simulationType="assignment"/>
          <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[VLiver_fraction_VTotal]" value="0.0408" type="ModelValue" simulationType="fixed"/>
          <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[VArt_fraction_VTotal]" value="0.0357" type="ModelValue" simulationType="fixed"/>
          <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[VLung_fraction_VTotal]" value="0.0121" type="ModelValue" simulationType="fixed"/>
          <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[VVen_fraction_VTotal]" value="0.08119999999999999" type="ModelValue" simulationType="fixed"/>
          <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[VGut_fraction_VTotal]" value="0.0263" type="ModelValue" simulationType="fixed"/>
          <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[VKidney_fraction_VTotal]" value="0.007000000000000001" type="ModelValue" simulationType="fixed"/>
        </ModelParameterGroup>
        <ModelParameterGroup cn="String=Kinetic Parameters" type="Group">
          <ModelParameterGroup cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Reactions[J01]" type="Reaction">
            <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Reactions[J01],ParameterGroup=Parameters,Parameter=QGut" value="74.4163988941778" type="ReactionParameter" simulationType="assignment">
              <InitialExpression>
                &lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[QGut],Reference=InitialValue&gt;
              </InitialExpression>
            </ModelParameter>
          </ModelParameterGroup>
          <ModelParameterGroup cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Reactions[J02]" type="Reaction">
            <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Reactions[J02],ParameterGroup=Parameters,Parameter=kGutabs" value="1.5" type="ReactionParameter" simulationType="assignment">
              <InitialExpression>
                &lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[kGutabs],Reference=InitialValue&gt;
              </InitialExpression>
            </ModelParameter>
          </ModelParameterGroup>
          <ModelParameterGroup cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Reactions[J03]" type="Reaction">
            <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Reactions[J03],ParameterGroup=Parameters,Parameter=QCardiac" value="363.0068238740381" type="ReactionParameter" simulationType="assignment">
              <InitialExpression>
                &lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[QCardiac],Reference=InitialValue&gt;
              </InitialExpression>
            </ModelParameter>
          </ModelParameterGroup>
          <ModelParameterGroup cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Reactions[J04]" type="Reaction">
            <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Reactions[J04],ParameterGroup=Parameters,Parameter=QCardiac" value="363.0068238740381" type="ReactionParameter" simulationType="assignment">
              <InitialExpression>
                &lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[QCardiac],Reference=InitialValue&gt;
              </InitialExpression>
            </ModelParameter>
          </ModelParameterGroup>
          <ModelParameterGroup cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Reactions[J05]" type="Reaction">
            <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Reactions[J05],ParameterGroup=Parameters,Parameter=k1" value="188.7998490968872" type="ReactionParameter" simulationType="assignment">
              <InitialExpression>
                &lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[QRest],Reference=InitialValue&gt;
              </InitialExpression>
            </ModelParameter>
          </ModelParameterGroup>
          <ModelParameterGroup cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Reactions[J06]" type="Reaction">
            <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Reactions[J06],ParameterGroup=Parameters,Parameter=Fraction_unbound_plasma" value="0.8" type="ReactionParameter" simulationType="assignment">
              <InitialExpression>
                &lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[Fraction_unbound_plasma],Reference=InitialValue&gt;
              </InitialExpression>
            </ModelParameter>
            <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Reactions[J06],ParameterGroup=Parameters,Parameter=KRest2plasma" value="1.6" type="ReactionParameter" simulationType="assignment">
              <InitialExpression>
                &lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[KRest2plasma],Reference=InitialValue&gt;
              </InitialExpression>
            </ModelParameter>
            <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Reactions[J06],ParameterGroup=Parameters,Parameter=QRest" value="188.7998490968872" type="ReactionParameter" simulationType="assignment">
              <InitialExpression>
                &lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[QRest],Reference=InitialValue&gt;
              </InitialExpression>
            </ModelParameter>
            <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Reactions[J06],ParameterGroup=Parameters,Parameter=Ratioblood2plasma" value="1.09" type="ReactionParameter" simulationType="assignment">
              <InitialExpression>
                &lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[Ratioblood2plasma],Reference=InitialValue&gt;
              </InitialExpression>
            </ModelParameter>
          </ModelParameterGroup>
          <ModelParameterGroup cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Reactions[J07]" type="Reaction">
            <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Reactions[J07],ParameterGroup=Parameters,Parameter=QLiver" value="19.42086507726104" type="ReactionParameter" simulationType="assignment">
              <InitialExpression>
                &lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[QLiver],Reference=InitialValue&gt;
              </InitialExpression>
            </ModelParameter>
          </ModelParameterGroup>
          <ModelParameterGroup cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Reactions[J08]" type="Reaction">
            <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Reactions[J08],ParameterGroup=Parameters,Parameter=CLmetabolism" value="9.5" type="ReactionParameter" simulationType="assignment">
              <InitialExpression>
                &lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[CLmetabolism],Reference=InitialValue&gt;
              </InitialExpression>
            </ModelParameter>
            <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Reactions[J08],ParameterGroup=Parameters,Parameter=Fraction_unbound_plasma" value="0.8" type="ReactionParameter" simulationType="assignment">
              <InitialExpression>
                &lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[Fraction_unbound_plasma],Reference=InitialValue&gt;
              </InitialExpression>
            </ModelParameter>
            <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Reactions[J08],ParameterGroup=Parameters,Parameter=Kliver2plasma" value="1" type="ReactionParameter" simulationType="assignment">
              <InitialExpression>
                &lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[Kliver2plasma],Reference=InitialValue&gt;
              </InitialExpression>
            </ModelParameter>
          </ModelParameterGroup>
          <ModelParameterGroup cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Reactions[J09]" type="Reaction">
            <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Reactions[J09],ParameterGroup=Parameters,Parameter=QGut" value="74.4163988941778" type="ReactionParameter" simulationType="assignment">
              <InitialExpression>
                &lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[QGut],Reference=InitialValue&gt;
              </InitialExpression>
            </ModelParameter>
          </ModelParameterGroup>
          <ModelParameterGroup cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Reactions[J10]" type="Reaction">
            <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Reactions[J10],ParameterGroup=Parameters,Parameter=Fraction_unbound_plasma" value="0.8" type="ReactionParameter" simulationType="assignment">
              <InitialExpression>
                &lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[Fraction_unbound_plasma],Reference=InitialValue&gt;
              </InitialExpression>
            </ModelParameter>
            <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Reactions[J10],ParameterGroup=Parameters,Parameter=Kliver2plasma" value="1" type="ReactionParameter" simulationType="assignment">
              <InitialExpression>
                &lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[Kliver2plasma],Reference=InitialValue&gt;
              </InitialExpression>
            </ModelParameter>
            <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Reactions[J10],ParameterGroup=Parameters,Parameter=QGut" value="74.4163988941778" type="ReactionParameter" simulationType="assignment">
              <InitialExpression>
                &lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[QGut],Reference=InitialValue&gt;
              </InitialExpression>
            </ModelParameter>
            <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Reactions[J10],ParameterGroup=Parameters,Parameter=QLiver" value="19.42086507726104" type="ReactionParameter" simulationType="assignment">
              <InitialExpression>
                &lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[QLiver],Reference=InitialValue&gt;
              </InitialExpression>
            </ModelParameter>
            <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Reactions[J10],ParameterGroup=Parameters,Parameter=Ratioblood2plasma" value="1.09" type="ReactionParameter" simulationType="assignment">
              <InitialExpression>
                &lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[Ratioblood2plasma],Reference=InitialValue&gt;
              </InitialExpression>
            </ModelParameter>
          </ModelParameterGroup>
          <ModelParameterGroup cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Reactions[J11]" type="Reaction">
            <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Reactions[J11],ParameterGroup=Parameters,Parameter=QKidney" value="80.36971080571205" type="ReactionParameter" simulationType="assignment">
              <InitialExpression>
                &lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[QKidney],Reference=InitialValue&gt;
              </InitialExpression>
            </ModelParameter>
          </ModelParameterGroup>
          <ModelParameterGroup cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Reactions[J12]" type="Reaction">
            <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Reactions[J12],ParameterGroup=Parameters,Parameter=Kkidney2plasma" value="1" type="ReactionParameter" simulationType="assignment">
              <InitialExpression>
                &lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[Kkidney2plasma],Reference=InitialValue&gt;
              </InitialExpression>
            </ModelParameter>
            <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Reactions[J12],ParameterGroup=Parameters,Parameter=Qgfr" value="0.943817742072499" type="ReactionParameter" simulationType="assignment">
              <InitialExpression>
                &lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[Qgfr],Reference=InitialValue&gt;
              </InitialExpression>
            </ModelParameter>
          </ModelParameterGroup>
          <ModelParameterGroup cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Reactions[J13]" type="Reaction">
            <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Reactions[J13],ParameterGroup=Parameters,Parameter=Fraction_unbound_plasma" value="0.8" type="ReactionParameter" simulationType="assignment">
              <InitialExpression>
                &lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[Fraction_unbound_plasma],Reference=InitialValue&gt;
              </InitialExpression>
            </ModelParameter>
            <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Reactions[J13],ParameterGroup=Parameters,Parameter=Kkidney2plasma" value="1" type="ReactionParameter" simulationType="assignment">
              <InitialExpression>
                &lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[Kkidney2plasma],Reference=InitialValue&gt;
              </InitialExpression>
            </ModelParameter>
            <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Reactions[J13],ParameterGroup=Parameters,Parameter=QKidney" value="80.36971080571205" type="ReactionParameter" simulationType="assignment">
              <InitialExpression>
                &lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[QKidney],Reference=InitialValue&gt;
              </InitialExpression>
            </ModelParameter>
            <ModelParameter cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Reactions[J13],ParameterGroup=Parameters,Parameter=Ratioblood2plasma" value="1.09" type="ReactionParameter" simulationType="assignment">
              <InitialExpression>
                &lt;CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[Ratioblood2plasma],Reference=InitialValue&gt;
              </InitialExpression>
            </ModelParameter>
          </ModelParameterGroup>
        </ModelParameterGroup>
      </ModelParameterSet>
    </ListOfModelParameterSets>
    <StateTemplate>
      <StateTemplateVariable objectReference="Model_4"/>
      <StateTemplateVariable objectReference="Metabolite_1"/>
      <StateTemplateVariable objectReference="Metabolite_9"/>
      <StateTemplateVariable objectReference="Metabolite_13"/>
      <StateTemplateVariable objectReference="Metabolite_17"/>
      <StateTemplateVariable objectReference="Metabolite_3"/>
      <StateTemplateVariable objectReference="Metabolite_11"/>
      <StateTemplateVariable objectReference="Metabolite_7"/>
      <StateTemplateVariable objectReference="Metabolite_15"/>
      <StateTemplateVariable objectReference="Metabolite_19"/>
      <StateTemplateVariable objectReference="Metabolite_5"/>
      <StateTemplateVariable objectReference="ModelValue_6"/>
      <StateTemplateVariable objectReference="ModelValue_8"/>
      <StateTemplateVariable objectReference="ModelValue_10"/>
      <StateTemplateVariable objectReference="ModelValue_12"/>
      <StateTemplateVariable objectReference="ModelValue_13"/>
      <StateTemplateVariable objectReference="ModelValue_15"/>
      <StateTemplateVariable objectReference="ModelValue_24"/>
      <StateTemplateVariable objectReference="Compartment_1"/>
      <StateTemplateVariable objectReference="Compartment_3"/>
      <StateTemplateVariable objectReference="Compartment_5"/>
      <StateTemplateVariable objectReference="Compartment_7"/>
      <StateTemplateVariable objectReference="Compartment_9"/>
      <StateTemplateVariable objectReference="Compartment_11"/>
      <StateTemplateVariable objectReference="Compartment_13"/>
      <StateTemplateVariable objectReference="Compartment_15"/>
      <StateTemplateVariable objectReference="Compartment_17"/>
      <StateTemplateVariable objectReference="ModelValue_0"/>
      <StateTemplateVariable objectReference="ModelValue_1"/>
      <StateTemplateVariable objectReference="ModelValue_2"/>
      <StateTemplateVariable objectReference="ModelValue_3"/>
      <StateTemplateVariable objectReference="ModelValue_4"/>
      <StateTemplateVariable objectReference="ModelValue_5"/>
      <StateTemplateVariable objectReference="ModelValue_7"/>
      <StateTemplateVariable objectReference="ModelValue_9"/>
      <StateTemplateVariable objectReference="ModelValue_11"/>
      <StateTemplateVariable objectReference="ModelValue_14"/>
      <StateTemplateVariable objectReference="ModelValue_16"/>
      <StateTemplateVariable objectReference="ModelValue_17"/>
      <StateTemplateVariable objectReference="ModelValue_18"/>
      <StateTemplateVariable objectReference="ModelValue_19"/>
      <StateTemplateVariable objectReference="ModelValue_20"/>
      <StateTemplateVariable objectReference="ModelValue_21"/>
      <StateTemplateVariable objectReference="ModelValue_22"/>
      <StateTemplateVariable objectReference="ModelValue_23"/>
      <StateTemplateVariable objectReference="ModelValue_25"/>
      <StateTemplateVariable objectReference="ModelValue_26"/>
      <StateTemplateVariable objectReference="ModelValue_27"/>
      <StateTemplateVariable objectReference="ModelValue_28"/>
      <StateTemplateVariable objectReference="ModelValue_29"/>
      <StateTemplateVariable objectReference="ModelValue_30"/>
    </StateTemplate>
    <InitialState type="initialState">
      0 0 0 0 0 0 0 0 0 0 5.576057212962963e+021 363.0068238740381 74.4163988941778 19.42086507726104 80.36971080571205 188.7998490968872 0.943817742072499 42 1.4994 1.1046 1 0.5082 3.4104 33.4698 1.7136 0.294 1 1.4 151.2 0.009259259259259259 70 1 15 0.205 0.0535 0.2214 0.039 1.5 9.5 0.8 1.09 1 1 1.6 0.6 0.0408 0.0357 0.0121 0.08119999999999999 0.0263 0.007000000000000001 
    </InitialState>
  </Model>
  <ListOfTasks>
    <Task key="Task_12" name="Steady-State" type="steadyState" scheduled="false" updateModel="false">
      <Report reference="Report_8" target="" append="1" confirmOverwrite="1"/>
      <Problem>
        <Parameter name="JacobianRequested" type="bool" value="1"/>
        <Parameter name="StabilityAnalysisRequested" type="bool" value="1"/>
      </Problem>
      <Method name="Enhanced Newton" type="EnhancedNewton">
        <Parameter name="Resolution" type="unsignedFloat" value="1e-009"/>
        <Parameter name="Derivation Factor" type="unsignedFloat" value="0.001"/>
        <Parameter name="Use Newton" type="bool" value="1"/>
        <Parameter name="Use Integration" type="bool" value="1"/>
        <Parameter name="Use Back Integration" type="bool" value="1"/>
        <Parameter name="Accept Negative Concentrations" type="bool" value="0"/>
        <Parameter name="Iteration Limit" type="unsignedInteger" value="50"/>
        <Parameter name="Maximum duration for forward integration" type="unsignedFloat" value="1000000000"/>
        <Parameter name="Maximum duration for backward integration" type="unsignedFloat" value="1000000"/>
      </Method>
    </Task>
    <Task key="Task_11" name="Time-Course" type="timeCourse" scheduled="false" updateModel="false">
      <Problem>
        <Parameter name="StepNumber" type="unsignedInteger" value="100"/>
        <Parameter name="StepSize" type="float" value="0.1"/>
        <Parameter name="Duration" type="float" value="10"/>
        <Parameter name="TimeSeriesRequested" type="bool" value="1"/>
        <Parameter name="OutputStartTime" type="float" value="0"/>
        <Parameter name="Output Event" type="bool" value="0"/>
        <Parameter name="Continue on Simultaneous Events" type="bool" value="1"/>
      </Problem>
      <Method name="Deterministic (LSODA)" type="Deterministic(LSODA)">
        <Parameter name="Integrate Reduced Model" type="bool" value="0"/>
        <Parameter name="Relative Tolerance" type="unsignedFloat" value="1e-006"/>
        <Parameter name="Absolute Tolerance" type="unsignedFloat" value="1e-012"/>
        <Parameter name="Max Internal Steps" type="unsignedInteger" value="10000"/>
      </Method>
    </Task>
    <Task key="Task_10" name="Scan" type="scan" scheduled="false" updateModel="false">
      <Problem>
        <Parameter name="Subtask" type="unsignedInteger" value="1"/>
        <ParameterGroup name="ScanItems">
        </ParameterGroup>
        <Parameter name="Output in subtask" type="bool" value="1"/>
        <Parameter name="Adjust initial conditions" type="bool" value="0"/>
      </Problem>
      <Method name="Scan Framework" type="ScanFramework">
      </Method>
    </Task>
    <Task key="Task_9" name="Elementary Flux Modes" type="fluxMode" scheduled="false" updateModel="false">
      <Report reference="Report_7" target="" append="1" confirmOverwrite="1"/>
      <Problem>
      </Problem>
      <Method name="EFM Algorithm" type="EFMAlgorithm">
      </Method>
    </Task>
    <Task key="Task_8" name="Optimization" type="optimization" scheduled="false" updateModel="false">
      <Report reference="Report_6" target="" append="1" confirmOverwrite="1"/>
      <Problem>
        <Parameter name="Subtask" type="cn" value="CN=Root,Vector=TaskList[Steady-State]"/>
        <ParameterText name="ObjectiveExpression" type="expression">
          
        </ParameterText>
        <Parameter name="Maximize" type="bool" value="0"/>
        <Parameter name="Randomize Start Values" type="bool" value="0"/>
        <Parameter name="Calculate Statistics" type="bool" value="1"/>
        <ParameterGroup name="OptimizationItemList">
        </ParameterGroup>
        <ParameterGroup name="OptimizationConstraintList">
        </ParameterGroup>
      </Problem>
      <Method name="Random Search" type="RandomSearch">
        <Parameter name="Number of Iterations" type="unsignedInteger" value="100000"/>
        <Parameter name="Random Number Generator" type="unsignedInteger" value="1"/>
        <Parameter name="Seed" type="unsignedInteger" value="0"/>
      </Method>
    </Task>
    <Task key="Task_7" name="Parameter Estimation" type="parameterFitting" scheduled="false" updateModel="false">
      <Report reference="Report_5" target="" append="1" confirmOverwrite="1"/>
      <Problem>
        <Parameter name="Maximize" type="bool" value="0"/>
        <Parameter name="Randomize Start Values" type="bool" value="0"/>
        <Parameter name="Calculate Statistics" type="bool" value="1"/>
        <ParameterGroup name="OptimizationItemList">
          <ParameterGroup name="FitItem">
            <ParameterGroup name="Affected Cross Validation Experiments">
            </ParameterGroup>
            <ParameterGroup name="Affected Experiments">
            </ParameterGroup>
            <Parameter name="LowerBound" type="cn" value="0.01"/>
            <Parameter name="ObjectCN" type="cn" value="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[CLmetabolism],Reference=InitialValue"/>
            <Parameter name="StartValue" type="float" value="1"/>
            <Parameter name="UpperBound" type="cn" value="1000"/>
          </ParameterGroup>
          <ParameterGroup name="FitItem">
            <ParameterGroup name="Affected Cross Validation Experiments">
            </ParameterGroup>
            <ParameterGroup name="Affected Experiments">
            </ParameterGroup>
            <Parameter name="LowerBound" type="cn" value="0.01"/>
            <Parameter name="ObjectCN" type="cn" value="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[kGutabs],Reference=InitialValue"/>
            <Parameter name="StartValue" type="float" value="1"/>
            <Parameter name="UpperBound" type="cn" value="100"/>
          </ParameterGroup>
          <ParameterGroup name="FitItem">
            <ParameterGroup name="Affected Cross Validation Experiments">
            </ParameterGroup>
            <ParameterGroup name="Affected Experiments">
            </ParameterGroup>
            <Parameter name="LowerBound" type="cn" value="0.01"/>
            <Parameter name="ObjectCN" type="cn" value="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[Kkidney2plasma],Reference=InitialValue"/>
            <Parameter name="StartValue" type="float" value="1"/>
            <Parameter name="UpperBound" type="cn" value="100"/>
          </ParameterGroup>
          <ParameterGroup name="FitItem">
            <ParameterGroup name="Affected Cross Validation Experiments">
            </ParameterGroup>
            <ParameterGroup name="Affected Experiments">
            </ParameterGroup>
            <Parameter name="LowerBound" type="cn" value="0.01"/>
            <Parameter name="ObjectCN" type="cn" value="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[Kliver2plasma],Reference=InitialValue"/>
            <Parameter name="StartValue" type="float" value="1"/>
            <Parameter name="UpperBound" type="cn" value="100"/>
          </ParameterGroup>
          <ParameterGroup name="FitItem">
            <ParameterGroup name="Affected Cross Validation Experiments">
            </ParameterGroup>
            <ParameterGroup name="Affected Experiments">
            </ParameterGroup>
            <Parameter name="LowerBound" type="cn" value="0.01"/>
            <Parameter name="ObjectCN" type="cn" value="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[KRest2plasma],Reference=InitialValue"/>
            <Parameter name="StartValue" type="float" value="1"/>
            <Parameter name="UpperBound" type="cn" value="1e+06"/>
          </ParameterGroup>
          <ParameterGroup name="FitItem">
            <ParameterGroup name="Affected Cross Validation Experiments">
            </ParameterGroup>
            <ParameterGroup name="Affected Experiments">
            </ParameterGroup>
            <Parameter name="LowerBound" type="cn" value="1e-06"/>
            <Parameter name="ObjectCN" type="cn" value="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[QGFR_ref],Reference=InitialValue"/>
            <Parameter name="StartValue" type="float" value="0.039"/>
            <Parameter name="UpperBound" type="cn" value="1"/>
          </ParameterGroup>
        </ParameterGroup>
        <ParameterGroup name="OptimizationConstraintList">
        </ParameterGroup>
        <Parameter name="Steady-State" type="cn" value="CN=Root,Vector=TaskList[Steady-State]"/>
        <Parameter name="Time-Course" type="cn" value="CN=Root,Vector=TaskList[Time-Course]"/>
        <Parameter name="Create Parameter Sets" type="bool" value="0"/>
        <ParameterGroup name="Experiment Set">
          <ParameterGroup name="Experiment">
            <Parameter name="Data is Row Oriented" type="bool" value="1"/>
            <Parameter name="Experiment Type" type="unsignedInteger" value="1"/>
            <Parameter name="File Name" type="file" value="Critchley_human_APAP_data.csv"/>
            <Parameter name="First Row" type="unsignedInteger" value="1"/>
            <Parameter name="Key" type="key" value="Experiment_0"/>
            <Parameter name="Last Row" type="unsignedInteger" value="16"/>
            <Parameter name="Normalize Weights per Experiment" type="bool" value="1"/>
            <Parameter name="Number of Columns" type="unsignedInteger" value="17"/>
            <ParameterGroup name="Object Map">
              <ParameterGroup name="0">
                <Parameter name="Role" type="unsignedInteger" value="3"/>
              </ParameterGroup>
              <ParameterGroup name="1">
                <Parameter name="Role" type="unsignedInteger" value="0"/>
              </ParameterGroup>
              <ParameterGroup name="10">
                <Parameter name="Role" type="unsignedInteger" value="0"/>
              </ParameterGroup>
              <ParameterGroup name="11">
                <Parameter name="Role" type="unsignedInteger" value="0"/>
              </ParameterGroup>
              <ParameterGroup name="12">
                <Parameter name="Role" type="unsignedInteger" value="0"/>
              </ParameterGroup>
              <ParameterGroup name="13">
                <Parameter name="Role" type="unsignedInteger" value="0"/>
              </ParameterGroup>
              <ParameterGroup name="14">
                <Parameter name="Role" type="unsignedInteger" value="0"/>
              </ParameterGroup>
              <ParameterGroup name="15">
                <Parameter name="Role" type="unsignedInteger" value="0"/>
              </ParameterGroup>
              <ParameterGroup name="16">
                <Parameter name="Role" type="unsignedInteger" value="0"/>
              </ParameterGroup>
              <ParameterGroup name="2">
                <Parameter name="Role" type="unsignedInteger" value="0"/>
              </ParameterGroup>
              <ParameterGroup name="3">
                <Parameter name="Role" type="unsignedInteger" value="0"/>
              </ParameterGroup>
              <ParameterGroup name="4">
                <Parameter name="Role" type="unsignedInteger" value="0"/>
              </ParameterGroup>
              <ParameterGroup name="5">
                <Parameter name="Object CN" type="cn" value="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Compartments[VVen],Vector=Metabolites[CVen],Reference=Concentration"/>
                <Parameter name="Role" type="unsignedInteger" value="2"/>
              </ParameterGroup>
              <ParameterGroup name="6">
                <Parameter name="Role" type="unsignedInteger" value="0"/>
              </ParameterGroup>
              <ParameterGroup name="7">
                <Parameter name="Role" type="unsignedInteger" value="0"/>
              </ParameterGroup>
              <ParameterGroup name="8">
                <Parameter name="Role" type="unsignedInteger" value="0"/>
              </ParameterGroup>
              <ParameterGroup name="9">
                <Parameter name="Role" type="unsignedInteger" value="0"/>
              </ParameterGroup>
            </ParameterGroup>
            <Parameter name="Row containing Names" type="unsignedInteger" value="1"/>
            <Parameter name="Separator" type="string" value=","/>
            <Parameter name="Weight Method" type="unsignedInteger" value="1"/>
          </ParameterGroup>
        </ParameterGroup>
        <ParameterGroup name="Validation Set">
          <Parameter name="Threshold" type="unsignedInteger" value="5"/>
          <Parameter name="Weight" type="unsignedFloat" value="1"/>
        </ParameterGroup>
      </Problem>
      <Method name="Particle Swarm" type="ParticleSwarm">
        <Parameter name="Iteration Limit" type="unsignedInteger" value="1000"/>
        <Parameter name="Swarm Size" type="unsignedInteger" value="20"/>
        <Parameter name="Std. Deviation" type="unsignedFloat" value="1e-006"/>
        <Parameter name="Random Number Generator" type="unsignedInteger" value="1"/>
        <Parameter name="Seed" type="unsignedInteger" value="0"/>
      </Method>
    </Task>
    <Task key="Task_6" name="Metabolic Control Analysis" type="metabolicControlAnalysis" scheduled="false" updateModel="false">
      <Report reference="Report_4" target="" append="1" confirmOverwrite="1"/>
      <Problem>
        <Parameter name="Steady-State" type="key" value="Task_12"/>
      </Problem>
      <Method name="MCA Method (Reder)" type="MCAMethod(Reder)">
        <Parameter name="Modulation Factor" type="unsignedFloat" value="1e-009"/>
        <Parameter name="Use Reeder" type="bool" value="1"/>
        <Parameter name="Use Smallbone" type="bool" value="1"/>
      </Method>
    </Task>
    <Task key="Task_5" name="Lyapunov Exponents" type="lyapunovExponents" scheduled="false" updateModel="false">
      <Report reference="Report_3" target="" append="1" confirmOverwrite="1"/>
      <Problem>
        <Parameter name="ExponentNumber" type="unsignedInteger" value="3"/>
        <Parameter name="DivergenceRequested" type="bool" value="1"/>
        <Parameter name="TransientTime" type="float" value="0"/>
      </Problem>
      <Method name="Wolf Method" type="WolfMethod">
        <Parameter name="Orthonormalization Interval" type="unsignedFloat" value="1"/>
        <Parameter name="Overall time" type="unsignedFloat" value="1000"/>
        <Parameter name="Relative Tolerance" type="unsignedFloat" value="1e-006"/>
        <Parameter name="Absolute Tolerance" type="unsignedFloat" value="1e-012"/>
        <Parameter name="Max Internal Steps" type="unsignedInteger" value="10000"/>
      </Method>
    </Task>
    <Task key="Task_4" name="Time Scale Separation Analysis" type="timeScaleSeparationAnalysis" scheduled="false" updateModel="false">
      <Report reference="Report_2" target="" append="1" confirmOverwrite="1"/>
      <Problem>
        <Parameter name="StepNumber" type="unsignedInteger" value="100"/>
        <Parameter name="StepSize" type="float" value="0.01"/>
        <Parameter name="Duration" type="float" value="1"/>
        <Parameter name="TimeSeriesRequested" type="bool" value="1"/>
        <Parameter name="OutputStartTime" type="float" value="0"/>
      </Problem>
      <Method name="ILDM (LSODA,Deuflhard)" type="TimeScaleSeparation(ILDM,Deuflhard)">
        <Parameter name="Deuflhard Tolerance" type="unsignedFloat" value="1e-006"/>
      </Method>
    </Task>
    <Task key="Task_3" name="Sensitivities" type="sensitivities" scheduled="false" updateModel="false">
      <Report reference="Report_1" target="" append="1" confirmOverwrite="1"/>
      <Problem>
        <Parameter name="SubtaskType" type="unsignedInteger" value="2"/>
        <ParameterGroup name="TargetFunctions">
          <Parameter name="SingleObject" type="cn" value="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Compartments[VVen],Vector=Metabolites[CVen],Reference=Concentration"/>
          <Parameter name="ObjectListType" type="unsignedInteger" value="1"/>
        </ParameterGroup>
        <ParameterGroup name="ListOfVariables">
          <ParameterGroup name="Variables">
            <Parameter name="SingleObject" type="cn" value=""/>
            <Parameter name="ObjectListType" type="unsignedInteger" value="41"/>
          </ParameterGroup>
        </ParameterGroup>
      </Problem>
      <Method name="Sensitivities Method" type="SensitivitiesMethod">
        <Parameter name="Delta factor" type="unsignedFloat" value="0.001"/>
        <Parameter name="Delta minimum" type="unsignedFloat" value="1e-012"/>
      </Method>
    </Task>
    <Task key="Task_2" name="Moieties" type="moieties" scheduled="false" updateModel="false">
      <Problem>
      </Problem>
      <Method name="Householder Reduction" type="Householder">
      </Method>
    </Task>
    <Task key="Task_1" name="Cross Section" type="crosssection" scheduled="false" updateModel="false">
      <Problem>
        <Parameter name="StepNumber" type="unsignedInteger" value="100"/>
        <Parameter name="StepSize" type="float" value="0.01"/>
        <Parameter name="Duration" type="float" value="1"/>
        <Parameter name="TimeSeriesRequested" type="bool" value="1"/>
        <Parameter name="OutputStartTime" type="float" value="0"/>
        <Parameter name="Output Event" type="bool" value="0"/>
        <Parameter name="Continue on Simultaneous Events" type="bool" value="0"/>
        <Parameter name="LimitCrossings" type="bool" value="0"/>
        <Parameter name="NumCrossingsLimit" type="unsignedInteger" value="0"/>
        <Parameter name="LimitOutTime" type="bool" value="0"/>
        <Parameter name="LimitOutCrossings" type="bool" value="0"/>
        <Parameter name="PositiveDirection" type="bool" value="1"/>
        <Parameter name="NumOutCrossingsLimit" type="unsignedInteger" value="0"/>
        <Parameter name="LimitUntilConvergence" type="bool" value="0"/>
        <Parameter name="ConvergenceTolerance" type="float" value="1e-006"/>
        <Parameter name="Threshold" type="float" value="0"/>
        <Parameter name="DelayOutputUntilConvergence" type="bool" value="0"/>
        <Parameter name="OutputConvergenceTolerance" type="float" value="1e-006"/>
        <ParameterText name="TriggerExpression" type="expression">
          
        </ParameterText>
        <Parameter name="SingleVariable" type="cn" value=""/>
      </Problem>
      <Method name="Deterministic (LSODA)" type="Deterministic(LSODA)">
        <Parameter name="Integrate Reduced Model" type="bool" value="0"/>
        <Parameter name="Relative Tolerance" type="unsignedFloat" value="1e-006"/>
        <Parameter name="Absolute Tolerance" type="unsignedFloat" value="1e-012"/>
        <Parameter name="Max Internal Steps" type="unsignedInteger" value="10000"/>
      </Method>
    </Task>
    <Task key="Task_13" name="Linear Noise Approximation" type="linearNoiseApproximation" scheduled="false" updateModel="false">
      <Report reference="Report_0" target="" append="1" confirmOverwrite="1"/>
      <Problem>
        <Parameter name="Steady-State" type="key" value="Task_12"/>
      </Problem>
      <Method name="Linear Noise Approximation" type="LinearNoiseApproximation">
      </Method>
    </Task>
  </ListOfTasks>
  <ListOfReports>
    <Report key="Report_8" name="Steady-State" taskType="steadyState" separator="&#x09;" precision="6">
      <Comment>
        Automatically generated report.
      </Comment>
      <Footer>
        <Object cn="CN=Root,Vector=TaskList[Steady-State]"/>
      </Footer>
    </Report>
    <Report key="Report_7" name="Elementary Flux Modes" taskType="fluxMode" separator="&#x09;" precision="6">
      <Comment>
        Automatically generated report.
      </Comment>
      <Footer>
        <Object cn="CN=Root,Vector=TaskList[Elementary Flux Modes],Object=Result"/>
      </Footer>
    </Report>
    <Report key="Report_6" name="Optimization" taskType="optimization" separator="&#x09;" precision="6">
      <Comment>
        Automatically generated report.
      </Comment>
      <Header>
        <Object cn="CN=Root,Vector=TaskList[Optimization],Object=Description"/>
        <Object cn="String=\[Function Evaluations\]"/>
        <Object cn="Separator=&#x09;"/>
        <Object cn="String=\[Best Value\]"/>
        <Object cn="Separator=&#x09;"/>
        <Object cn="String=\[Best Parameters\]"/>
      </Header>
      <Body>
        <Object cn="CN=Root,Vector=TaskList[Optimization],Problem=Optimization,Reference=Function Evaluations"/>
        <Object cn="Separator=&#x09;"/>
        <Object cn="CN=Root,Vector=TaskList[Optimization],Problem=Optimization,Reference=Best Value"/>
        <Object cn="Separator=&#x09;"/>
        <Object cn="CN=Root,Vector=TaskList[Optimization],Problem=Optimization,Reference=Best Parameters"/>
      </Body>
      <Footer>
        <Object cn="String=&#x0a;"/>
        <Object cn="CN=Root,Vector=TaskList[Optimization],Object=Result"/>
      </Footer>
    </Report>
    <Report key="Report_5" name="Parameter Estimation" taskType="parameterFitting" separator="&#x09;" precision="6">
      <Comment>
        Automatically generated report.
      </Comment>
      <Header>
        <Object cn="CN=Root,Vector=TaskList[Parameter Estimation],Object=Description"/>
        <Object cn="String=\[Function Evaluations\]"/>
        <Object cn="Separator=&#x09;"/>
        <Object cn="String=\[Best Value\]"/>
        <Object cn="Separator=&#x09;"/>
        <Object cn="String=\[Best Parameters\]"/>
      </Header>
      <Body>
        <Object cn="CN=Root,Vector=TaskList[Parameter Estimation],Problem=Parameter Estimation,Reference=Function Evaluations"/>
        <Object cn="Separator=&#x09;"/>
        <Object cn="CN=Root,Vector=TaskList[Parameter Estimation],Problem=Parameter Estimation,Reference=Best Value"/>
        <Object cn="Separator=&#x09;"/>
        <Object cn="CN=Root,Vector=TaskList[Parameter Estimation],Problem=Parameter Estimation,Reference=Best Parameters"/>
      </Body>
      <Footer>
        <Object cn="String=&#x0a;"/>
        <Object cn="CN=Root,Vector=TaskList[Parameter Estimation],Object=Result"/>
      </Footer>
    </Report>
    <Report key="Report_4" name="Metabolic Control Analysis" taskType="metabolicControlAnalysis" separator="&#x09;" precision="6">
      <Comment>
        Automatically generated report.
      </Comment>
      <Header>
        <Object cn="CN=Root,Vector=TaskList[Metabolic Control Analysis],Object=Description"/>
      </Header>
      <Footer>
        <Object cn="String=&#x0a;"/>
        <Object cn="CN=Root,Vector=TaskList[Metabolic Control Analysis],Object=Result"/>
      </Footer>
    </Report>
    <Report key="Report_3" name="Lyapunov Exponents" taskType="lyapunovExponents" separator="&#x09;" precision="6">
      <Comment>
        Automatically generated report.
      </Comment>
      <Header>
        <Object cn="CN=Root,Vector=TaskList[Lyapunov Exponents],Object=Description"/>
      </Header>
      <Footer>
        <Object cn="String=&#x0a;"/>
        <Object cn="CN=Root,Vector=TaskList[Lyapunov Exponents],Object=Result"/>
      </Footer>
    </Report>
    <Report key="Report_2" name="Time Scale Separation Analysis" taskType="timeScaleSeparationAnalysis" separator="&#x09;" precision="6">
      <Comment>
        Automatically generated report.
      </Comment>
      <Header>
        <Object cn="CN=Root,Vector=TaskList[Time Scale Separation Analysis],Object=Description"/>
      </Header>
      <Footer>
        <Object cn="String=&#x0a;"/>
        <Object cn="CN=Root,Vector=TaskList[Time Scale Separation Analysis],Object=Result"/>
      </Footer>
    </Report>
    <Report key="Report_1" name="Sensitivities" taskType="sensitivities" separator="&#x09;" precision="6">
      <Comment>
        Automatically generated report.
      </Comment>
      <Header>
        <Object cn="CN=Root,Vector=TaskList[Sensitivities],Object=Description"/>
      </Header>
      <Footer>
        <Object cn="String=&#x0a;"/>
        <Object cn="CN=Root,Vector=TaskList[Sensitivities],Object=Result"/>
      </Footer>
    </Report>
    <Report key="Report_0" name="Linear Noise Approximation" taskType="linearNoiseApproximation" separator="&#x09;" precision="6">
      <Comment>
        Automatically generated report.
      </Comment>
      <Header>
        <Object cn="CN=Root,Vector=TaskList[Linear Noise Approximation],Object=Description"/>
      </Header>
      <Footer>
        <Object cn="String=&#x0a;"/>
        <Object cn="CN=Root,Vector=TaskList[Linear Noise Approximation],Object=Result"/>
      </Footer>
    </Report>
  </ListOfReports>
  <ListOfPlots>
    <PlotSpecification name="Concentrations, Volumes, and Global Quantity Values" type="Plot2D" active="1">
      <Parameter name="log X" type="bool" value="0"/>
      <Parameter name="log Y" type="bool" value="0"/>
      <ListOfPlotItems>
        <PlotItem name="Values[QCardiac]" type="Curve2D">
          <Parameter name="Color" type="string" value="auto"/>
          <Parameter name="Line subtype" type="unsignedInteger" value="0"/>
          <Parameter name="Line type" type="unsignedInteger" value="0"/>
          <Parameter name="Line width" type="unsignedFloat" value="1"/>
          <Parameter name="Recording Activity" type="string" value="during"/>
          <Parameter name="Symbol subtype" type="unsignedInteger" value="0"/>
          <ListOfChannels>
            <ChannelSpec cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Reference=Time"/>
            <ChannelSpec cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[QCardiac],Reference=Value"/>
          </ListOfChannels>
        </PlotItem>
        <PlotItem name="Values[QGut]" type="Curve2D">
          <Parameter name="Color" type="string" value="auto"/>
          <Parameter name="Line subtype" type="unsignedInteger" value="0"/>
          <Parameter name="Line type" type="unsignedInteger" value="0"/>
          <Parameter name="Line width" type="unsignedFloat" value="1"/>
          <Parameter name="Recording Activity" type="string" value="during"/>
          <Parameter name="Symbol subtype" type="unsignedInteger" value="0"/>
          <ListOfChannels>
            <ChannelSpec cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Reference=Time"/>
            <ChannelSpec cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[QGut],Reference=Value"/>
          </ListOfChannels>
        </PlotItem>
        <PlotItem name="Values[QKidney]" type="Curve2D">
          <Parameter name="Color" type="string" value="auto"/>
          <Parameter name="Line subtype" type="unsignedInteger" value="0"/>
          <Parameter name="Line type" type="unsignedInteger" value="0"/>
          <Parameter name="Line width" type="unsignedFloat" value="1"/>
          <Parameter name="Recording Activity" type="string" value="during"/>
          <Parameter name="Symbol subtype" type="unsignedInteger" value="0"/>
          <ListOfChannels>
            <ChannelSpec cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Reference=Time"/>
            <ChannelSpec cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[QKidney],Reference=Value"/>
          </ListOfChannels>
        </PlotItem>
        <PlotItem name="Values[QLiver]" type="Curve2D">
          <Parameter name="Color" type="string" value="auto"/>
          <Parameter name="Line subtype" type="unsignedInteger" value="0"/>
          <Parameter name="Line type" type="unsignedInteger" value="0"/>
          <Parameter name="Line width" type="unsignedFloat" value="1"/>
          <Parameter name="Recording Activity" type="string" value="during"/>
          <Parameter name="Symbol subtype" type="unsignedInteger" value="0"/>
          <ListOfChannels>
            <ChannelSpec cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Reference=Time"/>
            <ChannelSpec cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[QLiver],Reference=Value"/>
          </ListOfChannels>
        </PlotItem>
        <PlotItem name="Values[QRest]" type="Curve2D">
          <Parameter name="Color" type="string" value="auto"/>
          <Parameter name="Line subtype" type="unsignedInteger" value="0"/>
          <Parameter name="Line type" type="unsignedInteger" value="0"/>
          <Parameter name="Line width" type="unsignedFloat" value="1"/>
          <Parameter name="Recording Activity" type="string" value="during"/>
          <Parameter name="Symbol subtype" type="unsignedInteger" value="0"/>
          <ListOfChannels>
            <ChannelSpec cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Reference=Time"/>
            <ChannelSpec cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[QRest],Reference=Value"/>
          </ListOfChannels>
        </PlotItem>
        <PlotItem name="Values[Qgfr]" type="Curve2D">
          <Parameter name="Color" type="string" value="auto"/>
          <Parameter name="Line subtype" type="unsignedInteger" value="0"/>
          <Parameter name="Line type" type="unsignedInteger" value="0"/>
          <Parameter name="Line width" type="unsignedFloat" value="1"/>
          <Parameter name="Recording Activity" type="string" value="during"/>
          <Parameter name="Symbol subtype" type="unsignedInteger" value="0"/>
          <ListOfChannels>
            <ChannelSpec cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Reference=Time"/>
            <ChannelSpec cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[Qgfr],Reference=Value"/>
          </ListOfChannels>
        </PlotItem>
        <PlotItem name="Values[VTotal]" type="Curve2D">
          <Parameter name="Color" type="string" value="auto"/>
          <Parameter name="Line subtype" type="unsignedInteger" value="0"/>
          <Parameter name="Line type" type="unsignedInteger" value="0"/>
          <Parameter name="Line width" type="unsignedFloat" value="1"/>
          <Parameter name="Recording Activity" type="string" value="during"/>
          <Parameter name="Symbol subtype" type="unsignedInteger" value="0"/>
          <ListOfChannels>
            <ChannelSpec cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Reference=Time"/>
            <ChannelSpec cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Values[VTotal],Reference=Value"/>
          </ListOfChannels>
        </PlotItem>
        <PlotItem name="[AGutlumen]" type="Curve2D">
          <Parameter name="Color" type="string" value="auto"/>
          <Parameter name="Line subtype" type="unsignedInteger" value="0"/>
          <Parameter name="Line type" type="unsignedInteger" value="0"/>
          <Parameter name="Line width" type="unsignedFloat" value="1"/>
          <Parameter name="Recording Activity" type="string" value="during"/>
          <Parameter name="Symbol subtype" type="unsignedInteger" value="0"/>
          <ListOfChannels>
            <ChannelSpec cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Reference=Time"/>
            <ChannelSpec cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Compartments[VGutLumen],Vector=Metabolites[AGutlumen],Reference=Concentration"/>
          </ListOfChannels>
        </PlotItem>
        <PlotItem name="[CArt]" type="Curve2D">
          <Parameter name="Color" type="string" value="auto"/>
          <Parameter name="Line subtype" type="unsignedInteger" value="0"/>
          <Parameter name="Line type" type="unsignedInteger" value="0"/>
          <Parameter name="Line width" type="unsignedFloat" value="1"/>
          <Parameter name="Recording Activity" type="string" value="during"/>
          <Parameter name="Symbol subtype" type="unsignedInteger" value="0"/>
          <ListOfChannels>
            <ChannelSpec cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Reference=Time"/>
            <ChannelSpec cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Compartments[VArt],Vector=Metabolites[CArt],Reference=Concentration"/>
          </ListOfChannels>
        </PlotItem>
        <PlotItem name="[CGut]" type="Curve2D">
          <Parameter name="Color" type="string" value="auto"/>
          <Parameter name="Line subtype" type="unsignedInteger" value="0"/>
          <Parameter name="Line type" type="unsignedInteger" value="0"/>
          <Parameter name="Line width" type="unsignedFloat" value="1"/>
          <Parameter name="Recording Activity" type="string" value="during"/>
          <Parameter name="Symbol subtype" type="unsignedInteger" value="0"/>
          <ListOfChannels>
            <ChannelSpec cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Reference=Time"/>
            <ChannelSpec cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Compartments[VGut],Vector=Metabolites[CGut],Reference=Concentration"/>
          </ListOfChannels>
        </PlotItem>
        <PlotItem name="[CKidney]" type="Curve2D">
          <Parameter name="Color" type="string" value="auto"/>
          <Parameter name="Line subtype" type="unsignedInteger" value="0"/>
          <Parameter name="Line type" type="unsignedInteger" value="0"/>
          <Parameter name="Line width" type="unsignedFloat" value="1"/>
          <Parameter name="Recording Activity" type="string" value="during"/>
          <Parameter name="Symbol subtype" type="unsignedInteger" value="0"/>
          <ListOfChannels>
            <ChannelSpec cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Reference=Time"/>
            <ChannelSpec cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Compartments[VKidney],Vector=Metabolites[CKidney],Reference=Concentration"/>
          </ListOfChannels>
        </PlotItem>
        <PlotItem name="[CLiver]" type="Curve2D">
          <Parameter name="Color" type="string" value="auto"/>
          <Parameter name="Line subtype" type="unsignedInteger" value="0"/>
          <Parameter name="Line type" type="unsignedInteger" value="0"/>
          <Parameter name="Line width" type="unsignedFloat" value="1"/>
          <Parameter name="Recording Activity" type="string" value="during"/>
          <Parameter name="Symbol subtype" type="unsignedInteger" value="0"/>
          <ListOfChannels>
            <ChannelSpec cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Reference=Time"/>
            <ChannelSpec cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Compartments[VLiver],Vector=Metabolites[CLiver],Reference=Concentration"/>
          </ListOfChannels>
        </PlotItem>
        <PlotItem name="[CLung]" type="Curve2D">
          <Parameter name="Color" type="string" value="auto"/>
          <Parameter name="Line subtype" type="unsignedInteger" value="0"/>
          <Parameter name="Line type" type="unsignedInteger" value="0"/>
          <Parameter name="Line width" type="unsignedFloat" value="1"/>
          <Parameter name="Recording Activity" type="string" value="during"/>
          <Parameter name="Symbol subtype" type="unsignedInteger" value="0"/>
          <ListOfChannels>
            <ChannelSpec cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Reference=Time"/>
            <ChannelSpec cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Compartments[VLung],Vector=Metabolites[CLung],Reference=Concentration"/>
          </ListOfChannels>
        </PlotItem>
        <PlotItem name="[CMetabolized]" type="Curve2D">
          <Parameter name="Color" type="string" value="auto"/>
          <Parameter name="Line subtype" type="unsignedInteger" value="0"/>
          <Parameter name="Line type" type="unsignedInteger" value="0"/>
          <Parameter name="Line width" type="unsignedFloat" value="1"/>
          <Parameter name="Recording Activity" type="string" value="during"/>
          <Parameter name="Symbol subtype" type="unsignedInteger" value="0"/>
          <ListOfChannels>
            <ChannelSpec cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Reference=Time"/>
            <ChannelSpec cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Compartments[VLiver],Vector=Metabolites[CMetabolized],Reference=Concentration"/>
          </ListOfChannels>
        </PlotItem>
        <PlotItem name="[CRest]" type="Curve2D">
          <Parameter name="Color" type="string" value="auto"/>
          <Parameter name="Line subtype" type="unsignedInteger" value="0"/>
          <Parameter name="Line type" type="unsignedInteger" value="0"/>
          <Parameter name="Line width" type="unsignedFloat" value="1"/>
          <Parameter name="Recording Activity" type="string" value="during"/>
          <Parameter name="Symbol subtype" type="unsignedInteger" value="0"/>
          <ListOfChannels>
            <ChannelSpec cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Reference=Time"/>
            <ChannelSpec cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Compartments[VRest],Vector=Metabolites[CRest],Reference=Concentration"/>
          </ListOfChannels>
        </PlotItem>
        <PlotItem name="[CTubules]" type="Curve2D">
          <Parameter name="Color" type="string" value="auto"/>
          <Parameter name="Line subtype" type="unsignedInteger" value="0"/>
          <Parameter name="Line type" type="unsignedInteger" value="0"/>
          <Parameter name="Line width" type="unsignedFloat" value="1"/>
          <Parameter name="Recording Activity" type="string" value="during"/>
          <Parameter name="Symbol subtype" type="unsignedInteger" value="0"/>
          <ListOfChannels>
            <ChannelSpec cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Reference=Time"/>
            <ChannelSpec cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Compartments[VKidneyTubules],Vector=Metabolites[CTubules],Reference=Concentration"/>
          </ListOfChannels>
        </PlotItem>
        <PlotItem name="[CVen]" type="Curve2D">
          <Parameter name="Color" type="string" value="auto"/>
          <Parameter name="Line subtype" type="unsignedInteger" value="0"/>
          <Parameter name="Line type" type="unsignedInteger" value="0"/>
          <Parameter name="Line width" type="unsignedFloat" value="1"/>
          <Parameter name="Recording Activity" type="string" value="during"/>
          <Parameter name="Symbol subtype" type="unsignedInteger" value="0"/>
          <ListOfChannels>
            <ChannelSpec cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Reference=Time"/>
            <ChannelSpec cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Compartments[VVen],Vector=Metabolites[CVen],Reference=Concentration"/>
          </ListOfChannels>
        </PlotItem>
      </ListOfPlotItems>
    </PlotSpecification>
    <PlotSpecification name="Parameter Estimation Result" type="Plot2D" active="1">
      <Parameter name="log X" type="bool" value="0"/>
      <Parameter name="log Y" type="bool" value="0"/>
      <ListOfPlotItems>
        <PlotItem name="Experiment,[CVen](Measured Value)" type="Curve2D">
          <Parameter name="Color" type="string" value="#FF0000"/>
          <Parameter name="Line subtype" type="unsignedInteger" value="1"/>
          <Parameter name="Line type" type="unsignedInteger" value="3"/>
          <Parameter name="Line width" type="unsignedFloat" value="1"/>
          <Parameter name="Recording Activity" type="string" value="after"/>
          <Parameter name="Symbol subtype" type="unsignedInteger" value="1"/>
          <ListOfChannels>
            <ChannelSpec cn="CN=Root,Vector=TaskList[Parameter Estimation],Problem=Parameter Estimation,ParameterGroup=Experiment Set,ParameterGroup=Experiment,Vector=Fitted Points[0],Reference=Independent Value"/>
            <ChannelSpec cn="CN=Root,Vector=TaskList[Parameter Estimation],Problem=Parameter Estimation,ParameterGroup=Experiment Set,ParameterGroup=Experiment,Vector=Fitted Points[0],Reference=Measured Value"/>
          </ListOfChannels>
        </PlotItem>
        <PlotItem name="Experiment,[CVen](Fitted Value)" type="Curve2D">
          <Parameter name="Color" type="string" value="#FF0000"/>
          <Parameter name="Line subtype" type="unsignedInteger" value="0"/>
          <Parameter name="Line type" type="unsignedInteger" value="0"/>
          <Parameter name="Line width" type="unsignedFloat" value="1"/>
          <Parameter name="Recording Activity" type="string" value="after"/>
          <Parameter name="Symbol subtype" type="unsignedInteger" value="0"/>
          <ListOfChannels>
            <ChannelSpec cn="CN=Root,Vector=TaskList[Parameter Estimation],Problem=Parameter Estimation,ParameterGroup=Experiment Set,ParameterGroup=Experiment,Vector=Fitted Points[0],Reference=Independent Value"/>
            <ChannelSpec cn="CN=Root,Vector=TaskList[Parameter Estimation],Problem=Parameter Estimation,ParameterGroup=Experiment Set,ParameterGroup=Experiment,Vector=Fitted Points[0],Reference=Fitted Value"/>
          </ListOfChannels>
        </PlotItem>
        <PlotItem name="Experiment,[CVen](Weighted Error)" type="Curve2D">
          <Parameter name="Color" type="string" value="#FF0000"/>
          <Parameter name="Line subtype" type="unsignedInteger" value="0"/>
          <Parameter name="Line type" type="unsignedInteger" value="2"/>
          <Parameter name="Line width" type="unsignedFloat" value="1"/>
          <Parameter name="Recording Activity" type="string" value="after"/>
          <Parameter name="Symbol subtype" type="unsignedInteger" value="2"/>
          <ListOfChannels>
            <ChannelSpec cn="CN=Root,Vector=TaskList[Parameter Estimation],Problem=Parameter Estimation,ParameterGroup=Experiment Set,ParameterGroup=Experiment,Vector=Fitted Points[0],Reference=Independent Value"/>
            <ChannelSpec cn="CN=Root,Vector=TaskList[Parameter Estimation],Problem=Parameter Estimation,ParameterGroup=Experiment Set,ParameterGroup=Experiment,Vector=Fitted Points[0],Reference=Weighted Error"/>
          </ListOfChannels>
        </PlotItem>
      </ListOfPlotItems>
    </PlotSpecification>
    <PlotSpecification name="Progress of Fit" type="Plot2D" active="1">
      <Parameter name="log X" type="bool" value="0"/>
      <Parameter name="log Y" type="bool" value="1"/>
      <ListOfPlotItems>
        <PlotItem name="sum of squares" type="Curve2D">
          <Parameter name="Color" type="string" value="auto"/>
          <Parameter name="Line subtype" type="unsignedInteger" value="0"/>
          <Parameter name="Line type" type="unsignedInteger" value="0"/>
          <Parameter name="Line width" type="unsignedFloat" value="1"/>
          <Parameter name="Recording Activity" type="string" value="during"/>
          <Parameter name="Symbol subtype" type="unsignedInteger" value="0"/>
          <ListOfChannels>
            <ChannelSpec cn="CN=Root,Vector=TaskList[Parameter Estimation],Problem=Parameter Estimation,Reference=Function Evaluations"/>
            <ChannelSpec cn="CN=Root,Vector=TaskList[Parameter Estimation],Problem=Parameter Estimation,Reference=Best Value"/>
          </ListOfChannels>
        </PlotItem>
      </ListOfPlotItems>
    </PlotSpecification>
    <PlotSpecification name="CVen vs Time" type="Plot2D" active="1">
      <Parameter name="log X" type="bool" value="0"/>
      <Parameter name="log Y" type="bool" value="0"/>
      <ListOfPlotItems>
        <PlotItem name="[CVen]" type="Curve2D">
          <Parameter name="Color" type="string" value="auto"/>
          <Parameter name="Line subtype" type="unsignedInteger" value="0"/>
          <Parameter name="Line type" type="unsignedInteger" value="0"/>
          <Parameter name="Line width" type="unsignedFloat" value="1"/>
          <Parameter name="Recording Activity" type="string" value="during"/>
          <Parameter name="Symbol subtype" type="unsignedInteger" value="0"/>
          <ListOfChannels>
            <ChannelSpec cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Reference=Time"/>
            <ChannelSpec cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Compartments[VVen],Vector=Metabolites[CVen],Reference=Concentration"/>
          </ListOfChannels>
        </PlotItem>
      </ListOfPlotItems>
    </PlotSpecification>
    <PlotSpecification name="Concentrations vs Time" type="Plot2D" active="1">
      <Parameter name="log X" type="bool" value="0"/>
      <Parameter name="log Y" type="bool" value="0"/>
      <ListOfPlotItems>
        <PlotItem name="[AGutlumen]" type="Curve2D">
          <Parameter name="Color" type="string" value="auto"/>
          <Parameter name="Line subtype" type="unsignedInteger" value="0"/>
          <Parameter name="Line type" type="unsignedInteger" value="0"/>
          <Parameter name="Line width" type="unsignedFloat" value="1"/>
          <Parameter name="Recording Activity" type="string" value="during"/>
          <Parameter name="Symbol subtype" type="unsignedInteger" value="0"/>
          <ListOfChannels>
            <ChannelSpec cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Reference=Time"/>
            <ChannelSpec cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Compartments[VGutLumen],Vector=Metabolites[AGutlumen],Reference=Concentration"/>
          </ListOfChannels>
        </PlotItem>
        <PlotItem name="[CArt]" type="Curve2D">
          <Parameter name="Color" type="string" value="auto"/>
          <Parameter name="Line subtype" type="unsignedInteger" value="0"/>
          <Parameter name="Line type" type="unsignedInteger" value="0"/>
          <Parameter name="Line width" type="unsignedFloat" value="1"/>
          <Parameter name="Recording Activity" type="string" value="during"/>
          <Parameter name="Symbol subtype" type="unsignedInteger" value="0"/>
          <ListOfChannels>
            <ChannelSpec cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Reference=Time"/>
            <ChannelSpec cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Compartments[VArt],Vector=Metabolites[CArt],Reference=Concentration"/>
          </ListOfChannels>
        </PlotItem>
        <PlotItem name="[CGut]" type="Curve2D">
          <Parameter name="Color" type="string" value="auto"/>
          <Parameter name="Line subtype" type="unsignedInteger" value="0"/>
          <Parameter name="Line type" type="unsignedInteger" value="0"/>
          <Parameter name="Line width" type="unsignedFloat" value="1"/>
          <Parameter name="Recording Activity" type="string" value="during"/>
          <Parameter name="Symbol subtype" type="unsignedInteger" value="0"/>
          <ListOfChannels>
            <ChannelSpec cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Reference=Time"/>
            <ChannelSpec cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Compartments[VGut],Vector=Metabolites[CGut],Reference=Concentration"/>
          </ListOfChannels>
        </PlotItem>
        <PlotItem name="[CKidney]" type="Curve2D">
          <Parameter name="Color" type="string" value="auto"/>
          <Parameter name="Line subtype" type="unsignedInteger" value="0"/>
          <Parameter name="Line type" type="unsignedInteger" value="0"/>
          <Parameter name="Line width" type="unsignedFloat" value="1"/>
          <Parameter name="Recording Activity" type="string" value="during"/>
          <Parameter name="Symbol subtype" type="unsignedInteger" value="0"/>
          <ListOfChannels>
            <ChannelSpec cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Reference=Time"/>
            <ChannelSpec cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Compartments[VKidney],Vector=Metabolites[CKidney],Reference=Concentration"/>
          </ListOfChannels>
        </PlotItem>
        <PlotItem name="[CLiver]" type="Curve2D">
          <Parameter name="Color" type="string" value="auto"/>
          <Parameter name="Line subtype" type="unsignedInteger" value="0"/>
          <Parameter name="Line type" type="unsignedInteger" value="0"/>
          <Parameter name="Line width" type="unsignedFloat" value="1"/>
          <Parameter name="Recording Activity" type="string" value="during"/>
          <Parameter name="Symbol subtype" type="unsignedInteger" value="0"/>
          <ListOfChannels>
            <ChannelSpec cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Reference=Time"/>
            <ChannelSpec cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Compartments[VLiver],Vector=Metabolites[CLiver],Reference=Concentration"/>
          </ListOfChannels>
        </PlotItem>
        <PlotItem name="[CLung]" type="Curve2D">
          <Parameter name="Color" type="string" value="auto"/>
          <Parameter name="Line subtype" type="unsignedInteger" value="0"/>
          <Parameter name="Line type" type="unsignedInteger" value="0"/>
          <Parameter name="Line width" type="unsignedFloat" value="1"/>
          <Parameter name="Recording Activity" type="string" value="during"/>
          <Parameter name="Symbol subtype" type="unsignedInteger" value="0"/>
          <ListOfChannels>
            <ChannelSpec cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Reference=Time"/>
            <ChannelSpec cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Compartments[VLung],Vector=Metabolites[CLung],Reference=Concentration"/>
          </ListOfChannels>
        </PlotItem>
        <PlotItem name="[CMetabolized]" type="Curve2D">
          <Parameter name="Color" type="string" value="auto"/>
          <Parameter name="Line subtype" type="unsignedInteger" value="0"/>
          <Parameter name="Line type" type="unsignedInteger" value="0"/>
          <Parameter name="Line width" type="unsignedFloat" value="1"/>
          <Parameter name="Recording Activity" type="string" value="during"/>
          <Parameter name="Symbol subtype" type="unsignedInteger" value="0"/>
          <ListOfChannels>
            <ChannelSpec cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Reference=Time"/>
            <ChannelSpec cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Compartments[VLiver],Vector=Metabolites[CMetabolized],Reference=Concentration"/>
          </ListOfChannels>
        </PlotItem>
        <PlotItem name="[CRest]" type="Curve2D">
          <Parameter name="Color" type="string" value="auto"/>
          <Parameter name="Line subtype" type="unsignedInteger" value="0"/>
          <Parameter name="Line type" type="unsignedInteger" value="0"/>
          <Parameter name="Line width" type="unsignedFloat" value="1"/>
          <Parameter name="Recording Activity" type="string" value="during"/>
          <Parameter name="Symbol subtype" type="unsignedInteger" value="0"/>
          <ListOfChannels>
            <ChannelSpec cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Reference=Time"/>
            <ChannelSpec cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Compartments[VRest],Vector=Metabolites[CRest],Reference=Concentration"/>
          </ListOfChannels>
        </PlotItem>
        <PlotItem name="[CTubules]" type="Curve2D">
          <Parameter name="Color" type="string" value="auto"/>
          <Parameter name="Line subtype" type="unsignedInteger" value="0"/>
          <Parameter name="Line type" type="unsignedInteger" value="0"/>
          <Parameter name="Line width" type="unsignedFloat" value="1"/>
          <Parameter name="Recording Activity" type="string" value="during"/>
          <Parameter name="Symbol subtype" type="unsignedInteger" value="0"/>
          <ListOfChannels>
            <ChannelSpec cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Reference=Time"/>
            <ChannelSpec cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Compartments[VKidneyTubules],Vector=Metabolites[CTubules],Reference=Concentration"/>
          </ListOfChannels>
        </PlotItem>
        <PlotItem name="[CVen]" type="Curve2D">
          <Parameter name="Color" type="string" value="auto"/>
          <Parameter name="Line subtype" type="unsignedInteger" value="0"/>
          <Parameter name="Line type" type="unsignedInteger" value="0"/>
          <Parameter name="Line width" type="unsignedFloat" value="1"/>
          <Parameter name="Recording Activity" type="string" value="during"/>
          <Parameter name="Symbol subtype" type="unsignedInteger" value="0"/>
          <ListOfChannels>
            <ChannelSpec cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Reference=Time"/>
            <ChannelSpec cn="CN=Root,Model=Sluka2015_Acetaminophen_PBPK,Vector=Compartments[VVen],Vector=Metabolites[CVen],Reference=Concentration"/>
          </ListOfChannels>
        </PlotItem>
      </ListOfPlotItems>
    </PlotSpecification>
  </ListOfPlots>
  <GUI>
  </GUI>
  <SBMLReference file="Wambaugh_vLiver_PBPK_based_v4.xml">
    <SBMLMap SBMLid="AGutlumen" COPASIkey="Metabolite_5"/>
    <SBMLMap SBMLid="APAP_Dose" COPASIkey="ModelValue_2"/>
    <SBMLMap SBMLid="APAP_Dose_grams" COPASIkey="ModelValue_0"/>
    <SBMLMap SBMLid="APAP_MW" COPASIkey="ModelValue_1"/>
    <SBMLMap SBMLid="BW" COPASIkey="ModelValue_3"/>
    <SBMLMap SBMLid="BW_ref" COPASIkey="ModelValue_4"/>
    <SBMLMap SBMLid="CArt" COPASIkey="Metabolite_1"/>
    <SBMLMap SBMLid="CGut" COPASIkey="Metabolite_3"/>
    <SBMLMap SBMLid="CKidney" COPASIkey="Metabolite_17"/>
    <SBMLMap SBMLid="CLiver" COPASIkey="Metabolite_13"/>
    <SBMLMap SBMLid="CLmetabolism" COPASIkey="ModelValue_17"/>
    <SBMLMap SBMLid="CLung" COPASIkey="Metabolite_7"/>
    <SBMLMap SBMLid="CMetabolized" COPASIkey="Metabolite_15"/>
    <SBMLMap SBMLid="CRest" COPASIkey="Metabolite_11"/>
    <SBMLMap SBMLid="CTubules" COPASIkey="Metabolite_19"/>
    <SBMLMap SBMLid="CVen" COPASIkey="Metabolite_9"/>
    <SBMLMap SBMLid="Cardiac_flow_ref" COPASIkey="ModelValue_5"/>
    <SBMLMap SBMLid="Fraction_unbound_plasma" COPASIkey="ModelValue_18"/>
    <SBMLMap SBMLid="J1" COPASIkey="Reaction_0"/>
    <SBMLMap SBMLid="J10" COPASIkey="Reaction_9"/>
    <SBMLMap SBMLid="J11" COPASIkey="Reaction_10"/>
    <SBMLMap SBMLid="J12" COPASIkey="Reaction_11"/>
    <SBMLMap SBMLid="J13" COPASIkey="Reaction_12"/>
    <SBMLMap SBMLid="J2" COPASIkey="Reaction_1"/>
    <SBMLMap SBMLid="J3" COPASIkey="Reaction_2"/>
    <SBMLMap SBMLid="J4" COPASIkey="Reaction_3"/>
    <SBMLMap SBMLid="J5" COPASIkey="Reaction_4"/>
    <SBMLMap SBMLid="J6" COPASIkey="Reaction_5"/>
    <SBMLMap SBMLid="J7" COPASIkey="Reaction_6"/>
    <SBMLMap SBMLid="J8" COPASIkey="Reaction_7"/>
    <SBMLMap SBMLid="J9" COPASIkey="Reaction_8"/>
    <SBMLMap SBMLid="KRest2plasma" COPASIkey="ModelValue_22"/>
    <SBMLMap SBMLid="Kkidney2plasma" COPASIkey="ModelValue_21"/>
    <SBMLMap SBMLid="Kliver2plasma" COPASIkey="ModelValue_20"/>
    <SBMLMap SBMLid="QCardiac" COPASIkey="ModelValue_6"/>
    <SBMLMap SBMLid="QGFR_ref" COPASIkey="ModelValue_14"/>
    <SBMLMap SBMLid="QGut" COPASIkey="ModelValue_8"/>
    <SBMLMap SBMLid="QGut_fraction_QCardiac" COPASIkey="ModelValue_7"/>
    <SBMLMap SBMLid="QKidney" COPASIkey="ModelValue_12"/>
    <SBMLMap SBMLid="QKidney_fraction_QCardiac" COPASIkey="ModelValue_11"/>
    <SBMLMap SBMLid="QLiver" COPASIkey="ModelValue_10"/>
    <SBMLMap SBMLid="QLiver_fraction_QCardiac" COPASIkey="ModelValue_9"/>
    <SBMLMap SBMLid="QRest" COPASIkey="ModelValue_13"/>
    <SBMLMap SBMLid="Qgfr" COPASIkey="ModelValue_15"/>
    <SBMLMap SBMLid="Ratioblood2plasma" COPASIkey="ModelValue_19"/>
    <SBMLMap SBMLid="VArt" COPASIkey="Compartment_1"/>
    <SBMLMap SBMLid="VArt_fraction_VTotal" COPASIkey="ModelValue_26"/>
    <SBMLMap SBMLid="VGut" COPASIkey="Compartment_3"/>
    <SBMLMap SBMLid="VGutLumen" COPASIkey="Compartment_5"/>
    <SBMLMap SBMLid="VGut_fraction_VTotal" COPASIkey="ModelValue_29"/>
    <SBMLMap SBMLid="VKidney" COPASIkey="Compartment_15"/>
    <SBMLMap SBMLid="VKidneyTubules" COPASIkey="Compartment_17"/>
    <SBMLMap SBMLid="VKidney_fraction_VTotal" COPASIkey="ModelValue_30"/>
    <SBMLMap SBMLid="VLiver" COPASIkey="Compartment_13"/>
    <SBMLMap SBMLid="VLiver_fraction_VTotal" COPASIkey="ModelValue_25"/>
    <SBMLMap SBMLid="VLung" COPASIkey="Compartment_7"/>
    <SBMLMap SBMLid="VLung_fraction_VTotal" COPASIkey="ModelValue_27"/>
    <SBMLMap SBMLid="VRest" COPASIkey="Compartment_11"/>
    <SBMLMap SBMLid="VTotal" COPASIkey="ModelValue_24"/>
    <SBMLMap SBMLid="VTotal_ref" COPASIkey="ModelValue_23"/>
    <SBMLMap SBMLid="VVen" COPASIkey="Compartment_9"/>
    <SBMLMap SBMLid="VVen_fraction_VTotal" COPASIkey="ModelValue_28"/>
    <SBMLMap SBMLid="kGutabs" COPASIkey="ModelValue_16"/>
  </SBMLReference>
</COPASI>
