import tellurium as te

r = te.loada('''
// Created by libAntimony v2.9.4
function Function_for_J10(CLiver, Fraction_unbound_plasma, Kliver2plasma, QGut, QLiver, Ratioblood2plasma, VLiver)
  ((QLiver + QGut)/VLiver)*CLiver*VLiver*Ratioblood2plasma/(Kliver2plasma*Fraction_unbound_plasma);
end

function Function_for_J06(CRest, Fraction_unbound_plasma, KRest2plasma, QRest, Ratioblood2plasma, VRest)
  (QRest/VRest)*CRest*VRest*Ratioblood2plasma/(KRest2plasma*Fraction_unbound_plasma);
end

function Function_for_J07(CArt, QLiver, VArt)
  (QLiver/VArt)*CArt*VArt;
end

function Function_for_J01(CArt, QGut, VArt)
  (QGut/VArt)*CArt*VArt;
end

function Function_for_J02(AGutlumen, VGutLumen, kGutabs)
  kGutabs*AGutlumen*VGutLumen;
end

function Function_for_J03(CLung, QCardiac, VLung)
  (QCardiac/VLung)*CLung*VLung;
end

function Function_for_J04(CVen, QCardiac, VVen)
  (QCardiac/VVen)*CVen*VVen;
end

function Function_for_J08(CLiver, CLmetabolism, Fraction_unbound_plasma, Kliver2plasma, VLiver)
  CLmetabolism*CLiver*VLiver/(Kliver2plasma*Fraction_unbound_plasma)/VLiver;
end

function Function_for_J09(CGut, QGut, VGut)
  (QGut/VGut)*CGut*VGut;
end

function Function_for_J13(CKidney, Fraction_unbound_plasma, Kkidney2plasma, QKidney, Ratioblood2plasma, VKidney)
  (QKidney/VKidney)*CKidney*VKidney*Ratioblood2plasma/(Kkidney2plasma*Fraction_unbound_plasma);
end

function Function_for_J12(CKidney, Kkidney2plasma, Qgfr, VKidney)
  (Qgfr/VKidney)*CKidney*VKidney/Kkidney2plasma;
end

function Function_for_J11(CArt, QKidney, VArt)
  (QKidney/VArt)*CArt*VArt;
end


model *Sluka2015_Acetaminophen_PBPK()

  // Compartments and Species:
  compartment VArt, VGut, VGutLumen, VLung, VVen, VRest, VKidney, VLiver;
  compartment VKidneyTubules;
  substanceOnly species CArt in VArt, CGut in VGut, AGutlumen in VGutLumen;
  substanceOnly species CLung in VLung, CVen in VVen, CRest in VRest, CLiver in VLiver;
  substanceOnly species CMetabolized in VLiver, CKidney in VKidney, CTubules in VKidneyTubules;

  // Assignment Rules:
  VTotal := VTotal_ref*(BW/BW_ref);
  QCardiac := Cardiac_flow_ref*(BW/BW_ref)^0.75;
  QGut := QCardiac*QGut_fraction_QCardiac;
  QLiver := QCardiac*QLiver_fraction_QCardiac;
  QKidney := QCardiac*QKidney_fraction_QCardiac;
  QRest := QCardiac - QGut - QKidney - QLiver;
  Qgfr := QGFR_ref*(BW/BW_ref)^0.75;

  // Reactions:
  J1: CArt => CGut; Function_for_J01(CArt/VArt, QGut, VArt);
  J2: AGutlumen => CGut; Function_for_J02(AGutlumen/VGutLumen, VGutLumen, kGutabs);
  J3: CLung => CArt; Function_for_J03(CLung/VLung, QCardiac, VLung);
  J4: CVen => CLung; Function_for_J04(CVen/VVen, QCardiac, VVen);
  J5: CArt => CRest; QRest*(CArt/VArt);
  J6: CRest => CVen; Function_for_J06(CRest/VRest, Fraction_unbound_plasma, KRest2plasma, QRest, Ratioblood2plasma, VRest);
  J7: CArt => CLiver; Function_for_J07(CArt/VArt, QLiver, VArt);
  J8: CLiver => CMetabolized; VLiver*Function_for_J08(CLiver/VLiver, CLmetabolism, Fraction_unbound_plasma, Kliver2plasma, VLiver);
  J9: CGut => CLiver; Function_for_J09(CGut/VGut, QGut, VGut);
  J10: CLiver => CVen; Function_for_J10(CLiver/VLiver, Fraction_unbound_plasma, Kliver2plasma, QGut, QLiver, Ratioblood2plasma, VLiver);
  J11: CArt => CKidney; Function_for_J11(CArt/VArt, QKidney, VArt);
  J12: CKidney => CTubules; Function_for_J12(CKidney/VKidney, Kkidney2plasma, Qgfr, VKidney);
  J13: CKidney => CVen; Function_for_J13(CKidney/VKidney, Fraction_unbound_plasma, Kkidney2plasma, QKidney, Ratioblood2plasma, VKidney);

  // Species initializations:
  CArt = 0;
  CGut = 0;
  AGutlumen = APAP_Dose;
  CLung = 0;
  CVen = 0;
  CRest = 0;
  CLiver = 0;
  CMetabolized = 0;
  CKidney = 0;
  CTubules = 0;

  // Compartment initializations:
  VArt = VTotal*VArt_fraction_VTotal;
  VGut = VTotal*VGut_fraction_VTotal;
  VGutLumen = 1;
  VLung = VTotal*VLung_fraction_VTotal;
  VVen = VTotal*VVen_fraction_VTotal;
  VRest = VTotal - VArt - VGut - VKidney - VLiver - VLung - VVen;
  VKidney = VTotal*VKidney_fraction_VTotal;
  VLiver = VTotal*VLiver_fraction_VTotal;
  VKidneyTubules = 1;

  // Variable initializations:
  VArt_fraction_VTotal = 0.0357;
  VGut_fraction_VTotal = 0.0263;
  VLung_fraction_VTotal = 0.0121;
  VVen_fraction_VTotal = 0.0812;
  VLiver_fraction_VTotal = 0.0408;
  VKidney_fraction_VTotal = 0.007;
  APAP_Dose = APAP_Dose_grams/APAP_MW;
  APAP_Dose_grams = 1.4;
  APAP_MW = 151.2;
  BW = 70;
  BW_ref = 1;
  Cardiac_flow_ref = 15;
  QGut_fraction_QCardiac = 0.205;
  QLiver_fraction_QCardiac = 0.0535;
  QKidney_fraction_QCardiac = 0.2214;
  QGFR_ref = 0.039;
  kGutabs = 1.5;
  CLmetabolism = 9.5;
  Fraction_unbound_plasma = 0.8;
  Ratioblood2plasma = 1.09;
  Kliver2plasma = 1;
  Kkidney2plasma = 1;
  KRest2plasma = 1.6;
  VTotal_ref = 0.6;

  // Other declarations:
  var VTotal, QCardiac, QGut, QLiver, QKidney, QRest, Qgfr;
  const VArt, VArt_fraction_VTotal, VGut, VGut_fraction_VTotal, VGutLumen;
  const VLung, VLung_fraction_VTotal, VVen, VVen_fraction_VTotal, VRest, VKidney;
  const VLiver, VLiver_fraction_VTotal, VKidney_fraction_VTotal, VKidneyTubules;
  const APAP_Dose, APAP_Dose_grams, APAP_MW, BW, BW_ref, Cardiac_flow_ref;
  const QGut_fraction_QCardiac, QLiver_fraction_QCardiac, QKidney_fraction_QCardiac;
  const QGFR_ref, kGutabs, CLmetabolism, Fraction_unbound_plasma, Ratioblood2plasma;
  const Kliver2plasma, Kkidney2plasma, KRest2plasma, VTotal_ref;

  // Unit definitions:
  unit time_unit = 3600 second;

  // Display Names:
  time_unit is "time";
  J1 is "J01";
  J2 is "J02";
  J3 is "J03";
  J4 is "J04";
  J5 is "J05";
  J6 is "J06";
  J7 is "J07";
  J8 is "J08";
  J9 is "J09";
end
''')
result = r.simulate(0, 12, 500,["time","CVen"]) 
te.plotArray(result)