
from PySteppables import *
import CompuCell
import sys
class ChemotaxisDependenceOnParametersSteppable(SteppableBasePy):

    def __init__(self,_simulator,_frequency=1):
        SteppableBasePy.__init__(self,_simulator,_frequency)
    def start(self):
        # any code in the start function runs before MCS=0
        # Set Parameter values here and create persistent variables
        self.max_switch_time = 100 # set the longest time between direction switches--too short and velocity is noisy, too long and simulation takes forever
        self.x_lattice_size=128
        self.y_lattice_size=64
        self.nflips=6 # number of times to average velocity for each parameter set
        # Parameter to scan
        # lambda chemo
        self.min_val = 0.25        
        self.current_val = 0.25
        self.max_val = 5
        self.lambda_chemo=400 # Fixed value of Lambda Chemo for scanning other parameters
        self.step_ratio = 1.5 # Paramter increase rate for log scale
        # use exponential steps
        self.setXMLAttributeValue('Lambda',self.lambda_chemo,['Plugin','Name','Chemotaxis'],['ChemicalField','Name','Attr'],['ChemotaxisByType','Type','cell'])
        self.updateXML()
        #set initial value of lambda chemo
        
        for cell in self.cellList:
            cell.lambdaVolume=self.min_val # In this simulation I am scanning lambda volume between min_value and max_value
            cell.targetVolume=100
            # we will give the cell a way to keep track of its velocity by tracking the last time and x position we changed direction
            cell.dict['lastDirectionChangeTime'] = 100
            cell.dict['lastDirectionChangePosition'] = 0
            
                   
        self.pW = self.addNewPlotWindow(_title='Center of Mass', _xAxisTitle='MonteCarlo Step (MCS)',
                                        _yAxisTitle='Variables', _xScaleType='linear', _yScaleType='linear')
        self.pW.addPlot('XPosition', _style='Dots', _color='red', _size=5)
        self.pW.addPlot('YPosition', _style='Dots',_color='blue', _size=5)
        self.pW2 = self.addNewPlotWindow(_title='Velocity', _xAxisTitle='MonteCarlo Step (MCS)',
                                        _yAxisTitle='Variables', _xScaleType='linear', _yScaleType='linear')
        self.pW2.addPlot('XVelocity', _style='Dots', _color='red', _size=5)
        self.pW2.addPlot('YVelocity', _style='Dots',_color='blue', _size=5)
        self.pW3 = self.addNewPlotWindow(_title='Velocity vs parameter', _xAxisTitle='Lambda Volume',
                                        _yAxisTitle='Mean Velocity', _xScaleType='linear', _yScaleType='linear')
        self.pW3.addPlot('XVelocity', _style='Dots', _color='red', _size=5)
        self.xPos=[]
        self.yPos=[]
        self.velocity_list=[]
        self.param_vs_velocity=[]
        self.nflipcount=0 # place to keep track of number of times cell has crossed the field
        self.parameter_change_time=0 # keep track of parameter change times so we can let things stabilize
        
        
        
 
    def step(self,mcs):   
        # First we need to set up the parameter scan we want to do
        

   
        #We want to calculate the velocity of the cell as a function of its chemotaxis parameters. 
        #We will also check that we reverse the direction of the cell when it gets within 10% of the x min
        #and x max positions
        
        for cell in self.cellList: 
            self.pW.addDataPoint("XPosition", mcs, cell.xCOM)  
            self.pW.addDataPoint("YPosition", mcs, cell.yCOM)
            self.xPos.append(cell.xCOM)
            self.yPos.append(cell.yCOM)
            if mcs == 100: #Set initial x position after stabilization
                cell.dict['lastDirectionChangePosition'] = cell.xCOM
            
            
            if (mcs > self.parameter_change_time+100) and (mcs > cell.dict['lastDirectionChangeTime']+10): 
                print "last change time", cell.dict['lastDirectionChangeTime'], " current time ", mcs
                #Don't want to start measuring velocity till the system equilibrates and don't want jitter after a direction switch
                
                if (cell.xCOM > self.x_lattice_size*0.8) or (cell.xCOM < self.x_lattice_size * 0.1) or (mcs-cell.dict['lastDirectionChangeTime'] > self.max_switch_time):
                    # if cell too close to end of track or if time has been too long then flip direction
                    mean_x_velocity=abs(cell.xCOM-cell.dict['lastDirectionChangePosition'])/(mcs-cell.dict['lastDirectionChangeTime'])
                    print "Mean Cell Velocity: ", mean_x_velocity, " Voxels/MCS"
                    self.velocity_list.append(mean_x_velocity)# add velocity measurement to the stack
                    vy=(cell.yCOM-self.yPos[-100])/100.0
                    self.pW2.addDataPoint("XVelocity", mcs, mean_x_velocity)  
                    self.pW2.addDataPoint("YVelocity", mcs, vy)
                    # Now swap direction of movement
                    # Read chemotaxis strength
                    attrVal=float(self.getXMLAttributeValue('Lambda',['Plugin','Name','Chemotaxis'],['ChemicalField','Name','Attr'],['ChemotaxisByType','Type','cell']))    
                    # Flip sign of chemotaxis strength
                    self.setXMLAttributeValue('Lambda',-attrVal,['Plugin','Name','Chemotaxis'],['ChemicalField','Name','Attr'],['ChemotaxisByType','Type','cell'])
                    self.updateXML() 
                    # Update time and position of last swap
                    cell.dict['lastDirectionChangePosition']=cell.xCOM
                    cell.dict['lastDirectionChangeTime']=mcs
                    self.nflipcount+=1 # keep track of number of velocity measurements
                    if self.nflipcount > self.nflips: # if we have made enough measurements we change the parameter and plot
                        
                        mean_v=np.mean(self.velocity_list) #find mean velocity for this parameter value
                        self.pW3.addDataPoint("XVelocity", self.current_val, mean_v) # plot parameter vs velocity
                        self.param_vs_velocity.append([self.current_val, mean_v]) #log parameter value and velocity
                        self.velocity_list=[] # reset list
                        self.nflipcount=0 # reset count
                        self.parameter_change_time = mcs # update change of parameter time
                        self.current_val*=self.step_ratio
                        self.current_val=min(self.current_val,self.max_val)
                        #
                        # Next lines change parameter value--will change depending on what paramter you are scanning
                        #
#                         self.setXMLAttributeValue('Lambda',self.current_val,['Plugin','Name','Chemotaxis'],['ChemicalField','Name','Attr'],['ChemotaxisByType','Type','cell'])
#                         self.updateXML()
                        cell.lambdaVolume=self.current_val #since we are scanning lambda volume
                        
                        
                        
                        
                        
                        
                        
            
    def finish(self):
        # Finish Function gets called after the last MCS
        pass
        