
from PySteppables import *
import CompuCell
import sys
class gradient_3Steppable(SteppableBasePy):    

    def __init__(self,_simulator,_frequency=1):
        SteppableBasePy.__init__(self,_simulator,_frequency)
    def start(self):
        # any code in the start function runs before MCS=0
        celldendrite=self.newCell(self.DENDRITE)
        # size of cell will be 3x3x1
        self.cellField[80:85,15:20,0] =celldendrite
        celldendrite.targetVolume=36
        celldendrite.lambdaVolume=2
        
        cellendo=self.newCell(self.ENDO)
        # size of cell will be 3x3x1
        self.cellField[80:85,20:25,0] =cellendo
        cellendo.targetVolume=36
        cellendo.lambdaVolume=2
        
        
        self.pW=self.addNewPlotWindow(_title='chemotax',_xAxisTitle='MonteCarlo Step (MCS)',_yAxisTitle='Variables', _xScaleType='linear',_yScaleType='linear')
        self.pW.addPlot('dendrite',_style='Dots',_color='red',_size=5)
        self.pW.addPlot('endo',_style='Dots',_color='blue',_size=5)
        
        
        
        
    def step(self,mcs):
        field=self.getConcentrationField('Local')
        
        
        for cell in self.cellListByType(self.DENDRITE):
            mValue=field.max()
            value=field[cell.xCOM,cell.yCOM,0]
            growth_rate=value/mValue
            cell.targetVolume+=growth_rate
            self.pW.addDataPoint("dendrite",mcs,cell.xCOM)
            
        for cell in self.cellListByType(self.ENDO):   
            self.pW.addDataPoint("endo",mcs,cell.xCOM) # arguments are (name of the data series, x, y)
            
                
        #type here the code that will run every _frequency MCS
        
    def finish(self):
        # Finish Function gets called after the last MCS
        pass
        