
from PySteppables import *
import CompuCell
import sys
class gradient_2Steppable(SteppableBasePy):    

    def __init__(self,_simulator,_frequency=1):
        SteppableBasePy.__init__(self,_simulator,_frequency)
    def start(self):
        # any code in the start function runs before MCS=0
        self.pW=self.addNewPlotWindow(_title='myGrad',_xAxisTitle='MonteCarlo Step (MCS)',_yAxisTitle='Variables', _xScaleType='linear',_yScaleType='linear')
        self.pW.addPlot('fgfval',_style='Dots',_color='red',_size=5)
        
    def step(self,mcs):        
        self.pW.eraseAllData()
        field=self.getConcentrationField('Fgf')
        y=50
        for x in range(0,101):
            
            value=field[x,y,0]
            self.pW.addDataPoint("fgfval",x,value) # arguments are (name of the data series, x, y)
            
    def finish(self):
        # Finish Function gets called after the last MCS
        pass
        
from PySteppables import *
import CompuCell
import sys

from PlayerPython import *
import CompuCellSetup
from math import *


class CreateCell(SteppableBasePy):
    def __init__(self,_simulator,_frequency=1):
        SteppableBasePy.__init__(self,_simulator,_frequency)
        
    def start(self):
        # size of cell will be 3x3x1
        celldendrite=self.newCell(self.DENDRITE)
        self.cellField[80:85,20:25,0] = celldendrite
        celldendrite.targetVolume=36
        celldendrite.lambdaVolume=2
        
        self.pWa=self.addNewPlotWindow(_title='chemograd',_xAxisTitle='MonteCarlo Step (MCS)',_yAxisTitle='Variables', _xScaleType='linear',_yScaleType='linear')
        self.pWa.addPlot('xgraph',_style='Dots',_color='red',_size=5)
        self.pWa.addPlot('ygraph',_style='Steps',_size=1)
        
        self.pWb=self.addNewPlotWindow(_title='phase_plane',_xAxisTitle='MonteCarlo Step (MCS)',_yAxisTitle='Variables', _xScaleType='linear',_yScaleType='linear')
        self.pWb.addPlot('xvsy',_style='Dots',_color='red',_size=5)
        
        
        
        
        
    def step(self,mcs):
        for cell in self.cellList:
            self.pWa.addDataPoint("xgraph",mcs,cell.xCOM) # arguments are (name of the data series, x, y)
            self.pWa.addDataPoint("ygraph",mcs,cell.yCOM) # arguments are (name of the data series, x, y)
            self.pWb.addDataPoint("xvsy",cell.xCOM,cell.yCOM) # arguments are (name of the data series, x, y)
            
            
    def finish(self):
        # this function may be called at the end of simulation - used very infrequently though
        return
    
