
from PySteppables import *
import CompuCell
import sys

class cellcycleSteppable(SteppableBasePy):    
    def __init__(self,_simulator,_frequency=1):
        SteppableBasePy.__init__(self,_simulator,_frequency)
        
    def start(self):      
        for cell in self.cellList:
            cell.targetVolume = 36
            cell.lambdaVolume = 4

    def step(self,mcs):               
        for cell in self.cellList:
            if cell.targetVolume < 72:
                cell.targetVolume += 0.1
       
    def finish(self):
        pass
        

from PlayerPython import *
import CompuCellSetup
from math import *


class TysonCellCyle(SteppableBasePy):
    def __init__(self,_simulator,_frequency=1):
        SteppableBasePy.__init__(self,_simulator,_frequency)
        self.scalarCLField=self.createScalarFieldCellLevelPy("CycB")
        
    def start(self): 
        modelFile='Simulation/BIOMD0000000195.xml' 
        stepSize=0.2
        for cell in self.cellList:        
            self.addSBMLToCell(_modelFile=modelFile,_modelName='CC',_cell=cell,_stepSize=stepSize)
        
        self.pW=self.addNewPlotWindow(_title='SpeciesXtime',_xAxisTitle='MonteCarlo Step (MCS)',_yAxisTitle='Concentration]')
        self.pW.addPlot('CycB',_style='Lines',_color='red',_size=3)
        self.pW.addPlot('Cdh1',_style='Lines',_color='blue',_size=3)
   
    def step(self,mcs):
        self.timestepSBML()     
        for cell in self.cellList:
            state=self.getSBMLState(_modelName='CC',_cell=cell)
            self.scalarCLField[cell]=state["CycB"]
        self.pW.addDataPoint("CycB",mcs,state["CycB"]) 
        self.pW.addDataPoint("Cdh1",mcs,state["Cdh1"]) 
            
    def finish(self):
        return
    

from PySteppables import *
from PySteppablesExamples import MitosisSteppableBase
import CompuCell
import sys

from PlayerPython import *
from math import *


class division(MitosisSteppableBase):
    def __init__(self,_simulator,_frequency=1):
        MitosisSteppableBase.__init__(self,_simulator, _frequency)
    
    def start(self):      
        for cell in self.cellList:
            cell.dict['old_CycB'] = 0

    def step(self,mcs):
        cells_to_divide=[]
        for cell in self.cellList:
            newCycB = self.getSBMLValue(_modelName='CC',_valueName='CycB',_cell=cell)
            if cell.dict['old_CycB']>0.1 and newCycB<=0.1:  
                cells_to_divide.append(cell)
            
            cell.dict['old_CycB'] = newCycB
            
        for cell in cells_to_divide:
            self.divideCellRandomOrientation(cell)

    def updateAttributes(self):
        self.parentCell.targetVolume /= 2.0 
        self.cloneParent2Child()            
        
        self.copySBMLs(_fromCell=self.childCell,_toCell=self.parentCell,_sbmlNames=['CC'])
        self.copySBMLs(_fromCell=self.childCell,_toCell=self.parentCell,_sbmlNames=['DN'])
        
        
from PySteppables import *
import CompuCell
import sys

from PlayerPython import *
import CompuCellSetup
from math import *

import random 
class DeltaNotchSBML(SteppableBasePy):
    def __init__(self,_simulator,_frequency=1):
        SteppableBasePy.__init__(self,_simulator,_frequency)
        self.scalarCLField=self.createScalarFieldCellLevelPy("Delta")

    def start(self):
        modelFile='Simulation/DN_Collier.sbml' 
        for cell in self.cellList:        
            self.addSBMLToCell(_modelFile=modelFile,_modelName='DN',_cell=cell,_stepSize=0.2)
            D = random.uniform(0.9,1.0)
            N = random.uniform(0.9,1.0)
            self.setSBMLValue(_modelName='DN',_valueName='D',_value=D,_cell=cell)
            self.setSBMLValue(_modelName='DN',_valueName='N',_value=N,_cell=cell)
      
    def step(self,mcs):
        for cell in self.cellList:
            D = self.getSBMLValue(_modelName='DN',_valueName='D',_cell=cell) 
            self.scalarCLField[cell]=D 
            Davg=0; nn=0
            for neighbor , commonSurfaceArea in self.getCellNeighborDataList(cell):
                if neighbor:
                    nn += 1
                    Davg += self.getSBMLValue(_modelName='DN',_valueName='D',_cell=neighbor) 
            if nn:
                Davg /= nn
            self.setSBMLValue(_modelName='DN',_valueName='Davg',_value=Davg,_cell=cell) 
            
    def finish(self):
        return
    
