from PySteppables import *
import CompuCell
import sys

from PySteppablesExamples import MitosisSteppableBase
import random

class ConstraintInitializerSteppable(SteppableBasePy):
    def __init__(self,_simulator,_frequency=1):
        SteppableBasePy.__init__(self,_simulator,_frequency)
    def start(self):
        for cell in self.cellList:
            cell.dict['Rho'] = 1000                # STEM cells allowed divisons     
            cell.targetVolume=36.               # initial target volume
            cell.lambdaVolume=2.0              # volume constraint
        for cell in self.cellListByType(self.STEM):
            cell.dict['P'] = 0.1                       # initial mutation probability
 
class GrowthSteppable(SteppableBasePy):
    def __init__(self,_simulator,_frequency=1):
        SteppableBasePy.__init__(self,_simulator,_frequency)
    def step(self,mcs):
        
        # iterating over all cells in simulation        
        for cell in self.cellList:
            if cell.type == self.NECROTIC:
                cell.targetVolume-=1            # N cells volume diminution
                cell.targetVolume=max(cell.targetVolume,0)    # no negative allowed
            if cell.dict['Rho'] == 0:
                cell.type=self.NECROTIC        
            if (cell.type != self.NECROTIC):
                if cell.type==self.STEMQUIES or  cell.type==self.SOMQUIES:
                    cell.targetVolume-=.01              # Q cells volume diminution
                    if cell.targetVolume < 18.:         # threshold to become N
                        cell.type=self.NECROTIC
                NMedium=0
                for neighbor , commonSurfaceArea in self.getCellNeighborDataList(cell):                
                    if not neighbor:
                        NMedium+=1
                if NMedium:
                    if cell.type==self.STEM or  cell.type==self.SOMATIC:
                        cell.targetVolume+=0.2        # growth rate for proliferating cells
                        cell.targetVolume=min(cell.targetVolume,60)   # max = 2 * initial target
                    if cell.type==self.SOMQUIES: cell.type=self.SOMATIC
                    if cell.type==self.STEMQUIES: cell.type=self.STEM
                else:
                    if cell.type==self.SOMATIC: cell.type=self.SOMQUIES
                    if cell.type==self.STEM: cell.type=self.STEMQUIES
  

class MitosisSteppable(MitosisSteppableBase):
    def __init__(self,_simulator,_frequency=1):
        MitosisSteppableBase.__init__(self,_simulator, _frequency)
    
    def step(self,mcs):
        # print "INSIDE MITOSIS STEPPABLE"
        cells_to_divide=[]
        for cell in self.cellList:
            if cell.volume>60:   
                cells_to_divide.append(cell)
                
        for cell in cells_to_divide:
            if cell.type==self.SOMATIC:
                cell.dict['Rho']-=1                     # division counter update
            self.divideCellRandomOrientation(cell)
                
    def updateAttributes(self):
        self.parentCell.targetVolume = 30 # reducing parent target volume                 
        self.cloneParent2Child()    
        
        
        Pmut = 0.05                     # Mutation threshold
        if self.parentCell.type==self.STEM:
            P = self.parentCell.dict['P']
            r = random.random()
            if r>P:
                self.childCell.type=self.SOMATIC
                self.childCell.dict['Rho']=random.choice([0,1,2,3,4])           # random value after division
            else:
                self.childCell.type=self.STEM
                self.childCell.dict['Rho']=1000                 # STEM cells don't change
                
            if random.random()<Pmut: 
                self.parentCell.dict['P'] *= 1+random.uniform(-0.5,0.5)         # mutatiion in P
      

class Plots(SteppableBasePy):
    def __init__(self,_simulator,_frequency=10):
        SteppableBasePy.__init__(self,_simulator,_frequency)
        
    def start(self):
        self.pW=self.addNewPlotWindow(_title='CELL POPULATION',_xAxisTitle='MonteCarlo Step (MCS)',_yAxisTitle='# of CELLS', _xScaleType='linear',_yScaleType='linear')
        self.pW.addPlot('STEM',_style='Dots',_color='red',_size=3)
        self.pW.addPlot('SOMATIC',_style='Dots',_color='blue',_size=3)
        self.pW.addPlot('STEMQ',_style='Lines',_color='pink',_size=3)
        self.pW.addPlot('SOMQ',_style='Lines',_color='lightblue',_size=3)
        self.pW.addPlot('NEC',_style='Dots',_color='black',_size=3)
        
        self.pW2=self.addNewPlotWindow(_title='STEM P & Q',_xAxisTitle='MonteCarlo Step (MCS)',_yAxisTitle='<P>', _xScaleType='linear',_yScaleType='linear')
        self.pW2.addPlot('STEM',_style='Dots',_color='red',_size=3)
        self.pW2.addPlot('STEMQ',_style='Lines',_color='pink',_size=3)
        
        self.pW3=self.addNewPlotWindow(_title='<Rho>',_xAxisTitle='MonteCarlo Step (MCS)',_yAxisTitle='<Rho>', _xScaleType='linear',_yScaleType='linear')
        self.pW3.addPlot('RhoSOM',_style='Dots',_color='red',_size=3)
        self.pW3.addPlot('RhoSOMQ',_style='Lines',_color='pink',_size=3)
        
    def step(self,mcs):
        self.pW.addDataPoint("STEM",mcs,len(self.cellListByType(self.STEM))) 
        self.pW.addDataPoint("SOMATIC",mcs,len(self.cellListByType(self.SOMATIC)))
        self.pW.addDataPoint("STEMQ",mcs,len(self.cellListByType(self.STEMQUIES))) 
        self.pW.addDataPoint("SOMQ",mcs,len(self.cellListByType(self.SOMQUIES)))
        self.pW.addDataPoint("NEC",mcs,len(self.cellListByType(self.NECROTIC)))
        
        PSTEMavg=0
        PSTEMQavg=0
        for cell in self.cellListByType(self.STEM,self.STEMQUIES):
            if cell.type==self.STEM: PSTEMavg+=cell.dict['P']
            if cell.type==self.STEMQUIES: PSTEMQavg+=cell.dict['P']
        if PSTEMavg: PSTEMavg/=1.0*len(self.cellListByType(self.STEM))
        if PSTEMQavg: PSTEMQavg/=1.0*len(self.cellListByType(self.STEMQUIES))
        self.pW2.addDataPoint("STEM",mcs,PSTEMavg)
        self.pW2.addDataPoint("STEMQ",mcs,PSTEMQavg)
            
        RhoSOMavg=0.0
        RhoSOMQavg=0.0
        for cell in self.cellListByType(self.SOMATIC,self.SOMQUIES,):
            if cell.type == self.SOMATIC: RhoSOMavg+=cell.dict['Rho']
            if cell.type == self.SOMQUIES: RhoSOMQavg+=cell.dict['Rho']
        if RhoSOMavg: RhoSOMavg/=1.0*len(self.cellListByType(self.SOMATIC))
        if RhoSOMQavg: RhoSOMQavg/=1.0*len(self.cellListByType(self.SOMQUIES))
        self.pW3.addDataPoint("RhoSOM",mcs,RhoSOMavg)
        self.pW3.addDataPoint("RhoSOMQ",mcs,RhoSOMQavg)


    
