from PySteppables import *
import CompuCell
import sys

class EpithelialSheetSteppable(SteppableBasePy):    
    def __init__(self,_simulator,_frequency=1):
        SteppableBasePy.__init__(self,_simulator,_frequency)
        
    def start(self):
        pass
        
    def step(self,mcs):  
        # Turn on constriction
        if mcs==500:
            for cell in self.cellListByType(self.APICAL): 
                if 70<cell.xCOM<130:
                    for fppd in self.getFocalPointPlasticityDataList(cell):
                        lambdaD=fppd.lambdaDistance*2 
                        targetD=fppd.targetDistance/2
                        self.focalPointPlasticityPlugin.setFocalPointPlasticityParameters(cell,fppd.neighborAddress,lambdaD,targetD,25.0) # arguments are (cell1,cell2,lambda,targetDistance,maxDistance)     
                            
    def finish(self):
        pass
        
from PySteppablesExamples import MitosisSteppableBase
from PlayerPython import *
from math import *

class CompartmentMaker(MitosisSteppableBase):
    def __init__(self,_simulator,_frequency=1):
        MitosisSteppableBase.__init__(self,_simulator, _frequency)
    
    def start(self):
        # 1st division
        self.division=1
        cells_to_divide=[]
        for cell in self.cellListByType(self.LATERAL):
            cells_to_divide.append(cell)   
        for cell in cells_to_divide:
            self.divideCellOrientationVectorBased(cell,0,1,0)
        
        # 2nd division
        self.division=2
        cells_to_divide=[]
        for cell in self.cellListByType(self.LATERAL):
            cells_to_divide.append(cell)   
        for cell in cells_to_divide:
            self.divideCellOrientationVectorBased(cell,0,1,0)
        
        # Assign Volumes
        for cell in self.cellListByType(self.LATERAL):
            cell.targetVolume = 80
            cell.lambdaVolume = 2
        for cell in self.cellListByType(self.APICAL):
            cell.targetVolume = 30
            cell.lambdaVolume = 2
        for cell in self.cellListByType(self.BASAL):
            cell.targetVolume = 30
            cell.lambdaVolume = 2      

    def updateAttributes(self):
        self.cloneParent2Child()
        cID = self.parentCell.clusterId 
        reassignIdFlag=self.inventory.reassignClusterId(self.childCell,cID) 
        
        if self.division==1:
            if self.childCell.yCOM<self.parentCell.yCOM:
                self.childCell.type = self.BASAL
                self.parentCell.type = self.LATERAL
            else:
                self.childCell.type = self.LATERAL
                self.parentCell.type = self.BASAL
        
        else:
            if self.childCell.yCOM>self.parentCell.yCOM:
                self.childCell.type = self.APICAL
                self.parentCell.type = self.LATERAL
            else:
                self.childCell.type = self.LATERAL
                self.parentCell.type = self.APICAL
