
from PySteppables import *
import CompuCell
import sys

import random
from math import *
from Parameters import *

class DirectedMovementSteppable(SteppableBasePy):    
    def __init__(self,_simulator,_frequency=1):
        SteppableBasePy.__init__(self,_simulator,_frequency)
        
    def start(self):
        global Myvalue
        global FileName
        # any code in the start function runs before MCS=0
        self.pW=self.addNewPlotWindow(_title='Tracking',_xAxisTitle='X',_yAxisTitle='Y', _xScaleType='linear',_yScaleType='linear')
        for cell in self.cellList:
            c = random.choice(['black','red','green','blue'])
            self.pW.addPlot(str(cell.id),_style='Lines',_color=c,_size=1)
        
        FileName = "myData.txt"
        self.File = open(FileName,"w")
        self.File.write("Time (mcs), X position (px), Y position (px)\n")        
        
    def step(self,mcs):
        if mcs%IntervalforOrientationChange==0:
            for cell in self.cellList:
                # access/modification of a dictionary attached to cell - make sure to decalare in main script that you will use such attribute
                cell.dict['direction'] = random.choice([1,-1])  
        for cell in self.cellList:        
            iXX=cell.iXX 
            iYY=cell.iYY
            iZZ=cell.iZZ
            iXY=cell.iXY
            iXZ=cell.iXZ
            iYZ=cell.iYZ
            eccentricity=cell.ecc
            phi = atan( 2*iXY/(iXX-iYY) )/2 
#                 phi = random.uniform(0,2*pi)
            cell.lambdaVecX=10*sin(phi)*cell.dict['direction']
            cell.lambdaVecY=10*cos(phi)*cell.dict['direction']
            cell.lambdaVecZ=0.0 
        for cell in self.cellList:
            self.pW.addDataPoint(str(cell.id),cell.xCOM,cell.yCOM) 
        
        #self.File.write(str(mcs)+", "+str(cell.xCOM)+", "+str(cell.yCOM)+"\n")
        self.File.write("%d, %f, %f\n" % (mcs,cell.xCOM,cell.yCOM) )
            
    def finish(self):
        self.File.close()
        pass
        