
from PySteppables import *
import CompuCell
import sys

from random import uniform

class VascularSteppable(SteppableBasePy):    

    def __init__(self,_simulator,_frequency=1):
        SteppableBasePy.__init__(self,_simulator,_frequency)
        
    def start(self):
        self.pW = self.addNewPlotWindow(\
        _title='Neighbors',\
        _xAxisTitle='MCS',_yAxisTitle='Number of Neighbors',\
        _xScaleType='linear',_yScaleType='linear'\
        )
        
   
        
        self.pW.addPlot('Cell_id_1',_style='Dots',_color='red',_size=2)
        self.pW.addPlot('Cell_id_2',_style='Steps',_size=1)
        
        
        
        
        
        # VASCULAR
        for i in range(400):
            x = int( uniform(0,self.dim.x-1) )
            y = int( uniform(0,self.dim.y-1) )
            self.cellField[x,y,0] = self.newCell(self.V)        
        
        
        for cell in self.cellList:
            cell.targetVolume = 25.0
            cell.lambdaVolume = 12.0
        
    def step(self,mcs):  
        
        for cell in self.cellList:           
            
            if cell.id == 1:
                counter = 0
                
                for neighbor , commonSurfaceArea in self.getCellNeighborDataList(cell):
                    counter += 1    
                    
                self.pW.addDataPoint("Cell_id_1", mcs, counter) 
                 
            elif cell.id == 2:
                counter = 0
                
                for neighbor , commonSurfaceArea in self.getCellNeighborDataList(cell):
                    counter += 1    
                    
                self.pW.addDataPoint("Cell_id_2", mcs, counter) 
                
                
                    
              
                
        
            
        pass
        
    def finish(self):
        # Finish Function gets called after the last MCS
        pass
        