
from PySteppables import *
import CompuCell
import sys
class TumorSteppable(SteppableBasePy):    

    def __init__(self,_simulator,_frequency=1):
        SteppableBasePy.__init__(self,_simulator,_frequency)
    def start(self):
        
        self.buildWall(self.S)
        
        for cell in self.cellList:
            
            if cell.type == self.P:
                
                cell.targetVolume = 25
                cell.lambdaVolume = 2.0

    def step(self,mcs): 
        field = self.getConcentrationField('GLU')
        if mcs> 2500:
            for cell in self.cellList:
                if cell.type == self.N:
                    cell.targetVolume -= 0.005 
                    if cell.targetVolume <=0:
                        cell.targetVolume =0
                if cell.type == self.P:
                    cell.targetVolume += 0.005*field[int (cell.xCOM) , int( cell.yCOM ) ,0 ]
        
        
        for cell in self.cellList:
            
            if cell.type == self.S:
                continue
            
            conc = field[int (cell.xCOM) , int( cell.yCOM ),0 ]
                
            if conc > 2.2 :
                cell.type = self.P
                
            elif conc > 1.5  and conc <=2.2:
                cell.type = self.Q
            
            else:
                
                cell.type = self.N
                

    def finish(self):
        # Finish Function gets called after the last MCS
        pass
        
        
        
        
        
        
from PySteppables import *
from PySteppablesExamples import MitosisSteppableBase
import CompuCell
import sys

from PlayerPython import *
from math import *


class Mitosis(MitosisSteppableBase):
    def __init__(self,_simulator,_frequency=1):
        MitosisSteppableBase.__init__(self,_simulator, _frequency)
    
    def step(self,mcs):
        # print "INSIDE Mitosis"
        cells_to_divide=[]
        for cell in self.cellList:
            if cell.volume>50:
                
                cells_to_divide.append(cell)
                
        for cell in cells_to_divide:
            # to change mitosis mode leave one of the below lines uncommented
            self.divideCellRandomOrientation(cell)
            # self.divideCellOrientationVectorBased(cell,1,0,0)                 # this is a valid option
            # self.divideCellAlongMajorAxis(cell)                               # this is a valid option
            # self.divideCellAlongMinorAxis(cell)                               # this is a valid option

    def updateAttributes(self):
        self.parentCell.targetVolume /= 2.0 # reducing parent target volume                 
        self.cloneParent2Child()            
        

        
