
from PySteppables import *
import CompuCell
import sys

class SortingSteppable(SteppableBasePy):    

    def __init__(self,_simulator,_frequency=1):
        SteppableBasePy.__init__(self,_simulator,_frequency)
        
    def start(self):
        
        self.cellField[50:54,50:54,0] = self.newCell(self.CONDENSING)
        
        self.cellField[65:69,65:69,0] = self.newCell(self.NONCONDENSING)
        
        
        for cell in self.cellList:
            
            cell.targetVolume = 25
            cell.lambdaVolume = 2.0
            
            cell.targetSurface = 20
            cell.lambdaSurface = 2.0
        
        # any code in the start function runs before MCS=0
        pass
        
    def step(self,mcs):  
        
        import math
        
#         for cell in self.cellList:
#             print "id=",cell.id, " type=",cell.type," volume=",cell.volume

        field=self.getConcentrationField('FGF')
        
        print 'concentration in the middle = ', field[50,50,0]
        
        for cell in self.cellList:
            if cell.type == self.NONCONDENSING:
                w = field[ int(cell.xCOM) , int(cell.yCOM) , 0] 
                print 'c_at_com = ',w     
                
                cell.targetVolume += w
                cell.targetSurface = 4*math.sqrt(cell.targetVolume)*1.2

#         for cell in self.cellList:
#             cell.targetVolume += 1
#             cell.targetSurface = 4*math.sqrt(cell.targetVolume)*1.2
            
        
        
#         if mcs % 100 == 0:
#             if cell.type == 1:
#                 cell.type = 2
#             else:
#                 cell.type = 1
        
        
        
        
    def finish(self):
        # Finish Function gets called after the last MCS
        pass
        
        
        
        
from PySteppables import *
from PySteppablesExamples import MitosisSteppableBase
import CompuCell
import sys

from PlayerPython import *
from math import *


class Mitosis(MitosisSteppableBase):
    def __init__(self,_simulator,_frequency=1):
        MitosisSteppableBase.__init__(self,_simulator, _frequency)
    
    def step(self,mcs):
        # print "INSIDE Mitosis"
        cells_to_divide = []
        
        for cell in self.cellList:
            if cell.volume>50:
                
                cells_to_divide.append(cell)
                
        for cell in cells_to_divide:
            # to change mitosis mode leave one of the below lines uncommented
            self.divideCellRandomOrientation(cell)
            # self.divideCellOrientationVectorBased(cell,1,0,0)                 # this is a valid option
            # self.divideCellAlongMajorAxis(cell)                               # this is a valid option
            # self.divideCellAlongMinorAxis(cell)                               # this is a valid option

    def updateAttributes(self):
        self.parentCell.targetVolume /= 2.0 # reducing parent target volume                 
        self.cloneParent2Child()            
        
#         # for more control of what gets copied from parent to child use cloneAttributes function
#         # self.cloneAttributes(sourceCell=self.parentCell, targetCell=self.childCell, no_clone_key_dict_list = [attrib1, attrib2] )
        
        
#         if self.parentCell.type==1:
#             self.childCell.type=2
#         else:
#             self.childCell.type=1
        
