from PlayerPython import * 
import CompuCellSetup

from PySteppables import *
import CompuCell
import sys

from random import uniform

class OscillatorSteppable(SteppableBasePy):    

    def __init__(self,_simulator,_frequency=1):
        SteppableBasePy.__init__(self,_simulator,_frequency)
        
        
#         self.track_cell_level_scalar_attribute (field_name = 'S0_heatmap',\
#         attribute_name = 'value_S0')
        
        self.scalarCLField = self.createScalarFieldCellLevelPy("S0_heatmap")                
        
    def myFunction(self):
        
        print self.scalarCLField 
        
        
    def start(self):
        
        
        modelFile='Simulation/osc.xml' 
        
        
        initialConditions={}
        initialConditions['S0'] = 1.0
        initialConditions['S1'] = 0.0        
        
        stepSize = 0.002
        
        self.addSBMLToCellTypes(\
        
        _modelFile=modelFile,\
        
        _modelName='OSC',\
        
        _types=[self.C,self.N],\
        
        _stepSize=stepSize,\
        
        _initialConditions=initialConditions\
        
        ) 
        
        new_cell = self.newCell(self.C)
        
        self.cellField[10:12,10:12,0] = new_cell
        
        self.addSBMLToCell(_modelFile=modelFile,\
        _modelName='OSC',\
        _cell=new_cell,\
        _stepSize=stepSize,\
        _initialConditions=initialConditions)
        
        
        
        
        for cell in self.cellList:
            cell.targetVolume = 25
            cell.lambdaVolume = 2.0
                        
        
        self.pW=self.addNewPlotWindow(_title='S0',_xAxisTitle='(MCS)',_yAxisTitle='Variables', _xScaleType='linear',_yScaleType='linear')
        self.pW.addPlot('S0_1',_style='Dots',_color='red',_size=5)
        self.pW.addPlot('S0_2',_style='Dots',_color='blue',_size=5)
        self.pW.addPlot('S0_10',_style='Dots',_color='green',_size=5)

        for cell in self.cellList:
            state=self.getSBMLState(_modelName='OSC',_cell=cell) 
            state['S0'] = uniform(0,3.0)
            state['S1'] = uniform(0,3.0)                            
            
#             self.setSBMLState(_modelName='OSC',_cell=cell,_state=state)
            


    def step(self,mcs):        
        
#         self.myFunction()
        
        for cell in self.cellList:
            state = self.getSBMLState(_modelName='OSC',_cell=cell)
            self.scalarCLField[ cell ]  = state['S0']
            
            
        
        #type here the code that will run every _frequency MCS
        for cell in self.cellList:
            state = self.getSBMLState(_modelName='OSC',_cell=cell)
            cell.dict['value_S0'] = state['S0']
            
            if cell.id == 1 :
                state = self.getSBMLState(_modelName='OSC',_cell=cell)
                self.pW.addDataPoint("S0_1",mcs,state['S0'])                 
                
            elif cell.id == 2 :                
                state = self.getSBMLState(_modelName='OSC',_cell=cell)
                self.pW.addDataPoint("S0_2",mcs,state['S0'])                 

            elif cell.id == 10 :                
                state = self.getSBMLState(_modelName='OSC',_cell=cell)
                self.pW.addDataPoint("S0_10",mcs,state['S0'])                 




        for cell in self.cellList:
            state=self.getSBMLState(_modelName='OSC',_cell=cell) 
            
            cell.targetVolume = 12 + 5*state['S0']
            
            
        
        
            

        self.timestepSBML()
                
            
    def finish(self):
        # Finish Function gets called after the last MCS
        pass
        