
from PySteppables import *
import CompuCell
import sys

from random import random
from random import uniform

class BacteriumMacrophageSteppable(SteppableBasePy):    

    def __init__(self,_simulator,_frequency=1):
        SteppableBasePy.__init__(self,_simulator,_frequency)
        
    def start(self):
        
        # MACROPHAGE        
        x = int( uniform(0,self.dim.x-1) )
        y = int( uniform(0,self.dim.y-1) )        
        self.cellField[x,y,0] = self.newCell(self.M) 
        
        # BACTERIUM        
        x = int( uniform(0,self.dim.x-1) )
        y = int( uniform(0,self.dim.y-1) )        
        self.cellField[x,y,0] = self.newCell(self.B)
       
        # RED BLOOD CELLS
        for i in range(20):
            x = int( uniform(0,self.dim.x-1) )
            y = int( uniform(0,self.dim.y-1) )
            self.cellField[x,y,0] = self.newCell(self.R)


        for cell in self.cellList:
            
            if cell.type == self.B:
                
                cell.targetVolume = 10.0
                cell.lambdaVolume = 10.0
                
            elif cell.type == self.M:
                cell.targetVolume = 200.0
                cell.lambdaVolume = 10.0
                
            elif cell.type == self.R:
                cell.targetVolume = 100.0
                cell.lambdaVolume = 10.0
                
            
        


    def step(self,mcs):        
        #type here the code that will run every _frequency MCS
        for cell in self.cellList:
            print "cell.id=",cell.id
    def finish(self):
        # Finish Function gets called after the last MCS
        pass
        