from PlayerPython import * 
import CompuCellSetup

from PySteppables import *
import CompuCell
import sys
class GrowthSteppable(SteppableBasePy):    

    def __init__(self,_simulator,_frequency=1):
        SteppableBasePy.__init__(self,_simulator,_frequency)
        self.scalarCLField=self.createScalarFieldCellLevelPy("Age")
        
    def start(self):
        
        
        
#         x=50
#         y=50
#         size=5
#         cell=self.newCell(self.A)
#         self.cellField[x:x+size-1,y:y+size-1,0]=cell 
        
        
        cell=self.createNewCell(self.A, [50,50,0] , xSize=5,ySize=5,zSize=1) 
        
        for cell in self.cellList:
            cell.lambdaVolume=2.0
            cell.targetVolume=25.0
            
            cellDict=self.getDictionaryAttribute(cell)
            cellDict["InitMCS"]=0
            cellDict["initVol"]=cell.volume
            
            
            
            
        
        
        
        
        
        
        
    def step(self,mcs):        
        #type here the code that will run every _frequency MCS
        
        self.scalarCLField.clear()
        for cell in self.cellList:
            cellDict=self.getDictionaryAttribute(cell)
            self.scalarCLField[cell] = mcs-cellDict['InitMCS']
            
            
        
        
        if mcs <2000:
            for cell in self.cellList:
                cell.targetVolume += 0.1
            
            
            
            
        if mcs >= 2000:
            for cell in self.cellList:
                cell.targetVolume=0.0
                
                
        if mcs >= 2000:
            field=self.getConcentrationField("FGF")
            field[0:100,0:100,0]=0.0
            field[:,:,:]=0.0
            
            
            
        
        if (mcs % 100) == 0 :
            for cell in self.cellList:
                cellDict=self.getDictionaryAttribute(cell)
                print 'cell.id=',cell.id
                print cellDict
                
                
                
            
            
            
            
            
            
            
    def finish(self):
        # Finish Function gets called after the last MCS
        pass
        
from PySteppables import *
from PySteppablesExamples import MitosisSteppableBase
import CompuCell
import sys

from PlayerPython import *
from math import *


class Mitosis(MitosisSteppableBase):
    def __init__(self,_simulator,_frequency=1):
        MitosisSteppableBase.__init__(self,_simulator, _frequency)
        self.mcs=0
        
    def step(self,mcs):
        self.mcs=mcs
        # print "INSIDE Mitosis"
        cells_to_divide=[]
        for cell in self.cellList:
            if cell.volume>50:
                
                cells_to_divide.append(cell)
                
        for cell in cells_to_divide:
            # to change mitosis mode leave one of the below lines uncommented
            self.divideCellRandomOrientation(cell)
            # self.divideCellOrientationVectorBased(cell,1,0,0)                 # this is a valid option
            # self.divideCellAlongMajorAxis(cell)                               # this is a valid option
            # self.divideCellAlongMinorAxis(cell)                               # this is a valid option

    def updateAttributes(self):
        parentCell=self.mitosisSteppable.parentCell
        childCell=self.mitosisSteppable.childCell
        
        childCellDict=self.getDictionaryAttribute(childCell)
        childCellDict["InitMCS"]=self.mcs
        childCellDict["initVol"]=childCell.volume
        
        
        
        
        
        parentCell.targetVolume=25
        
        
        
        childCell.targetVolume=parentCell.targetVolume
        childCell.lambdaVolume=parentCell.lambdaVolume
        if parentCell.type==1:
            childCell.type=2
        else:
            childCell.type=2
        
