
from PySteppables import *
import CompuCell
import sys
class VascularSteppable(SteppableBasePy):    

    def __init__(self,_simulator,_frequency=1):
        SteppableBasePy.__init__(self,_simulator,_frequency)
    def start(self):
        
        cell=self.createNewCell(self.TUMOR, [160,160,0] , xSize=5,ySize=5,zSize=1) # args - type, location of seed point, x,y,z dimansions           
        
        for cell in self.cellList:
            cell.lambdaVolume=13.0
            cell.targetVolume=25.0
        

            
        
        
    def step(self,mcs):        
        
        field=self.getConcentrationField("Glucose")
        
        
        
            # you can access/manipulate cell properties here
            print "id=",cell.id," type=",cell.type
            
        
        for cell in self.cellListByType(self.VASC): # list of  cell types (capitalized)
            if cell.xCOM>100 and cell.yCOM>100 :
                field[int(cell.xCOM),int(cell.yCOM),0] += 1.0
                
        growth_rate=1.0    
        
        for cell in self.cellList:
            if cell.type == self.TUMOR:
                cell.targetVolume += growth_rate*field[int(cell.xCOM),int(cell.yCOM),0]
        
            
    def finish(self):
        # Finish Function gets called after the last MCS
        pass
        
from PySteppables import *
from PySteppablesExamples import MitosisSteppableBase
import CompuCell
import sys

from PlayerPython import *
from math import *


class Mitosis(MitosisSteppableBase):
    def __init__(self,_simulator,_frequency=1):
        MitosisSteppableBase.__init__(self,_simulator, _frequency)
    
    def step(self,mcs):
        # print "INSIDE Mitosis"
        cells_to_divide=[]
        for cell in self.cellList:
            
            if cell.volume>50 and cell.type == self.TUMOR:
                
                cells_to_divide.append(cell)
                
        for cell in cells_to_divide:
            self.divideCellRandomOrientation(cell)
 

    def updateAttributes(self):
        parentCell=self.mitosisSteppable.parentCell
        childCell=self.mitosisSteppable.childCell
        
        parentCell.targetVolume=25
        
        from random import random
        rnd_number=random()
        
        
        childCell.targetVolume=parentCell.targetVolume
        
        childCell.lambdaVolume=parentCell.lambdaVolume
        
        childCell.type=self.TUMOR

            
#         childCell.type=self.TUMOR    
        




