
from PySteppables import *
import CompuCell
import sys

from PySteppablesExamples import MitosisSteppableBase

import bionetAPI
class ConstraintInitializerSteppable(SteppableBasePy):
    def __init__(self,_simulator,_frequency=1):
        SteppableBasePy.__init__(self,_simulator,_frequency)
        bionetAPI.initializeBionetworkManager(self.simulator)
    
    def start(self):
        #Loading model
        ModelName = "CellCycle"
        ModelKey = "CC"
        import os
        fileDir=os.path.dirname (os.path.abspath( __file__ ))
        ModelPath =  fileDir+"/CellCycle_Tyson.sbml"
        IntegrationStep = 0.2
        bionetAPI.loadSBMLModel(ModelName, ModelPath, ModelKey, IntegrationStep)
        
        bionetAPI.addSBMLModelToTemplateLibrary(ModelName,"Condensing")
        bionetAPI.initializeBionetworks()
    
        #Initial conditions
        for cell in self.cellList:
            cell.targetVolume=49
            cell.lambdaVolume=4.0
            bionetAPI.setBionetworkValue("CC_m",cell.volume/49.0,cell.id)
            dict_attrib=CompuCell.getPyAttrib(cell)
            dict_attrib["CycB"]=bionetAPI.getBionetworkValue("CC_CycB",cell.id)
            
    def step(self,mcs):
        for cell in self.cellList:
            #Setting volume parameter for each cell
            bionetAPI.setBionetworkValue("CC_m",cell.volume/49.0,cell.id)
            #Storing CycB and Cdh1 levels of each cell
            dict_attrib=CompuCell.getPyAttrib(cell)
            dict_attrib["CycB0"]=dict_attrib["CycB"]
            dict_attrib["CycB"]=bionetAPI.getBionetworkValue("CC_CycB",cell.id)
        #Iterating the ODEs
        bionetAPI.timestepBionetworks()


class GrowthSteppable(SteppableBasePy):
    def __init__(self,_simulator,_frequency=1):
        SteppableBasePy.__init__(self,_simulator,_frequency)
    
    def step(self,mcs):
        for cell in self.cellList:
            if cell.targetVolume<49:
                cell.targetVolume+=0.1


class MitosisSteppable(MitosisSteppableBase):
    def __init__(self,_simulator,_frequency=1):
        MitosisSteppableBase.__init__(self,_simulator,_frequency)
    
    def step(self,mcs):
        cells_to_divide=[]
        for cell in self.cellList:
            dict_attrib=CompuCell.getPyAttrib(cell)
            if (dict_attrib["CycB"]<=0.1 and dict_attrib["CycB0"]>0.1):
                cells_to_divide.append(cell)
        for cell in cells_to_divide:
            self.divideCellRandomOrientation(cell)

    def updateAttributes(self):  
        parentCell=self.mitosisSteppable.parentCell
        childCell=self.mitosisSteppable.childCell
         
        #transfering attributes
        childCell.type=parentCell.type
        bionetAPI.copyBionetworkFromParent(parentCell,childCell)
        #volume
        parentCell.targetVolume=parentCell.volume
        childCell.targetVolume=childCell.volume
        childCell.lambdaVolume=parentCell.lambdaVolume
        #dictionaries
        parentDict_attrib=CompuCell.getPyAttrib(parentCell)
        childDict_attrib=CompuCell.getPyAttrib(childCell)
        from copy import deepcopy
        for key,item in parentDict_attrib.items():
            if (key!="Bionetwork"): 
                childDict_attrib[key] = deepcopy(parentDict_attrib[key])
        
        
from PySteppables import *
import CompuCell
import sys

from PlayerPython import *
import CompuCellSetup
from math import *


class VisualizationField(SteppableBasePy):
    def __init__(self,_simulator,_frequency):
        SteppableBasePy.__init__(self,_simulator,_frequency)
        self.scalarCLField=CompuCellSetup.createScalarFieldCellLevelPy("CycB")
        
    def step(self,mcs):
        clearScalarValueCellLevel(self.scalarCLField)
        for cell in self.cellList:
            dict_attrib=CompuCell.getPyAttrib(cell)
            fillScalarValueCellLevel(self.scalarCLField,cell,dict_attrib["CycB"])

    
