from PlayerPython import * 
import CompuCellSetup

from PySteppables import *
import CompuCell
import sys
import bionetAPI

class CellCycleSteppable(SteppableBasePy):    
    def __init__(self,_simulator,_frequency):
        SteppableBasePy.__init__(self,_simulator,_frequency)
        bionetAPI.initializeBionetworkManager(self.simulator)
        
    def start(self):
        for cell in self.cellList: #setting initial cell volumes
            cell.targetVolume=25
            cell.lambdaVolume=5
        
        modelName = "CellCycle" 
        modelNickname  = "CC"   
        import os
        fileDir=os.path.dirname (os.path.abspath( __file__ )) 
        modelPath = fileDir+"\BIOMD0000000003.xml" 
        integrationStep = 0.2   
        bionetAPI.loadSBMLModel(modelName, modelPath, modelNickname, integrationStep)
        
        bionetAPI.addSBMLModelToTemplateLibrary(modelName,"Condensing")
        
        modelName = "CellCycle2" 
        modelNickname  = "CC2"   
        import os
        fileDir=os.path.dirname (os.path.abspath( __file__ )) 
        modelPath = fileDir+"\BIOMD0000000003.xml" 
        integrationStep = 0.1
        bionetAPI.loadSBMLModel(modelName, modelPath, modelNickname, integrationStep)
        
        bionetAPI.addSBMLModelToTemplateLibrary(modelName,"NonCondensing") 
        
        bionetAPI.initializeBionetworks()
        
    def step(self,mcs):
        bionetAPI.timestepBionetworks() # iterating the SBML model

from PySteppables import *
import CompuCell
import sys

from PlayerPython import *
import CompuCellSetup
from math import *

class VisualizationField(SteppableBasePy):
    def __init__(self,_simulator,_frequency):
        SteppableBasePy.__init__(self,_simulator,_frequency)
        self.scalarCLField=CompuCellSetup.createScalarFieldCellLevelPy("M")

    def step(self,mcs):
        clearScalarValueCellLevel(self.scalarCLField) #cleaning filed
        for cell in self.cellList: #"painting" each cell with the value of M
            if cell.type==self.CONDENSING:
                M=bionetAPI.getBionetworkValue("CC_M",cell.id) 
                fillScalarValueCellLevel(self.scalarCLField,cell,M)
            else:
                M=bionetAPI.getBionetworkValue("CC2_M",cell.id) 
                fillScalarValueCellLevel(self.scalarCLField,cell,M)

from PySteppables import *
from PySteppablesExamples import MitosisSteppableBase
import CompuCell
import sys

from PlayerPython import *
from math import *

class Mitosis(MitosisSteppableBase):
    def __init__(self,_simulator,_frequency):
        MitosisSteppableBase.__init__(self,_simulator,_frequency)
    
    def start(self):
        for cell in self.cellList: #store initial value of M (cdc2 kinase)
            dict_attrib=CompuCell.getPyAttrib(cell)
            if cell.type==self.CONDENSING:
                dict_attrib["M"]=bionetAPI.getBionetworkValue("CC_M",cell.id)
            else:
                dict_attrib["M"]=bionetAPI.getBionetworkValue("CC2_M",cell.id)
    
    def step(self,mcs):
        cells_to_divide=[]
        for cell in self.cellList:
            #growing cells back
            if cell.targetVolume<25:
                cell.targetVolume+=0.1
            #get current value of M
            dict_attrib=CompuCell.getPyAttrib(cell)
            if cell.type==self.CONDENSING:
                M=bionetAPI.getBionetworkValue("CC_M",cell.id)
            else:
                M=bionetAPI.getBionetworkValue("CC2_M",cell.id)
            if (M>0.7 and dict_attrib["M"]<0.7): #check division condition
                cells_to_divide.append(cell)
            dict_attrib["M"]=M #store current value of M for the next step
        for cell in cells_to_divide:
            self.divideCellRandomOrientation(cell)

    def updateAttributes(self):
        parentCell=self.mitosisSteppable.parentCell
        childCell=self.mitosisSteppable.childCell
        parentCell.targetVolume/=2
        childCell.targetVolume=parentCell.targetVolume
        childCell.lambdaVolume=parentCell.lambdaVolume
        #set cell type
        childCell.type=parentCell.type
        bionetAPI.copyBionetworkFromParent(parentCell,childCell)
        #coping dictionaries
        dict_attrib_Child=CompuCell.getPyAttrib(childCell)
        dict_attrib_Parent=CompuCell.getPyAttrib(parentCell)
        dict_attrib_Child["M"]=dict_attrib_Parent["M"]