#!/bin/sh

# echo " "
# echo " dollar-zero AKA the first argument to this .command script is: "
# echo $0
# echo " "
export PYTHON_MINOR_VERSION=7

cd "${0%/*}"


export PREFIX_CC3D=$(pwd)
export PYTHON_EXEC_FILE=${PREFIX_CC3D}/python27/bin/python2.7

export TWEDIT_PYTHON_APP=${PREFIX_CC3D}/python27/twedit++.app/Contents/MacOS/python

if [ -e ${TWEDIT_PYTHON_APP} ]
then
    echo "Using app"
    export PYTHON_EXEC_FILE=${TWEDIT_PYTHON_APP}
    export PYTHON_EXEC=${TWEDIT_PYTHON_APP}
else
    echo "Using script"
    ln -s ${PYTHON_EXEC_FILE} ${PREFIX_CC3D}/Twedit++
    export PYTHON_EXEC=${PREFIX_CC3D}/Twedit++
fi

current_directory=$(pwd)

cd $PREFIX_CC3D

echo "====> twedit++ working directory: $PREFIX_CC3D"

export PYTHONPATH=

export DYLD_LIBRARY_PATH=${PREFIX_CC3D}/lib
export DYLD_LIBRARY_PATH=${PREFIX_CC3D}/lib/python:$DYLD_LIBRARY_PATH

export SWIG_LIB_INSTALL_DIR=${PREFIX_CC3D}/lib/python

export PYTHON_MODULE_PATH=${PREFIX_CC3D}/pythonSetupScripts



export PYTHONPATH=${PREFIX_CC3D}/player:$PYTHONPATH
echo "====> PYTHONPATH directory: $PYTHONPATH"




echo "---- ---- ---- ---- ---- ---- ---- ---- "
echo " setting the PYTHONLIB_SYSTEM shell variable as used by CompuCell3D: "


osx_version=$(sw_vers -productVersion)
osx_major=$(echo $osx_version | cut -d. -f1)
osx_minor=$(echo $osx_version | cut -d. -f2)

osx_minor=$((osx_minor+0))
osx_major=$((osx_major+0))

if [ $osx_minor -ge 11 ]
then
    echo 'GOT >11'

fi
echo ${osx_major}-${osx_minor}

echo " ====> PYTHONLIB_SYSTEM: $PYTHONLIB_SYSTEM"


echo "---- ---- ---- ---- ---- ---- ---- ---- "
echo " setting the PATH shell variable as used by CompuCell3D: "
export PATH=${PYTHONLIB_SYSTEM}/bin:$PATH

# ln -s ${PYTHON_EXEC_FILE} ${PREFIX_CC3D}/Twedit++
# export PYTHON_EXEC=${PREFIX_CC3D}/Twedit++





export TWEDIT_MAJOR_VERSION=0
export TWEDIT_MINOR_VERSION=9
export TWEDIT_BUILD_VERSION=0


${PYTHON_EXEC} ${PREFIX_CC3D}/Twedit++5/twedit_plus_plus_cc3d.py $*


cd ${current_directory}
