#!/bin/bash

# echo " "
# echo " dollar-zero AKA the first argument to this .command script is: "
# echo $0
# echo " "

export PYTHON_MINOR_VERSION=7
cd "${0%/*}"


export COMPUCELL3D_MAJOR_VERSION=3
export COMPUCELL3D_MINOR_VERSION=7
export COMPUCELL3D_BUILD_VERSION=9

echo " "
echo "---- ---- ---- ---- ---- ---- ---- ---- "
echo "  CompuCell3D version $COMPUCELL3D_MAJOR_VERSION.$COMPUCELL3D_MINOR_VERSION.$COMPUCELL3D_BUILD_VERSION"
echo "---- ---- ---- ---- ---- ---- ---- ---- "


# the "PREFIX_CC3D" shell variable is used by CompuCell3D code, its name can NOT be modified:
export PREFIX_CC3D=$(pwd)
export PYTHON_EXEC=${PREFIX_CC3D}/python27/bin/python2.7

export MAX_NUMBER_OF_CONSECUTIVE_RUNS=50

cd $PREFIX_CC3D

pwd

export PYTHON_MODULE_PATH=${PREFIX_CC3D}/pythonSetupScripts

export COMPUCELL3D_PLUGIN_PATH=${PREFIX_CC3D}/lib/CompuCell3DPlugins

export COMPUCELL3D_STEPPABLE_PATH=${PREFIX_CC3D}/lib/CompuCell3DSteppables

export SWIG_LIB_INSTALL_DIR=${PREFIX_CC3D}/lib/python

export SOSLIB_PATH=${PREFIX_CC3D}

export PYTHONPATH=${PREFIX_CC3D}/pythonSetupScripts

export PYTHONPATH=${PREFIX_CC3D}/lib/python:$PYTHONPATH

export PYTHONPATH=${PREFIX_CC3D}/vtk/lib/python2.7/site-packages/:$PYTHONPATH

export DYLD_LIBRARY_PATH=${PREFIX_CC3D}/lib

export DYLD_LIBRARY_PATH=${PREFIX_CC3D}/lib/python:$DYLD_LIBRARY_PATH

export DYLD_LIBRARY_PATH=${PREFIX_CC3D}/vtk/lib:$DYLD_LIBRARY_PATH

export DYLD_LIBRARY_PATH=${PREFIX_CC3D}/player5/Utilities:$DYLD_LIBRARY_PATH

export DYLD_LIBRARY_PATH=${COMPUCELL3D_PLUGIN_PATH}:$DYLD_LIBRARY_PATH

export DYLD_LIBRARY_PATH=${COMPUCELL3D_STEPPABLE_PATH}:$DYLD_LIBRARY_PATH

# in case rr ships with dylibs
export DYLD_LIBRARY_PATH=${PREFIX_CC3D}/lib/python/roadrunner:$DYLD_LIBRARY_PATH

# we don't need to set any PYTHONPATH values:
# export PYTHONPATH=${PYTHONLIB_26_SYSTEM}/lib/python2.5/:${PYTHONLIB_26_SYSTEM}/python2.5/lib-dynload/:${PYTHONLIB_26_SYSTEM}/bin/

# export PYTHONLIB_SYSTEM=/System/Library/Frameworks/Python.framework/Versions/2.${PYTHON_MINOR_VERSION}
# export PYTHON_EXEC=python2.${PYTHON_MINOR_VERSION}

osx_version=$(sw_vers -productVersion)
osx_major=$(echo $osx_version | cut -d. -f1)
osx_minor=$(echo $osx_version | cut -d. -f2)

osx_minor=$((osx_minor+0))
osx_major=$((osx_major+0))

if [ $osx_minor -ge 11 ]
then
    echo 'GOT >11'

fi
echo ${osx_major}-${osx_minor}


# if [ $osx_minor -ge 11 ]
# then
#
#     if [ ! -f "${PREFIX_CC3D}/cc3d_python" ]
#     then
#         #cp /usr/bin/python2.${PYTHON_MINOR_VERSION} ${PREFIX_CC3D}/cc3d_python
#         cp /System/Library/Frameworks/Python.framework/Versions/2.${PYTHON_MINOR_VERSION}/Resources/Python.app/Contents/MacOS/Python ${PREFIX_CC3D}/cc3d_python
#     fi
#
#     export PYTHON_EXEC=${PREFIX_CC3D}/cc3d_python
# fi
#

echo " ====> PYTHONLIB_SYSTEM: $PYTHONLIB_SYSTEM"


echo "---- ---- ---- ---- ---- ---- ---- ---- "
echo " setting the PATH shell variable as used by CompuCell3D: "
# avoid any previously user-defined DYLD_LIBRARY_PATH values:
# export PATH=${PREFIX_CC3D}/LIBRARYDEPS/sipDeps:${PYTHONLIB_26_SYSTEM}/bin:${PYTHONLIB_26_SYSTEM}:${PREFIX_CC3D}/LIBRARYDEPS:${PREFIX_CC3D}/LIBRARYDEPS/LIBRARY-PYTHON-2.5/Extras/lib/python/wx/lib:$PATH
# export PATH=${PYTHONLIB_26_SYSTEM}/bin:${PYTHONLIB_26_SYSTEM}
export PATH=${PYTHONLIB_SYSTEM}/bin:$PATH


# export PYTHON_EXEC=${PREFIX_CC3D}/python27/bin/python2.7
${PYTHON_EXEC} --version


# python ${PREFIX_CC3D}/player/CompuCellPythonSimulationCML.py $* --currentDir=${current_directory}

export exit_code=0
${PYTHON_EXEC} ${PREFIX_CC3D}/player5/CompuCellPythonSimulationCML.py $* --currentDir=${PREFIX_CC3D}
exit_code=$?

# cd ${current_directory}
cd ${PREFIX_CC3D}
exit ${exit_code}
