#!/bin/bash

# echo " "
# echo " dollar-zero AKA the first argument to this .command script is: "
# echo $0
# echo " "
export PYTHON_MINOR_VERSION=7
cd "${0%/*}"



# language settings
export LANG=en_EN
export __CF_USER_TEXT_ENCODING=""

export COMPUCELL3D_MAJOR_VERSION=3
export COMPUCELL3D_MINOR_VERSION=7
export COMPUCELL3D_BUILD_VERSION=5


echo " "
echo "---- ---- ---- ---- ---- ---- ---- ---- "
echo "  CompuCell3D version $COMPUCELL3D_MAJOR_VERSION.$COMPUCELL3D_MINOR_VERSION.$COMPUCELL3D_BUILD_VERSION"
echo "     (OS X 10.8 x86_64 build) "
echo "---- ---- ---- ---- ---- ---- ---- ---- "



export PREFIX_CC3D=$(pwd)

export PYTHON_EXEC_FILE=${PREFIX_CC3D}/python27/bin/python2.7

export CC3D_PYTHON_APP=${PREFIX_CC3D}/python27/compucell3d.app/Contents/MacOS/python

if [ -e ${CC3D_PYTHON_APP} ]
then
    echo "Using app"
    export PYTHON_EXEC_FILE=${CC3D_PYTHON_APP}
    export PYTHON_EXEC=${CC3D_PYTHON_APP}
else
    echo "Using script"
    ln -s ${PYTHON_EXEC_FILE} ${PREFIX_CC3D}/Twedit++
    export PYTHON_EXEC=${PREFIX_CC3D}/Twedit++
fi



export MAX_NUMBER_OF_CONSECUTIVE_RUNS=50


cd $PREFIX_CC3D

pwd

export PYTHONPATH=

export PYTHON_MODULE_PATH=${PREFIX_CC3D}/pythonSetupScripts

export COMPUCELL3D_PLUGIN_PATH=${PREFIX_CC3D}/lib/CompuCell3DPlugins

export COMPUCELL3D_STEPPABLE_PATH=${PREFIX_CC3D}/lib/CompuCell3DSteppables

export SWIG_LIB_INSTALL_DIR=${PREFIX_CC3D}/lib/python

export SOSLIB_PATH=${PREFIX_CC3D}

export PYTHONPATH=${PREFIX_CC3D}/pythonSetupScripts

export PYTHONPATH=${PREFIX_CC3D}/lib/python:$PYTHONPATH

export PYTHONPATH=${PREFIX_CC3D}/vtk/lib/python2.7/site-packages/:$PYTHONPATH

export DYLD_LIBRARY_PATH=${PREFIX_CC3D}/lib

export DYLD_LIBRARY_PATH=${PREFIX_CC3D}/lib/python:$DYLD_LIBRARY_PATH

export DYLD_LIBRARY_PATH=${PREFIX_CC3D}/vtk/lib:$DYLD_LIBRARY_PATH

export DYLD_LIBRARY_PATH=${PREFIX_CC3D}/player5/Utilities:$DYLD_LIBRARY_PATH

export DYLD_LIBRARY_PATH=${COMPUCELL3D_PLUGIN_PATH}:$DYLD_LIBRARY_PATH

export DYLD_LIBRARY_PATH=${COMPUCELL3D_STEPPABLE_PATH}:$DYLD_LIBRARY_PATH

# in case rr ships with dylibs
export DYLD_LIBRARY_PATH=${PREFIX_CC3D}/lib/python/roadrunner:$DYLD_LIBRARY_PATH

# we don't need to set any PYTHONPATH values:
# export PYTHONPATH=${PYTHONLIB_26_SYSTEM}/lib/python2.5/:${PYTHONLIB_26_SYSTEM}/python2.5/lib-dynload/:${PYTHONLIB_26_SYSTEM}/bin/


echo "---- ---- ---- ---- ---- ---- ---- ---- "
echo " setting the PYTHONLIB_SYSTEM shell variable as used by CompuCell3D: "
export PYTHONLIB_SYSTEM=/System/Library/Frameworks/Python.framework/Versions/2.${PYTHON_MINOR_VERSION}


osx_version=$(sw_vers -productVersion)
osx_major=$(echo $osx_version | cut -d. -f1)
osx_minor=$(echo $osx_version | cut -d. -f2)

osx_minor=$((osx_minor+0))
osx_major=$((osx_major+0))

if [ $osx_minor -ge 11 ]
then
    echo 'GOT >11'

fi
echo ${osx_major}-${osx_minor}


echo " ====> PYTHONLIB_SYSTEM: $PYTHONLIB_SYSTEM"

# avoid any previously user-defined DYLD_LIBRARY_PATH values:
# export PATH=${PREFIX_CC3D}/LIBRARYDEPS/sipDeps:${PYTHONLIB_26_SYSTEM}/bin:${PYTHONLIB_26_SYSTEM}:${PREFIX_CC3D}/LIBRARYDEPS:${PREFIX_CC3D}/LIBRARYDEPS/LIBRARY-PYTHON-2.5/Extras/lib/python/wx/lib:$PATH

export PATH=${PYTHONLIB_SYSTEM}/bin:$PATH
echo " ====> PATH: $PATH"

# ln -s ${PREFIX_CC3D}/python27/bin/python2.7 ${PREFIX_CC3D}/CompuCell3D

# ln -s ${PYTHON_EXEC_FILE} ${PREFIX_CC3D}/CompuCell3D
# export PYTHON_EXEC=${PREFIX_CC3D}/CompuCell3D

${PYTHON_EXEC} --version

echo "---- ---- ---- ---- ---- ---- ---- ---- "
echo " "
echo " Now starting CompuCell3D $COMPUCELL3D_MAJOR_VERSION.$COMPUCELL3D_MINOR_VERSION.$COMPUCELL3D_BUILD_VERSION  in GUI mode:"
echo " "

export exit_code=0
${PYTHON_EXEC} ${PREFIX_CC3D}/player5/compucell3d.pyw $* --currentDir=${PREFIX_CC3D}
exit_code=$?

cd ${PREFIX_CC3D}
exit ${exit_code}
