#
# compucell3d.pyw - main Python script for the CompuCell3D interactive (GUI) application
#
import sys
import os

def setVTKPaths():
   import sys
   from os import environ
   import string
   import sys
   platform=sys.platform
   if platform=='win32':
      sys.path.append(environ["VTKPATH"])
      sys.path.append(environ["VTKPATH1"])
      sys.path.append(environ["PYQT_PATH"])
      sys.path.append(environ["SIP_PATH"])
      sys.path.append(environ["SIP_UTILS_PATH"])
#   else:
#      swig_path_list=string.split(environ["VTKPATH"])
#      for swig_path in swig_path_list:
#         sys.path.append(swig_path)

# print "PATH=",sys.path
setVTKPaths()
# print "PATH=",sys.path  

#mainWindow = None

from PyQt4.QtCore import *
from PyQt4.QtGui import *


def main(argv):
    argc=len(argv)
    from CQt.CQApplication import CQApplication    
    app = CQApplication(argv)
    
    pixmap = QPixmap("icons/splash_angio.png")
    splash = QSplashScreen(pixmap)
    splash.show()
    
    # RWH:  not sure why vtk was being imported here
    #splash.showMessage("Loading VTK modules...",Qt.AlignLeft,  Qt.white)
    #import vtk    
    
    splash.showMessage("Loading User Interface ...",Qt.AlignLeft,  Qt.white)
    from UI.UserInterface import UserInterface    
    from CQt.CQApplication import CQApplication
    
    sys.path.append(os.environ["PYTHON_MODULE_PATH"])
    sys.path.append(os.environ["SWIG_LIB_INSTALL_DIR"])
    
    splash.showMessage("Loading CompuCell3D Python Modules...",Qt.AlignLeft,  Qt.white)
    import CompuCellSetup
    CompuCellSetup.playerType="new" # the value of CompuCellSetup.playerType (can be "new" or "old") determines which PlayerPython module will be loaded. For the new player we want PlayerPythonNew
    import PlayerPython # from now on import PlayerPython will import PlayerPythonNew
    
    app.processEvents()
    
    mainWindow = UserInterface()
    mainWindow.setArgv(argv) # passing command line to the code
    
    # process reminder of the command line options
    if argv != "":
        mainWindow.viewmanager.processCommandLineOptions()
    
    mainWindow.show()
    splash.finish(mainWindow)

    # 2010: mainWindow.raise_() must be called after mainWindow.show() 
    #       otherwise the CC3D player GUI won't receive foreground focus. It's a
    #       workaround for a well-known bug caused by PyQt4/Qt on Mac OS X, as shown here:
    #       http://www.riverbankcomputing.com/pipermail/pyqt/2009-September/024509.html
    mainWindow.raise_()
    
    app.exec_()

if __name__ == '__main__':
    main(sys.argv[1:])
