# -*- coding: utf-8 -*-
import os, sys
import re
import inspect
import string

from PyQt4.QtCore import *
from PyQt4.QtGui import *
from PyQt4.QtXml import *


FIELD_TYPES = ("CellField", "ConField", "ScalarField", "ScalarFieldCellLevel", "VectorField", "VectorFieldCellLevel")
PLANES      = ("xy", "xz", "yz")

MODULENAME = '---- SimpleTabView.py: '


# from ViewManager.ViewManager import ViewManager
from ViewManager.SimpleViewManager import SimpleViewManager
from  Graphics.GraphicsFrameWidget import GraphicsFrameWidget

from Utilities.QVTKRenderWidget import QVTKRenderWidget
from Utilities.SimModel import SimModel
from Configuration.ConfigurationDialog import ConfigurationDialog
import Configuration

from Simulation.CMLResultReader import CMLResultReader

from Simulation.SimulationThread import SimulationThread
# from Simulation.SimulationThread1 import SimulationThread1

import ScreenshotManager
import vtk
from RollbackImporter import RollbackImporter

class SimpleTabView(QMdiArea,SimpleViewManager):

    def __init__(self, parent):
        self.__parent = parent # QMainWindow -> UI.UserInterface
        QTabWidget.__init__(self, parent)
        SimpleViewManager.__init__(self, parent)
        self.__createStatusBar()
        self.__setConnects()
        
        self.scrollView=QScrollArea(self)
        self.scrollView.setBackgroundRole(QPalette.Dark)
        self.scrollView.setVisible(False)
        
        # turning off vtk debug output. Thisd requires small modification to the vtk code itself. Files affected vtkOutputWindow.h vtkOutputWindow.cxx vtkWin32OutputWindow.h vtkWin32OutputWindow.cxx
        if hasattr(vtk.vtkOutputWindow,"setOutputToWindowFlag"):            
            vtkOutput=vtk.vtkOutputWindow.GetInstance()
            vtkOutput.setOutputToWindowFlag(False)
            
        #had to introduce separate scrollArea for 2D and 3D widgets. for some reason switching graphics widgets in Scroll area  did not work correctly. 
        self.scrollView3D=QScrollArea(self)
        self.scrollView3D.setBackgroundRole(QPalette.Dark)
        self.scrollView3D.setVisible(False)
        #qworkspace        
        # self.setScrollBarsEnabled(True)    

        self.setVerticalScrollBarPolicy(Qt.ScrollBarAsNeeded)
        self.setHorizontalScrollBarPolicy(Qt.ScrollBarAsNeeded)                
        
        self.rollbackImporter=None
        
        from PlotManagerSetup import createPlotManager
        self.plotManager=createPlotManager(self) # object that is responsible for creating and managing plot windows sdo that they are accessible from steppable level 
        print "\n\n\n self.plotManager=",self.plotManager
        
        self.pluginTab  = None
        self.sim        = None
        
        self.simulation = None
        self.screenshotManager=None
        self.zitems     = []
        self.__fileName = ""        
        self.setParams()
        self.__fieldType = ("Cell_Field", FIELD_TYPES[0])
        self.simulationIsStepping=False
        self.simulationIsRunning=False
        self.screenshotDirectoryName=""
        self.playerSettingsFileName = ""
        self.resultStorageDirectory=""
        self.customScreenshotDirectoryName=""
        self.baseScreenshotName=""
        self.latticeType=Configuration.LATTICE_TYPES["Square"]
        self.newDrawingUserRequest=False
        self.completedFirstMCS=False
        
        self.cmlHandlerCreated=False
        
        self.basicSimulationData=None
        self.saveSettings=True
        
        self.closePlayerAfterSimulationDone=False
        
        self.__screenshotDescriptionFileName=""
        
        self.__viewManagerType="Regular"
        
        self.screenshotNumberOfDigits=10 #this determines how many digits screenshot number of screenshot file name should have
        
        self.windowCounter=0
        self.windowDict={}
        self.plotWindowDict={}
        self.graphicsWindowDict={}
        self.mdiWindowDict={} # this extra dictionary is needed to map widget number to mdiWidget. when inserting window to mdiArea it is wrapped as QMdiSubWindow and QMdiSubwindow are used as identifiers 
                              # in managing QMdiArea. If we sore only underlying widgets (i.e. those that QMdisubwindow wrap than we willnot have access to QMdiSubWindow when e.g. we want ot make it actice )
                              # we might also use subWindowList to deal with it but for now we will use the solution with extra dictionary
        self.graphicsWindowActionsDict={}
        self.lastActiveWindow=None
        self.lastPositionMainGraphicsWindow=None
        self.newWindowDefaultPlane=None
        
        # for more information on QSignalMapper see Mark Summerfield book "Rapid GUI Development with PyQt"
        self.windowMapper = QSignalMapper(self)
        self.connect(self.windowMapper,SIGNAL("mapped(QWidget*)"),  self.setActiveSubWindowCustomSlot)        
        
        
        self.prepareForNewSimulation(_forceGenericInitialization=True)                
        self.keepOldTabs=False #this flag sets if tabs should be removed before creating new one or not
        
        self.mainGraphicsWindow=None
        
        # determine if some relevant plugins are defined in the model
        self.pluginFPPDefined = False   # FocalPointPlasticity
        self.pluginCOMDefined = False   # CenterOfMass
        # is there a better way to check for plugins being defined?
        # mainGraphicsWindow.drawModel2D.currentDrawingParameters.bsd.sim.getCC3DModuleData("Plugin","FocalPointPlasticity"):
        
        # Note: we cannot check the plugins here as CompuCellSetup.cc3dXML2ObjConverter.root is not defined
        
    
    def updateRecentFileMenu(self):
        menusDict=self.__parent.getMenusDictionary()
        rencentSimulationsMenu=menusDict["recentSimulations"]    
        rencentSimulationsMenu.clear()
        recentSimulations=Configuration.getSimulation("RecentSimulations")
        simCounter=1
        for simulationFileName in recentSimulations:
            actionText = self.tr("&%1 %2").arg(simCounter).arg(simulationFileName)
            # action=rencentSimulationsMenu.addAction(actionText)
            action=QAction("&%d %s " % (simCounter,simulationFileName) , self)
            rencentSimulationsMenu.addAction(action)
            action.setData(QVariant(simulationFileName))
            self.connect(action,SIGNAL("triggered()"),self.__openRecentSim)
            
            simCounter+=1
            
        return

        
    def setActiveSubWindowCustomSlot(self, window):
        print "\n\n\nsetActiveSubWindow\n\n\n window=",window
        if window:
            self.setActiveSubWindow(window)
            self.lastActiveWindow=window
            # print "self.lastActiveWindow is ",self.lastActiveWindow.windowTitle()
        

    def updateWindowMenu(self):
        
        menusDict=self.__parent.getMenusDictionary()
        windowMenu=menusDict["window"]    
        windowMenu.clear()
        windowMenu.addAction(self.newGraphicsWindowAct)
        # windowMenu.addAction(self.newPlotWindowAct)
        windowMenu.addAction(self.tileAct)
        windowMenu.addAction(self.cascadeAct)
        windowMenu.addAction(self.minimizeAllGraphicsWindowsAct)
        windowMenu.addAction(self.restoreAllGraphicsWindowsAct)
        windowMenu.addSeparator()
        windowMenu.addAction(self.closeActiveWindowAct)
        windowMenu.addAction(self.closeAdditionalGraphicsWindowsAct)
        windowMenu.addSeparator()        
        
        # adding graphics windows
        counter=0
        for windowName in self.graphicsWindowDict.keys():
            graphicsWindow=self.graphicsWindowDict[windowName]
            if counter < 9:
                actionText = self.tr("&%1 %2").arg(counter + 1).arg(graphicsWindow.windowTitle())
            else:
                actionText = self.tr("%1 %2").arg(counter + 1).arg(graphicsWindow.windowTitle())
        
            action = windowMenu.addAction(actionText)
            action.setCheckable(True)
            action.setChecked(self.lastActiveWindow==graphicsWindow)
            # if self.lastActiveWindow==graphicsWindow:
                # print "CHECKING window title = ",self.lastActiveWindow.windowTitle()
            # action.triggered.connect(self.windowMapper.map)
            
            self.connect(action,SIGNAL("triggered()"),self.windowMapper,SLOT("map()"))
            self.windowMapper.setMapping(action, graphicsWindow)
            counter+=1

        # windows = self.mdiArea.subWindowList()
        # self.separatorAct.setVisible(len(windows) != 0)

        # for i, window in enumerate(windows):
            # child = window.widget()

            # if i < 9:
                # text = self.tr("&%1 %2").arg(i + 1).arg(child.userFriendlyCurrentFile())
            # else:
                # text = self.tr("%1 %2").arg(i + 1).arg(child.userFriendlyFile())

            # action = self.windowMenu.addAction(text)
            # action.setCheckable(True)
            # action.setChecked(child == self.activeMdiChild())
            # action.triggered.connect(self.windowMapper.map)
            # self.windowMapper.setMapping(action, child)


    def addNewPlotWindow(self):
        # from PlotManager import CustomPlot        
        # customPlot=CustomPlot(self.plotManager)
        # customPlot.initPlot()
        
        # print "ADDING NEW WINDOW"
        # sys.exit()
        # import time
        # time.sleep(2)
        
        return self.plotManager.addNewPlotWindow()

        
    def addNewGraphicsWindow(self): 
        # if self.pauseAct.isEnabled():
            # self.__pauseSim()
        if not self.simulationIsRunning:
            return
        self.simulation.drawMutex.lock()
    
        self.windowCounter+=1        
        newWindow=GraphicsFrameWidget(self)
        self.windowDict[self.windowCounter]=newWindow
        self.graphicsWindowDict[self.windowCounter]=newWindow  
        
        newWindow.setWindowTitle("Aux Graphics Window "+str(self.windowCounter))
        newWindow.setZoomItems(self.zitems)   # Set zoomFixed parameters
        
        
        self.lastActiveWindow=newWindow
        # self.updateWindowMenu()
        
          
        newWindow.setShown(False)
        self.connect(self, SIGNAL('configsChanged'), newWindow.draw2D.configsChanged)
        self.connect(self, SIGNAL('configsChanged'), newWindow.draw3D.configsChanged)
        
        newWindow.readSettings()
        # setting up plane tuple based on window number 1
        # plane=self.windowDict[1].getPlane()
        # newWindow.setPlane(plane[0],plane[1])
        
        #each new window is painted in 2D mode xy projection with z coordinate set to fieldDim.z/2
        self.newWindowDefaultPlane=("XY",self.basicSimulationData.fieldDim.z/2)
        newWindow.setPlane(self.newWindowDefaultPlane[0],self.newWindowDefaultPlane[1])
        
        # newWindow.currentDrawingObject.setPlane(plane[0],plane[1])
        newWindow.currentDrawingObject.setPlane(self.newWindowDefaultPlane[0],self.newWindowDefaultPlane[1])
        # self.simulation.drawMutex.unlock()
        
        # newWindow.setConnects(self)
        # newWindow.setInitialCrossSection(self.basicSimulationData)
        # newWindow.setFieldTypesComboBox(self.fieldTypes)
        
        
       # self.simulation.setGraphicsWidget(self.mainGraphicsWindow)        
        self.mdiWindowDict[self.windowCounter] = self.addSubWindow(newWindow)
        newWindow.show()
        # camera=self.windowDict[1].getCamera2D()
        # newWindow.setActiveCamera(camera)
        # newWindow.resetCamera()

        
        self.simulation.drawMutex.unlock()
        
        newWindow.setConnects(self)
        newWindow.setInitialCrossSection(self.basicSimulationData)
        newWindow.setFieldTypesComboBox(self.fieldTypes)

        
    def addVTKWindowToWorkspace(self):
#        print '========= SimpleTabView.py:  addVTKWindowToWorkspace ========='
        # self.graphics2D = Graphics2DNew(self)     
        self.mainGraphicsWindow = GraphicsFrameWidget(self)               
        
        # we make sure that first graphics window is positioned in the left upper corner
        # NOTE: we have to perform move prior to calling addSubWindow. or else we will get distorted window
        if self.lastPositionMainGraphicsWindow is not None:
            self.mainGraphicsWindow.move(self.lastPositionMainGraphicsWindow)
        else:
            self.lastPositionMainGraphicsWindow=self.mainGraphicsWindow.pos()

        
        self.mainGraphicsWindow.setShown(False)
        # self.connect(self, SIGNAL('configsChanged'), self.graphics2D.configsChanged)        
        self.connect(self, SIGNAL('configsChanged'), self.mainGraphicsWindow.draw2D.configsChanged) 
        self.connect(self, SIGNAL('configsChanged'), self.mainGraphicsWindow.draw3D.configsChanged)        
        self.mainGraphicsWindow.readSettings()
        self.simulation.setGraphicsWidget(self.mainGraphicsWindow)
        # self.addSubWindow(self.mainGraphicsWindow)
        mdiSubWindow=self.addSubWindow(self.mainGraphicsWindow)
        self.mainGraphicsWindow.show()
        self.mainGraphicsWindow.setConnects(self)
        
        self.windowCounter+=1
        self.windowDict[self.windowCounter]=self.mainGraphicsWindow
        self.graphicsWindowDict[self.windowCounter]=self.mainGraphicsWindow
        
        self.mdiWindowDict[self.windowCounter]=mdiSubWindow
        
        # self.windowDict[self.windowCounter]=mdiSubWindow
        # self.graphicsWindowDict[self.windowCounter]=mdiSubWindow
        
        self.mainGraphicsWindow.setWindowTitle("Main Graphics Window "+str(self.windowCounter))
        self.lastActiveWindow=self.mainGraphicsWindow
        
        # print "self.lastPositionMainGraphicsWindow=",self.lastPositionMainGraphicsWindow
        # print "\n\n\n"
        # import time
        # time.sleep(3)
        
        # self.activeWindow().move(10,80)
        
        
        self.updateWindowMenu()
        
    def removeAllVTKWindows(self,_leaveFirstWindowFlag=False):
        # self.closeAllWindows()
        # for windowName in self.graphicsWindowDict.keys():
            # print "windowName=",windowName
            # print "self.graphicsWindowDict=",self.graphicsWindowDict
            # if _leaveFirstWindowFlag and windowName==1:
                # print "leaving first window"
                # continue
            # # self.setActiveWindow(self.graphicsWindowDict[windowName])
            # # self.closeActiveWindow()
            # windowToRemove=self.graphicsWindowDict[windowName]
            # print "removing window=",windowName
            # del self.graphicsWindowDict[windowName]
            # print "removing window=",windowName
            # del self.windowDict[windowName]
            # windowToRemove.close()
            # self.windowCounter-=1   

        windowNames=self.graphicsWindowDict.keys()
        for windowName in windowNames:
            # print "windowName=",windowName
            # print "self.graphicsWindowDict=",self.graphicsWindowDict
            if _leaveFirstWindowFlag and windowName==1:
                # print "leaving first window"
                continue
                
            # self.removeSubWindow(self.graphicsWindowDict[windowName])
            print "\n\n\n REMOVING window=",self.graphicsWindowDict[windowName]
            # self.setActiveSubWindow(self.graphicsWindowDict[windowName])
            self.setActiveSubWindow(self.mdiWindowDict[windowName])
            self.closeActiveSubWindowSlot()
            continue
            
            
        self.updateWindowMenu()


    def removeAllPlotWindows(self,_leaveFirstWindowFlag=False):
        windowNames=self.plotWindowDict.keys()
        for windowName in windowNames:
            # print "windowName=",windowName
            # print "self.graphicsWindowDict=",self.graphicsWindowDict
            if _leaveFirstWindowFlag and windowName==1:
                # print "leaving first window"
                continue
            # self.setActiveSubWindow(self.plotWindowDict[windowName])
            self.setActiveSubWindow(self.mdiWindowDict[windowName])
            self.closeActiveSubWindowSlot()
            
        self.updateWindowMenu()
        self.plotWindowDict={}
        self.plotManager.reset()
        # from PlotManagerSetup import createPlotManager
        # self.plotManager=createPlotManager(self) # object that is responsible for creating and managing plot windows sdo that they are accessible from steppable level 
        
    def removeAuxiliaryGraphicsWindows(self):
        self.removeAllVTKWindows(True)
        
    def minimizeAllGraphicsWindows(self):
        for windowName in self.graphicsWindowDict.keys():
            self.windowDict[windowName].showMinimized()
            
    def restoreAllGraphicsWindows(self):
        for windowName in self.graphicsWindowDict.keys():
            self.windowDict[windowName].showNormal()
    
    def closeActiveSubWindowSlot(self):
        print MODULENAME,"THIS IS CLOSE ACTIVE WINDOW SLOT"
        activeWindow=self.activeSubWindow()
        print "activeWindow=",activeWindow.widget()
        # print "self.windowDict[1]=",self.windowDict[1]
        # print "self.graphicsWindowDict[1]=",self.graphicsWindowDict[1]
        print "self.windowDict.keys()=",self.windowDict.keys()
        for windowName in self.windowDict.keys():
            if self.windowDict[windowName]==activeWindow.widget():
                del self.windowDict[windowName]
                if windowName in self.graphicsWindowDict.keys():
                    del self.graphicsWindowDict[windowName]
                    del self.mdiWindowDict[windowName]
                activeWindow.close()
                self.windowCounter-=1 
        
        self.updateWindowMenu()
        
        
    def processCommandLineOptions(self):
        import getopt
        self.__screenshotDescriptionFileName=""
        self.customScreenshotDirectoryName=""
        startSimulation=False
        
        opts=None
        args=None
        try:
            #  NOTE: need ending ":" on single letter options string!
            opts, args = getopt.getopt(self.__parent.argv, "h:i:s:o:p:", ["help","noOutput","exitWhenDone","currentDir="])
            print "opts=",opts
            print "args=",args
        except getopt.GetoptError, err:
            print str(err) # will print something like "option -a not recognized"
            # self.usage()
            sys.exit(2)
        output = None
        verbose = False
        currentDir=""
        for o, a in opts:
            print "o=",o
            print "a=",a
            if o in ("-i"):
                self.__fileName=a
                startSimulation=True
                
            elif o in ("-h", "--help"):
                self.usage()
                sys.exit()
            elif o in ("-s"):
                self.__screenshotDescriptionFileName=a
            elif o in ("-o"):    
                self.customScreenshotDirectoryName=a
                print MODULENAME, 'customScreenshotDirectoryName= ',self.customScreenshotDirectoryName
                self.__noOutput=False
            elif o in ("-p"):
                print ' handling -p... a = ',a
                self.playerSettingsFileName = a
                print MODULENAME, 'self.playerSettingsFileName= ',self.playerSettingsFileName
            elif o in ("--noOutput"):             
                self.__noOutput=True 
            elif o in ("--currentDir"):
                currentDir=a
                print "currentDirectory=",currentDir
                
            elif o in ("--exitWhenDone"):             
                self.closePlayerAfterSimulationDone=True 
                
            else:
                assert False, "unhandled option"
        # ...
        # checking if file path needs to be remapped to point to files in the directories from which run script was called
        simFileFullName = os.path.join(currentDir,self.__fileName)
        if startSimulation:
            if os.access(simFileFullName,os.F_OK): # checking if such a file exists
                self.__fileName=simFileFullName
                print "self.__fileName=",self.__fileName
            elif not os.access(self.__fileName,os.F_OK): 
                assert False, "Could not find simulation file: "+self.__fileName
            from os.path import basename    
            self.__parent.setWindowTitle(self.trUtf8(basename(self.__fileName)+" - CompuCell3D Player"))
        
            
        if self.__screenshotDescriptionFileName!="":   
            screenshotDescriptionFullFileName = os.path.abspath(self.__screenshotDescriptionFileName)
            if os.access(screenshotDescriptionFullFileName,os.F_OK):# checking if such a file exists
                self.__screenshotDescriptionFileName=screenshotDescriptionFullFileName
            else:
                assert False, "Could not find screenshot Description file: "+self.__screenshotDescriptionFileName
        
        if self.playerSettingsFileName != "":   
            playerSettingsFullFileName = os.path.abspath(self.playerSettingsFileName)
            if os.access(playerSettingsFullFileName, os.F_OK):# checking if such a file exists
                self.playerSettingsFileName = playerSettingsFullFileName
                print MODULENAME,'(full) playerSettings filename=',self.playerSettingsFileName
            else:
                assert False, "Could not find playerSettings file: "+self.playerSettingsFileName
        
        # print "This is startSimulation=",startSimulation
        if startSimulation:
            self.__runSim()
            
    def usage(self):
        print "USAGE: ./compucell3d.sh -i <xmlFile or Python File> -s <ScreenshotDescriptionFile> -o <custom outputDirectory>"
        print "--exitWhenDone option will close the player after simulation is done"
        print "--noOutput will ensure that no screenshots are stored regardless of Player settings"
        print "-h or --help will print help message"
        
    def setRecentSimulationFile(self,_fileName):
        self.__fileName =_fileName
        from os.path import basename
        self.__parent.setWindowTitle(self.trUtf8(basename(self.__fileName)+" - CompuCell3D Player"))        
        
    def prepareForNewSimulation(self,_forceGenericInitialization=False):
        """
        This function creates new instance of computational thread and sets various flags to initial values i.e. to a state before the beginnig of the simulations
        """
        self.pauseAct.setEnabled(False)
        self.stopAct.setEnabled(False)
        self.openAct.setEnabled(True)
        self.pifFromSimulationAct.setEnabled(False)
        
        self.steppingThroughSimulation=False
        
        import CompuCellSetup
        
        CompuCellSetup.viewManager=self
        
        from BasicSimulationData import BasicSimulationData
        self.basicSimulationData=BasicSimulationData()
        # this import has to be here not inside is statement to ensure that during switching from playing one type of files to another there is no "missing module" issue due to imoprer imports
        # import CMLResultReader 
        from Simulation.CMLResultReader import CMLResultReader                                
        
        self.cmlHandlerCreated=False
        
        # this is used to perform generic preparation for new simulation , normally called after "stop". If users decide to use *.dml  prepare simulation will be called again with False argument
        if _forceGenericInitialization:
            CompuCellSetup.playerType="new"
        
        if  CompuCellSetup.playerType=="CMLResultReplay":
            self.__viewManagerType="CMLResultReplay"
            
            self.simulation=CMLResultReader(self)

            # print "GOT THIS self.__fileName=",self.__fileName
            self.simulation.extractLatticeDescriptionInfo(self.__fileName)
            #filling out basic simulation data
            self.basicSimulationData.fieldDim=self.simulation.fieldDim
            self.basicSimulationData.numberOfSteps=self.simulation.numberOfSteps
            
            
            self.connect(self.simulation,SIGNAL("simulationInitialized(bool)"),self.initializeSimulationViewWidget)
            self.connect(self.simulation,SIGNAL("simulationFinished(bool)"),self.handleSimulationFinished)
            self.connect(self.simulation,SIGNAL("completedStep(int)"),self.handleCompletedStep)
            # print "\n\n\n\n\n\n\n\n self.simulation=",self.simulation
            import PlayerPython

            self.fieldExtractor=PlayerPython.FieldExtractorCML()
            self.fieldExtractor.setFieldDim(self.basicSimulationData.fieldDim)
        else:
            self.__viewManagerType="Regular"
            import CompuCellSetup
            CompuCellSetup.cmlFieldHandler=None # have to reinitialize cmlFieldHandler to None
            
            self.simulation=SimulationThread(self)
            
            self.connect(self.simulation,SIGNAL("simulationInitialized(bool)"),self.initializeSimulationViewWidget)
            self.connect(self.simulation,SIGNAL("simulationFinished(bool)"),self.handleSimulationFinished)
            self.connect(self.simulation,SIGNAL("completedStep(int)"),self.handleCompletedStep)
            
            # self.connect(self.plotManager,SIGNAL("newPlotWindow(bool)"),self.addNewPlotWindow)
            self.plotManager.initSignalAndSlots()
            
            import PlayerPython
            self.fieldStorage=PlayerPython.FieldStorage()
            self.fieldExtractor=PlayerPython.FieldExtractor()
            self.fieldExtractor.setFieldStorage(self.fieldStorage)
            
        self.simulation.setCallingWidget(self)    
        
        """Commented out"""
        # if not _forceGenericInitialization:    
            # self.simulation.setCallingWidget(self)            
            # self.__setupArea()
            
        self.drawingAreaPrepared=False
        self.simulationIsRunning=False
        
        self.newDrawingUserRequest=False
        self.completedFirstMCS=False
        
    def __setupArea(self):
        self.removeAllVTKWindows()
        self.removeAllPlotWindows()
        self.addVTKWindowToWorkspace()
        
        
    def handleErrorMessage(self,_errorType,_traceback_message):
        msg = QMessageBox.warning(self, _errorType, \
                                  _traceback_message, \
                                  QMessageBox.Ok , 
                                  QMessageBox.Ok)
        self.__stopSim()
    
    def prepareXMLTreeView(self,_xmlFileName):
        
        import XMLUtils
        import CompuCellSetup
        
        _simulationFileName="D:\Program Files\COMPUCELL3D_3.4.0\Demos\cellsort_2D\cellsort_2D.xml"
        
        self.root_element=CompuCellSetup.cc3dXML2ObjConverter.root
        self.model = SimModel(self.root_element, self.__modelEditor)
        self.simulation.setSimModel(self.model) # hook in simulation thread class to XML model TreeView panel in the GUI - needed for steering
        
        # self.model.checkSanity()
        
        self.__modelEditor.setModel(self.model)
        self.model.setPrintFlag(True)
    
    def prepareLatticeDataView(self):
        self.__parent.latticeDataModel.setLatticeDataFileList(self.simulation.ldsFileList)
        self.latticeDataModel=self.__parent.latticeDataModel
        self.__parent.latticeDataModelTable.setModel(self.__parent.latticeDataModel) # this sets up the model and actually displays model data- so use this function when model is ready to be used
        self.__parent.latticeDataModelTable.setParams()
        self.latticeDataModelTable=self.__parent.latticeDataModelTable
    
    def __loadSim(self, file):
        fileName = str(self.__fileName)
        print "Load file ",fileName
        
        # have to connect error handler to the signal emited from self.simulation object
        self.connect(self.simulation,SIGNAL("errorOccured(QString,QString)"),self.handleErrorMessage)
        
            
        # We need to create new SimulationPaths object for each new simulation.    
        import CompuCellSetup            
        CompuCellSetup.simulationPaths=CompuCellSetup.SimulationPaths()   
        
        if re.match(".*\.xml$", fileName): # If filename ends with .xml
            # print "GOT FILE ",fileName
    
            # self.prepareForNewSimulation()
            self.simulation.setRunUserPythonScriptFlag(True)
            
            pythonScriptName=CompuCellSetup.ExtractPythonScriptNameFromXML(fileName)
            
                
            CompuCellSetup.simulationPaths.setPlayerSimulationXMLFileName(fileName)
            if pythonScriptName!="":
                CompuCellSetup.simulationPaths.setPythonScriptNameFromXML(pythonScriptName) 
                
            if self.__parent.latticeDataDock.isVisible():
                self.__parent.latticeDataAct.trigger()            

            if self.__parent.modelEditorDock.isHidden():
                self.__parent.modelAct.trigger()                   
                
            
        elif re.match(".*\.py$", fileName):
            globals={'simTabView':20}
            locals={}
            self.simulation.setRunUserPythonScriptFlag(True)
            
            # NOTE: extracting of xml file name from python script is done during script run time so we cannot use CompuCellSetup.simulationPaths.setXmlFileNameFromPython function here
            CompuCellSetup.simulationPaths.setPlayerSimulationPythonScriptName(self.__fileName)
            
            if self.__parent.latticeDataDock.isVisible():
                self.__parent.latticeDataAct.trigger()            

            if self.__parent.modelEditorDock.isHidden():
                self.__parent.modelAct.trigger()   
            
        
        elif re.match(".*\.dml$", fileName):
            CompuCellSetup.playerType="CMLResultReplay"
            self.prepareForNewSimulation()
            CompuCellSetup.simulationPaths.setSimulationResultDescriptionFile(fileName)
            
            if self.__parent.latticeDataDock.isHidden():
                self.__parent.latticeDataAct.trigger()            

            if self.__parent.modelEditorDock.isVisible():
                self.__parent.modelAct.trigger()   
            self.prepareLatticeDataView()    
        
        
    def __setConnects(self):        
        self.connect(self.runAct,   SIGNAL('triggered()'), self.__runSim) 
        self.connect(self.stepAct,  SIGNAL('triggered()'), self.__stepSim)
        self.connect(self.pauseAct, SIGNAL('triggered()'), self.__pauseSim)
        self.connect(self.stopAct,  SIGNAL('triggered()'), self.__simulationStop)
        
        self.connect(self.openAct,  SIGNAL('triggered()'), self.__openSim)
        self.connect(self.openLDSAct,  SIGNAL('triggered()'), self.__openLDSFile)

        self.connect(self.saveAct,  SIGNAL('triggered()'), self.__saveSim)
        self.connect(self.saveScreenshotDescriptionAct,  SIGNAL('triggered()'), self.__saveScrDesc)
        self.connect(self.openScreenshotDescriptionAct,  SIGNAL('triggered()'), self.__openScrDesc)
        
#        self.connect(self.savePlayerParamsAct,  SIGNAL('triggered()'), self.__savePlayerParams)
#        self.connect(self.openPlayerParamsAct,  SIGNAL('triggered()'), self.__openPlayerParams)
        
        self.connect(self.cellsAct,    SIGNAL('triggered(bool)'),  self.__checkCells)
        self.connect(self.borderAct,    SIGNAL('triggered(bool)'),  self.__checkBorder)
        self.connect(self.cellGlyphsAct,  SIGNAL('triggered(bool)'),  self.__checkCellGlyphs)
        self.connect(self.FPPLinksAct,  SIGNAL('triggered(bool)'),  self.__checkFPPLinks)

        # self.connect(self.contourAct,   SIGNAL('triggered(bool)'),  self.__checkContour)
        self.connect(self.limitsAct,    SIGNAL('triggered(bool)'),  self.__checkLimits)
        self.connect(self.configAct,    SIGNAL('triggered()'),      self.__showConfigDialog)
        self.connect(self.pifFromSimulationAct,    SIGNAL('triggered()'),      self.__generatePIFFromCurrentSnapshot)
        # self.connect(self.pifFromVTKAct,    SIGNAL('triggered()'),      self.__generatePIFFromVTK)
        
        #window menu actions
        self.connect(self.newGraphicsWindowAct,    SIGNAL('triggered()'),      self.addNewGraphicsWindow)        
        # self.connect(self.newPlotWindowAct,    SIGNAL('triggered()'),      self.addNewPlotWindow)        
        self.connect(self.tileAct,    SIGNAL('triggered()'),      self.tileSubWindows)
        self.connect(self.cascadeAct,    SIGNAL('triggered()'),      self.cascadeSubWindows) 
        self.connect(self.minimizeAllGraphicsWindowsAct,    SIGNAL('triggered()'),      self.minimizeAllGraphicsWindows) 
        self.connect(self.restoreAllGraphicsWindowsAct,    SIGNAL('triggered()'),      self.restoreAllGraphicsWindows) 
        
        
        self.connect(self.closeActiveWindowAct,    SIGNAL('triggered()'),      self.closeActiveSubWindowSlot)         
        self.connect(self.closeAdditionalGraphicsWindowsAct,    SIGNAL('triggered()'),      self.removeAuxiliaryGraphicsWindows)        
        self.connect(self,          SIGNAL('configsChanged'), self.__paramsChanged)
    
    # Connections that are related to the simulation view
    # Change to Graphics2D or Graphics3D
    def __setSimConnects(self):
        # Set connections is the self.mainGraphicsWindow is instance of Graphics2D 
        if self.mainGraphicsWindow is not None and isinstance(self.mainGraphicsWindow, (Graphics2D)):
            self.connect(self, SIGNAL('configsChanged'), self.mainGraphicsWindow.configsChanged)

        
    def setFieldType(self,_fieldTypeTuple):
        self.__fieldType=_fieldTypeTuple
    

    def closeEventSimpleTabView(self, event=None):
        # print "CALLING CLOSE EVENT SIMTAB"
        # print "self.simulation=",self.simulation
        Configuration.setSimulation("RecentFile",self.__fileName)
        Configuration.setSimulation("RecentSimulations",self.__fileName)
        # import time
        # time.sleep(3)
        
        if self.saveSettings:    
            Configuration.syncPreferences()        

            self.__simulationStop()
            return
        
            """
            For some reason have to introduce delay to avoid problems with application becomeing unresponsive
            """
            import time
            time.sleep(0.5)
            self.simulation.stop()
            self.simulation.wait()
            
            self.removeAllVTKWindows()
            self.removeAllPlotWindows()
        
    # # Core method for running simulation
    def printInfo(self):
        # print "INFO"
        self.simulation.sem.acquire()
        self.simulation.sem.release()
        
    
    def initializeSimulationViewWidgetCMLResultReplay(self):
        # self.pifFromVTKAct.setEnabled(True)
        self.fieldDim = self.simulation.fieldDim
        self.sim = self.simulation.sim
        # print "INSIDE INITIALIZE SIMULATION WIDGET"
        
        latticeTypeStr=self.simulation.latticeType
        if latticeTypeStr in Configuration.LATTICE_TYPES.keys():
            self.latticeType=Configuration.LATTICE_TYPES[latticeTypeStr]
        else:
            self.latticeType=Configuration.LATTICE_TYPES["Square"] # default choice        

        simulationDataIntAddr=self.extractAddressIntFromVtkObject(self.simulation.simulationData)
        self.fieldExtractor.setSimulationData(simulationDataIntAddr) 
        self.simulation.newFileBeingLoaded=False # this flag is used to prevent calling  draw function when new data is read from hard drive
                                                 # at this moment new data has been read and is ready to be used  
        # this fcn will draw initial lattice configuration so data has to be available by then and appropriate pointers set - see line above
        self.prepareSimulationView()
        
        self.screenshotManager=ScreenshotManager.ScreenshotManager(self)
        self.screenshotNumberOfDigits=len(str(self.basicSimulationData.numberOfSteps))
        
        # print "self.screenshotManager",self.screenshotManager
        # print "self.__fileName=",self.__fileName
        
        if self.__screenshotDescriptionFileName != "":
            self.screenshotManager.readScreenshotDescriptionFile(self.__screenshotDescriptionFileName)
        
        
        if self.simulationIsStepping:
            # print "BEFORE STEPPING PAUSE"
            self.__pauseSim()              


        # after this call I can access self.root_element of the XML File
        # self.loadCustomPlayerSettings(self.root_element)
        # creating simulation directory depending on whether user requests simulatin output or not
        import CompuCellSetup
        if not self.__noOutput:
            if self.customScreenshotDirectoryName=="":
                (self.screenshotDirectoryName,self.baseScreenshotName) = self.makeSimDir(self.__fileName)
                CompuCellSetup.screenshotDirectoryName=self.screenshotDirectoryName
                
            else:
                (self.screenshotDirectoryName,self.baseScreenshotName)=self.makeCustomSimDir(self.customScreenshotDirectoryName,self.__fileName)
                CompuCellSetup.screenshotDirectoryName=self.screenshotDirectoryName
                if self.screenshotDirectoryName=="":
                    self.__noOutput=True # do not output screenshots when custom directory was not created or already exists                
        self.simulation.sem.tryAcquire()
        self.simulation.sem.release()      
        
   
    def initializeSimulationViewWidgetRegular(self):
        # self.pifFromVTKAct.setEnabled(False)
        
        self.fieldDim = self.simulation.sim.getPotts().getCellFieldG().getDim()
        self.sim = self.simulation.sim
        
        # check if we will be outputtin fields in the binary (or vtk) format
        import CompuCellSetup
        # print "THIS IS Configuration.getOutputFrequency(OutputLatticeDataInBinaryFormat)",Configuration.getOutputFrequency("OutputLatticeDataInBinaryFormat")
        # print self.sim
        self.basicSimulationData.fieldDim=self.fieldDim
        self.basicSimulationData.sim=self.sim
        self.basicSimulationData.numberOfSteps=self.sim.getNumSteps()
        
        self.fieldStorage.allocateCellField(self.fieldDim)
                
        self.fieldExtractor.init(self.sim)
        
        self.screenshotNumberOfDigits=len(str(self.basicSimulationData.numberOfSteps))
        
        import CompuCellSetup
        latticeTypeStr=CompuCellSetup.ExtractLatticeType()
        if latticeTypeStr in Configuration.LATTICE_TYPES.keys():
            self.latticeType=Configuration.LATTICE_TYPES[latticeTypeStr]
        else:
            self.latticeType=Configuration.LATTICE_TYPES["Square"] # default choice
        self.prepareSimulationView()
        self.screenshotManager=ScreenshotManager.ScreenshotManager(self)
        
        # print "self.screenshotManager",self.screenshotManager
        
        if self.__screenshotDescriptionFileName != "":
            self.screenshotManager.readScreenshotDescriptionFile(self.__screenshotDescriptionFileName)
            
        if self.simulationIsStepping:
            # print "BEFORE STEPPING PAUSE REGULAR SIMULATION"
            self.__pauseSim()   
        
        
        self.prepareXMLTreeView(self.__fileName)
        # after this call I can access self.root_element of the XML File
        self.loadCustomPlayerSettings(self.root_element)
        # creating simulation directory depending on whether user requests simulatin output or not
        import CompuCellSetup
        if not self.__noOutput:
            if self.customScreenshotDirectoryName=="":
                (self.screenshotDirectoryName,self.baseScreenshotName) = self.makeSimDir(self.__fileName)
                CompuCellSetup.screenshotDirectoryName=self.screenshotDirectoryName
            else:
                (self.screenshotDirectoryName,self.baseScreenshotName)=self.makeCustomSimDir(self.customScreenshotDirectoryName,self.__fileName)
                CompuCellSetup.screenshotDirectoryName=self.screenshotDirectoryName
                if self.screenshotDirectoryName=="":
                    self.__noOutput=True # do not output screenshots when custom directory was not created or already exists
                    
        if Configuration.getOutputFrequency("OutputLatticeDataInBinaryFormat"):
            if self.screenshotDirectoryName=="":
                (screenshotDirectoryName,baseScreenshotName) = self.makeSimDir(self.__fileName)
                CompuCellSetup.screenshotDirectoryName=screenshotDirectoryName
                self.resultStorageDirectory=os.path.join(screenshotDirectoryName,"LatticeData")
            else:
                self.resultStorageDirectory=os.path.join(self.screenshotDirectoryName,"LatticeData")
            import CompuCellSetup
            CompuCellSetup.initCMLFieldHandler(self.sim,self.resultStorageDirectory,self.fieldStorage)
        self.simulation.sem.tryAcquire()
        self.simulation.sem.release()        
    
    def initializeSimulationViewWidget(self):
        initializeSimulationViewWidgetFcn = getattr(self, "initializeSimulationViewWidget" + self.__viewManagerType)
        initializeSimulationViewWidgetFcn()        
        

    def loadCustomPlayerSettings(self,_root_element):
        import XMLUtils
        import CC3DXML
        from XMLUtils import dictionaryToMapStrStr as d2mss        
        playerSettingsElement=_root_element.getFirstElement("Plugin",d2mss({"Name":"PlayerSettings"}))
        if playerSettingsElement:
            visualControlElement=playerSettingsElement.getFirstElement("VisualControl")
            if visualControlElement:
                if visualControlElement.findAttribute("ScreenshotFrequency"):
                    scrFreq=visualControlElement.getAttributeAsUInt("ScreenshotFrequency")
                    
                    Configuration.setOutputFrequency("ScreenshotFrequency",scrFreq)
                    
                if visualControlElement.findAttribute("ScreenUpdateFrequency"):
                    screenUpdateFrequency=visualControlElement.getAttributeAsUInt("ScreenUpdateFrequency")
                    Configuration.setOutputFrequency("ScreenUpdateFrequency",screenUpdateFrequency)
                    
                if visualControlElement.findAttribute("NoOutput"):
                    noOutput=visualControlElement.getAttributeAsBool("NoOutput")
                    Configuration.setOutputFrequency("NoOutputFlag",noOutput)

#		if visualControlElement.findAttribute("ClosePlayerAfterSimulationDone"):
#		    closePlayerAfterSimulationDone=visualControlElement.getAttributeAsBool("ClosePlayerAfterSimulationDone")
#		    Configuration.setOutputFrequency("ClosePlayerAfterSimulationDone",closePlayerAfterSimulationDone)
                self.__paramsChanged()    
                
            borderElement=playerSettingsElement.getFirstElement("Border")
            if borderElement:
                if borderElement.findAttribute("BorderColor"):
                    # print "borderElement"
                    borderColor=borderElement.getAttribute("BorderColor")
                    Configuration.setCellTypeColors("Border", QColor(borderColor))
                    
                if borderElement.findAttribute("BorderOn"):
                    borderOn=borderElement.getAttributeAsBool("BorderOn")
                    Configuration.setVisualization("BordersOn", borderOn)
                    if borderOn:
                        self.borderAct.setChecked(True)
                    else:
                        self.borderAct.setChecked(False)
                        
            cellColorsList=XMLUtils.CC3DXMLListPy(playerSettingsElement.getElements("Cell"))
            typeColorMap={}
            cellColorsListLength=0
            for cellElement in cellColorsList:
                cellColorsListLength+=1
                
            if cellColorsListLength:                
                for cellElement in cellColorsList:
                    cellType=cellElement.getAttributeAsUInt("Type")
                    cellColor=cellElement.getAttribute("Color")
                    cellColor=string.lower(cellColor)
                    typeColorMap[cellType]=QColor(cellColor)
                # print "GOT CUSTOM COLORS"    
                # for cellType in typeColorMap.keys():
                    # print "typeColorMap=",typeColorMap
                Configuration.setCellTypeColors("CustomTypeColorMap", typeColorMap)
                for windowName,window in self.graphicsWindowDict.items():
                    window.populateLookupTable()
                
                # self.mainGraphicsWindow.populateLookupTable()
                # self.graphics3D.populateLookupTable()
            
            typesInvisibleIn3DElement=playerSettingsElement.getFirstElement("TypesInvisibleIn3D")
            if typesInvisibleIn3DElement:
                
                Configuration.setThreeDView("Types3DInvisible", typesInvisibleIn3DElement.getAttribute("Types"))
            
            self.saveSettings=True # by default we will save settings each time we exit player    
            
            settingsElement=playerSettingsElement.getFirstElement("Settings")
            if settingsElement:
                self.saveSettings=settingsElement.getAttributeAsBool("SaveSettings")
                
            projection2DElement=playerSettingsElement.getFirstElement("Project2D")
            if projection2DElement:
                if projection2DElement.findAttribute("XYProj"):
                    zPos=projection2DElement.getAttributeAsUInt("XYProj")
                    if zPos>=self.xySB.minimum() and zPos<=self.xySB.maximum():
                        self.mainGraphicsWindow._xyChecked(True)
                        self.mainGraphicsWindow._xyChanged(zPos)
                
                elif projection2DElement.findAttribute("XZProj"):
                    yPos=projection2DElement.getAttributeAsUInt("XZProj")
                    if yPos>=self.xzSB.minimum() and yPos<=self.xzSB.maximum():
                        self.mainGraphicsWindow._xzChecked(True)
                        self.mainGraphicsWindow._xzChanged(yPos)
                        
                elif projection2DElement.findAttribute("YZProj"):
                    xPos=projection2DElement.getAttributeAsUInt("YZProj")
                    if xPos>=self.yzSB.minimum() and xPos<=self.yzSB.maximum():
                        self.mainGraphicsWindow._yzChecked(True)
                        self.mainGraphicsWindow._yzChanged(xPos)
            else:
                view3DElement=playerSettingsElement.getFirstElement("View3D")
                if view3DElement:
                    
                    cameraCippingRange=None
                    cameraFocalPoint=None
                    cameraPosition=None
                    cameraViewUp=None
                    
                    clippingRangeElement=view3DElement.getFirstElement("CameraClippingRange")
                    if clippingRangeElement:
                        cameraClippingRange=[float(clippingRangeElement.getAttribute("Min")),float(clippingRangeElement.getAttribute("Max"))]
                        
                    focalPointElement=view3DElement.getFirstElement("CameraFocalPoint")
                    if focalPointElement:
                        cameraFocalPoint=[float(focalPointElement.getAttribute("x")),float(focalPointElement.getAttribute("y")),float(focalPointElement.getAttribute("z"))]
                    
                    positionElement=view3DElement.getFirstElement("CameraPosition")
                    if positionElement:
                        cameraPosition=[float(positionElement.getAttribute("x")),float(positionElement.getAttribute("y")),float(positionElement.getAttribute("z"))]
                        
                    viewUpElement=view3DElement.getFirstElement("CameraViewUp")
                    if viewUpElement:
                        cameraViewUp=[float(viewUpElement.getAttribute("x")),float(viewUpElement.getAttribute("y")),float(viewUpElement.getAttribute("z"))]
                
                    camera3D=self.mainGraphicsWindow.getCamera3D()
                    if cameraCippingRange:
                        camera3D.SetClippingRange(cameraCippingRange)
                    if  cameraFocalPoint:
                        camera3D.SetFocalPoint(cameraFocalPoint)
                    if  cameraPosition:
                        camera3D.SetPosition(cameraPosition)   
                    if  cameraViewUp:
                        camera3D.SetViewUp(cameraViewUp)   
                    
                    self.mainGraphicsWindow._switchDim(True)
                    
    def __savePlayerParams(self):   # never called; used in version 3.5
        # print "THIS IS __saveScrDesc"
        filter = "Player parameters File (*.txt )" # self._getOpenFileFilter() 
        self.playerParamsFileName = QFileDialog.getSaveFileName(\
            self.ui,
            QApplication.translate('ViewManager', "Save Player Parameters File"),
            os.getcwd(), 
            filter
            )
#        if self.screenshotManager:
#            self.screenshotManager.writePlayerParamsFile(self.playerParamsFileName)
            
        print MODULENAME,"playerParamsFileName=",self.playerParamsFileName
#        pFile = open(self.playerParamsFileName,'w')
#        pFile.write('size 512\n')
#        pFile.close()
        from csv import writer
        params = Configuration.getPlayerLayout("All")
        paramWriter = writer(open(self.playerParamsFileName, 'w'), delimiter=' ')
        paramWriter.writerow(params)
        print MODULENAME,'allValues =',params


    def extractAddressIntFromVtkObject(self,_vtkObj):
        return self.fieldExtractor.unmangleSWIGVktPtrAsLong(_vtkObj.__this__)

    def handleSimulationFinishedCMLResultReplay(self,_flag):
        import CompuCellSetup
        if  CompuCellSetup.playerType=="CMLResultReplay":
            self.latticeDataModelTable.prepareToClose()

        self.__stopSim()
        
    def handleSimulationFinishedRegular(self,_flag):
        self.__stopSim()
    
    def handleSimulationFinished(self,_flag):
        handleSimulationFinishedFcn = getattr(self, "handleSimulationFinished" + self.__viewManagerType)
        handleSimulationFinishedFcn(_flag)
        
        
    def handleCompletedStepCMLResultReplay(self,_mcs):
        self.simulation.drawMutex.lock()    # had to add synchronization here . without it I would get weird behavior in CML replay mode
        # print "THIS IS handleCompletedStepCMLResultReplay"
        # print "Before extracting the address self.simulation.simulationData=",self.simulation.simulationData
        simulationDataIntAddr=self.extractAddressIntFromVtkObject(self.simulation.simulationData)
        # print "simulationDataIntAddr=%X\n"% (simulationDataIntAddr)
        # print "self.simulation.simulationData=",self.simulation.simulationData
        self.fieldExtractor.setSimulationData(simulationDataIntAddr)
        self.__step=self.simulation.currentStep
        self.latticeDataModelTable.selectRow(self.__step / self.simulation.frequency ) # here elf.step holds the value of the "user step" i.e. not multiplied by frequency. it gets multiplied by frequency next
        #there is additional locking inside draw to acccount for the fact that users may want to draw lattice on demand
        # self.simulation.newFileBeingLoaded=False
        self.simulation.drawMutex.unlock()  # had to add synchronization here . without it I would get weird behavior in CML replay mode      
        
        self.simulation.newFileBeingLoaded=False # this flag is used to prevent calling  draw function when new data is read from hard drive
                                                 # at this moment new data has been read and is ready to be used  
        self.__drawField()
        
        self.simulation.drawMutex.lock()
        # will need to synchorinize screenshots with simulation thread . make sure that before simuklation thread writes new results all the screenshots are taken
        
        if not (self.__step % self.__shotFrequency) and not self.__noOutput:
            mcsFormattedNumber = string.zfill(str(self.__step),self.screenshotNumberOfDigits) # fills strin wtih 0's up to self.screenshotNumberOfDigits width
            screenshotFileName=os.path.join(self.screenshotDirectoryName,self.baseScreenshotName+"_"+mcsFormattedNumber+".png")

            self.mainGraphicsWindow.takeSimShot(screenshotFileName)
            
            self.screenshotManager.outputScreenshots(self.screenshotDirectoryName,self.__step)
        self.simulation.drawMutex.unlock()
        
        if self.simulationIsStepping:
            self.__pauseSim()            
            self.stepAct.setEnabled(True)
        
        self.simulation.sem.tryAcquire()
        self.simulation.sem.release()        
        
        
    def handleCompletedStepRegular(self,_mcs):
        self.__drawField()
        
        self.simulation.drawMutex.lock()
        # will need to synchorinize screenshots with simulation thread . make sure that before simuklation thread writes new results all the screenshots are taken

        if not (self.__step % self.__shotFrequency) and not self.__noOutput:
            mcsFormattedNumber = string.zfill(str(self.__step),self.screenshotNumberOfDigits) # fills strin wtih 0's up to self.screenshotNumberOfDigits width
            screenshotFileName=os.path.join(self.screenshotDirectoryName,self.baseScreenshotName+"_"+mcsFormattedNumber+".png")
            
            self.mainGraphicsWindow.takeSimShot(screenshotFileName)
            
            self.screenshotManager.outputScreenshots(self.screenshotDirectoryName,self.__step)
        self.simulation.drawMutex.unlock()
        
        if self.simulationIsStepping:
            self.__pauseSim()            
            self.stepAct.setEnabled(True)
        
        self.simulation.sem.tryAcquire()
        self.simulation.sem.release()
    
    def handleCompletedStep(self,_mcs):
        self.completedFirstMCS=True        
        self.__step=_mcs
        
        handleCompletedStepFcn = getattr(self, "handleCompletedStep" + self.__viewManagerType)
        handleCompletedStepFcn(_mcs)
        return 

    def __runSim(self):    
        if  Configuration.getOutputFrequency("OutputLatticeDataInBinaryFormat") and not self.cmlHandlerCreated:
            import CompuCellSetup
            # print "will create CML FILE HANDLER"
            # print "\n\n\n created    CMLFieldHandler \n\n\n"
            CompuCellSetup.createCMLFieldHandler()
            self.cmlHandlerCreated=True

        self.steppingThroughSimulation=False
        
        if self.simulationIsStepping:
            self.simulationIsStepping=False
            self.simulation.screenUpdateFrequency=self.__updateScreen
            self.simulation.screenshotFrequency=self.__shotFrequency
        
        if not self.pauseAct.isEnabled() and self.simulationIsRunning:
            self.runAct.setEnabled(False)
            self.pauseAct.setEnabled(True)
            self.simulation.semPause.release()
            return
            
        if not self.drawingAreaPrepared:
            # checking if the simulation file is not an empty string 
            if self.__fileName=="":
                msg = QMessageBox.warning(self, "Not A Valid Simulation File", \
                          "Please pick simulation file <b>File->OpenS imulation File ...</b>", \
                          QMessageBox.Ok , 
                          QMessageBox.Ok)
                return
            file = QFile(self.__fileName)

            try: 
                self.__loadSim(file)            
            except AssertionError,e:
                print "Assertion Error: ",e.message
                self.handleErrorMessage("Assertion Error",e.message)
                return
                
            self.runAct.setEnabled(False)
            self.stepAct.setEnabled(True)
            self.pauseAct.setEnabled(True)
            self.stopAct.setEnabled(True)
            self.pifFromSimulationAct.setEnabled(True)
            self.openAct.setEnabled(False)
            
            self.simulation.screenUpdateFrequency=self.__updateScreen
            self.simulation.screenshotFrequency=self.__shotFrequency            
            self.screenshotDirectoryName=""
                
            if self.rollbackImporter:
                self.rollbackImporter.uninstall()
            self.rollbackImporter = RollbackImporter()
            
            self.simulation.start()
            self.simulationIsRunning=True
            return

            
        self.runAct.setEnabled(False)
        self.pauseAct.setEnabled(True)
        self.stopAct.setEnabled(True)
        self.pifFromSimulationAct.setEnabled(True)
      
    def __stepSim(self):
        if  Configuration.getOutputFrequency("OutputLatticeDataInBinaryFormat") and not self.cmlHandlerCreated:
            import CompuCellSetup
            CompuCellSetup.createCMLFieldHandler()
            self.cmlHandlerCreated=True        
            
        if self.simulationIsRunning and self.simulationIsStepping:
            self.pauseAct.setEnabled(False)
            self.simulation.semPause.release()
            self.stepAct.setEnabled(False)
            self.pauseAct.setEnabled(False)
            
            return
        elif self.simulationIsRunning and not self.simulationIsStepping and self.pauseAct.isEnabled(): #transition from running simulation
            self.simulation.screenUpdateFrequency=1
            self.simulation.screenshotFrequency=self.__shotFrequency
            self.simulationIsStepping=True
            self.stepAct.setEnabled(False)
            self.pauseAct.setEnabled(False)
        elif self.simulationIsRunning and not self.simulationIsStepping and not self.pauseAct.isEnabled():#transition from paused simulation
            self.simulation.screenUpdateFrequency=1
            self.simulation.screenshotFrequency=self.__shotFrequency
            self.simulationIsStepping=True
            
            return
            
        if not self.drawingAreaPrepared:
        
            # checking if the simulation file is not an empty string 
            if self.__fileName=="":
                msg = QMessageBox.warning(self, "Not A Valid Simulation File", \
                          "Please pick simulation file <b>File->OpenS imulation File ...</b>", \
                          QMessageBox.Ok , 
                          QMessageBox.Ok)
                return
            
            file = QFile(self.__fileName)

            try: 
                self.__loadSim(file)            
            except AssertionError,e:
                print "Assertion Error: ",e.message
                self.handleErrorMessage("Assertion Error",e.message)
                return
            

            self.runAct.setEnabled(True)
            self.pauseAct.setEnabled(False)
            self.stopAct.setEnabled(True)
            self.pifFromSimulationAct.setEnabled(True)
            self.openAct.setEnabled(False)
            
            self.simulation.screenUpdateFrequency=1
            self.simulation.screenshotFrequency=self.__shotFrequency
            self.screenshotDirectoryName=""
                
            if self.rollbackImporter:
                self.rollbackImporter.uninstall()
            self.rollbackImporter = RollbackImporter()
            
            
            self.simulation.start()
            
            self.simulationIsStepping=True
            self.simulationIsRunning=True

                
    def requestRedraw(self):
        self.__drawField()
        
    def drawFieldCMLResultReplay(self):
        self.simulation.drawMutex.lock()
        # print "self.simulation.readFileSem.available()=",self.simulation.readFileSem.available()
        self.simulation.readFileSem.acquire()
        # print " THIS IS drawFieldCMLResultReplay and NEW FILE IS LOADED=",self.simulation.newFileBeingLoaded
        if not self.simulationIsRunning:
            return    
    
        if self.newDrawingUserRequest:
            # print "entering newDrawingUserRequest"
            self.newDrawingUserRequest=False
            if self.pauseAct.isEnabled():
                # print "PAUSING THE SIMULATION"
                self.__pauseSim()

                
        self.simulation.drawMutex.unlock()
        self.simulation.readFileSem.release()
        
        # print "self.simulation.drawMutex=",self.simulation.drawMutex
        self.simulation.drawMutex.lock()
        self.simulation.readFileSem.acquire()
        
        self.__step=self.simulation.getCurrentStep()   
        if True:            
            for windowName in self.windowDict.keys():
                graphicsFrame=self.windowDict[windowName]
                # print "graphicsFrame=",graphicsFrame
                    
                (currentPlane, currentPlanePos)=graphicsFrame.getPlane()

                # print "NEW FILE IS LOADED =",self.simulation.newFileBeingLoaded
                
                if not self.simulation.newFileBeingLoaded: # this flag is used to prevent calling  draw function when new data is read from hard drive
                    graphicsFrame.drawFieldLocal(self.basicSimulationData)

                self.__updateStatusBar(self.__step, graphicsFrame.conMinMax())
            
        self.simulation.drawMutex.unlock()
        self.simulation.readFileSem.release()
    
    def drawFieldRegular(self):
        if not self.simulationIsRunning:
            return    
    
        if self.newDrawingUserRequest:
            self.newDrawingUserRequest=False
            if self.pauseAct.isEnabled():
                self.__pauseSim()
        self.simulation.drawMutex.lock()
        
        self.__step=self.simulation.getCurrentStep()
        
        if self.sim:
            for windowName in self.graphicsWindowDict.keys():
                graphicsFrame=self.windowDict[windowName]
                # print "graphicsFrame=",graphicsFrame
                    
                (currentPlane, currentPlanePos)=graphicsFrame.getPlane()
                graphicsFrame.drawFieldLocal(self.basicSimulationData)
                self.__updateStatusBar(self.__step, graphicsFrame.conMinMax())
        
        self.simulation.drawMutex.unlock()
    
        
    def _drawField(self):
        self.__drawField()
    
    def __drawField(self):
        __drawFieldFcn = getattr(self, "drawField" + self.__viewManagerType)
        __drawFieldFcn()
        
    def __updateStatusBar(self, step, conMinMax):
        self.mcSteps.setText("MC Step: %s"% step)
        self.conSteps.setText("Min: %s Max: %s" % conMinMax)
           
    def __pauseSim(self):
        # print "Pause Sim"
        self.simulation.semPause.acquire()        
        self.runAct.setEnabled(True)
        self.pauseAct.setEnabled(False)
        
    def __simulationStop(self):
        if  not self.pauseAct.isEnabled():
            self.__stopSim()
        else:
            self.simulation.setStopSimulation(True)
            
    def __stopSim(self):
        # print "STOP SIMULATION"
        self.simulation.stop()
        self.simulation.wait()
        
        Configuration.setSimulation("RecentSimulations",self.__fileName)
        
        if Configuration.getOutputFrequency("ClosePlayerAfterSimulationDone") or self.closePlayerAfterSimulationDone:
            Configuration.setSimulation("RecentFile",self.__fileName)
            
            Configuration.setSimulation("RecentSimulations",self.__fileName)
            
            if self.saveSettings:
                Configuration.syncPreferences()        

            sys.exit()
            
        self.runAct.setEnabled(True)
        
        self.prepareForNewSimulation(_forceGenericInitialization=True) 
        
    # Creates names for simulation directory 
    # if they don't exist 
    # Returns string (not QString!)
    
    def getNameForSimDir(self,_simulationFileName):
        # print "_simulationFileName=",_simulationFileName
        fullFileName=os.path.abspath(_simulationFileName)
        # filePath=os.path.dirname(fullFileName)
        (filePath,baseFileName)=os.path.split(fullFileName)
        
        import string
        
        baseFileNameForDirectory=baseFileName.replace('.','_')
        print "baseFileName=",baseFileNameForDirectory
        
        
        import time
        timeNameExtension="_"+time.strftime("%m",time.localtime())+"_"+time.strftime("%d",time.localtime())+"_"+time.strftime("%Y",time.localtime())\
        +"_"+time.strftime("%H",time.localtime())+"_"+time.strftime("%M",time.localtime())+"_"+time.strftime("%S",time.localtime())
        
        screenshotDirectoryName=os.path.join(filePath,baseFileNameForDirectory+timeNameExtension)
        return (screenshotDirectoryName,baseFileNameForDirectory)
        
    # Creates screenshot and simulation directory
    # if they don't exist 
    # Returns string (not QString!)
    
    def makeSimDir(self,_simulationFileName):
        
        screenshotDirectoryName,baseFileNameForDirectory=self.getNameForSimDir(_simulationFileName)
        if not os.path.isdir(screenshotDirectoryName):
            os.mkdir(screenshotDirectoryName)
            return (screenshotDirectoryName,baseFileNameForDirectory)
        else:
            return ("","")
        
    def makeCustomSimDir(self,_dirName,_simulationFileName):    
        fullFileName=os.path.abspath(_simulationFileName)
        (filePath,baseFileName)=os.path.split(fullFileName)
        baseFileNameForDirectory=baseFileName.replace('.','_')    
        if not os.path.isdir(_dirName):
            os.mkdir(_dirName)
            return (_dirName,baseFileNameForDirectory)
        else:
            return ("","")
    
    def mapCellTypeToColor(self, cellType):
        return self.colors[cellType]

    # Shows the plugin view tab
    def showPluginView(self, pluginInfo):
        textStr = QString('<div style="margin: 10px 10px 10px 20px; font-size: 14px"><br />\
        Plugin: &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; <b>%1</b><br />\
        Description: &nbsp; %2</div>').arg(pluginInfo[0]).arg(pluginInfo[1])
        
        if self.pluginTab is None:
            self.pluginTab = QTextEdit(textStr, self)
            self.addTab(self.pluginTab, QIcon("player/icons/plugin.png"), pluginInfo[0])  
            # self.closeTab.show()
        else:
            # The plugin view always has index 1 if simview present 0 otherwhise
            if self.count() == 2:
                idx = 1
            else:
                idx = 0
            self.setTabText(idx, pluginInfo[0]) # self.currentIndex()
            self.pluginTab.setText(textStr)
            
        self.setCurrentIndex(1)

    def prepareDrawingArea(self):
        
        self.__setupArea()
        self.mainGraphicsWindow =  self.mainGraphicsWindow # Graphics2D by default
        self.__step=0
        self.__loadSim(file)
        self.setSimParams()
        self.mainGraphicsWindow.initSimArea(self.sim)
        # self.graphics3D.initSimArea(self.sim)
        self.drawingAreaPrepared=True
        
    def setInitialCrossSection(self,_basicSimulationData):
        for windowName in self.windowDict.keys():
            self.windowDict[windowName].setInitialCrossSection(_basicSimulationData)
            
    def initGraphicsWidgetsFieldTypes(self):
        for windowName in self.windowDict.keys():
            self.windowDict[windowName].setFieldTypesComboBox(self.fieldTypes)
            
        
    # Shows simulation view tab
    def showSimView(self, file):
        self.__setupArea()
        
        # Set to 'True' if it is a test tab
        isTest = False
        
        """      
        # For testing. Leave for a while
        if isTest:
            self.mainGraphicsWindow = QVTKRenderWidget(self)
            self.insertTab(0, self.mainGraphicsWindow, QIcon("player/icons/sim.png"), os.path.basename(str(self.__fileName)))
            self.setupArea()
        else:
        """
        
        # Create self.mainGraphicsWindow  
        self.mainGraphicsWindow =  self.mainGraphicsWindow # Graphics2D by default
        self.__step = 0
        self.showDisplayWidgets()
        # # # self.mainGraphicsWindow.initSimArea(self.basicSimulationData)
        # # # self.graphics3D.initSimArea(self.basicSimulationData)
        
        self.__fieldType = ("Cell_Field", FIELD_TYPES[0])
        
        if self.basicSimulationData.sim:
            cellField=self.sim.getPotts().getCellFieldG()
            # self.simulation.graphicsWidget.fillCellFieldData(cellField,"xy",0)
            
            # print "BEFORE DRAW FIELD FROM SHOSIMVIEW"
            self.__drawField()
        
            # # Fields are available only after simulation is loaded
            self.setFieldTypes() 
        else:
            self.__drawField()
            self.setFieldTypesCML() 
            
            
        # # # self.__setCrossSection()
        self.setInitialCrossSection(self.basicSimulationData)
        self.initGraphicsWidgetsFieldTypes()
        # self.closeTab.show()
        self.drawingAreaPrepared=True
        
    def setFieldTypesCML(self):
        # Add cell field
        self.fieldTypes = {}
        self.fieldTypes["Cell_Field"]    = FIELD_TYPES[0]#"CellField" 
    
        self.fieldComboBox.clear()
        self.fieldComboBox.addItem("-- Field Type --")
        self.fieldComboBox.addItem("Cell_Field")
        
    
        for fieldName in self.simulation.fieldsUsed.keys():
            if fieldName!="Cell_Field":
                self.fieldTypes[fieldName]=self.simulation.fieldsUsed[fieldName]
                self.fieldComboBox.addItem(fieldName)
                
        
    def setFieldTypes(self):
        # Add cell field
        self.fieldTypes = {}
        self.fieldTypes["Cell_Field"]    = FIELD_TYPES[0]#"CellField" 
        
        # Add concentration fields How? I don't care how I got it at this time
        # print self.sim.getPotts()
        concFieldNameVec=self.sim.getConcentrationFieldNameVector()
        
        #putting concentration fields from simulator
        for fieldName in concFieldNameVec:
            print "Got this field: ",fieldName
            self.fieldTypes[fieldName]=FIELD_TYPES[1]
        
        
        #inserting extra scalar fields managed from Python script
        scalarFieldNameVec=self.fieldStorage.getScalarFieldNameVector()
        for fieldName in scalarFieldNameVec:
            print "Got this scalar field from Python: ",fieldName
            self.fieldTypes[fieldName]=FIELD_TYPES[2]
            
        
        #inserting extra scalar fields cell levee managed from Python script
        scalarFieldCellLevelNameVec=self.fieldStorage.getScalarFieldCellLevelNameVector()
        for fieldName in scalarFieldCellLevelNameVec:
            print "Got this scalar field from Python: ",fieldName
            self.fieldTypes[fieldName]=FIELD_TYPES[3]
            
            
        #inserting extra vector fields  managed from Python script
        vectorFieldNameVec=self.fieldStorage.getVectorFieldNameVector()
        for fieldName in vectorFieldNameVec:
            print "Got this scalar field from Python: ",fieldName
            self.fieldTypes[fieldName]=FIELD_TYPES[4]
            
        #inserting extra vector fields  cell level managed from Python script
        vectorFieldCellLevelNameVec=self.fieldStorage.getVectorFieldCellLevelNameVector()
        for fieldName in vectorFieldCellLevelNameVec:
            print "Got this scalar field from Python: ",fieldName
            self.fieldTypes[fieldName]=FIELD_TYPES[5]
            
        print "THIS IS vectorFieldCellLevelNameVec=",vectorFieldCellLevelNameVec
        

    def showDisplayWidgets(self):
        print MODULENAME,' showDisplayWidgets'
        
        # This block of code simply checks to see if some plugins assoc'd with Vis are defined
        import CompuCellSetup, XMLUtils
#        print MODULENAME,' dir(XMLUtils)= ',dir(XMLUtils)
        if CompuCellSetup.cc3dXML2ObjConverter != None:
            print MODULENAME, 'CompuCellSetup.cc3dXML2ObjConverter != None; check FPP and COM plugins'
            self.root_element = CompuCellSetup.cc3dXML2ObjConverter.root
            elms = self.root_element.getElements("Plugin")
            elmList = XMLUtils.CC3DXMLListPy(elms)
            for elm in elmList:
    #                print 'dir(elm) = ',dir(elm)
    #                print "Element = ",elm.name  # -> Plugin
                pluginName = elm.getAttribute("Name")
                print "   pluginName = ",pluginName  # e.g. CellType, Contact, etc
                if pluginName == "FocalPointPlasticity":
                    self.pluginFPPDefined = True
                if pluginName == "CenterOfMass":
                    self.pluginCOMDefined = True
    #                break
        print MODULENAME,' FPP= ',self.pluginFPPDefined, ', COM=',self.pluginCOMDefined
        #------------------
            
        self.mainGraphicsWindow.setStatusBar(self.__statusBar)
        
        if not self.keepOldTabs:
            pass
        #self.mainGraphicsWindow.setZoomItems(self.zitems)   # Set zoomFixed parameters
        self.mainGraphicsWindow.setZoomItems(self.zitems)   # Set zoomFixed parameters
        
        #if self.cellsAct.isChecked():          # Set "Cells" check box
        #    self.mainGraphicsWindow.showCells()
            
        if self.borderAct.isChecked():          # Vis menu "Cell Borders" check box
            self.mainGraphicsWindow.showBorder()
            
        #---------------------
        if self.cellGlyphsAct.isChecked():          # Vis menu "Cell Glyphs"
            if not self.pluginCOMDefined:
                print "CenterOfMass plugin was NOT defined - toggling off Vis Cell Glyphs menu item"
                self.cellGlyphsAct.setChecked(False)
                Configuration.setVisualization("CellGlyphsOn",False)
            else:
                self.mainGraphicsWindow.showCellGlyphs()

        #---------------------
        if self.FPPLinksAct.isChecked():          # Vis menu "FPP (Focal Point Plasticity) Links"
            if not self.pluginFPPDefined:
                print "FocalPointPlasticity plugin was NOT defined - toggling off Vis FPP Links menu item"
                self.FPPLinksAct.setChecked(False)
                Configuration.setVisualization("FPPLinksOn",False)
            else:
                self.mainGraphicsWindow.showFPPLinks()
                
        #---------------------
        # if self.contourAct.isChecked():         
            # self.mainGraphicsWindow.showContours(True)
        # else:
            # self.mainGraphicsWindow.showContours(False)

        self.mainGraphicsWindow.setPlane(PLANES[0], 0)
        self.mainGraphicsWindow.currentDrawingObject.setPlane(PLANES[0], 0)
    
    def setParams(self):
        self.__paramsChanged()

    def __paramsChanged(self):
        self.__updateScreen     = Configuration.getOutputFrequency("ScreenUpdateFrequency")
        self.__noOutput         = Configuration.getOutputFrequency("NoOutputFlag")
        self.__shotFrequency    = Configuration.getOutputFrequency("ScreenshotFrequency")
        if self.simulation:
            self.simulation.screenUpdateFrequency=self.__updateScreen
            self.simulation.screenshotFrequency=self.__shotFrequency            
        
    def setZoomItems(self, zitems):
         self.zitems = zitems
         
    def zoomIn(self):
        if self.mainGraphicsWindow is not None:
            self.activeWindow().zoomIn()
            # self.mainGraphicsWindow.zoomIn()
        # print "Zoom in from TabView"
            
    def zoomOut(self):
        if self.mainGraphicsWindow is not None:
            self.activeWindow().zoomOut()
            # self.mainGraphicsWindow.zoomOut()

    def zoomFixed(self, val):
        if self.mainGraphicsWindow is not None:
            self.activeWindow().zoomFixed(val)
            # self.mainGraphicsWindow.zoomFixed(val)
    
    # # File name should be passed    
    def takeShot(self):
        if self.screenshotManager is not None:
            if self.threeDRB.isChecked():
                camera=self.mainGraphicsWindow.ren.GetActiveCamera()
                # print "CAMERA SETTINGS =",camera
                self.screenshotManager.add3DScreenshot(self.__fieldType[0],self.__fieldType[1],camera)
            else:
                planePositionTupple=self.mainGraphicsWindow.getPlane()
                # print "planePositionTupple=",planePositionTupple
                self.screenshotManager.add2DScreenshot(self.__fieldType[0],self.__fieldType[1],planePositionTupple[0],planePositionTupple[1])
    
    def prepareSimulationView(self):
        if self.__fileName != "":
            file = QFile(self.__fileName)
            if file is not None:                
                if self.mainGraphicsWindow is None:
                    # print "NO SIM TAB HERE"
                    self.showSimView(file)
                else:
                    # print "SIM TAB IITIALIZED"
                    self.__closeSim()
                    self.showSimView(file)
        self.drawingAreaPrepared=True
    
    
    def __openLDSFile(self,fileName=None):
        filter = "Lattice Description Summary file  (*.dml )" # self._getOpenFileFilter() 
        
        self.__fileName = QFileDialog.getOpenFileName(\
            self.ui,
            QApplication.translate('ViewManager', "Open Lattice Description Summary file"),
            os.getcwd(), 
            filter
            )
        # converting Qstring to python string    
        self.__fileName=str(self.__fileName)
        from os.path import basename
        # setting text for main window (self.__parent) title bar 
        self.__parent.setWindowTitle(self.trUtf8(basename(self.__fileName)+" - CompuCell3D Player"))
                

    def __openRecentSim(self):
        if self.simulationIsRunning:
            return
        
        action=self.sender()
        if isinstance(action,QAction):
            self.__fileName=str(action.data().toString())    
        from os.path import basename
        # setting text for main window (self.__parent) title bar 
        self.__parent.setWindowTitle(self.trUtf8(basename(self.__fileName)+" - CompuCell3D Player"))
        
    def __openSim(self, fileName = None):
        # """
        # Public slot to open some files.
        
        # @param prog name of file to be opened (string or QString)
        # """

        # set the cwd of the dialog based on the following search criteria:
        #     1: Directory of currently active editor
        #     2: Directory of currently active project
        #     3: CWD  

        filter = "XML files or Python scripts (*.xml *.py)" # self._getOpenFileFilter() 
        
        self.__screenshotDescriptionFileName="" # make screenshotDescriptionFile empty string
        
        self.__fileName = QFileDialog.getOpenFileName(\
            self.ui,
            QApplication.translate('ViewManager', "Open Simulation File"),
            os.getcwd(), 
            filter
            )
        # converting Qstring to python string    
        self.__fileName=str(self.__fileName)
        from os.path import basename
        # setting text for main window (self.__parent) title bar 
        self.__parent.setWindowTitle(self.trUtf8(basename(self.__fileName)+" - CompuCell3D Player"))

                    
    def __saveSim(self):
        fullSimFileName=os.path.abspath(self.__fileName)
        simFilePath=os.path.dirname(fullSimFileName)

        filter = "CompuCell3D Simulation File (CC3DML) (*.xml )" # self._getOpenFileFilter() 
        cc3dmlFileName = QFileDialog.getSaveFileName(\
            self.ui,
            QApplication.translate('ViewManager', "CompuCell3D Simulation File (CC3DML)"),
            simFilePath, 
            filter
            )    
            
        import CompuCellSetup
        CompuCellSetup.cc3dXML2ObjConverter.root.saveXML(str(cc3dmlFileName))        
                
    def __openScrDesc(self):    
        filter = "Screenshot description file (*.sdfml)" # self._getOpenFileFilter() 
        self.__screenshotDescriptionFileName = QFileDialog.getOpenFileName(\
            self.ui,
            QApplication.translate('ViewManager', "Open Screenshot Description File"),
            os.getcwd(), 
            filter
            )
        
    def __saveScrDesc(self):
        # print "THIS IS __saveScrDesc"
        filter = "Screenshot Description File (*.sdfml )" # self._getOpenFileFilter() 
        self.screenshotDescriptionFileName = QFileDialog.getSaveFileName(\
            self.ui,
            QApplication.translate('ViewManager', "Save Screenshot Description File"),
            os.getcwd(), 
            filter
            )
        if self.screenshotManager:
            self.screenshotManager.writeScreenshotDescriptionFile(self.screenshotDescriptionFileName)
            
        print "self.screenshotDescriptionFileName=",self.screenshotDescriptionFileName
    def __closeSim(self):
        print "INSIDE closeSim"

    # Sets the attribute self.movieSupport
    def __setMovieSupport(self):
        self.movieSupport = False # Is there vtkMPEG2Writer class in vtk module?
        vtkmod = inspect.getmembers(vtk, inspect.isclass)
        for i in range(len(vtkmod)):
            if vtkmod[i][0] == "vtkMPEG2Writer":
                self.movieSupport = True
                self.movieAct.setEnabled(True)
                return

        self.movieAct.setEnabled(False)
    
    def __checkMovieSupport(self, checked):
        if self.movieAct.isEnabled():
            if checked and self.movieSupport:
                # The ONLY place where the self.movieAct is checked!
                self.movieAct.setChecked(True) 
            elif not self.movieSupport:
                self.movieAct.setChecked(False)
                QMessageBox.warning(self, "Movie Support Failed", 
                                    "Sorry, your VTK library does not support \nmovie generation!",
                                    QMessageBox.Ok)
    
    def __checkCells(self, checked):
        # Should be disabled when the simulation is not loaded!
        self.simulation.drawMutex.lock()
        if self.cellsAct.isEnabled():
            if checked:
                if self.mainGraphicsWindow is not None:
                    self.mainGraphicsWindow.showCells()
                self.cellsAct.setChecked(True)
            else:
                if self.mainGraphicsWindow is not None:
                    self.mainGraphicsWindow.hideCells()
                self.cellsAct.setChecked(False)
#        else:
#            print '======== SimpleTabView.py:  __checkCells, cellsAct NOT Enabled!!'
        self.simulation.drawMutex.unlock()
        
    def __checkBorder(self, checked):
        # Should be disabled when the simulation is not loaded!
        self.simulation.drawMutex.lock()
        if self.borderAct.isEnabled():
            if checked:
                if self.mainGraphicsWindow is not None:
                    self.mainGraphicsWindow.showBorder()
                self.borderAct.setChecked(True)
            else:
                if self.mainGraphicsWindow is not None:
                    self.mainGraphicsWindow.hideBorder()
                self.borderAct.setChecked(False)
        self.simulation.drawMutex.unlock()

    def __checkCellGlyphs(self, checked):
        # Should be disabled when the simulation is not loaded!
        self.simulation.drawMutex.lock()
        if self.cellGlyphsAct.isEnabled():
            if checked:
                if self.mainGraphicsWindow is not None:
                    # Check for CenterOfMass plugin - improve to not even allow glyphs if no CoM
#                    print '---- dir(self.simulation) =', dir(self.simulation)
#                    print MODULENAME,'---- CoM = ',self.mainGraphicsWindow.drawModel2D.currentDrawingParameters.bsd.sim.getCC3DModuleData("Plugin","CenterOfMass")
                    if not self.pluginCOMDefined:
                        QMessageBox.warning(self, "Message", 
                                        "Warning: You have not defined a CenterOfMass plugin",
                                        QMessageBox.Ok)
                        self.cellGlyphsAct.setChecked(False)
                        Configuration.setVisualization("CellGlyphsOn",False)

                        self.simulation.drawMutex.unlock()
                        return
                    else:
                        self.mainGraphicsWindow.showCellGlyphs()
                        
                self.cellGlyphsAct.setChecked(True)
            else:
                if self.mainGraphicsWindow is not None:
                    self.mainGraphicsWindow.hideCellGlyphs()
                self.cellGlyphsAct.setChecked(False)
#        else:
#            print MODULENAME,'  __checkCellGlyphs, cellGlyphsAct NOT Enabled!!'
        self.simulation.drawMutex.unlock()

    def __checkFPPLinks(self, checked):
        print 'SimpleTabView.py:  __checkFPPLinks, checked=',checked
        Configuration.setVisualization("FPPLinksOn",checked)
        # Should be disabled when the simulation is not loaded!
        self.simulation.drawMutex.lock()
        if self.FPPLinksAct.isEnabled():
            if checked:
                if self.mainGraphicsWindow is not None:
#                    Check for FPP plugin - improve to not even allow glyphs if no CoM
#                    print '---- dir(self.simulation) =', dir(self.simulation)
#                    print MODULENAME,'---- CoM = ',self.mainGraphicsWindow.drawModel2D.currentDrawingParameters.bsd.sim.getCC3DModuleData("Plugin","CenterOfMass")
#                    print 'dir(self.mainGraphicsWindow)=',dir(self.mainGraphicsWindow)
                    if not self.pluginFPPDefined:
                        QMessageBox.warning(self, "Message", 
                                        "Warning: You have not defined a FocalPointPlasticity plugin",
                                        QMessageBox.Ok)
                        self.FPPLinksAct.setChecked(False)
                        Configuration.setVisualization("FPPLinksOn",False)

                        self.simulation.drawMutex.unlock()
                        return
                    else:
                        self.mainGraphicsWindow.showFPPLinks()
                        
                self.FPPLinksAct.setChecked(True)
            else:
                if self.mainGraphicsWindow is not None:
                    self.mainGraphicsWindow.hideFPPLinks()
                self.FPPLinksAct.setChecked(False)
#        else:
#            print '======== SimpleTabView.py:  __checkFPPLinks, FPPLinksAct NOT Enabled!!'
        self.simulation.drawMutex.unlock()

    def __checkContour(self, checked):
        if self.contourAct.isEnabled():
            if checked:
                if self.mainGraphicsWindow is not None:
                    self.mainGraphicsWindow.showContours(True)
                self.contourAct.setChecked(True)
            else:
                if self.mainGraphicsWindow is not None:
                    self.mainGraphicsWindow.showContours(False)
                self.contourAct.setChecked(False)

    def __checkLimits(self, checked):
        pass
        
                        
    def __showConfigDialog(self, pageName = None):
        """
        Private slot to set the configurations.
        @param pageName name of the configuration page to show (string or QString)
        """
        dlg = ConfigurationDialog(self, 'Configuration', True)
        self.connect(dlg, SIGNAL('configsChanged'), self.__configsChanged)
        dlg.show()
        dlg.showConfigurationPageByName("default") #showConfigurationDefaultPage()#
        
        dlg.exec_()
        QApplication.processEvents()

        if dlg.result() == QDialog.Accepted:
            # Saves changes from all configuration pages!
            dlg.setPreferences()
            Configuration.syncPreferences()
            self.__configsChanged() # Explicitly calling signal 'configsChanged'
    
    def __generatePIFFromCurrentSnapshot(self):
        if self.__viewManagerType=="CMLResultReplay":
            self.__generatePIFFromVTK()
        else:
            self.__generatePIFFromRunningSimulation()
            
    def __generatePIFFromRunningSimulation(self):
        if self.pauseAct.isEnabled():
            self.__pauseSim()
    
        fullSimFileName=os.path.abspath(self.__fileName)
        simFilePath=os.path.dirname(fullSimFileName)

        filter = "Choose PIF File Name (*.pif *.txt )" # self._getOpenFileFilter() 
        pifFileName = QFileDialog.getSaveFileName(\
            self.ui,
            QApplication.translate('ViewManager', "Save PIF File As ..."),
            simFilePath, 
            filter
            )      
        self.simulation.generatePIFFromRunningSimulation(str(pifFileName))
    
    def __generatePIFFromVTK(self):
        if self.pauseAct.isEnabled():
            self.__pauseSim()
    
        fullSimFileName=os.path.abspath(self.__fileName)
        simFilePath=os.path.dirname(fullSimFileName)

        filter = "Choose PIF File Name (*.pif *.txt )" # self._getOpenFileFilter() 
        pifFileName = QFileDialog.getSaveFileName(\
            self.ui,
            QApplication.translate('ViewManager', "Save PIF File As ..."),
            simFilePath, 
            filter
            )      
        
        self.simulation.generatePIFFromVTK(self.simulation.currentFileName,str(pifFileName))

    # def __generatePIFFromVTK(self):
        # if self.__viewManagerType!="CMLResultReplay":
            # return
        # else:
            # #pause simulation if it is running
            # if self.pauseAct.isEnabled():
                # self.__pauseSim()
        
            # fullSimFileName=os.path.abspath(self.__fileName)
            # simFilePath=os.path.dirname(fullSimFileName)

            # filter = "Choose PIF File Name (*.pif *.txt )" # self._getOpenFileFilter() 
            # pifFileName = QFileDialog.getSaveFileName(\
                # self.ui,
                # QApplication.translate('ViewManager', "Save PIF File As ..."),
                # simFilePath, 
                # filter
                # )      
            
            # self.simulation.generatePIFFromVTK(self.simulation.currentFileName,str(pifFileName))

    def __configsChanged(self):
        """
        Private slot to handle a change of the preferences.
        """
        self.emit(SIGNAL('configsChanged'))

    def setModelEditor(self, modelEditor):
        self.__modelEditor = modelEditor
    
    # Class that checks if it is safe to close the simulation view
    def isSafeToCloseSim(self):
        msg = QMessageBox.warning(self, "Close Simulation", \
                                  "Are you sure you want to close the Simulation?", \
                                  QMessageBox.Ok | QMessageBox.Cancel, QMessageBox.Cancel)
        
        if msg == QMessageBox.Ok:
            return True
        else:
            return False


    def __createStatusBar(self): 
        self.__statusBar = self.__parent.statusBar()
        self.mcSteps = QLabel()#self.__parent)
        self.mcSteps.setAutoFillBackground(True)
        mcp = QPalette()
        mcp.setColor(QPalette.Window, QColor("white"))# WindowText
        mcp.setColor(QPalette.WindowText, QColor("red"))
        self.mcSteps.setPalette(mcp)
        
        self.conSteps = QLabel()
        self.conSteps.setAutoFillBackground(True)
        cp = QPalette()
        cp.setColor(QPalette.Window, QColor("white"))# WindowText
        cp.setColor(QPalette.WindowText, QColor("blue"))
        self.conSteps.setPalette(cp)
        
        self.__statusBar.addWidget(self.mcSteps)
        self.__statusBar.addWidget(self.conSteps)
        