# -*- coding: utf-8 -*-
from PyQt4 import Qt
from PyQt4.Qt import *

from PyQt4 import QtCore, QtGui
from PyQt4.QtCore import *    

import PyQt4.Qwt5 as Qwt
from PyQt4.Qwt5.anynumpy import *

import PlotManagerSetup
        

        
    
# class PlotWindowInterface(PlotManagerSetup.PlotWindowInterfaceBase,QtCore.QObject):
class PlotWindowInterface(QtCore.QObject):
    # showPlotSignal = QtCore.pyqtSignal( (QtCore.QString,QtCore.QMutex, ))
    showPlotSignal = QtCore.pyqtSignal( ('char*',QtCore.QMutex, ))
    showAllPlotsSignal=QtCore.pyqtSignal( (QtCore.QMutex, ))
    
    def __init__(self,_plotWindow=None):
        # PlotManagerSetup.PlotWindowInterfaceBase.__init__(self,_plotWindow)
        QtCore.QObject.__init__(self, None)
        if _plotWindow:
            self.plotWindow=_plotWindow
            self.pW=self.plotWindow.plotWidget        
        self.plotData={}
        self.plotDrawingObjects={}
        self.initSignalsAndSlots()
        self.plotWindowInterfaceMutex=QtCore.QMutex()
        self.dirtyFlagIndex=2 # this is the index of the flag tha is used to signal wheather the data has been modified or not
        self.autoLegendFlag=False
        self.legendSetFlag=False
        self.legendPosition=Qwt.QwtPlot.BottomLegend
        
    def getQWTPLotWidget(self): # returns native QWT widget to be manipulated byt expert users
        return self.plotWindow        
        
    def initSignalsAndSlots(self):
        self.showAllPlotsSignal.connect(self.__showAllPlots)
        self.showPlotSignal.connect(self.__showPlot)
        
    def setTitle(self,_title):
        self.pW.setTitle(_title)
        
    def setTitleSize(self,_size):
        title=self.pW.title()
        font=title.font()
        font.setPointSize(_size)
        title.setFont(font)        
        self.pW.setTitle(title)
        
    def setTitleColor(self,_colorName):
        title=self.pW.title()
        title.setColor(QColor(_colorName))
        self.pW.setTitle(title)
        
    def setPlotBackgroundColor(self,_colorName):
        self.pW.setCanvasBackground(QColor(_colorName))

    def addAutoLegend(self,_position="bottom"): 
        self.autoLegendFlag=True
        
        # print "_position=",_position
        # sys.exit()
        
        if _position.lower()=="top":
            self.legendPosition=Qwt.QwtPlot.TopLegend
            # print "_position=",_position
            # sys.exit()
            
        elif _position.lower()=="bottom":
            self.legendPosition=Qwt.QwtPlot.BottomLegend
        elif _position.lower()=="left":
            self.legendPosition=Qwt.QwtPlot.LeftLegend            
        elif _position.lower()=="right":
            self.legendPosition=Qwt.QwtPlot.RightLegend
            
            
        # self.legend = Qwt.QwtLegend()
        # self.legend.setFrameStyle(QFrame.Box | QFrame.Sunken)
        # self.legend.setItemMode(Qwt.QwtLegend.ClickableItem)
        
        # self.pW.insertLegend(legend, Qwt.QwtPlot.TopLegend)
        
    def addPlot(self,_plotName):
        # self.plotData[_plotName]=[arange(0),arange(0),False]
        self.plotData[_plotName]=[array([],dtype=double),array([],dtype=double),False]
        
        self.plotDrawingObjects[_plotName]={"curve":Qwt.QwtPlotCurve(_plotName),"LineWidth":2,"LineColor":"black"}
        
        
    def addGrid(self):
        grid = Qwt.QwtPlotGrid()
        grid.attach(self.pW)
        grid.setPen(QPen(Qt.black, 0, Qt.DotLine))        
        
    def addDataPoint(self,_plotName, _x,_y):        
        if not _plotName in self.plotData.keys():
            return
        currentLength=len(self.plotData[_plotName][0])
        self.plotData[_plotName][0].resize(currentLength+1)
        self.plotData[_plotName][1].resize(currentLength+1)
        
        self.plotData[_plotName][0][currentLength]=_x
        self.plotData[_plotName][1][currentLength]=_y
        self.plotData[_plotName][self.dirtyFlagIndex]=True
        # print "self.plotData[_plotName][0]=",self.plotData[_plotName][0]
        # print "self.plotData[_plotName][1]=",self.plotData[_plotName][1]
        
       
    def getDrawingObjectsSettings(self,_plotName):
        if _plotName in self.plotDrawingObjects.keys():
            return self.plotDrawingObjects[_plotName]
        else:
            return None

    def changePlotProperty(self,_plotName,_property,_value):
        self.plotDrawingObjects[_plotName][_property]=_value
        
    def setXAxisTitle(self,_title):
        self.pW.setAxisTitle(Qwt.QwtPlot.xBottom, _title)
        
    def setYAxisTitle(self,_title):
        self.pW.setAxisTitle(Qwt.QwtPlot.yLeft, _title)
        
    def setXAxisTitleSize(self,_size):
        
        title=self.pW.axisTitle(Qwt.QwtPlot.xBottom)
        font=title.font()
        font.setPointSize(_size)
        title.setFont(font)
        self.pW.setAxisTitle(Qwt.QwtPlot.xBottom, title)

    def setXAxisTitleColor(self,_colorName):
        
        title=self.pW.axisTitle(Qwt.QwtPlot.xBottom)
        title.setColor(QColor(_colorName))
        self.pW.setAxisTitle(Qwt.QwtPlot.xBottom, title)
        
    def setYAxisTitleSize(self,_size):
        
        title=self.pW.axisTitle(Qwt.QwtPlot.yLeft)
        font=title.font()
        font.setPointSize(_size)
        title.setFont(font)
        self.pW.setAxisTitle(Qwt.QwtPlot.yLeft, title)

    def setYAxisTitleColor(self,_colorName):
        
        title=self.pW.axisTitle(Qwt.QwtPlot.yLeft)
        title.setColor(QColor(_colorName))
        self.pW.setAxisTitle(Qwt.QwtPlot.yLeft, title)

        
    def setXAxisLogScale(self):
        self.pW.setAxisScaleEngine(Qwt.QwtPlot.xBottom, Qwt.QwtLog10ScaleEngine())
        
    def setYAxisLogScale(self):
        self.pW.setAxisScaleEngine(Qwt.QwtPlot.yLeft, Qwt.QwtLog10ScaleEngine())

    def showPlot(self,_plotName):
        self.plotWindowInterfaceMutex.lock()
        self.showPlotSignal.emit(_plotName,self.plotWindowInterfaceMutex)
        
    def savePlotAsPNG(self,_fileName,_sizeX=400,_sizeY=400):        
        pixmap=QPixmap(_sizeX,_sizeY)
        pixmap.fill(QColor("white"))
        
        self.pW.print_(pixmap)
        pixmap.save(_fileName,"PNG")
        
    def __showPlot(self,_plotName,_mutex=None):
        if (not _plotName in self.plotData.keys() ) or (not _plotName in self.plotDrawingObjects.keys() ):                        
            return
        if not self.plotData[_plotName][self.dirtyFlagIndex]:                        
            return
        drawingObjects=self.plotDrawingObjects[_plotName]    
        drawingObjects["curve"].attach(self.pW)
        drawingObjects["curve"].setPen(QPen(QColor(drawingObjects["LineColor"]), drawingObjects["LineWidth"]))
        drawingObjects["curve"].setData(self.plotData[_plotName][0], self.plotData[_plotName][1])        
        self.plotData[_plotName][self.dirtyFlagIndex]=False
        if self.autoLegendFlag and not self.legendSetFlag:
            self.legend = Qwt.QwtLegend()
            self.legend.setFrameStyle(QFrame.Box | QFrame.Sunken)
            self.legend.setItemMode(Qwt.QwtLegend.ClickableItem)
            self.pW.insertLegend(self.legend, self.legendPosition)                    
            self.legendSetFlag=True
        self.pW.replot()
        self.plotWindowInterfaceMutex.unlock()


    def showAllPlots(self):    
        self.plotWindowInterfaceMutex.lock()
        self.showAllPlotsSignal.emit(self.plotWindowInterfaceMutex)

    def __showAllPlots(self,_mutex=None):
        
        for plotName in self.plotData.keys():
            if self.plotData[plotName][self.dirtyFlagIndex]:
                if plotName in self.plotDrawingObjects.keys():                
                    drawingObjects=self.plotDrawingObjects[plotName]    
                    drawingObjects["curve"].attach(self.pW)
                    drawingObjects["curve"].setPen(QPen(QColor(drawingObjects["LineColor"]), drawingObjects["LineWidth"]))
                    drawingObjects["curve"].setData(self.plotData[plotName][0], self.plotData[plotName][1])                    
                    
                    print "self.legendPosition=",self.legendPosition
                    if self.autoLegendFlag and not self.legendSetFlag:
                        self.legend = Qwt.QwtLegend()
                        self.legend.setFrameStyle(QFrame.Box | QFrame.Sunken)
                        self.legend.setItemMode(Qwt.QwtLegend.ClickableItem)
                        self.pW.insertLegend(self.legend, self.legendPosition)                    
                        self.legendSetFlag=True
                        
                    self.pW.replot()
                    self.plotData[plotName][self.dirtyFlagIndex]=False
        _mutex.unlock()
           
class PlotManager(QtCore.QObject):

    # __pyqtSignals__ = ("newPlotWindow(QtCore.QMutex)",)
    # @QtCore.pyqtSignature("newPlotWindow(QtCore.QMutex)")
    
    # def emitNewPlotWindow(self,_mutex):
        # self.emit(SIGNAL("newPlotWindow(QtCore.QMutex)") , _mutex)
    
    newPlotWindowSignal = QtCore.pyqtSignal( (QtCore.QMutex, ))

    
    def __init__(self,_viewManager=None,_plotSupportFlag=False):
        QtCore.QObject.__init__(self, None)
        self.vm=_viewManager
        self.plotsSupported=_plotSupportFlag
        self.plotWindowList=[]
        self.plotWindowMutex=QtCore.QMutex()
        self.signalsInitialized=False
                     
    def getPlotWindow(self):
        if self.plotsSupported:
           return PlotWindow()
        else:
            return PlotWindowBase()
            
    def reset(self):
        self.plotWindowList=[]
        
        
    def initSignalAndSlots(self):
        # since initSignalAndSlots can be called in SimTabView multiple times (after each simulation restart) we have to ensure that signals are connected only once 
        # otherwise there will be an avalanche of signals - each signal for each additional simulation run this will cause lots of extra windows to pop up 
        if not self.signalsInitialized: 
            self.newPlotWindowSignal.connect(self.processRequestForNewPlotWindow)
            self.signalsInitialized=True
        # self.connect(self,SIGNAL("newPlotWindow(QtCore.QMutex)"),self.processRequestForNewPlotWindow)
        
    def getNewPlotWindow(self):
        print "\n\n\n getNewPlotWindow "
        self.plotWindowMutex.lock()

        self.newPlotWindowSignal.emit(self.plotWindowMutex)
        # processRequestForNewPlotWindow will be called and it will unlock drawMutex but before it will finish runnning (i.e. before the new window is actually added)we must make sure that getNewPlotwindow does not return 
        self.plotWindowMutex.lock()
        self.plotWindowMutex.unlock()
        return self.plotWindowList[-1] # returning recently added window
        
    def processRequestForNewPlotWindow(self,_mutex):
        print "\n\n\n\n GOT HERE mutex=",_mutex
        if not self.plotsSupported:
            return PlotWindowInterfaceBase(None) # dummy PlotwindowInterface
        
        from  Graphics.PlotFrameWidget import PlotFrameWidget
        if not self.vm.simulationIsRunning:
            return
        # self.vm.simulation.drawMutex.lock()
        
        self.vm.windowCounter+=1        
        newWindow=PlotFrameWidget(self.vm)
        
        self.vm.windowDict[self.vm.windowCounter]=newWindow
        self.vm.plotWindowDict[self.vm.windowCounter]=self.vm.windowDict[self.vm.windowCounter]
        
        newWindow.setWindowTitle("Plot Window "+str(self.vm.windowCounter))
        
        
        
        
        self.vm.lastActiveWindow=newWindow
        # # self.updateWindowMenu()
        
          
        newWindow.setShown(False)
        
        self.vm.mdiWindowDict[self.vm.windowCounter]=self.vm.addSubWindow(newWindow)
        newWindow.show()
        
        plotWindowInterface=PlotWindowInterface(newWindow)
        self.plotWindowList.append(plotWindowInterface) # store plot window interface in the window list
                
        
        self.plotWindowMutex.unlock()
        
        # return  plotWindowInterface# here I will need to call either PlotWindowInterface or PlotWindowInterfaceBase depending if dependencies are installed or not
    # def updatePlots(self):
        # for plotWindowInterface in self.plotWindowList:
            # plotWindowInterface.showAllPlots()
            
    # def addNewPlotWindow(self):
        # print "\n\n\n\n GOT HERE"
        # if not self.plotsSupported:
            # return PlotWindowInterfaceBase(None) # dummy PlotwindowInterface
        
        # from  Graphics.PlotFrameWidget import PlotFrameWidget
        # if not self.vm.simulationIsRunning:
            # return
        # self.vm.simulation.drawMutex.lock()
        
        # self.vm.windowCounter+=1        
        # newWindow=PlotFrameWidget(self.vm)
        
        # self.vm.windowDict[self.vm.windowCounter]=newWindow
        
        # newWindow.setWindowTitle("Plot Window "+str(self.vm.windowCounter))
        
        
        
        
        # self.vm.lastActiveWindow=newWindow
        # # # self.updateWindowMenu()
        
          
        # newWindow.setShown(False)
        
        # self.vm.addSubWindow(newWindow)
        # newWindow.show()
        
        # plotWindowInterface=PlotWindowInterface(newWindow)
        # self.plotWindowList.append(plotWindowInterface) # store plot window interface in the window list
                
        
        # self.vm.simulation.drawMutex.unlock()
        # return  plotWindowInterface# here I will need to call either PlotWindowInterface or PlotWindowInterfaceBase depending if dependencies are installed or not
        
#//////////////////////////////////////////////////////////////////////
# class CustomPlot:
    # def __init__(self,_plotManager):    
        # self.pM=_plotManager
        # print "self.pM=",self.pM," function list=",dir(self.pM)
        
        # self.pW=self.pM.addNewPlotWindow()
        
    # def initPlot(self):
        # self.pW.setTitle("Custom Plot")        
        # self.pW.setXAxisTitle("MonteCarlo Step (MCS)")
        # self.pW.setYAxisTitle("Variables")        
        # self.pW.addGrid()
        # # plot 1
        # self.pW.addPlot("MCS")
        # self.pW.addDataPoint("MCS",1,1)
        # self.pW.addDataPoint("MCS",2,2)
        # self.pW.changePlotProperty("MCS","LineWidth",5)
        # self.pW.changePlotProperty("MCS","LineColor","red")        
        # # self.pW.showPlot("MCS")
        
        # # plot 1
        # self.pW.addPlot("MCS1")
        # self.pW.addDataPoint("MCS1",1,-1)
        # self.pW.addDataPoint("MCS1",2,2)
        # self.pW.changePlotProperty("MCS1","LineWidth",1)
        # self.pW.changePlotProperty("MCS1","LineColor","green")        
        # # self.pW.showPlot("MCS1")
        # self.pW.showAllPlots()
        

#////////////////////////////////////////////////////////////////////// 
        