# -*- coding: utf-8 -*-
from PyQt4.QtCore import *
from PyQt4.QtGui import *

from Utilities.QVTKRenderWidget import QVTKRenderWidget
# from GraphicsNew import GraphicsNew
from MVCDrawViewBase import MVCDrawViewBase
from Plugins.ViewManagerPlugins.SimpleTabView import FIELD_TYPES
import Configuration
import vtk, math
import sys, os
import string

CONTOUR_ALLOWED_FIELD_TYPES=[FIELD_TYPES[1],FIELD_TYPES[2],FIELD_TYPES[3]]

MODULENAME='----MVCDrawView2D.py: '

class MVCDrawView2D(MVCDrawViewBase):
    def __init__(self, _drawModel, qvtkWidget, parent=None):
        MVCDrawViewBase.__init__(self,_drawModel,qvtkWidget, parent)
        
        self.initArea()
        self.setParams()
#        self.simIs3D = self.getSim3DFlag()
        
    # Sets up the VTK simulation area 
    def initArea(self):
        self.actorCollection=vtk.vtkActorCollection()
        self.borderActor    = vtk.vtkActor()
        self.borderActorHex = vtk.vtkActor()
        self.cellGlyphsActor  = vtk.vtkActor()
        self.FPPLinksActor  = vtk.vtkActor()
        self.outlineActor = vtk.vtkActor()
        self.outlineDim=[0,0,0]
        
        self.cellsActor     = vtk.vtkActor()
        self.cellsActor.GetProperty().SetInterpolationToFlat() # ensures that pixels are drawn exactly not with interpolations/antialiasing
        
        self.hexCellsActor     = vtk.vtkActor()
        self.hexCellsActor.GetProperty().SetInterpolationToFlat() # ensures that pixels are drawn exactly not with interpolations/antialiasing
        
        self.conActor       = vtk.vtkActor()
        self.conActor.GetProperty().SetInterpolationToFlat()

        self.hexConActor       = vtk.vtkActor()
        self.hexConActor.GetProperty().SetInterpolationToFlat()
        
        self.contourActor   = vtk.vtkActor()      

        self.glyphsActor=vtk.vtkActor()
        #self.linksActor=vtk.vtkActor()

        # # Concentration lookup table
        
        self.clut = vtk.vtkLookupTable()
        self.clut.SetHueRange(0.67, 0.0)
        self.clut.SetSaturationRange(1.0,1.0)
        self.clut.SetValueRange(1.0,1.0)
        self.clut.SetAlphaRange(1.0,1.0)
        self.clut.SetNumberOfColors(1024)
        self.clut.Build()

        # Contour lookup table
        # Do I need lookup table? May be just one color?
        self.ctlut = vtk.vtkLookupTable()
        self.ctlut.SetHueRange(0.6, 0.6)
        self.ctlut.SetSaturationRange(0,1.0)
        self.ctlut.SetValueRange(1.0,1.0)
        self.ctlut.SetAlphaRange(1.0,1.0)
        self.ctlut.SetNumberOfColors(1024)
        self.ctlut.Build()
        
    def setPlane(self, plane, pos):
        (self.plane, self.planePos) = (str(plane).upper(), pos)
#        print MODULENAME,"  got this plane ",(self.plane, self.planePos)
        print (self.plane, self.planePos)

        
    def getPlane(self):
        return (self.plane, self.planePos)

    #----------------------------------------------------------------------------
    def showBorder(self):
        # # # print " SHOW BORDERS self.parentWidget.borderAct.isEnabled()=",self.parentWidget.borderAct.isEnabled()
        Configuration.setVisualization("BordersOn",True)
#        print MODULENAME,' showBorder ============'
        if not self.currentActors.has_key("BorderActor"):
            self.currentActors["BorderActor"]=self.borderActor  
            self.graphicsFrameWidget.ren.AddActor(self.borderActor)
        # print "self.currentActors.keys()=",self.currentActors.keys()
        # Don't re-render until next calc step since it could show previous/incorrect actor
        #self.Render()
        #self.graphicsFrameWidget.repaint()        
    
    def hideBorder(self):
        Configuration.setVisualization("BordersOn",False)
        if self.currentActors.has_key("BorderActor"):
            del self.currentActors["BorderActor"] 
            self.graphicsFrameWidget.ren.RemoveActor(self.borderActor)
        self.Render()
        self.graphicsFrameWidget.repaint()

    #----------------------------------------------------------------------------
    def showCells(self):
        Configuration.setVisualization("CellsOn",True)
#        print MODULENAME,' showCells() '
        if self.parentWidget.latticeType==Configuration.LATTICE_TYPES["Hexagonal"] and self.plane=="XY": # drawing in other planes will be done on a rectangular lattice
            if not self.currentActors.has_key("HexCellsActor"):
                self.currentActors["HexCellsActor"] = self.hexCellsActor  
                self.graphicsFrameWidget.ren.AddActor(self.hexCellsActor)
        else:
            if not self.currentActors.has_key("CellsActor"):
                self.currentActors["CellsActor"]=self.cellsActor  
                self.graphicsFrameWidget.ren.AddActor(self.cellsActor)
        # print "self.currentActors.keys()=",self.currentActors.keys()
        # Don't re-render until next calc step since it could show previous/incorrect actor
        #self.Render()
        #self.graphicsFrameWidget.repaint()
        
    def hideCells(self):
#        print MODULENAME,' hideCells()  (was hideCellField)'
#        Configuration.setVisualization("CellsOn",False)
        if self.parentWidget.latticeType==Configuration.LATTICE_TYPES["Hexagonal"] and self.plane=="XY": # drawing in other planes will be done on a rectangular lattice
            del self.currentActors["HexCellsActor"] 
            self.graphicsFrameWidget.ren.RemoveActor(self.hexCellsActor)
        if self.currentActors.has_key("CellsActor"):
            del self.currentActors["CellsActor"] 
            self.graphicsFrameWidget.ren.RemoveActor(self.cellsActor)
        self.Render()
        self.graphicsFrameWidget.repaint()

    def hideAllActors(self):   # never used?
        removedActors=[]
#        print '   hideAllActors: currentActors=',self.currentActors
        for actorName in self.currentActors:
#            print '   hideAllActors:  removing actorName=',actorName
            self.graphicsFrameWidget.ren.RemoveActor(self.currentActors[actorName])
            removedActors.append(actorName)
        #cannot remove dictionary elements in  above loop
        for actorName in removedActors:
            del self.currentActors[actorName]

    #----------------------------------------------------------------------------
    def showCellGlyphs(self):
#        print MODULENAME,'  showCellGlyphs'
        Configuration.setVisualization("CellGlyphsOn",True)
        if not self.currentActors.has_key("CellGlyphsActor"):
            self.currentActors["CellGlyphsActor"]=self.cellGlyphsActor  
            print '============       MVCDrawView2D.py:  showCellGlyphs, add cellGlyphsActor'
            self.graphicsFrameWidget.ren.AddActor(self.cellGlyphsActor)
        # print "self.currentActors.keys()=",self.currentActors.keys()
        #self.Render()
        #self.graphicsFrameWidget.repaint()        
    
    def hideCellGlyphs(self):
#        print MODULENAME,'  hideCellGlyphs'
        Configuration.setVisualization("CellGlyphsOn",False)
        if self.currentActors.has_key("CellGlyphsActor"):
            del self.currentActors["CellGlyphsActor"] 
            print '============       MVCDrawView2D.py:  showCellGlyphs, remove cellGlyphsActor'
            self.graphicsFrameWidget.ren.RemoveActor(self.cellGlyphsActor)
        self.Render()
        self.graphicsFrameWidget.repaint()
        
    #----------------------------------------------------------------------------
    def showFPPLinks(self):
#        print MODULENAME,'   showFPPLinks'
        Configuration.setVisualization("FPPLinksOn",True)
        if not self.currentActors.has_key("FPPLinksActor"):
            self.currentActors["FPPLinksActor"]=self.FPPLinksActor  
            print '============       MVCDrawView2D.py:  showFPPLinks, add FPPLinksActor'
            self.graphicsFrameWidget.ren.AddActor(self.FPPLinksActor)
        # print "self.currentActors.keys()=",self.currentActors.keys()
        #self.Render()
        #self.graphicsFrameWidget.repaint()        
    
    def hideFPPLinks(self):
#        print MODULENAME,'   hideFPPLinks'
        Configuration.setVisualization("FPPLinksOn",False)
        if self.currentActors.has_key("FPPLinksActor"):
            del self.currentActors["FPPLinksActor"] 
            print '============       MVCDrawView2D.py:  showFPPLinks, remove FPPLinksActor'
            self.graphicsFrameWidget.ren.RemoveActor(self.FPPLinksActor)
        self.Render()
        self.graphicsFrameWidget.repaint()

    
    #----------------------------------------------------------------------------
    def removeContourActors(self):        
        if self.currentActors.has_key("ContourActor"):        
            del self.currentActors["ContourActor"]             
            self.graphicsFrameWidget.ren.RemoveActor(self.contourActor)
    
    def showContours(self, enable):
        if enable and self.currentFieldType[1] in CONTOUR_ALLOWED_FIELD_TYPES:
            Configuration.setColorMapPlot("ContoursOn",True)
            if not self.currentActors.has_key("ContourActor"):
                self.currentActors["ContourActor"]=self.contourActor              
                self.graphicsFrameWidget.ren.AddActor(self.contourActor)        
            # will ensure that borders is the last item to draw
            actorsCollection=self.graphicsFrameWidget.ren.GetActors()
            if actorsCollection.GetLastItem()!=self.contourActor:
                self.graphicsFrameWidget.ren.RemoveActor(self.contourActor)
                self.graphicsFrameWidget.ren.AddActor(self.contourActor) 
                # print "ADDED CONTOUR ACTOR TO THE TOP"
        else:
            Configuration.setColorMapPlot("ContoursOn",False)
            if self.currentActors.has_key("ContourActor"):
                del self.currentActors["ContourActor"]             
                self.graphicsFrameWidget.ren.RemoveActor(self.contourActor)
                
        self.Render() 
        self.graphicsFrameWidget.repaint()
    
    def setBorderColor(self):
        color = Configuration.getCellTypeColors("Border")
        r = color.red()
        g = color.green()
        b = color.blue()
        self.borderActor.GetProperty().SetColor(self.toVTKColor(r), self.toVTKColor(g), self.toVTKColor(b))
        self.borderActorHex.GetProperty().SetColor(self.toVTKColor(r), self.toVTKColor(g), self.toVTKColor(b))
        self.Render() 
        self.qvtkWidget.repaint()
            
    def setCamera(self, fieldDim = None):
        camera = self.graphicsFrameWidget.ren.GetActiveCamera()
        
        self.setDim(fieldDim)
        # Should I specify these parameters explicitly? 
        # What if I change dimensions in XML file? 
        # The parameters should be set based on the configuration parameters!
        # Should it set depending on projection? (e.g. xy, xz, yz)
        
        distance = self.largestDim(self.dim)*2 # 200 #273.205 #
        
        # FIXME: Hardcoded numbers
        
        camera.SetPosition(self.dim[0]/2, self.dim[1]/2, distance)
        camera.SetFocalPoint(self.dim[0]/2, self.dim[1]/2, 0)
        camera.SetClippingRange(distance - 1, distance + 1)
        # self.qvtkWidget.ren.ResetCameraClippingRange()
        self.graphicsFrameWidget.ren.ResetCameraClippingRange()
        self.__initDist = distance #camera.GetDistance()
        self.Render() 
        self.qvtkWidget.repaint()

    def setDim(self, fieldDim):       
        self.dim = [fieldDim.x , fieldDim.y , fieldDim.z]
#        print MODULENAME,' setDim(), self.dim=',self.dim
#        print MODULENAME,' setDim(), self.dim[2]=',self.dim[2]

        
    def prepareOutlineActor(self,_dim):
        outlineData = vtk.vtkImageData()
        outlineData.SetDimensions(_dim[0], _dim[1], 1)

        outline = vtk.vtkOutlineFilter()
        outline.SetInput(outlineData)
        outlineMapper = vtk.vtkPolyDataMapper()
        outlineMapper.SetInputConnection(outline.GetOutputPort())
    
        self.outlineActor.SetMapper(outlineMapper)
        self.outlineActor.GetProperty().SetColor(1, 1, 1)        

    def showOutlineActor(self):
        self.currentActors["Outline"]=self.outlineActor
        self.graphicsFrameWidget.ren.AddActor(self.outlineActor)
        
    
    def hideOutlineActor(self):
        self.ren.RemoveActor(self.outlineActor)
        del self.currentActors["Outline"]

    def drawCellField(self, _bsd, fieldType):
#        print MODULENAME,'  drawCellField'
#        self.removeContourActors()
        # self.hideAllActors()   # Q: how expensive is this?
        
#        if self.parentWidget.cellsAct.isChecked():
        if self.parentWidget.cellsAct.isChecked() or self.getSim3DFlag():  # rwh: hack for FPP

#            print '    drawCellField: yes, cellsAct isChecked'
            if self.parentWidget.latticeType==Configuration.LATTICE_TYPES["Hexagonal"] and self.plane=="XY": # drawing in other planes will be done on a rectangular lattice
                self.drawCellFieldHex(_bsd,fieldType)
                return
            
            self.drawModel.initCellFieldActors((self.cellsActor,))
        
#            print '   drawCellField:  currentActors=',self.currentActors
            if not self.currentActors.has_key("CellsActor"):
                self.currentActors["CellsActor"] = self.cellsActor  
                self.graphicsFrameWidget.ren.AddActor(self.cellsActor) 
#                print '-----  added CELLS ACTOR'
        
        # Always draw outline of lattice
        self.drawModel.prepareOutlineActors((self.outlineActor,))
        self.showOutlineActor()
        

        if self.parentWidget.borderAct.isChecked():
            if self.parentWidget.latticeType==Configuration.LATTICE_TYPES["Hexagonal"] and self.plane=="XY": # drawing in other planes will be done on a rectangular lattice
                self.drawBorders2DHex()    
            else:
                self.drawBorders2D()       
        #else:
        #    self.hideBorder()
            
        if self.parentWidget.cellGlyphsAct.isChecked() and not self.getSim3DFlag():
            self.drawCellGlyphs2D()       
        #else:
        #    self.hideCellGlyphs()
        
#        print MODULENAME, ' drawCellField(), zdim=', self.getZDim()
        if self.parentWidget.FPPLinksAct.isChecked() and not self.getSim3DFlag():
            self.drawFPPLinks2D()
            
        self.Render()
        
        
    # FIXME: Draw contour lines: drawContourLines()
    def drawCellFieldHex(self, bsd, fieldType):
#        print MODULENAME,'  drawCellFieldHex'
        #self.removeContourActors()    # not needed, assuming this method never called directly (rather, via drawCellField)
        
        self.drawModel.initCellFieldHexActors((self.hexCellsActor,))
        
        if self.currentActors.has_key("CellsActor"):
            if self.ren:
                self.ren.RemoveActor(self.currentActors["CellsActor"])
            del self.currentActors["CellsActor"]        

        # if self.currentActors.has_key("BorderActor"):
            # self.ren.RemoveActor(self.currentActors["BorderActor"])
            # del self.currentActors["BorderActor"]        
        
        if not self.currentActors.has_key("HexCellsActor"):
            self.currentActors["HexCellsActor"]=self.hexCellsActor  
            self.graphicsFrameWidget.ren.AddActor(self.hexCellsActor)         
        
        if self.parentWidget.borderAct.isChecked():
            self.drawBorders2DHex()    
#        else:
#            self.hideBorder()

        self.drawModel.prepareOutlineActors((self.outlineActor,))        
        self.showOutlineActor()
        
        if self.parentWidget.cellGlyphsAct.isChecked() and not self.getSim3DFlag():
            self.drawCellGlyphs2D()       
        #else:
        #    self.hideCellGlyphs()
        
#        print MODULENAME, ' drawCellField(), zdim=', self.getZDim()
        if self.parentWidget.FPPLinksAct.isChecked() and not self.getSim3DFlag():
            self.drawFPPLinks2D()
        
        self.Render()
        return
        
    def drawConFieldHex(self,bsd,fieldType):
        self.drawModel.initConFieldHexActors((self.hexConActor,self.contourActor))    

        if not self.currentActors.has_key("HexConActor"):
            self.currentActors["HexConActor"]=self.hexConActor         
            self.graphicsFrameWidget.ren.AddActor(self.hexConActor)         
        
        if self.parentWidget.borderAct.isChecked():
            self.drawBorders2DHex()    
        else:
            self.hideBorder()
            
            
        # Draw legend!
        if Configuration.getColorMapPlot("LegendEnable"):            
            self.drawModel.prepareLegendActors((self.drawModel.hexConMapper,),(self.legendActor,))
            self.showLegend(True)
        else:
            self.showLegend(False)
            
        if Configuration.getColorMapPlot("ContoursOn"):            
            self.showContours(True)            
        else:
            self.showContours(False)
            
        self.drawModel.prepareOutlineActors((self.outlineActor,))        
        self.showOutlineActor()
        
        self.Render()
        
    def drawScalarFieldCellLevelHex(self,bsd,fieldType):
        self.drawModel.initScalarFieldCellLevelHexActors((self.hexConActor,self.contourActor))
            
        if not self.currentActors.has_key("HexConActor"):
            self.currentActors["HexConActor"]=self.hexConActor  
            self.graphicsFrameWidget.ren.AddActor(self.hexConActor)         
        
        if self.parentWidget.borderAct.isChecked():
            self.drawBorders2DHex()    
        else:
            self.hideBorder()
            
        if Configuration.getColorMapPlot("LegendEnable"):            
            self.drawModel.prepareLegendActors((self.drawModel.hexConMapper,),(self.legendActor,))
            self.showLegend(True)
        else:
            self.showLegend(False)
    
        if Configuration.getColorMapPlot("ContoursOn"):            
            self.showContours(True)            
        else:
            self.showContours(False)
    
        self.drawModel.prepareOutlineActors((self.outlineActor,))        
        self.showOutlineActor()
        
        self.Render()

    def drawScalarFieldHex(self,bsd,fieldType):
        self.drawModel.initScalarFieldHexActors((self.hexConActor,self.contourActor))
        
        if not self.currentActors.has_key("HexConActor"):
            self.currentActors["HexConActor"]=self.hexConActor  
            self.graphicsFrameWidget.ren.AddActor(self.hexConActor)         
        
        if self.parentWidget.borderAct.isChecked():
            self.drawBorders2DHex()    
        else:
            self.hideBorder()
            
        if Configuration.getColorMapPlot("LegendEnable"):            
            self.drawModel.prepareLegendActors((self.drawModel.hexConMapper,),(self.legendActor,))
            self.showLegend(True)
        else:
            self.showLegend(False)
    
        if Configuration.getColorMapPlot("ContoursOn"):            
            self.showContours(True)            
        else:
            self.showContours(False)

        self.drawModel.prepareOutlineActors((self.outlineActor,))        
        self.showOutlineActor()      
        
        self.Render()
        
    def drawConField(self, sim, fieldType):
        if self.parentWidget.latticeType==Configuration.LATTICE_TYPES["Hexagonal"] and self.plane=="XY": # drawing in other planes will be done on a rectangular lattice
            self.drawConFieldHex(sim,fieldType)
            return
            
        fillScalarField = getattr(self.parentWidget.fieldExtractor, "fillConFieldData2D") # this is simply a "pointer" to function       
        self.drawScalarFieldData(sim,fieldType,fillScalarField)
        
    def drawScalarFieldCellLevel(self, sim, fieldType):
        if self.parentWidget.latticeType==Configuration.LATTICE_TYPES["Hexagonal"] and self.plane=="XY": # drawing in other planes will be done on a rectangular lattice
            self.drawScalarFieldCellLevelHex(sim,fieldType)
            return    
        fillScalarField = getattr(self.parentWidget.fieldExtractor, "fillScalarFieldCellLevelData2D") # this is simply a "pointer" to function        
        self.drawScalarFieldData(sim,fieldType,fillScalarField)
        
    def drawScalarField(self, sim, fieldType):
        if self.parentWidget.latticeType==Configuration.LATTICE_TYPES["Hexagonal"] and self.plane=="XY": # drawing in other planes will be done on a rectangular lattice
            self.drawScalarFieldHex(sim,fieldType)
            return        
        fillScalarField = getattr(self.parentWidget.fieldExtractor, "fillScalarFieldData2D") # this is simply a "pointer" to function        
        self.drawScalarFieldData(sim,fieldType,fillScalarField)
    
    def drawScalarFieldData(self, _bsd, fieldType,_fillScalarField):
        
        self.drawModel.initScalarFieldActors(_fillScalarField,(self.conActor,self.contourActor,))
        
        if not self.currentActors.has_key("ConActor"):
            self.currentActors["ConActor"]=self.conActor  
            self.graphicsFrameWidget.ren.AddActor(self.conActor) 
            
            actorProperties=vtk.vtkProperty()
            actorProperties.SetOpacity(1.0)
            
            self.conActor.SetProperty(actorProperties)
            
        if Configuration.getColorMapPlot("LegendEnable"):            
            self.drawModel.prepareLegendActors((self.drawModel.conMapper,),(self.legendActor,))
            self.showLegend(True)
        else:
            self.showLegend(False)

        if self.parentWidget.borderAct.isChecked():
            self.drawBorders2D() 
        else:
            self.hideBorder()

        if Configuration.getColorMapPlot("ContoursOn"):                        
            self.showContours(True)
        else:
            self.showContours(False)
            
        self.drawModel.prepareOutlineActors((self.outlineActor,))       
        self.showOutlineActor()    
        
        # FIXME: 
        # self.drawContourLines()
        # # # print "DRAW CON FIELD NUMBER OF ACTORS = ",self.ren.GetActors().GetNumberOfItems()
        # self.repaint()
        self.Render()

        
    def drawVectorField(self, bsd, fieldType):
        self.removeContourActors()
        
        if self.parentWidget.latticeType==Configuration.LATTICE_TYPES["Hexagonal"] and self.plane=="XY": # drawing in other planes will be done on a rectangular lattice
            self.drawVectorFieldDataHex(bsd,fieldType)
            return            
        fillVectorField = getattr(self.parentWidget.fieldExtractor, "fillVectorFieldData2D") # this is simply a "pointer" to function self.parentWidget.fieldExtractor.fillVectorFieldData2D        
        self.drawVectorFieldData(bsd,fieldType,fillVectorField)
        
    def drawVectorFieldCellLevel(self, bsd, fieldType):        
        self.removeContourActors()
        
        if self.parentWidget.latticeType==Configuration.LATTICE_TYPES["Hexagonal"] and self.plane=="XY": # drawing in other planes will be done on a rectangular lattice
            self.drawVectorFieldCellLevelDataHex(bsd,fieldType)
            return            
        fillVectorField = getattr(self.parentWidget.fieldExtractor, "fillVectorFieldCellLevelData2D") # this is simply a "pointer" to function self.parentWidget.fieldExtractor.fillVectorFieldData2D        
        self.drawVectorFieldData(bsd,fieldType,fillVectorField)

    def drawVectorFieldDataHex(self,bsd,fieldType):        
        self.removeContourActors()
        
        self.drawModel.initVectorFieldDataHexActors((self.glyphsActor,))
        
        if not self.currentActors.has_key("Glyphs2DActor"):
            self.currentActors["Glyphs2DActor"]=self.glyphsActor  
            self.graphicsFrameWidget.ren.AddActor(self.glyphsActor)         
            
        if Configuration.getColorMapPlot("LegendEnable"):            
            self.drawModel.prepareLegendActors((self.drawModel.glyphsMapper,),(self.legendActor,))
            self.showLegend(True)
        else:
            self.showLegend(False)
            
        if self.parentWidget.borderAct.isChecked():
            self.drawBorders2DHex()         
        else:
            self.hideBorder()

        self.drawModel.prepareOutlineActors((self.outlineActor,))        
        self.showOutlineActor()           
        
        self.Render()
        
        
    def drawVectorFieldCellLevelDataHex(self,bsd,fieldType):        
        self.removeContourActors()
        
        self.drawModel.initVectorFieldCellLevelDataHexActors((self.glyphsActor,))
        
        if not self.currentActors.has_key("Glyphs2DActor"):
            self.currentActors["Glyphs2DActor"]=self.glyphsActor  
            self.graphicsFrameWidget.ren.AddActor(self.glyphsActor)         
            
        if Configuration.getColorMapPlot("LegendEnable"):            
            self.drawModel.prepareLegendActors((self.drawModel.glyphsMapper,),(self.legendActor,))
            self.showLegend(True)
        else:
            self.showLegend(False)
            
        if self.parentWidget.borderAct.isChecked():
            self.drawBorders2DHex()         
        else:
            self.hideBorder()

        self.drawModel.prepareOutlineActors((self.outlineActor,))        
        self.showOutlineActor()           
           
        self.Render()


        
    def drawVectorFieldData(self,bsd,fieldType,_fillVectorFieldFcn):        
        self.drawModel.initVectorFieldCellLevelActors(_fillVectorFieldFcn, (self.glyphsActor,))
        
        if Configuration.getVectorField("OverlayVectorCellFields"):
            self.drawCellField(bsd, fieldType)
        else:
            self.hideCells()
        
        if not self.currentActors.has_key("Glyphs2DActor"):
            self.currentActors["Glyphs2DActor"]=self.glyphsActor  
            self.graphicsFrameWidget.ren.AddActor(self.glyphsActor)         

        if Configuration.getColorMapPlot("LegendEnable"):            
            self.drawModel.prepareLegendActors((self.drawModel.glyphsMapper,),(self.legendActor,))
            self.showLegend(True)
        else:
            self.showLegend(False)
            
        if self.parentWidget.borderAct.isChecked():
            self.drawBorders2D()         
        else:
            self.hideBorder()

        self.drawModel.prepareOutlineActors((self.outlineActor,))        
        self.showOutlineActor()
            
        self.Render()
        
    # Optimize code?
    def dimOrder(self, plane):
        plane=string.lower(plane)
        order = (0, 1, 2)
        if plane == "xy":
            order = (0, 1, 2)
        elif plane == "xz":
            order = (0, 2, 1)
        elif plane == "yz": 
            order = (1, 2, 0)
            
        return order

    # Optimize code?
    def pointOrder(self, plane):
        plane=string.lower(plane)
        order = (0, 1, 2)
        if plane == "xy":
            order = (0, 1, 2)
        elif plane == "xz":
            order = (0, 2, 1)
        elif plane == "yz": 
            order = (2, 0, 1)
        return order

    def planeMapper(self, order, tuple):
        return [tuple[order[0]], tuple[order[1]], tuple[order[2]]]
    
    # ?
    def drawContourLines(self): 
        pass        
        
    def wheelEvent(self, ev): 
        print "wheelEvent \n\n\n\n"
        self.__zoomStep(ev.delta())
    
    # Overrides the mousePressEvent() method from QVTKRenderWidget
    def mousePressEvent(self,ev):
        if (ev.button() == 1):
            self._Mode = "Pan"
            self._ActiveButton = ev.button()
            #self.PickActor(ev.x(), ev.y())
            #print self.GetPicker()
            #self.showTip(ev.x(), ev.y())
            
        elif (ev.button() == 2):
            self._Mode = "Zoom"
            self._ActiveButton = ev.button()

        self.UpdateRenderer(ev.x(),ev.y())

    def event(self, ev):
        if ev.type() == QEvent.ToolTip:
            self.showTip(ev)
        return QWidget.event(self, ev)

    def showTip(self, ev):
        # toll tips are not enabled in this release
        return
        import CompuCell
        pt = CompuCell.Point3D() 

        self.PickActor(ev.x(), ev.y())
        id = self.GetPicker().GetCellId()
        if id != -1:
            pos = self.GetPicker().GetPickPosition()
            pt.x, pt.y, pt.z = int(pos[0]), int(pos[1]), 0 
            
            if  self.cellField.get(pt) is not None and self.cellField.get(pt).id != 0:
                QToolTip.hideText()
                QToolTip.showText(ev.globalPos(), self.toolTip(self.cellField.get(pt)))
                    
    def takeShot(self):
        filter = "PNG files (*.png)"
        fileName = QFileDialog.getSaveFileName(\
            self,
            "Save Screenshot",
            os.getcwd(), 
            filter
            )

        # Other way to get the correct file name: fileName.toAscii().data())
        if fileName is not None and fileName != "":
            self.takeSimShot(str(fileName))
    
    # fileName - full file name (e.g. "/home/user/shot.png")        
    def takeSimShot(self, fileName):
        # DON'T REMOVE!
        # Better quality
        # Passes vtkRenderer. Takes actual screenshot of the region withing the widget window
        # If other application are present within this region it will shoot them also

        renderLarge = vtk.vtkRenderLargeImage()
        renderLarge.SetInput(self.graphicsFrameWidget.ren)
        renderLarge.SetMagnification(1)

        
        # We write out the image which causes the rendering to occur. If you
        # watch your screen you might see the pieces being rendered right
        # after one another.
        writer = vtk.vtkPNGWriter()
        writer.SetInputConnection(renderLarge.GetOutputPort())
        # # # print "GOT HERE fileName=",fileName
        writer.SetFileName(fileName)
        
        writer.Write()
            
    def toolTip(self, cellG):
        return "Id:             %s\nType:       %s\nVolume:  %s" % (cellG.id, cellG.type, cellG.volume)

    def configsChanged(self):
        self.populateLookupTable()
        self.setBorderColor()
        # Doesn't work, gives error: 
        # vtkScalarBarActor (0x8854218): Need a mapper to render a scalar bar
        #self.showLegend(Configuration.getColorMapPlot("LegendEnable"))
        self.showContours(Configuration.getColorMapPlot("ContoursOn"))
        
        self.parentWidget.requestRedraw()

    def drawBorders2D(self):
        #print '============ MVCDrawView2D.py: drawBorders2D ============='
        self.setBorderColor()         
        self.drawModel.initBordersActors2D((self.borderActor,))

        if not self.currentActors.has_key("BorderActor"):
            self.currentActors["BorderActor"]=self.borderActor
            self.graphicsFrameWidget.ren.AddActor(self.borderActor)
            # print "ADDING BORDER ACTOR"
        else:
            # will ensure that borders is the last item to draw
            actorsCollection=self.graphicsFrameWidget.ren.GetActors()
            if actorsCollection.GetLastItem()!=self.borderActor:
                self.graphicsFrameWidget.ren.RemoveActor(self.borderActor)
                self.graphicsFrameWidget.ren.AddActor(self.borderActor) 
        # print "self.currentActors.keys()=",self.currentActors.keys()    
        
    def drawBorders2DHex(self):
        self.setBorderColor() 
        self.drawModel.initBordersActors2DHex((self.borderActor,))
        if not self.currentActors.has_key("BorderActor"):
            self.currentActors["BorderActor"]=self.borderActor
            self.graphicsFrameWidget.ren.AddActor(self.borderActor) 
        else:
            # will ensure that borders is the last item to draw
            actorsCollection=self.graphicsFrameWidget.ren.GetActors()
            if actorsCollection.GetLastItem()!=self.borderActor:
                self.graphicsFrameWidget.ren.RemoveActor(self.borderActor)
                self.graphicsFrameWidget.ren.AddActor(self.borderActor)             
                
    def drawCellGlyphs2D(self):
#        print MODULENAME,' drawCellGlyphs2D()'
        #self.setBorderColor()         
        self.drawModel.initCellGlyphsActor2D(self.cellGlyphsActor)

        if not self.currentActors.has_key("CellGlyphsActor"):
            self.currentActors["CellGlyphsActor"]=self.cellGlyphsActor
            self.graphicsFrameWidget.ren.AddActor(self.cellGlyphsActor)
            # print "ADDING cellGlyphs ACTOR"
        else:
            # will ensure that borders is the last item to draw
            actorsCollection=self.graphicsFrameWidget.ren.GetActors()
            if actorsCollection.GetLastItem()!=self.borderActor:
                self.graphicsFrameWidget.ren.RemoveActor(self.cellGlyphsActor)
                self.graphicsFrameWidget.ren.AddActor(self.cellGlyphsActor) 
        # print "self.currentActors.keys()=",self.currentActors.keys()    

    def drawFPPLinks2D(self):
#        print MODULENAME,' drawFPPLinks2D()'
        #self.setBorderColor()         
        self.drawModel.initFPPLinksActor2D(self.FPPLinksActor)

        if not self.currentActors.has_key("FPPLinksActor"):
            self.currentActors["FPPLinksActor"]=self.FPPLinksActor
            self.graphicsFrameWidget.ren.AddActor(self.FPPLinksActor)
            # print "ADDING FPPLinks ACTOR"
        else:
            # will ensure that links actor is the last item to draw
            actorsCollection=self.graphicsFrameWidget.ren.GetActors()
            if actorsCollection.GetLastItem()!=self.FPPLinksActor:
                self.graphicsFrameWidget.ren.RemoveActor(self.FPPLinksActor)
                self.graphicsFrameWidget.ren.AddActor(self.FPPLinksActor) 
        # print "self.currentActors.keys()=",self.currentActors.keys()    
