import sys, os

def setVTKPaths():
   import sys
   from os import environ
   import string
   import sys
   platform=sys.platform
   if platform=='win32':
      sys.path.append(environ["VTKPATH"])
      sys.path.append(environ["VTKPATH1"])
      sys.path.append(environ["PYQT_PATH"])
      sys.path.append(environ["SIP_PATH"])
      sys.path.append(environ["SIP_UTILS_PATH"])
#   else:
#      swig_path_list=string.split(environ["VTKPATH"])
#      for swig_path in swig_path_list:
#         sys.path.append(swig_path)


setVTKPaths()
# print "GRAPHICS PATH=",sys.path  



from PyQt4.QtCore import *
from PyQt4.QtGui import *

# from Utilities.QVTKRenderWidget import QVTKRenderWidget
# from FrameQVTK import FrameQVTK
# import FrameQVTK
import Graphics

from PyQt4 import QtCore, QtGui,QtOpenGL
import vtk

import Configuration
import vtk, math
import sys, os

from Plugins.ViewManagerPlugins.SimpleTabView import FIELD_TYPES,PLANES
        
class MVCDrawModelBase():
    def __init__(self, graphicsFrameWidget, parent=None):
        
        (self.minCon, self.maxCon) = (0, 0)
        
        self.parentWidget=parent
        self.graphicsFrameWidget=graphicsFrameWidget
        self.qvtkWidget=self.graphicsFrameWidget.qvtkWidget
        self.currentDrawingFunction=None       
        self.fieldTypes=None 
        self.currentDrawingParameters=None
        
        
    def setDrawingParametersObject(self,_drawingParams):
        self.currentDrawingParameters=_drawingParams
        
    def setDrawingParameters(self,_bsd,_plane,_planePos,_fieldType):   
        self.bsd=_bsd
        self.plane=_plane
        self.planePos=_planePos
        self.fieldtype=_fieldType
        
    def setDrawingFunctionName(self,_fcnName):
        # print "\n\n\n THIS IS _fcnName=",_fcnName," self.drawingFcnName=",self.drawingFcnName
        
        if self.drawingFcnName != _fcnName:
            self.drawingFcnHasChanged=True
        else:
            self.drawingFcnHasChanged=False
        self.drawingFcnName=_fcnName
        
    def clearDisplay(self):
        print "CLEAR DISPLAY"
        for actor in self.currentActors:
            self.graphicsFrameWidget.ren.RemoveActor(self.currentActors[actor])
            
        self.currentActors.clear()
    
    def Render(self):
        self.graphicsFrameWidget.Render()
        
    #this is an ugly solution that seems to work on 32 bit machines. We will see if it will work on other machines        
    def extractAddressIntFromVtkObject(self,_vtkObj):
        # pointer_ia=ia.__this__
        # print "pointer_ia=",pointer_ia
        # address=pointer_ia[1:9]
        # print "address=",address," int(address)=",int(address,16)
        return self.parentWidget.fieldExtractor.unmangleSWIGVktPtrAsLong(_vtkObj.__this__)
        # return int(_vtkObj.__this__[1:9],16)
                
        
    def initCellFieldActors(self, _actors): pass
    
    def initConFieldActors(self, _actors): pass
    
    def initVectorFieldCellLevelActors(self, _fillVectorFieldFcn, _actors): pass
    
    def initVectorFieldActors(self, _actors): pass
    
    def initScalarFieldCellLevelActors(self, _actors): pass     
    
    def initScalarFieldActors(self, _fillScalarField, _actors): pass   
    
    def prepareOutlineActors(self,_actors):pass        
    
    # def showContours(self, enable): pass
    
    # def setPlane(self, plane, pos): pass
    
    # def getPlane(self):
        # return ("",0)
    
    def getCamera(self):
        return self.ren.GetActiveCamera()
        
    # def initSimArea(self, _bsd):
        # fieldDim   = _bsd.fieldDim
        # # sim.getPotts().getCellFieldG().getDim()
        # self.setCamera(fieldDim)
       
    def configsChanged(self): pass
        
    # Transforms interval [0, 255] to [0, 1]
    def toVTKColor(self, val):
        return float(val)/255

    def largestDim(self, dim):
        ldim = dim[0]
        for i in range(len(dim)):
            if dim[i] > ldim:
                ldim = dim[i]
                
        return ldim
    
    def setParams(self):
        # You can use either Build() method (256 color by default) or
        # SetNumberOfTableValues() to allocate much more colors!
        self.lut = vtk.vtkLookupTable()
        # You need to explicitly call Build() when constructing the LUT by hand     
        self.lut.Build()
        self.populateLookupTable()
        # self.dim = [100, 100, 1] # Default values
    
    def populateLookupTable(self):
        colorMap = Configuration.getCellTypeColors("TypeColorMap")
        for key in colorMap.keys():
            r = colorMap[key].red()
            g = colorMap[key].green()
            b = colorMap[key].blue()
            self.lut.SetTableValue(key, self.toVTKColor(r), self.toVTKColor(g), self.toVTKColor(b), 1.0)
            # print "type=",key," red=",r," green=",g," blue=",b
        # self.qvtkWidget.repaint()
        
        self.graphicsFrameWidget.Render()
        
    # Do I need this method?
    # Calculates min and max concentration
    def findMinMax(self, conField, dim):
        import CompuCell
        pt = CompuCell.Point3D() 

        maxCon = 0
        minCon = 0
        for k in range(dim[2]):
            for j in range(dim[1]):
                for i in range(dim[0]):
                    pt.x = i
                    pt.y = j
                    pt.z = k
                    
                    con = float(conField.get(pt))
                    
                    if maxCon < con:
                        maxCon = con
                    
                    if minCon > con:
                        minCon = con

        # Make sure that the concentration is positive
        if minCon < 0:
            minCon = 0

        return (minCon, maxCon)

    # Just returns min and max concentration
    def conMinMax(self):
        return (self.minCon, self.maxCon)
    
    def frac(self, con, minCon, maxCon):
        if maxCon == minCon:
            return 0.0
        else:
            frac = (con - minCon)/(maxCon - minCon)
            
        if frac > 1.0:
            frac = 1.0
            
        if frac < 0.0:
            frac = 0.0

        return frac

    def prepareLegendActors(self, _mappers, _actors):
        legendActor=_actors[0]
        mapper=_mappers[0]
            
        legendActor.SetLookupTable(mapper.GetLookupTable())    
        legendActor.GetPositionCoordinate().SetCoordinateSystemToNormalizedViewport()
        legendActor.GetPositionCoordinate().SetValue(0.01, 0.1)
        legendActor.SetOrientationToHorizontal()
        
        legendActor.SetOrientationToVertical()
        # self.legendActor.SetWidth(0.8)
        # self.legendActor.SetHeight(0.10)

        legendActor.SetWidth(0.1)
        legendActor.SetHeight(0.9)

        
        # You don't actually need to make contrast for the text as
        # it has shadow!
        text = legendActor.GetLabelTextProperty()
        #text.SetFontSize(12) # For some reason it doesn't make effect
        text.BoldOff()
        text.SetColor(1.0, 1.0, 1.0)
        # self.ren.AddActor(self.legendActor)
        # if not self.currentActors.has_key("LegendActor"):
            # self.currentActors["LegendActor"]=self.legendActor  
            # self.graphicsFrameWidget.ren.AddActor(self.legendActor) 
            # # # # print "\n\n\n\n added LEGEND ACTOR"        
        
        
        # if not self.currentActors.has_key("LegendActor"):
            # self.currentActors["LegendActor"]=self.legendActor  
     
    # def showLegend(self, enable):
        # if enable:
            # if not self.currentActors.has_key("LegendActor"):
                # self.currentActors["LegendActor"]=self.legendActor
                # self.ren.AddActor(self.legendActor)
        # else:
            # if self.currentActors.has_key("LegendActor"):
                # del self.currentActors["LegendActor"]
                # self.ren.RemoveActor(self.legendActor)
        # self.repaint()
    
    # def setZoomItems(self, zitems):
        # self.zitems = zitems

    # def showBorder(self): pass
    
    # def hideBorder(self): pass
    
    # def zoomIn(self): pass
    
    # def zoomOut(self): pass
    
    # def zoomFixed(self, val): pass
    
    # def takeShot(self): pass

    # def cloneCamera(self,_camera):
        # cam = self.ren.GetActiveCamera()
        # # cam.ApplyTransform(_camera.GetViewTransformObject())
        # cam.SetClippingRange(_camera.GetClippingRange())
        
        # cam.SetFocalPoint(_camera.GetFocalPoint())
        # cam.SetPosition(_camera.GetPosition())
        
        # # cam.SetViewPlaneNormal(_camera.GetViewPlaneNormal())
        # cam.SetViewUp(_camera.GetViewUp())
        
        # # cam.SetRoll(_camera.GetRoll())
        
        # # cam.SetDistance(_camera.GetDistance())
        # # cam.SetViewShear(_camera.GetViewShear())
        
        
        # # cam.SetDistance(_camera.GetDistance())
        
        # # cam.SetViewAngle(_camera.GetViewAngle())
        
    # def setCamera(self, fieldDim): 
        # camera = self.GetCurrentRenderer().GetActiveCamera()
        
        # #self.setDim(dim)
        # # Should I specify these parameters explicitly? 
        # # What if I change dimensions in XML file? 
        # # The parameters should be set based on the configuration parameters!
        # # Should it set depending on projection? (e.g. xy, xz, yz)
        
        # distance = 200 #self.largestDim()*2 # 273.205 #
        # # FIXME: Hardcoded numbers
        
        # # camera.SetPosition(50, 50, distance)
        # # camera.SetFocalPoint(50, 50, 0)
        # # camera.SetClippingRange(distance - 100, distance + 100)
        # # # self.GetCurrentRenderer().ResetCameraClippingRange()
        # # self.ren.ResetCameraClippingRange()

    # def startMovie(self):
        # self.w = vtk.vtkWindowToImageFilter()
        # self.w.SetInput(self.GetRenderWindow())
        
        # self.movie = vtk.vtkMPEG2Writer() # Check is it is available.
        # self.movie.SetInput(self.w.GetOutput())
        # self.movie.SetFileName("cellsort2D.mpg")
        # self.movie.Start()

    # def writeMovie(self):
        # self.movie.Write()
        # self.w = vtk.vtkWindowToImageFilter()
        # self.w.SetInput(self.GetRenderWindow())
        # self.movie.SetInput(self.w.GetOutput())


    # def endMovie(self):
        # self.movie.End()

    # def setStatusBar(self, statusBar):
        # self._statusBar = statusBar

    # Break the settings read into groups?
    def readSettings(self):
        self.readColorsSets()
        self.readViewSets()
        self.readColormapSets()
        self.readOutputSets()
        self.readVectorSets()
        self.readVisualSets()
        # simDefaults?

    def readColorsSets(self):
        #colorsDefaults
        self._colorMap     = Configuration.getCellTypeColors("TypeColorMap")
        self._borderColor  = Configuration.getCellTypeColors("Border")
        self._contourColor = Configuration.getCellTypeColors("Contour")
        self._brushColor   = Configuration.getCellTypeColors("Brush")
        self._penColor     = Configuration.getCellTypeColors("Pen")

    def readViewSets(self):
        # For 3D only?
        # viewDefaults
        self._types3D      = Configuration.getThreeDView("Types3DInvisible")

    def readColormapSets(self):
        # colormapDefaults
        self._minCon       = Configuration.getColorMapPlot("MinConcentration")
        self._minConFixed  = Configuration.getColorMapPlot("MinConcentrationFixed")
        self._maxCon       = Configuration.getColorMapPlot("MaxConcentration")
        self._maxConFixed  = Configuration.getColorMapPlot("MaxConcentrationFixed")
        self._accuracy     = Configuration.getColorMapPlot("NumberAccuracy")
        self._numLegend    = Configuration.getColorMapPlot("NumberOfLegendBoxes")
        self._enableLegend = Configuration.getColorMapPlot("LegendEnable")
        self._contoursOn   = Configuration.getColorMapPlot("ContoursOn")
        self._numberOfContourLines   = Configuration.getColorMapPlot("NumberOfContourLines")

    def readOutputSets(self):
        # Should I read the settings here?
        # outputDefaults
        self._updateScreen     = Configuration.getOutputFrequency("ScreenUpdateFrequency")
        self._noOutput         = Configuration.getOutputFrequency("NoOutputFlag")
        self._shotFrequency    = Configuration.getOutputFrequency("ScreenshotFrequency")

    def readVectorSets(self):
        # vectorDefaults
        self._arrowColor   = Configuration.getVectorField("ArrowColor")
        self._arrowLength  = Configuration.getVectorField("ArrowLength")
        self._arrowColorFixed  = Configuration.getVectorField("FixedArrowColorFlag")
        self._enableLegendVec  = Configuration.getVectorField("LegendEnableVector")
        self._scaleArrows  = Configuration.getVectorField("ScaleArrows")
        self._accuracyVec  = Configuration.getVectorField("NumberAccuracyVector")
        self._numLegendVec = Configuration.getVectorField("NumberOfLegendBoxesVector")
        self._overlayVec   = Configuration.getVectorField("OverlayVectorCellFields")
        self._maxMag       = Configuration.getVectorField("MaxMagnitude")
        self._maxMagFixed  = Configuration.getVectorField("MaxMagnitudeFixed")
        self._minMag       = Configuration.getVectorField("MinMagnitude")
        self._minMagFixed  = Configuration.getVectorField("MinMagnitudeFixed")

    def readVisualSets(self):
        # visualDefaults
        self._bordersOn    = Configuration.getVisualization("BordersOn")        
        self._conLimitsOn  = Configuration.getVisualization("ConcentrationLimitsOn")
        self._zoomFactor   = Configuration.getVisualization("ZoomFactor")
        


    
    
    # Just thoughtlessly copied methods from the old player.
    # Need to selected and revisited 
    # Names? Interface from the old Graphics2D
    
    #def paintLattice(self): pass ->
    #def paintLegend(self, minCon, maxCon, location, type): pass
    #def legendDimension(self, location, rectWidth, rectHeight, type): pass
    #def paintConcentrationLattice(self): pass
    #def paintCellVectorFieldLattice(self): pass
    # def fillFakeConcentration(self): pass
    #def doContourLines(self): pass
    #def produceImage(self, image): pass
    #def produceImage(self, fileName): pass

    # def getCurrentPainitgFcnPtr(self): pass
    # def getPaintConcentrationLattice(self): pass
    # def getPaintCellVectorFieldLattice(self): pass
    # def getPaintLattice(self): pass
    # def setCurrentPainitgFcnPtr(self, paintingFcnPtr): pass
    # def drawCurrentScene(self): pass
 
 
    # def setGraphicsDataFieldPtr(self, graphFieldsPtr): pass
    # def getGraphFieldsPtr(self): pass
    # def setUnivGraphSetPtr(self, univGraphSetPtr): pass

    def setLatticeType(self, latticeType):
        self.latticeType=latticeType
     
    # Setters, getters
    #def getTypePenMap(self): pass
    #def getTypeBrushMap(self): pass

    
