# -*- coding: utf-8 -*-
from PyQt4.QtCore import *
from PyQt4.QtGui import *

from Utilities.QVTKRenderWidget import QVTKRenderWidget
# from GraphicsNew import GraphicsNew
from MVCDrawModelBase import MVCDrawModelBase
import Configuration
import vtk, math
import sys, os
import string

MODULENAME='----- MVCDrawModel2D.py:  '


class MVCDrawModel2D(MVCDrawModelBase):
    def __init__(self, qvtkWidget, parent=None):
        MVCDrawModelBase.__init__(self,qvtkWidget, parent)
        
        self.initArea()
        self.setParams()
        
    # Sets up the VTK simulation area 
    def initArea(self):
        ## Set up the mappers (2D) for cell vis.
        self.cellsMapper    = vtk.vtkPolyDataMapper()
        self.hexCellsMapper = vtk.vtkPolyDataMapper()
        self.borderMapper   = vtk.vtkPolyDataMapper()
        self.borderMapperHex   = vtk.vtkPolyDataMapper()
        self.cellGlyphsMapper  = vtk.vtkPolyDataMapper()
        self.FPPLinksMapper  = vtk.vtkPolyDataMapper()
        
        self.outlineDim=[0,0,0]
        
        ## Set up the mappers (2D) for concentration field.
        self.conMapper      = vtk.vtkPolyDataMapper()
        self.hexConMapper   = vtk.vtkPolyDataMapper()
        self.contourMapper  = vtk.vtkPolyDataMapper()
        self.glyphsMapper   = vtk.vtkPolyDataMapper()
        
        # # Concentration lookup table
        self.numberOfTableColors=1024
        self.clut = vtk.vtkLookupTable()
        self.clut.SetHueRange(0.67, 0.0)
        self.clut.SetSaturationRange(1.0,1.0)
        self.clut.SetValueRange(1.0,1.0)
        self.clut.SetAlphaRange(1.0,1.0)
        self.clut.SetNumberOfColors(self.numberOfTableColors)
        self.clut.Build()
        
        self.lowTableValue=self.clut.GetTableValue(0)
        self.highTableValue=self.clut.GetTableValue(self.numberOfTableColors-1)

        # Contour lookup table
        # Do I need lookup table? May be just one color?
        self.ctlut = vtk.vtkLookupTable()
        self.ctlut.SetHueRange(0.6, 0.6)
        self.ctlut.SetSaturationRange(0,1.0)
        self.ctlut.SetValueRange(1.0,1.0)
        self.ctlut.SetAlphaRange(1.0,1.0)
        self.ctlut.SetNumberOfColors(self.numberOfTableColors)
        self.ctlut.Build()

    def setDim(self, fieldDim):       
        self.dim = [fieldDim.x , fieldDim.y , fieldDim.z]

    def prepareOutlineActors(self,_actors):
        outlineData = vtk.vtkImageData()
        
        fieldDim = self.currentDrawingParameters.bsd.fieldDim
        dimOrder    = self.dimOrder(self.currentDrawingParameters.plane)
        self.dim = self.planeMapper(dimOrder, (fieldDim.x, fieldDim.y, fieldDim.z))        
        
        if self.parentWidget.latticeType==Configuration.LATTICE_TYPES["Hexagonal"] and self.currentDrawingParameters.plane=="XY":       
            import math            
            outlineData.SetDimensions(self.dim[0]+1,int(self.dim[1]*math.sqrt(3.0)/2.0)+2,1)
            # print "self.dim[0]+1,int(self.dim[1]*math.sqrt(3.0)/2.0)+2,1= ",(self.dim[0]+1,int(self.dim[1]*math.sqrt(3.0)/2.0)+2,1)
        else:            
            outlineData.SetDimensions(self.dim[0]+1, self.dim[1]+1, 1)

        # outlineDimTmp=_imageData.GetDimensions()
        # # print "\n\n\n this is outlineDimTmp=",outlineDimTmp," self.outlineDim=",self.outlineDim
        # if self.outlineDim[0] != outlineDimTmp[0] or self.outlineDim[1] != outlineDimTmp[1] or self.outlineDim[2] != outlineDimTmp[2]:
            # self.outlineDim=outlineDimTmp
        
        outline = vtk.vtkOutlineFilter()
        outline.SetInput(outlineData)
        outlineMapper = vtk.vtkPolyDataMapper()
        outlineMapper.SetInputConnection(outline.GetOutputPort())
    
        _actors[0].SetMapper(outlineMapper)
        _actors[0].GetProperty().SetColor(1, 1, 1)        
        # self.outlineDim=_imageData.GetDimensions()

    def initCellFieldActors(self, _actors):
#        print '---- MVCDrawModel2D.py ----:  initCellFieldActors called'
        
        if self.parentWidget.latticeType==Configuration.LATTICE_TYPES["Hexagonal"] and self.currentDrawingParameters.plane=="XY": # drawing in other planes will be done on a rectangular lattice
#            self.initCellFieldHexActors(_bsd,fieldType,_actors)
            self.initCellFieldHexActors(_actors)
            return
            
        # cellField  = _bsd.sim.getPotts().getCellFieldG()
        
        # # # print "drawing plane ",self.plane," planePos=",self.planePos
        # fieldDim = cellField.getDim()
        fieldDim = self.currentDrawingParameters.bsd.fieldDim
        
        dimOrder    = self.dimOrder(self.currentDrawingParameters.plane)
        self.dim = self.planeMapper(dimOrder, (fieldDim.x, fieldDim.y, fieldDim.z))# [fieldDim.x, fieldDim.y, fieldDim.z]         
        
        self.cellType = vtk.vtkIntArray()
        self.cellType.SetName("celltype")
        # self.cellTypeIntAddr=self.parentWidget.fieldExtractor.unmangleSWIGVktPtr(self.cellType.__this_)
        
        self.cellTypeIntAddr=self.extractAddressIntFromVtkObject(self.cellType)
        # print "self.cellTypeIntAddr=",self.cellTypeIntAddr
        self.parentWidget.fieldExtractor.fillCellFieldData2D(self.cellTypeIntAddr,self.currentDrawingParameters.plane, self.currentDrawingParameters.planePos)
        
        # Python function used during prototyping
        # self.fillCellFieldData(cellField,self.plane, self.planePos)
        
        self.initCellFieldActorsData(_actors)
    
    def initCellFieldHexActors(self, _actors):
        # cellField  = sim.getPotts().getCellFieldG()
        # # # # print "INSIDE drawCellFieldHex"
        # # # # print "drawing plane ",self.plane," planePos=",self.planePos
        # fieldDim = cellField.getDim()
        fieldDim = self.currentDrawingParameters.bsd.fieldDim
        dimOrder    = self.dimOrder(self.currentDrawingParameters.plane)
        self.dim = self.planeMapper(dimOrder, (fieldDim.x, fieldDim.y, fieldDim.z))# [fieldDim.x, fieldDim.y, fieldDim.z]         
            
        self.cellType = vtk.vtkIntArray()
        self.cellType.SetName("celltype")
        self.cellTypeIntAddr=self.extractAddressIntFromVtkObject(self.cellType)
		# a=21
        self.hexCells=vtk.vtkCellArray()
		
        self.hexCellsIntAddr=self.extractAddressIntFromVtkObject(self.hexCells)
		
        self.hexCellsPolyData=vtk.vtkPolyData()
		# **********************************************
		
        self.hexPoints = vtk.vtkPoints()
        # self.hexPoints.SetName("hexpoints")
        self.hexPointsIntAddr=self.extractAddressIntFromVtkObject(self.hexPoints)
        
        self.parentWidget.fieldExtractor.fillCellFieldData2DHex(self.cellTypeIntAddr,self.hexCellsIntAddr,self.hexPointsIntAddr,self.currentDrawingParameters.plane, self.currentDrawingParameters.planePos)
		# self.parentWidget.fieldExtractor.fillCellFieldData2DHex(self.cellTypeIntAddr,self.hexPointsIntAddr,self.plane, self.planePos)
        
        self.hexCellsPolyData.GetCellData().SetScalars(self.cellType)
        self.hexCellsPolyData.SetPoints(self.hexPoints)
        self.hexCellsPolyData.SetPolys(self.hexCells)
		
        self.hexCellsMapper.SetInput(self.hexCellsPolyData)
        self.hexCellsMapper.ScalarVisibilityOn()
        self.hexCellsMapper.SetLookupTable(self.lut)
        self.hexCellsMapper.SetScalarRange(0,self.lut.GetNumberOfColors())
        
        _actors[0].SetMapper(self.hexCellsMapper)
    
    def initializeContoursHex(self,_dim,_conArray,_minMax,_contourActor):
        data = vtk.vtkImageData()
        data.SetDimensions(_dim[0], _dim[1], 1)        
        data.SetScalarTypeToUnsignedChar()      
        data.GetPointData().SetScalars(_conArray)
        field       = vtk.vtkImageDataGeometryFilter()        
        # field.SetExtent(0, _dim[0], 0, int((_dim[1])*math.sqrt(3.0)), 0, 0)
        # field.SetExtent(0, _dim[0], 0, _dim[1]/2, 0, 0)
        field.SetInput(data)
        transform=vtk.vtkTransform()
        transform.Scale(1,math.sqrt(3.0)/2.0,1)
        transform.Translate(0,math.sqrt(3.0)/2.0,0)
        
        contour     = vtk.vtkContourFilter()
        
        if Configuration.getColorMapPlot("ContoursOn"):            
            contour.SetInputConnection(field.GetOutputPort())
            contour.GenerateValues(Configuration.getColorMapPlot("NumberOfContourLines"), _minMax)
            
            tpd1 = vtk.vtkTransformPolyDataFilter()
            tpd1.SetInputConnection(contour.GetOutputPort())
            tpd1.SetTransform(transform)
            
            # self.contourMapper.SetInputConnection(contour.GetOutputPort())
            self.contourMapper.SetInputConnection(tpd1.GetOutputPort())
            self.contourMapper.SetLookupTable(self.ctlut)
            self.contourMapper.SetScalarRange(_minMax) 
            _contourActor.SetMapper(self.contourMapper)
            
    def initConFieldHexActors(self,_actors):
        # cellField  = sim.getPotts().getCellFieldG()
        # conField   = CompuCell.getConcentrationField(sim, fieldType[0]) 
        conFieldName=self.currentDrawingParameters.fieldName        
        
        # # # print "drawing plane ",self.plane," planePos=",self.planePos
        # fieldDim = cellField.getDim()
        
        fieldDim = self.currentDrawingParameters.bsd.fieldDim
        
        dimOrder    = self.dimOrder(self.currentDrawingParameters.plane)
        self.dim = self.planeMapper(dimOrder, (fieldDim.x, fieldDim.y, fieldDim.z))# [fieldDim.x, fieldDim.y, fieldDim.z]         
            
        self.conArray = vtk.vtkDoubleArray()
        self.conArray.SetName("concentration")
        self.conArrayIntAddr=self.extractAddressIntFromVtkObject(self.conArray)
        self.hexPointsCon = vtk.vtkPoints()
        # self.hexPoints.SetName("hexpoints")
        self.hexPointsConIntAddr=self.extractAddressIntFromVtkObject(self.hexPointsCon)
        
        # ***************************************************************************    
        self.hexCellsCon=vtk.vtkCellArray()
		
        self.hexCellsConIntAddr=self.extractAddressIntFromVtkObject(self.hexCellsCon)
		
        self.hexCellsConPolyData=vtk.vtkPolyData()
        
        # *************************************************************************** 
        fillSuccessful=self.parentWidget.fieldExtractor.fillConFieldData2DHex(self.conArrayIntAddr,self.hexCellsConIntAddr,self.hexPointsConIntAddr,conFieldName,self.currentDrawingParameters.plane, self.currentDrawingParameters.planePos)        
        
        # fillSuccessful=self.parentWidget.fieldExtractor.fillConFieldData2DHex(self.conArrayIntAddr,self.hexPointsIntAddr,conFieldName,self.plane, self.planePos)
        
        # fillSuccessful=self.parentWidget.fieldExtractor.fillConFieldData2DHex(self.conArrayIntAddr,self.hexPointsIntAddr,conFieldName,self.plane, self.planePos)
        if not fillSuccessful:
            return

        range=self.conArray.GetRange()
        self.minCon=range[0]
        self.maxCon=range[1]
        dim_0=self.dim[0]+1
        dim_1=self.dim[1]+1

        if Configuration.getColorMapPlot("MinConcentrationFixed"):
            self.minCon=Configuration.getColorMapPlot("MinConcentration")            
            self.clut.SetTableValue(0,[0,0,0,1])
        else:
            self.clut.SetTableValue(0,self.lowTableValue)
                        
        if Configuration.getColorMapPlot("MaxConcentrationFixed"):
            self.maxCon=Configuration.getColorMapPlot("MaxConcentration")
            self.clut.SetTableValue(self.numberOfTableColors-1,[0,0,0,1])
        else:
            self.clut.SetTableValue(self.numberOfTableColors-1,self.highTableValue)


        if Configuration.getColorMapPlot("ContoursOn"):
            contourActor=_actors[1]
            self.initializeContoursHex([self.dim[0], self.dim[1]],self.conArray,[self.minCon, self.maxCon],contourActor)        

        self.hexCellsConPolyData.GetCellData().SetScalars(self.conArray)
        self.hexCellsConPolyData.SetPoints(self.hexPointsCon)
        self.hexCellsConPolyData.SetPolys(self.hexCellsCon)
		
        self.hexConMapper.SetInput(self.hexCellsConPolyData)
        self.hexConMapper.ScalarVisibilityOn()
        self.hexConMapper.SetLookupTable(self.clut)
        self.hexConMapper.SetScalarRange(self.minCon, self.maxCon)
        
        _actors[0].SetMapper(self.hexConMapper)
                    
    def initScalarFieldCellLevelHexActors(self,_actors):
        # cellField  = sim.getPotts().getCellFieldG()
        # conField   = CompuCell.getConcentrationField(sim, fieldType[0]) 
        conFieldName=self.currentDrawingParameters.fieldName        
        
        
        # # # print "drawing plane ",self.plane," planePos=",self.planePos
        fieldDim = self.currentDrawingParameters.bsd.fieldDim
        dimOrder    = self.dimOrder(self.currentDrawingParameters.plane)
        self.dim = self.planeMapper(dimOrder, (fieldDim.x, fieldDim.y, fieldDim.z))# [fieldDim.x, fieldDim.y, fieldDim.z]         
            
        self.conArray = vtk.vtkDoubleArray()
        self.conArray.SetName("concentration")
        self.conArrayIntAddr=self.extractAddressIntFromVtkObject(self.conArray)
        self.hexPointsCon = vtk.vtkPoints()
        
        self.hexPointsConIntAddr=self.extractAddressIntFromVtkObject(self.hexPointsCon)

        # ***************************************************************************    
        self.hexCellsCon=vtk.vtkCellArray()
        self.hexCellsConIntAddr=self.extractAddressIntFromVtkObject(self.hexCellsCon)
        self.hexCellsConPolyData=vtk.vtkPolyData()
        
        # *************************************************************************** 
        fillSuccessful=self.parentWidget.fieldExtractor.fillScalarFieldCellLevelData2DHex(self.conArrayIntAddr,self.hexCellsConIntAddr,self.hexPointsConIntAddr,conFieldName,self.currentDrawingParameters.plane, self.currentDrawingParameters.planePos)             
        
        if not fillSuccessful:
            return
       
        range=self.conArray.GetRange()
        self.minCon=range[0]
        self.maxCon=range[1]
        dim_0=self.dim[0]+1
        dim_1=self.dim[1]+1
        
        if Configuration.getColorMapPlot("MinConcentrationFixed"):
            self.minCon=Configuration.getColorMapPlot("MinConcentration")            
            self.clut.SetTableValue(0,[0,0,0,1])
        else:
            self.clut.SetTableValue(0,self.lowTableValue)
                        
        if Configuration.getColorMapPlot("MaxConcentrationFixed"):
            self.maxCon=Configuration.getColorMapPlot("MaxConcentration")
            self.clut.SetTableValue(self.numberOfTableColors-1,[0,0,0,1])
        else:
            self.clut.SetTableValue(self.numberOfTableColors-1,self.highTableValue)
            
        if Configuration.getColorMapPlot("ContoursOn"):
            contourActor=_actors[1]
            self.initializeContoursHex([self.dim[0], self.dim[1]],self.conArray,[self.minCon, self.maxCon],contourActor)        
        
        self.hexCellsConPolyData.GetCellData().SetScalars(self.conArray)
        self.hexCellsConPolyData.SetPoints(self.hexPointsCon)
        self.hexCellsConPolyData.SetPolys(self.hexCellsCon)
		
        self.hexConMapper.SetInput(self.hexCellsConPolyData)
        self.hexConMapper.ScalarVisibilityOn()
        self.hexConMapper.SetLookupTable(self.clut)
        self.hexConMapper.SetScalarRange(self.minCon, self.maxCon)
        
        _actors[0].SetMapper(self.hexConMapper)
        
    def initScalarFieldHexActors(self,_actors):
        # cellField  = sim.getPotts().getCellFieldG()
        # conField   = CompuCell.getConcentrationField(sim, fieldType[0]) 
        conFieldName=self.currentDrawingParameters.fieldName       
        
        # # # print "drawing plane ",self.plane," planePos=",self.planePos
        fieldDim = self.currentDrawingParameters.bsd.fieldDim
        dimOrder    = self.dimOrder(self.currentDrawingParameters.plane)
        self.dim = self.planeMapper(dimOrder, (fieldDim.x, fieldDim.y, fieldDim.z))# [fieldDim.x, fieldDim.y, fieldDim.z]         
            
        self.conArray = vtk.vtkDoubleArray()
        self.conArray.SetName("concentration")
        self.conArrayIntAddr=self.extractAddressIntFromVtkObject(self.conArray)
        self.hexPointsCon = vtk.vtkPoints()
        # self.hexPoints.SetName("hexpoints")
        self.hexPointsConIntAddr=self.extractAddressIntFromVtkObject(self.hexPointsCon)
        
        # ***************************************************************************    
        self.hexCellsCon=vtk.vtkCellArray()
		
        self.hexCellsConIntAddr=self.extractAddressIntFromVtkObject(self.hexCellsCon)
		
        self.hexCellsConPolyData=vtk.vtkPolyData()
        
        # *************************************************************************** 
        fillSuccessful=self.parentWidget.fieldExtractor.fillScalarFieldData2DHex(self.conArrayIntAddr,self.hexCellsConIntAddr,self.hexPointsConIntAddr,conFieldName,self.currentDrawingParameters.plane, self.currentDrawingParameters.planePos)             
        
        if not fillSuccessful:
            return

        range=self.conArray.GetRange()
        self.minCon=range[0]
        self.maxCon=range[1]
        dim_0=self.dim[0]+1
        dim_1=self.dim[1]+1
        
        if Configuration.getColorMapPlot("MinConcentrationFixed"):
            self.minCon=Configuration.getColorMapPlot("MinConcentration")            
            self.clut.SetTableValue(0,[0,0,0,1])
        else:
            self.clut.SetTableValue(0,self.lowTableValue)
                        
        if Configuration.getColorMapPlot("MaxConcentrationFixed"):
            self.maxCon=Configuration.getColorMapPlot("MaxConcentration")
            self.clut.SetTableValue(self.numberOfTableColors-1,[0,0,0,1])
        else:
            self.clut.SetTableValue(self.numberOfTableColors-1,self.highTableValue)
        
        if Configuration.getColorMapPlot("ContoursOn"):
            contourActor=_actors[1]
            self.initializeContoursHex([self.dim[0], self.dim[1]],self.conArray,[self.minCon, self.maxCon],contourActor)        
            

        self.hexCellsConPolyData.GetCellData().SetScalars(self.conArray)
        self.hexCellsConPolyData.SetPoints(self.hexPointsCon)
        self.hexCellsConPolyData.SetPolys(self.hexCellsCon)
		
        self.hexConMapper.SetInput(self.hexCellsConPolyData)
        self.hexConMapper.ScalarVisibilityOn()
        self.hexConMapper.SetLookupTable(self.clut)
        self.hexConMapper.SetScalarRange(self.minCon, self.maxCon)
        
        _actors[0].SetMapper(self.hexConMapper)        
            
    def drawConField(self, sim, fieldType):
        if self.parentWidget.latticeType==Configuration.LATTICE_TYPES["Hexagonal"] and self.plane=="XY": # drawing in other planes will be done on a rectangular lattice
            self.drawConFieldHex(sim,fieldType)
            return
            
        fillScalarField = getattr(self.parentWidget.fieldExtractor, "fillConFieldData2D") # this is simply a "pointer" to function       
        self.drawScalarFieldData(sim,fieldType,fillScalarField)
        
    def drawScalarFieldCellLevel(self, sim, fieldType):
        if self.parentWidget.latticeType==Configuration.LATTICE_TYPES["Hexagonal"] and self.plane=="XY": # drawing in other planes will be done on a rectangular lattice
            self.drawScalarFieldCellLevelHex(sim,fieldType)
            return    
        fillScalarField = getattr(self.parentWidget.fieldExtractor, "fillScalarFieldCellLevelData2D") # this is simply a "pointer" to function        
        self.drawScalarFieldData(sim,fieldType,fillScalarField)
        
    def drawScalarField(self, sim, fieldType):
        if self.parentWidget.latticeType==Configuration.LATTICE_TYPES["Hexagonal"] and self.plane=="XY": # drawing in other planes will be done on a rectangular lattice
            self.drawScalarFieldHex(sim,fieldType)
            return        
        fillScalarField = getattr(self.parentWidget.fieldExtractor, "fillScalarFieldData2D") # this is simply a "pointer" to function        
        self.drawScalarFieldData(sim,fieldType,fillScalarField)
    
    def initScalarFieldActors(self, _fillScalarField,_actors):
        import CompuCell
        # potts      = sim.getPotts()
        # cellField  = potts.getCellFieldG()
        # fieldDim   = cellField.getDim()
        # conField   = CompuCell.getConcentrationField(sim, fieldType[0]) 
        # conFieldName=fieldType[0]
        
        
        #print self._statusBar.currentMessage() 
        fieldDim=self.currentDrawingParameters.bsd.fieldDim
        conFieldName=self.currentDrawingParameters.fieldName
        # conFieldName=fieldType[0]
        
        self.dim    = [fieldDim.x, fieldDim.y, fieldDim.z]
        field       = vtk.vtkImageDataGeometryFilter()
        contour     = vtk.vtkContourFilter()
        
        # Leave it for testing
        assert self.currentDrawingParameters.plane in ("XY", "XZ", "YZ"), "Plane is not XY, XZ or YZ"


        # fieldDim = cellField.getDim()
        dimOrder    = self.dimOrder(self.plane)
        self.dim = self.planeMapper(dimOrder, (fieldDim.x, fieldDim.y, fieldDim.z))# [fieldDim.x, fieldDim.y, fieldDim.z] 

        self.conArray = vtk.vtkDoubleArray()
        self.conArray.SetName("concentration")
        self.conArrayIntAddr=self.extractAddressIntFromVtkObject(self.conArray)
        fillSuccessful=_fillScalarField(self.conArrayIntAddr,conFieldName,self.currentDrawingParameters.plane, self.currentDrawingParameters.planePos)
        if not fillSuccessful:
            return

        range=self.conArray.GetRange()
        self.minCon=range[0]
        self.maxCon=range[1]
                      
        if Configuration.getColorMapPlot("MinConcentrationFixed"):
            self.minCon=Configuration.getColorMapPlot("MinConcentration")            
            self.clut.SetTableValue(0,[0,0,0,1])
        else:
            self.clut.SetTableValue(0,self.lowTableValue)
                        
        if Configuration.getColorMapPlot("MaxConcentrationFixed"):
            self.maxCon=Configuration.getColorMapPlot("MaxConcentration")
            self.clut.SetTableValue(self.numberOfTableColors-1,[0,0,0,1])
        else:
            self.clut.SetTableValue(self.numberOfTableColors-1,self.highTableValue)

        ####################
        # field       = vtk.vtkImageDataGeometryFilter()
        # contour     = vtk.vtkContourFilter()
        # conFieldName=self.currentDrawingParameters.fieldName       
        
        # # # # print "drawing plane ",self.plane," planePos=",self.planePos
        # fieldDim = self.currentDrawingParameters.bsd.fieldDim
        # dimOrder    = self.dimOrder(self.currentDrawingParameters.plane)
        # self.dim = self.planeMapper(dimOrder, (fieldDim.x, fieldDim.y, fieldDim.z))# [fieldDim.x, fieldDim.y, fieldDim.z]         
            
        # self.conArray = vtk.vtkDoubleArray()
        # self.conArray.SetName("concentration")
        # self.conArrayIntAddr=self.extractAddressIntFromVtkObject(self.conArray)
        # self.hexPointsCon = vtk.vtkPoints()
        # # self.hexPoints.SetName("hexpoints")
        # self.hexPointsConIntAddr=self.extractAddressIntFromVtkObject(self.hexPointsCon)
        
        # # ***************************************************************************    
        # self.hexCellsCon=vtk.vtkCellArray()
		
        # self.hexCellsConIntAddr=self.extractAddressIntFromVtkObject(self.hexCellsCon)
		
        # self.hexCellsConPolyData=vtk.vtkPolyData()


            
        # fillSuccessful=self.parentWidget.fieldExtractor.fillScalarFieldData2DHex(self.conArrayIntAddr,self.hexCellsConIntAddr,self.hexPointsConIntAddr,conFieldName,self.currentDrawingParameters.plane, self.currentDrawingParameters.planePos)                     
        
        # range=self.conArray.GetRange()
        # self.minCon=range[0]
        # self.maxCon=range[1]
        
        
        
        # if Configuration.getColorMapPlot("MinConcentrationFixed"):
            # self.minCon=Configuration.getColorMapPlot("MinConcentration")
            
        # if Configuration.getColorMapPlot("MaxConcentrationFixed"):
            # self.maxCon=Configuration.getColorMapPlot("MaxConcentration")        
        #####################    
        # if Configuration.getColorMapPlot("ContoursOn"):
            # contourActor=_actors[1]
            
            # plane = vtk.vtkPlaneSource() #note center of the plane is at 0,0,0 so we need to moe it to the center of the lattice by either 
                                         # # setting the origin or translating it
            # plane.SetResolution(self.dim[0], self.dim[1])
            # transP1 = vtk.vtkTransform()
            # transP1.Translate(self.dim[0]/2, self.dim[1]/2,0)
            # transP1.Scale(self.dim[0], self.dim[1], 1)
            
            # tpd1 = vtk.vtkTransformPolyDataFilter()
            # tpd1.SetInputConnection(plane.GetOutputPort())
            # tpd1.SetTransform(transP1)
            
            # appendF = vtk.vtkAppendPolyData()
            # appendF.AddInput(tpd1.GetOutput())
        
            # plane2DScalarFieldStructuredPoints=vtk.vtkStructuredPoints()
            # plane2DScalarFieldStructuredPoints.SetDimensions(self.dim[0], self.dim[1],1)
            # plane2DScalarFieldStructuredPoints.GetPointData().AddArray(self.conArray)
            
        
            # probe = vtk.vtkProbeFilter()
            # probe.SetInputConnection(appendF.GetOutputPort())                    
            # probe.SetSource(plane2DScalarFieldStructuredPoints)
            
            # self.contourMapper.SetInputConnection(probe.GetOutputPort())
            
            # self.contourMapper.SetScalarRange([self.minCon,self.maxCon])           
            # contourActor.SetMapper(self.contourMapper)
            
        
        dim_0=self.dim[0]+1
        dim_1=self.dim[1]+1
        
        
        # self.fillCellFieldData(cellField,self.plane, self.planePos)
        # (self.minCon, self.maxCon,dim_0,dim_1) = self.fillConFieldData( cellField, conField, self.plane, self.planePos)
        
        # self.initializeContours([dim_0, dim_1],self.conArray,[self.minCon, self.maxCon],[_actors[1]])
        
        data = vtk.vtkImageData()
        data.SetDimensions(dim_0, dim_1, 1)
        # print "dim_0,dim_1",(dim_0,dim_1)
        data.SetScalarTypeToUnsignedChar()      
        data.GetPointData().SetScalars(self.conArray)
        field.SetExtent(0, dim_0, 0, dim_1, 0, 0)
        field.SetInput(data)
        
        if Configuration.getColorMapPlot("ContoursOn"):
            contourActor=_actors[1]
            contourActor.SetMapper(self.contourMapper)
            contour.SetInputConnection(field.GetOutputPort())
            contour.GenerateValues(Configuration.getColorMapPlot("NumberOfContourLines"), [self.minCon, self.maxCon])
            self.contourMapper.SetInputConnection(contour.GetOutputPort())
            self.contourMapper.SetLookupTable(self.ctlut)
            self.contourMapper.SetScalarRange(self.minCon, self.maxCon) 
        
        self.conMapper.SetInputConnection(field.GetOutputPort()) # port index = 0
        self.conMapper.ScalarVisibilityOn()
        self.conMapper.SetLookupTable(self.clut)
        self.conMapper.SetScalarRange(self.minCon, self.maxCon) #0, self.clut.GetNumberOfColors()) # may manually set range so that type reassignment will not be scalled dynamically when one type is missing
        self.conMapper.SetScalarModeToUsePointData()
        _actors[0].SetMapper(self.conMapper)
        
    def drawVectorField(self, bsd, fieldType):
        if self.parentWidget.latticeType==Configuration.LATTICE_TYPES["Hexagonal"] and self.plane=="XY": # drawing in other planes will be done on a rectangular lattice
            self.drawVectorFieldDataHex(bsd,fieldType)
            return            
        fillVectorField = getattr(self.parentWidget.fieldExtractor, "fillVectorFieldData2D") # this is simply a "pointer" to function self.parentWidget.fieldExtractor.fillVectorFieldData2D        
        self.drawVectorFieldData(bsd,fieldType,fillVectorField)
        
    def drawVectorFieldCellLevel(self, bsd, fieldType):        
        if self.parentWidget.latticeType==Configuration.LATTICE_TYPES["Hexagonal"] and self.plane=="XY": # drawing in other planes will be done on a rectangular lattice
            self.drawVectorFieldCellLevelDataHex(bsd,fieldType)
            return            
        fillVectorField = getattr(self.parentWidget.fieldExtractor, "fillVectorFieldCellLevelData2D") # this is simply a "pointer" to function self.parentWidget.fieldExtractor.fillVectorFieldData2D        
        self.drawVectorFieldData(bsd,fieldType,fillVectorField)

    def initVectorFieldDataHexActors(self,_actors):        
        # # # print "INSIDE drawVectorFieldDataHex"
        # potts      = sim.getPotts()
        # cellField  = potts.getCellFieldG()
        fieldDim   = self.currentDrawingParameters.bsd.fieldDim
        
        fieldName=self.currentDrawingParameters.fieldName
        
        
        #print self._statusBar.currentMessage() 
        self.dim    = [fieldDim.x, fieldDim.y, fieldDim.z]

        assert self.currentDrawingParameters.plane in ("XY", "XZ", "YZ"), "Plane is not XY, XZ or YZ"


        # fieldDim = cellField.getDim()
        dimOrder    = self.dimOrder(self.currentDrawingParameters.plane)
        self.dim = self.planeMapper(dimOrder, (fieldDim.x, fieldDim.y, fieldDim.z))# [fieldDim.x, fieldDim.y, fieldDim.z] 

        dim_0=self.dim[0]+1
        dim_1=self.dim[1]+1
        
        
        vectorGrid=vtk.vtkUnstructuredGrid()

        points=vtk.vtkPoints()
        vectors=vtk.vtkFloatArray()
        vectors.SetNumberOfComponents(3)
        vectors.SetName("visVectors")

        pointsIntAddr=self.extractAddressIntFromVtkObject(points)
        vectorsIntAddr=self.extractAddressIntFromVtkObject(vectors)
        
        fillSuccessful=self.parentWidget.fieldExtractor.fillVectorFieldData2DHex(pointsIntAddr,vectorsIntAddr,fieldName,self.currentDrawingParameters.plane, self.currentDrawingParameters.planePos)
        if not fillSuccessful:
            return
        
        vectorGrid.SetPoints(points)
        vectorGrid.GetPointData().SetVectors(vectors)

        cone=vtk.vtkConeSource()
        cone.SetResolution(5)
        cone.SetHeight(2)
        cone.SetRadius(0.5)
        #cone.SetRadius(4)

        range=vectors.GetRange(-1)
        
        self.minMagnitude=range[0]
        self.maxMagnitude=range[1]
        
        
        if Configuration.getVectorField("MinMagnitudeFixed"):
            self.minMagnitude=Configuration.getVectorField("MinMagnitude")
            self.clut.SetTableValue(0,[0,0,0,1])
        else:
            self.clut.SetTableValue(0,self.lowTableValue)
            
        if Configuration.getVectorField("MaxMagnitudeFixed"):
            self.maxMagnitude=Configuration.getVectorField("MaxMagnitude")
            self.clut.SetTableValue(self.numberOfTableColors-1,[0,0,0,1])
        else:
            self.clut.SetTableValue(self.numberOfTableColors-1,self.highTableValue)
        
        

        glyphs=vtk.vtkGlyph3D()

        glyphs.SetInput(vectorGrid)
        glyphs.SetSourceConnection(cone.GetOutputPort())
        #glyphs.SetScaleModeToScaleByVector()        
        # glyphs.SetColorModeToColorByVector()
        # glyphs.SetScaleFactor(Configuration.getVectorField("ArrowLength")) # scaling arrows here ArrowLength indicates scaling factor not actual length
        
        arrowScalingFactor=Configuration.getVectorField("ArrowLength") # sscaling factor for and arrow  -  ArrowLength indicates scaling factor not actual length
        
        if Configuration.getVectorField("FixedArrowColorFlag"):
            glyphs.SetScaleModeToScaleByVector()
            rangeSpan=self.maxMagnitude-self.minMagnitude
            dataScalingFactor=max(abs(self.minMagnitude),abs(self.maxMagnitude))
            print "self.minMagnitude=",self.minMagnitude," self.maxMagnitude=",self.maxMagnitude
            
            if dataScalingFactor==0.0:
                dataScalingFactor=1.0 # in this case we are plotting 0 vectors and in this case data scaling factor will be set to 1
            glyphs.SetScaleFactor(arrowScalingFactor/dataScalingFactor)
            #coloring arrows
            
            arrowColor=Configuration.getVectorField("ArrowColor")
            r = arrowColor.red()
            g = arrowColor.green()
            b = arrowColor.blue()
            _actors[0].GetProperty().SetColor(self.toVTKColor(r), self.toVTKColor(g), self.toVTKColor(b))        
        else:
            if Configuration.getVectorField("ScaleArrows"):
                glyphs.SetColorModeToColorByVector()
                glyphs.SetScaleModeToScaleByVector()    
                
                rangeSpan=self.maxMagnitude-self.minMagnitude
                dataScalingFactor=max(abs(self.minMagnitude),abs(self.maxMagnitude))
                print "self.minMagnitude=",self.minMagnitude," self.maxMagnitude=",self.maxMagnitude
                
                if dataScalingFactor==0.0:
                    dataScalingFactor=1.0 # in this case we are plotting 0 vectors and in this case data scaling factor will be set to 1
                glyphs.SetScaleFactor(arrowScalingFactor/dataScalingFactor)
                
            else:
                glyphs.SetColorModeToColorByVector()
                glyphs.SetScaleFactor(arrowScalingFactor)         
        
        self.glyphsMapper.SetInputConnection(glyphs.GetOutputPort())
        self.glyphsMapper.SetLookupTable(self.clut)
        
        # # # print "range=",range
        # # # print "vectors.GetNumberOfTuples()=",vectors.GetNumberOfTuples()    
        # self.glyphsMapper.SetScalarRange(vectors.GetRange(-1)) # this will return the range of magnitudes of all the vectors store int vtkFloatArray
        # self.glyphsMapper.SetScalarRange(range)
        self.glyphsMapper.SetScalarRange([self.minMagnitude,self.maxMagnitude])
        
        _actors[0].SetMapper(self.glyphsMapper)

        
    def initVectorFieldCellLevelDataHexActors(self,_actors):        
        # # # print "INSIDE drawVectorFieldDataHex"
        # potts      = sim.getPotts()
        # cellField  = potts.getCellFieldG()
        fieldDim   = self.currentDrawingParameters.bsd.fieldDim
        
        fieldName=self.currentDrawingParameters.fieldName
        
        
        #print self._statusBar.currentMessage() 
        self.dim    = [fieldDim.x, fieldDim.y, fieldDim.z]

        assert self.currentDrawingParameters.plane in ("XY", "XZ", "YZ"), "Plane is not XY, XZ or YZ"


        # fieldDim = cellField.getDim()
        dimOrder    = self.dimOrder(self.currentDrawingParameters.plane)
        self.dim = self.planeMapper(dimOrder, (fieldDim.x, fieldDim.y, fieldDim.z))# [fieldDim.x, fieldDim.y, fieldDim.z] 

        dim_0=self.dim[0]+1
        dim_1=self.dim[1]+1
        
        vectorGrid=vtk.vtkUnstructuredGrid()

        points=vtk.vtkPoints()
        vectors=vtk.vtkFloatArray()
        vectors.SetNumberOfComponents(3)
        vectors.SetName("visVectors")

        pointsIntAddr=self.extractAddressIntFromVtkObject(points)
        vectorsIntAddr=self.extractAddressIntFromVtkObject(vectors)
        
        fillSuccessful=self.parentWidget.fieldExtractor.fillVectorFieldCellLevelData2DHex(pointsIntAddr,vectorsIntAddr,fieldName,self.currentDrawingParameters.plane, self.currentDrawingParameters.planePos)
        if not fillSuccessful:
            return

        vectorGrid.SetPoints(points)
        vectorGrid.GetPointData().SetVectors(vectors)

        cone=vtk.vtkConeSource()
        cone.SetResolution(5)
        cone.SetHeight(2)
        cone.SetRadius(0.5)
        #cone.SetRadius(4)

        range=vectors.GetRange(-1)
        
        self.minMagnitude=range[0]
        self.maxMagnitude=range[1]        
        
        if Configuration.getVectorField("MinMagnitudeFixed"):
            self.minMagnitude=Configuration.getVectorField("MinMagnitude")
            self.clut.SetTableValue(0,[0,0,0,1])
        else:
            self.clut.SetTableValue(0,self.lowTableValue)
            
        if Configuration.getVectorField("MaxMagnitudeFixed"):
            self.maxMagnitude=Configuration.getVectorField("MaxMagnitude")
            self.clut.SetTableValue(self.numberOfTableColors-1,[0,0,0,1])
        else:
            self.clut.SetTableValue(self.numberOfTableColors-1,self.highTableValue)
        
        glyphs=vtk.vtkGlyph3D()

        glyphs.SetInput(vectorGrid)
        glyphs.SetSourceConnection(cone.GetOutputPort())
        #glyphs.SetScaleModeToScaleByVector()
        # glyphs.SetColorModeToColorByVector()
        # glyphs.SetScaleFactor(Configuration.getVectorField("ArrowLength")) # scaling arrows here ArrowLength indicates scaling factor not actual length
        
        arrowScalingFactor=Configuration.getVectorField("ArrowLength") # sscaling factor for and arrow  -  ArrowLength indicates scaling factor not actual length
        
        if Configuration.getVectorField("FixedArrowColorFlag"):
            glyphs.SetScaleModeToScaleByVector()
            rangeSpan=self.maxMagnitude-self.minMagnitude
            dataScalingFactor=max(abs(self.minMagnitude),abs(self.maxMagnitude))
            print "self.minMagnitude=",self.minMagnitude," self.maxMagnitude=",self.maxMagnitude
            
            if dataScalingFactor==0.0:
                dataScalingFactor=1.0 # in this case we are plotting 0 vectors and in this case data scaling factor will be set to 1
            glyphs.SetScaleFactor(arrowScalingFactor/dataScalingFactor)
            #coloring arrows
            
            arrowColor=Configuration.getVectorField("ArrowColor")
            r = arrowColor.red()
            g = arrowColor.green()
            b = arrowColor.blue()
            _actors[0].GetProperty().SetColor(self.toVTKColor(r), self.toVTKColor(g), self.toVTKColor(b))        
        else:
            if Configuration.getVectorField("ScaleArrows"):
                glyphs.SetColorModeToColorByVector()
                glyphs.SetScaleModeToScaleByVector()    
                
                rangeSpan=self.maxMagnitude-self.minMagnitude
                dataScalingFactor=max(abs(self.minMagnitude),abs(self.maxMagnitude))
                print "self.minMagnitude=",self.minMagnitude," self.maxMagnitude=",self.maxMagnitude
                
                if dataScalingFactor==0.0:
                    dataScalingFactor=1.0 # in this case we are plotting 0 vectors and in this case data scaling factor will be set to 1
                glyphs.SetScaleFactor(arrowScalingFactor/dataScalingFactor)
                
            else:
                glyphs.SetColorModeToColorByVector()
                glyphs.SetScaleFactor(arrowScalingFactor)        
        
        
        self.glyphsMapper.SetInputConnection(glyphs.GetOutputPort())
        self.glyphsMapper.SetLookupTable(self.clut)
        
        # # # print "range=",range
        # # # print "vectors.GetNumberOfTuples()=",vectors.GetNumberOfTuples()    
        # self.glyphsMapper.SetScalarRange(vectors.GetRange(-1)) # this will return the range of magnitudes of all the vectors store int vtkFloatArray
        # self.glyphsMapper.SetScalarRange(range)
        self.glyphsMapper.SetScalarRange([self.minMagnitude,self.maxMagnitude])
        
        _actors[0].SetMapper(self.glyphsMapper)

    def initVectorFieldCellLevelActors(self, _fillVectorFieldFcn, _actors):   
        # potts      = sim.getPotts()
        # cellField  = potts.getCellFieldG()
        # fieldDim   = cellField.getDim()
        
        fieldDim=self.currentDrawingParameters.bsd.fieldDim
        fieldName=self.currentDrawingParameters.fieldName
        
        #print self._statusBar.currentMessage() 
        self.dim    = [fieldDim.x, fieldDim.y, fieldDim.z]

        assert self.plane in ("XY", "XZ", "YZ"), "Plane is not XY, XZ or YZ"


        # fieldDim = cellField.getDim()
        dimOrder    = self.dimOrder(self.plane)
        self.dim = self.planeMapper(dimOrder, (fieldDim.x, fieldDim.y, fieldDim.z))# [fieldDim.x, fieldDim.y, fieldDim.z] 

        dim_0=self.dim[0]+1
        dim_1=self.dim[1]+1
        
        vectorGrid=vtk.vtkUnstructuredGrid()

        points=vtk.vtkPoints()
        vectors=vtk.vtkFloatArray()
        vectors.SetNumberOfComponents(3)
        vectors.SetName("visVectors")

        pointsIntAddr=self.extractAddressIntFromVtkObject(points)
        vectorsIntAddr=self.extractAddressIntFromVtkObject(vectors)
        
        fillSuccessful=_fillVectorFieldFcn(pointsIntAddr,vectorsIntAddr,fieldName,self.currentDrawingParameters.plane, self.currentDrawingParameters.planePos)
        if not fillSuccessful:
            return

        vectorGrid.SetPoints(points)
        vectorGrid.GetPointData().SetVectors(vectors)

        cone=vtk.vtkConeSource()
        cone.SetResolution(5)
        cone.SetHeight(2)
        cone.SetRadius(0.5)
        #cone.SetRadius(4)

        range=vectors.GetRange(-1)
        
        self.minMagnitude=range[0]
        self.maxMagnitude=range[1]
        
        if Configuration.getVectorField("MinMagnitudeFixed"):
            self.minMagnitude=Configuration.getVectorField("MinMagnitude")
            self.clut.SetTableValue(0,[0,0,0,1])
        else:
            self.clut.SetTableValue(0,self.lowTableValue)
            
        if Configuration.getVectorField("MaxMagnitudeFixed"):
            self.maxMagnitude=Configuration.getVectorField("MaxMagnitude")
            self.clut.SetTableValue(self.numberOfTableColors-1,[0,0,0,1])
        else:
            self.clut.SetTableValue(self.numberOfTableColors-1,self.highTableValue)

        glyphs=vtk.vtkGlyph3D()

        glyphs.SetInput(vectorGrid)
        glyphs.SetSourceConnection(cone.GetOutputPort())
        #glyphs.SetScaleModeToScaleByVector()
        # glyphs.SetColorModeToColorByVector()

        # print "glyphs.GetScaleFactor()=",glyphs.GetScaleFactor()
        # print "glyphs.GetScaleFactor()=",
        arrowScalingFactor=Configuration.getVectorField("ArrowLength") # sscaling factor for and arrow  -  ArrowLength indicates scaling factor not actual length
        
        if Configuration.getVectorField("FixedArrowColorFlag"):
            glyphs.SetScaleModeToScaleByVector()
            rangeSpan=self.maxMagnitude-self.minMagnitude
            dataScalingFactor=max(abs(self.minMagnitude),abs(self.maxMagnitude))
            print "self.minMagnitude=",self.minMagnitude," self.maxMagnitude=",self.maxMagnitude
            
            if dataScalingFactor==0.0:
                dataScalingFactor=1.0 # in this case we are plotting 0 vectors and in this case data scaling factor will be set to 1
            glyphs.SetScaleFactor(arrowScalingFactor/dataScalingFactor)
            #coloring arrows
            
            arrowColor=Configuration.getVectorField("ArrowColor")
            r = arrowColor.red()
            g = arrowColor.green()
            b = arrowColor.blue()
            _actors[0].GetProperty().SetColor(self.toVTKColor(r), self.toVTKColor(g), self.toVTKColor(b))        
        else:
            if Configuration.getVectorField("ScaleArrows"):
                glyphs.SetColorModeToColorByVector()
                glyphs.SetScaleModeToScaleByVector()    
                
                rangeSpan=self.maxMagnitude-self.minMagnitude
                dataScalingFactor=max(abs(self.minMagnitude),abs(self.maxMagnitude))
                print "self.minMagnitude=",self.minMagnitude," self.maxMagnitude=",self.maxMagnitude
                
                if dataScalingFactor==0.0:
                    dataScalingFactor=1.0 # in this case we are plotting 0 vectors and in this case data scaling factor will be set to 1
                glyphs.SetScaleFactor(arrowScalingFactor/dataScalingFactor)
                
            else:
                glyphs.SetColorModeToColorByVector()
                glyphs.SetScaleFactor(arrowScalingFactor) 
        
        self.glyphsMapper.SetInputConnection(glyphs.GetOutputPort())
        self.glyphsMapper.SetLookupTable(self.clut)

        
        # # # print "range=",range
        # # # print "vectors.GetNumberOfTuples()=",vectors.GetNumberOfTuples()    
        # self.glyphsMapper.SetScalarRange(vectors.GetRange(-1)) # this will return the range of magnitudes of all the vectors store int vtkFloatArray
        # self.glyphsMapper.SetScalarRange(range)
        self.glyphsMapper.SetScalarRange([self.minMagnitude,self.maxMagnitude])
        
        _actors[0].SetMapper(self.glyphsMapper)
        
    # Optimize code?
    def dimOrder(self, plane):
        plane=string.lower(plane)
        order = (0, 1, 2)
        if plane == "xy":
            order = (0, 1, 2)
        elif plane == "xz":
            order = (0, 2, 1)
        elif plane == "yz": 
            order = (1, 2, 0)
            
        return order

    # Optimize code?
    def pointOrder(self, plane):
        plane=string.lower(plane)
        order = (0, 1, 2)
        if plane == "xy":
            order = (0, 1, 2)
        elif plane == "xz":
            order = (0, 2, 1)
        elif plane == "yz": 
            order = (2, 0, 1)
            
        return order

    def planeMapper(self, order, tuple):
        return [tuple[order[0]], tuple[order[1]], tuple[order[2]]]

    # ?
    def drawContourLines(self): 
        pass        
        
    def wheelEvent(self, ev):        
        self.__zoomStep(ev.delta())
    
    # Overrides the mousePressEvent() method from QVTKRenderWidget
    def mousePressEvent(self,ev):
        if (ev.button() == 1):
            self._Mode = "Pan"
            self._ActiveButton = ev.button()
            #self.PickActor(ev.x(), ev.y())
            #print self.GetPicker()
            #self.showTip(ev.x(), ev.y())
            
        elif (ev.button() == 2):
            self._Mode = "Zoom"
            self._ActiveButton = ev.button()

        self.UpdateRenderer(ev.x(),ev.y())

    def event(self, ev):
        if ev.type() == QEvent.ToolTip:
            self.showTip(ev)
        return QWidget.event(self, ev)

    def showTip(self, ev):
        # toll tips are not enabled in this release
        return
        import CompuCell
        pt = CompuCell.Point3D() 

        self.PickActor(ev.x(), ev.y())
        id = self.GetPicker().GetCellId()
        if id != -1:
            pos = self.GetPicker().GetPickPosition()
            pt.x, pt.y, pt.z = int(pos[0]), int(pos[1]), 0 
            
            if  self.cellField.get(pt) is not None and self.cellField.get(pt).id != 0:
                QToolTip.hideText()
                QToolTip.showText(ev.globalPos(), self.toolTip(self.cellField.get(pt)))
                    
    # Overrides the Zoom() method from QVTKRenderWidget  
    def __zoomStep(self, delta):
        # # # print "ZOOM STEP"
        if self.ren:
            # renderer = self.GetCurrentRenderer()
            camera = self.ren.GetActiveCamera()
            
            zoomFactor = math.pow(1.02,(0.5*(delta/8)))

            # I don't know why I might need the parallel projection
            if camera.GetParallelProjection(): 
                parallelScale = camera.GetParallelScale()/zoomFactor
                camera.SetParallelScale(parallelScale)
            else:
                camera.Dolly(zoomFactor)
                self.ren.ResetCameraClippingRange()

            self.Render()
        

    def zoomIn(self):
        delta = 2*120
        self.__zoomStep(delta)

    def zoomOut(self):
        delta = -2*120
        self.__zoomStep(delta)

    def zoomFixed(self, val):
        if self.ren:
            # renderer = self._CurrentRenderer
            camera = self.ren.GetActiveCamera()
            self.__curDist = camera.GetDistance()
            
            # To zoom fixed, dolly should be set to initial position
            # and then moved to a new specified position!
            if (self.__initDist != 0):
                # You might need to rewrite the fixed zoom in case if there
                # will be flickering
                camera.Dolly(self.__curDist/self.__initDist)

            camera.Dolly(self.zitems[val])
            self.ren.ResetCameraClippingRange()

            self.Render()

        
    def takeShot(self):
        filter = "PNG files (*.png)"
        fileName = QFileDialog.getSaveFileName(\
            self,
            "Save Screenshot",
            os.getcwd(), 
            filter
            )

        # Other way to get the correct file name: fileName.toAscii().data())
        if fileName is not None and fileName != "":
            self.takeSimShot(str(fileName))
    
    # fileName - full file name (e.g. "/home/user/shot.png")        
    def takeSimShot(self, fileName):
        # DON'T REMOVE!
        # Better quality
        # Passes vtkRenderer. Takes actual screenshot of the region withing the widget window
        # If other application are present within this region it will shoot them also

        renderLarge = vtk.vtkRenderLargeImage()
        renderLarge.SetInput(self.graphicsFrameWidget.ren)
        renderLarge.SetMagnification(1)
        
        # We write out the image which causes the rendering to occur. If you
        # watch your screen you might see the pieces being rendered right
        # after one another.
        writer = vtk.vtkPNGWriter()
        writer.SetInputConnection(renderLarge.GetOutputPort())
        # # # print "GOT HERE fileName=",fileName
        writer.SetFileName(fileName)
        
        writer.Write()
            
    def toolTip(self, cellG):
        return "Id:             %s\nType:       %s\nVolume:  %s" % (cellG.id, cellG.type, cellG.volume)

    def configsChanged(self):
        self.populateLookupTable()
        self.setBorderColor()
        # Doesn't work, gives error: 
        # vtkScalarBarActor (0x8854218): Need a mapper to render a scalar bar
        #self.showLegend(Configuration.getColorMapPlot("LegendEnable"))
        self.showContours(Configuration.getColorMapPlot("ContoursOn"))
        
        self.parentWidget.requestRedraw()

    # this function is used during prototyping. in production code it is replaced by C++ counterpart
    def fillCellFieldData(self,_cellFieldG, plane=None, pos=None):
        import CompuCell
        
        pt = CompuCell.Point3D() 
        cell = CompuCell.CellG() 
        fieldDim = _cellFieldG.getDim()
        if plane is None:
            self.dim = [fieldDim.x , fieldDim.y , fieldDim.z]
        else:
            dimOrder    = self.dimOrder(plane)
            pointOrder  = self.pointOrder(plane)
            self.dim        = self.planeMapper(dimOrder, (fieldDim.x, fieldDim.y, fieldDim.z))# [fieldDim.x, fieldDim.y, fieldDim.z]         
            # # # print "pointOrder=",pointOrder
        
        # # # print "FILLCELLFIELDDATA"
        # # # print "self.dim=",self.dim
        offset=0
        if plane is None:
            self.cellType = vtk.vtkIntArray()
            self.cellType.SetName("celltype")
            self.cellType.SetNumberOfValues((self.dim[2]+1)*(self.dim[1]+1)*(self.dim[0]+1))
            
            self.cellId=[[[0 for k in range(self.dim[2])] for j in range(self.dim[1]+1)] for i in range(self.dim[0]+1)]
            
            # For some reasons the points x=0 are eaten up (don't know why).
            # So we just populate empty cellIds.
            for i in range(self.dim[0]+1):
                self.cellType.SetValue(offset, 0)
                offset += 1
                    
            for k in range(self.dim[2]):
                for j in range(self.dim[1]+1):
                    for i in range(self.dim[0]+1):
                        pt.x = i
                        pt.y = j
                        pt.z = k
                        cell = _cellFieldG.get(pt)
                        if cell is not None:
                            type    = int(cell.type)
                            id      = int(cell.id)
                        else:
                            type    = 0
                            id      = 0
                        self.cellType.InsertValue(offset, type)
                        # print "inserting type ",type," offset ",offset
                        
                        offset += 1
                        
                        self.cellId[i][j][k] = id  
        else:
            self.cellType = vtk.vtkIntArray()
            self.cellType.SetName("celltype")
            self.cellType.SetNumberOfValues((self.dim[1]+2)*(self.dim[0]+1))
            
            self.cellId=[[0 for j in range(self.dim[1]+1)] for i in range(self.dim[0]+1)]
            
            # For some reasons the points x=0 are eaten up (don't know why).
            # So we just populate empty cellIds.
            for i in range(self.dim[0]+1):
                self.cellType.SetValue(offset, 0)
                offset += 1
                    
            # for k in range(self.dim[2]):
            for j in range(self.dim[1]+1):
                for i in range(self.dim[0]+1):
                    point = self.planeMapper(pointOrder, (i, j, pos))
                    pt.x = point[0]
                    pt.y = point[1]
                    pt.z = point[2]
                
                    # pt.x = i
                    # pt.y = j
                    # pt.z = k
                    cell = _cellFieldG.get(pt)
                    # print "pt=",pt," cell=",cell
                    if cell is not None:
                        type    = int(cell.type)
                        id      = int(cell.id)
                    else:
                        type    = 0
                        id      = 0
                    self.cellType.InsertValue(offset, type)
                    # print "inserting type ",type," offset ",offset
                    
                    offset += 1
                    
                    self.cellId[i][j] = id 
                    
    #this function is used during prototyping. in production code it is replaced by C++ counterpart   
    def fillConFieldData(self,_cellFieldG,_conField, plane=None, pos=None):
        import CompuCell
        
        pt = CompuCell.Point3D(0,0,0) 
        cell = CompuCell.CellG() 
        fieldDim = _cellFieldG.getDim()

        dimOrder    = self.dimOrder(plane)
        pointOrder  = self.pointOrder(plane)
        self.dim        = self.planeMapper(dimOrder, (fieldDim.x, fieldDim.y, fieldDim.z))# [fieldDim.x, fieldDim.y, fieldDim.z]         
        # # # print "pointOrder=",pointOrder
        
        # # # print "FILL CONFIELDDATA"
        # # # print "self.dim=",self.dim

        self.conArray = vtk.vtkDoubleArray()
        self.conArray.SetName("concentration")
        self.conArray.SetNumberOfValues((self.dim[1]+2)*(self.dim[0]+1))

        offset=0        
        # For some reasons the points x=0 are eaten up (don't know why).
        # So we just populate empty cellIds.
        for i in range(self.dim[0]+1):
            self.conArray.SetValue(offset, 0.0)    
            offset += 1
        
        
        maxCon = float(_conField.get(pt)) # concentration at pt=0,0,0
        minCon = float(_conField.get(pt)) # concentration at pt=0,0,0
            
        # for k in range(self.dim[2]):        
        for j in range(self.dim[1]+1):
            for i in range(self.dim[0]+1):
                point = self.planeMapper(pointOrder, (i, j, pos))
                pt.x = point[0]
                pt.y = point[1]
                pt.z = point[2]
                
                if i==self.dim[0] or j==self.dim[1]:
                    con=0.0
                else:
                    con = float(_conField.get(pt))
                
                self.conArray.SetValue(offset, con)

                if maxCon < con:
                    maxCon = con
                
                if minCon > con:
                    minCon = con
                
                offset += 1
        
        return (minCon, maxCon, self.dim[0]+1,self.dim[1]+1)


    def initBordersActors2D(self,_actors):
        points = vtk.vtkPoints()
        lines = vtk.vtkCellArray()
        pointsIntAddr=self.extractAddressIntFromVtkObject(points)
        linesIntAddr=self.extractAddressIntFromVtkObject(lines)
        
        self.parentWidget.fieldExtractor.fillBorderData2D(pointsIntAddr , linesIntAddr, self.currentDrawingParameters.plane, self.currentDrawingParameters.planePos)
        
        borders = vtk.vtkPolyData()

        borders.SetPoints(points)
        borders.SetLines(lines)
        
        self.borderMapper.SetInput(borders)
        _actors[0].SetMapper(self.borderMapper)
        # self.setBorderColor() 

        # print "self.currentActors.keys()=",self.currentActors.keys()    
        
        # # print "self.currentActors[BorderActor]=",self.currentActors["BorderActor"].GetClassName()
        # if not self.currentActors.has_key("BorderActor"):
            # self.currentActors["BorderActor"]=self.borderActor
            # self.graphicsFrameWidget.ren.AddActor(self.borderActor)
            # print "ADDING BORDER ACTOR"
            
        # else:
            # # will ensure that borders is the last item to draw
            # actorsCollection=self.graphicsFrameWidget.ren.GetActors()
            # if actorsCollection.GetLastItem()!=self.borderActor:
                # self.graphicsFrameWidget.ren.RemoveActor(self.borderActor)
                # self.graphicsFrameWidget.ren.AddActor(self.borderActor) 
        # print "self.currentActors.keys()=",self.currentActors.keys()    
        
    def initBordersActors2DHex(self,_actors):
        
        points = vtk.vtkPoints()    
        lines = vtk.vtkCellArray()  
        pointsIntAddr=self.extractAddressIntFromVtkObject(points)
        linesIntAddr=self.extractAddressIntFromVtkObject(lines)
        
        self.parentWidget.fieldExtractor.fillBorderData2DHex(pointsIntAddr , linesIntAddr, self.currentDrawingParameters.plane, self.currentDrawingParameters.planePos)
        
        borders = vtk.vtkPolyData()

        borders.SetPoints(points)
        borders.SetLines(lines)

        self.borderMapperHex.SetInput(borders)
        _actors[0].SetMapper(self.borderMapperHex)
        # self.setBorderColor() 
        # if not self.currentActors.has_key("BorderActor"):
            # self.currentActors["BorderActor"]=self.borderActor
            # self.graphicsFrameWidget.ren.AddActor(self.borderActor) 
        # else:
            # # will ensure that borders is the last item to draw
            # actorsCollection=self.graphicsFrameWidget.ren.GetActors()
            # if actorsCollection.GetLastItem()!=self.borderActor:
                # self.graphicsFrameWidget.ren.RemoveActor(self.borderActor)
                # self.graphicsFrameWidget.ren.AddActor(self.borderActor)
                
    def initCellGlyphsActor2D(self,cellGlyphActor):
#        print MODULENAME,'  initCellGlyphsActor2D'

        from PySteppables import CellList

        #points = vtk.vtkPoints()
        #lines = vtk.vtkCellArray()
        #pointsIntAddr=self.extractAddressIntFromVtkObject(points)
        #linesIntAddr=self.extractAddressIntFromVtkObject(lines)
        #self.parentWidget.fieldExtractor.fillCentroidData2D(pointsIntAddr , linesIntAddr, self.currentDrawingParameters.plane, self.currentDrawingParameters.planePos)
        
#        self.drawCentroids()   # doing in pure Python
        
        #centroids = vtk.vtkPolyData()
        #centroids.SetPoints(points)
        #centroids.SetLines(lines)
        
        #self.centroidMapper.SetInput(centroids)
        #cellGlyphActor.SetMapper(self.centroidMapper)
        
#    def drawCentroids(self):
        fieldDim=self.currentDrawingParameters.bsd.fieldDim
        cellField = self.currentDrawingParameters.bsd.sim.getPotts().getCellFieldG()
        inventory = self.currentDrawingParameters.bsd.sim.getPotts().getCellInventory()
        #print 'inventory=',type(inventory)  # = <class 'CompuCell.CellInventory'>
        cellList=CellList(inventory)
        centroidPoints = vtk.vtkPoints()
        cellTypes = vtk.vtkIntArray()
        cellTypes.SetName("CellTypes")
        cellVolumes = vtk.vtkIntArray()
        cellVolumes.SetName("CellVolumes")
        for cell in cellList:
          #print 'cell.id=',cell.id  # = 2,3,4,...
          #print 'cell.type=',cell.type
          #print 'cell.volume=',cell.volume
          if cell.volume > 0:
              xmid = float(cell.xCM) / cell.volume
              ymid = float(cell.yCM) / cell.volume
              centroidPoints.InsertNextPoint(xmid,ymid,0.0)
              cellTypes.InsertNextValue(cell.type)
              cellVolumes.InsertNextValue(cell.volume)
#          else:
#              print 'cell.id, .volume=',cell.id,cell.volume

        centroidsPD = vtk.vtkPolyData()
        centroidsPD.SetPoints(centroidPoints)
        centroidsPD.GetPointData().SetScalars(cellTypes)
        centroidsPD.GetPointData().AddArray(cellVolumes)

        centroidGS = vtk.vtkGlyphSource2D()
        centroidGS.SetGlyphTypeToCircle()
        #centroidGS.SetScale(1)
        #gs.FilledOff()
        #gs.CrossOff()

        centroidGlyph = vtk.vtkGlyph3D()
        centroidGlyph.SetInput(centroidsPD)
        centroidGlyph.SetSource(centroidGS.GetOutput())
        centroidGlyph.SetScaleFactor( 0.2 )  # rwh: should this lattice size dependent or cell vol or ?
        #centroidGlyph.SetIndexModeToScalar()
        #centroidGlyph.SetRange(0,2)

        #centroidGlyph.SetScaleModeToDataScalingOff()
        centroidGlyph.SetColorModeToColorByScalar()
        centroidGlyph.SetScaleModeToScaleByScalar()

        centroidGlyph.SetInputArrayToProcess(3,0,0,0,"CellTypes")
        centroidGlyph.SetInputArrayToProcess(0,0,0,0,"CellVolumes")


        self.cellGlyphsMapper.SetInput(centroidGlyph.GetOutput())
        self.cellGlyphsMapper.SetScalarRange(0,2)
        self.cellGlyphsMapper.ScalarVisibilityOn()
        self.cellGlyphsMapper.SetLookupTable(self.clut)
        
        cellGlyphActor.SetMapper(self.cellGlyphsMapper)

    def initFPPLinksActor2D(self,fppActor):
#        print MODULENAME,'  initFPPLinksActor2D'

        from PySteppables import CellList, FocalPointPlasticityDataList, InternalFocalPointPlasticityDataList
        import CompuCell
        
        fppPlugin = CompuCell.getFocalPointPlasticityPlugin()
#        print '    initFPPLinksActor2D:  fppPlugin=',fppPlugin
        if (fppPlugin == 0):
          print '    fppPlugin is null, returning'
          return

        fieldDim=self.currentDrawingParameters.bsd.fieldDim
        cellField = self.currentDrawingParameters.bsd.sim.getPotts().getCellFieldG()
        inventory = self.currentDrawingParameters.bsd.sim.getPotts().getCellInventory()
        #print 'inventory=',type(inventory)  # = <class 'CompuCell.CellInventory'>
        cellList=CellList(inventory)
        
        points = vtk.vtkPoints()
        lines = vtk.vtkCellArray()
#        cellTypes = vtk.vtkIntArray()
#        cellTypes.SetName("CellTypes")
#        cellVolumes = vtk.vtkIntArray()
#        cellVolumes.SetName("CellVolumes")

        # figure out which list we need
        for cell in cellList:
            numList1 = sum(1 for _ in FocalPointPlasticityDataList(fppPlugin, cell))
            numList2 = sum(1 for _ in InternalFocalPointPlasticityDataList(fppPlugin, cell))
#            print MODULENAME,' numList1=',numList1
#            print MODULENAME,' numList2=',numList2
            break
        
        dataList = FocalPointPlasticityDataList
        if numList2 > 0:
            dataList = InternalFocalPointPlasticityDataList
            
        beginPt = 0
        for cell in cellList:
#          print '\n cell (addr) = ',cell
#          print 'cell.id=',cell.id  # = 2,3,4,...
#          print 'cell.type=',cell.type
#          print 'cell.volume=',cell.volume
          vol = cell.volume
          xmid = float(cell.xCM) / vol
          ymid = float(cell.yCM) / vol
#          print MODULENAME,'cell.id=',cell.id,'  x,y (begin)=',xmid,ymid
          points.InsertNextPoint(xmid,ymid,0)
          
          endPt = beginPt + 1

#          for fppd in FocalPointPlasticityDataList(fppPlugin, cell):
#          for fppd in InternalFocalPointPlasticityDataList(fppPlugin, cell):
          for fppd in dataList(fppPlugin, cell):

#            print '   nbrId=',fppd.neighborAddress.id
            vol = fppd.neighborAddress.volume
            xmid=float(fppd.neighborAddress.xCM) / vol
            ymid=float(fppd.neighborAddress.yCM) / vol
#            print '    x,y (end)=',xmid,ymid
            points.InsertNextPoint(xmid,ymid,0)
            
            lines.InsertNextCell(2)  # our line has 2 points
#            print beginPt,' -----> ',endPt
            lines.InsertCellPoint(beginPt)
            lines.InsertCellPoint(endPt)
            endPt += 1
          beginPt = endPt
            

        FPPLinksPD = vtk.vtkPolyData()
        FPPLinksPD.SetPoints(points)
        FPPLinksPD.SetLines(lines)
        
        self.FPPLinksMapper.SetInput(FPPLinksPD)
        
        fppActor.SetMapper(self.FPPLinksMapper)


    #this function is used during prototyping. in production code it is replaced by C++ counterpart   
    def drawBorders(self):
        # Draw borders
        points = vtk.vtkPoints()    
        lines = vtk.vtkCellArray()  
        
        k = 0 # dim[2]-1 -- k = 0 for 2D lattice
        pc = 0 # point counter
        # Add lines for the very bottom edge 

        for i in range(self.dim[0]):
            for j in range(self.dim[1]):
                if (i > 0) and (j < self.dim[1]) and (self.cellId[i][j] != self.cellId[i-1][j]):
                    points.InsertNextPoint(i,j,0)
                    points.InsertNextPoint(i,j+1,0)
                    pc+=2
                    lines.InsertNextCell(2)
                    lines.InsertCellPoint(pc-2)
                    lines.InsertCellPoint(pc-1)
        
                if (j > 0) and (i<self.dim[0]) and (self.cellId[i][j] != self.cellId[i][j-1]):
                    points.InsertNextPoint(i,j,0)
                    points.InsertNextPoint(i+1,j,0)
                    pc+=2
                    lines.InsertNextCell(2)
                    lines.InsertCellPoint(pc-2)
                    lines.InsertCellPoint(pc-1)
        
                if (i < self.dim[0]) and (j < self.dim[1]) and (self.cellId[i][j] != self.cellId[i+1][j]):
                    points.InsertNextPoint(i+1,j,0)
                    points.InsertNextPoint(i+1,j+1,0)
                    pc+=2
                    lines.InsertNextCell(2)
                    lines.InsertCellPoint(pc-2)
                    lines.InsertCellPoint(pc-1)
        
                if (j < self.dim[1]) and (i < self.dim[1]) and (self.cellId[i][j] != self.cellId[i][j+1]):
                    points.InsertNextPoint(i,j+1,0)
                    points.InsertNextPoint(i+1,j+1,0)
                    pc+=2
                    lines.InsertNextCell(2)
                    lines.InsertCellPoint(pc-2)
                    lines.InsertCellPoint(pc-1)
        

        borders = vtk.vtkPolyData()

        borders.SetPoints(points)
        borders.SetLines(lines)
        
        
        self.borderMapper.SetInput(borders)
        self.borderActor.SetMapper(self.borderMapper)
        # self.setBorderColor() 
        self.borderActor.GetProperty().SetColor(1,1,1)
        if not self.currentActors.has_key("BorderActor"):
            self.currentActors["BorderActor"]=self.borderActor
            self.ren.AddActor(self.borderActor) 
        else:
            # will ensure that borders is the last item to draw
            actorsCollection=self.ren.GetActors()
            if actorsCollection.GetLastItem()!=self.borderActor:
                self.ren.RemoveActor(self.borderActor)
                self.ren.AddActor(self.borderActor)                 

    def HexCoordXY(self,x,y,z):
        from math import sqrt
        if(z%2):
            if(y%2):
                return [x , sqrt(3.0)/2.0*(y+2.0/3.0), z*sqrt(6.0)/3.0 ]
            else:
                return [ x+0.5 ,  sqrt(3.0)/2.0*(y+2.0/3.0) , z*sqrt(6.0)/3.0]
  
        else:
            if(y%2):
                return [x , sqrt(3.0)/2.0*y, z*sqrt(6.0)/3.0 ]
            else:
                return [ x+0.5 ,  sqrt(3.0)/2.0*y , z*sqrt(6.0)/3.0]
   
        
    def drawBordersHex(self):
        self.hexVerts=[]
        import math
        sqrt_3_3=math.sqrt(3.0)/3.0
        self.hexVerts.append([0, sqrt_3_3, 0.0])
        self.hexVerts.append([0.5 , 0.5*sqrt_3_3, 0.0])
        self.hexVerts.append([0.5, -0.5*sqrt_3_3, 0.0])
        self.hexVerts.append([0. , -sqrt_3_3, 0.0])
        self.hexVerts.append([-0.5 , -0.5*sqrt_3_3, 0.0])
        self.hexVerts.append([-0.5, 0.5*sqrt_3_3, 0.0])
    
        # Draw borders
        points = vtk.vtkPoints()    
        lines = vtk.vtkCellArray()  
        
        k = 0 # dim[2]-1 -- k = 0 for 2D lattice
        pc = 0 # point counter
        # Add lines for the very bottom edge 

        for i in range(self.dim[0]):
            for j in range(self.dim[1]):
                hexPt=self.HexCoordXY(i,j,0)
                if j%2:
                    if i-1>=0 and self.cellId[i][j] != self.cellId[i-1][j]:
                        points.InsertNextPoint(self.hexVerts[4][0]+hexPt[0],self.hexVerts[4][1]+hexPt[1],0)
                        points.InsertNextPoint(self.hexVerts[5][0]+hexPt[0],self.hexVerts[5][1]+hexPt[1],0)
                        pc+=2
                        lines.InsertNextCell(2)
                        lines.InsertCellPoint(pc-2)
                        lines.InsertCellPoint(pc-1)
                        
                    if i-1>=0 and j+1<self.dim[1] and self.cellId[i][j] != self.cellId[i-1][j+1]:
                        points.InsertNextPoint(self.hexVerts[5][0]+hexPt[0],self.hexVerts[5][1]+hexPt[1],0)
                        points.InsertNextPoint(self.hexVerts[0][0]+hexPt[0],self.hexVerts[0][1]+hexPt[1],0)
                        pc+=2
                        lines.InsertNextCell(2)
                        lines.InsertCellPoint(pc-2)
                        lines.InsertCellPoint(pc-1)
                        
                    if j+1<self.dim[1] and self.cellId[i][j] != self.cellId[i][j+1]:
                        points.InsertNextPoint(self.hexVerts[0][0]+hexPt[0],self.hexVerts[0][1]+hexPt[1],0)
                        points.InsertNextPoint(self.hexVerts[1][0]+hexPt[0],self.hexVerts[1][1]+hexPt[1],0)
                        pc+=2
                        lines.InsertNextCell(2)
                        lines.InsertCellPoint(pc-2)
                        lines.InsertCellPoint(pc-1)          

                    if i+1<self.dim[0] and self.cellId[i][j] != self.cellId[i+1][j]:
                        points.InsertNextPoint(self.hexVerts[1][0]+hexPt[0],self.hexVerts[1][1]+hexPt[1],0)
                        points.InsertNextPoint(self.hexVerts[2][0]+hexPt[0],self.hexVerts[2][1]+hexPt[1],0)
                        pc+=2
                        lines.InsertNextCell(2)
                        lines.InsertCellPoint(pc-2)
                        lines.InsertCellPoint(pc-1) 

                    if j-1>=0 and self.cellId[i][j] != self.cellId[i][j-1]:
                        points.InsertNextPoint(self.hexVerts[2][0]+hexPt[0],self.hexVerts[2][1]+hexPt[1],0)
                        points.InsertNextPoint(self.hexVerts[3][0]+hexPt[0],self.hexVerts[3][1]+hexPt[1],0)
                        pc+=2
                        lines.InsertNextCell(2)
                        lines.InsertCellPoint(pc-2)
                        lines.InsertCellPoint(pc-1)          

                    if i-1>=0 and j-1>= 0 and self.cellId[i][j] != self.cellId[i-1][j-1]:
                        points.InsertNextPoint(self.hexVerts[3][0]+hexPt[0],self.hexVerts[3][1]+hexPt[1],0)
                        points.InsertNextPoint(self.hexVerts[4][0]+hexPt[0],self.hexVerts[4][1]+hexPt[1],0)
                        pc+=2
                        lines.InsertNextCell(2)
                        lines.InsertCellPoint(pc-2)
                        lines.InsertCellPoint(pc-1)                        
                        
                else:
                    if i-1>=0 and self.cellId[i][j] != self.cellId[i-1][j]:
                        points.InsertNextPoint(self.hexVerts[4][0]+hexPt[0],self.hexVerts[4][1]+hexPt[1],0)
                        points.InsertNextPoint(self.hexVerts[5][0]+hexPt[0],self.hexVerts[5][1]+hexPt[1],0)
                        pc+=2
                        lines.InsertNextCell(2)
                        lines.InsertCellPoint(pc-2)
                        lines.InsertCellPoint(pc-1)
                        
                    if j+1<self.dim[1] and self.cellId[i][j] != self.cellId[i][j+1]:
                        points.InsertNextPoint(self.hexVerts[5][0]+hexPt[0],self.hexVerts[5][1]+hexPt[1],0)
                        points.InsertNextPoint(self.hexVerts[0][0]+hexPt[0],self.hexVerts[0][1]+hexPt[1],0)
                        pc+=2
                        lines.InsertNextCell(2)
                        lines.InsertCellPoint(pc-2)
                        lines.InsertCellPoint(pc-1)
                        
                    if i+1<self.dim[0] and j+1<self.dim[1] and self.cellId[i][j] != self.cellId[i+1][j+1]:
                        points.InsertNextPoint(self.hexVerts[0][0]+hexPt[0],self.hexVerts[0][1]+hexPt[1],0)
                        points.InsertNextPoint(self.hexVerts[1][0]+hexPt[0],self.hexVerts[1][1]+hexPt[1],0)
                        pc+=2
                        lines.InsertNextCell(2)
                        lines.InsertCellPoint(pc-2)
                        lines.InsertCellPoint(pc-1)
                        
                    if i+1<self.dim[0] and self.cellId[i][j] != self.cellId[i+1][j]:
                        points.InsertNextPoint(self.hexVerts[1][0]+hexPt[0],self.hexVerts[1][1]+hexPt[1],0)
                        points.InsertNextPoint(self.hexVerts[2][0]+hexPt[0],self.hexVerts[2][1]+hexPt[1],0)
                        pc+=2
                        lines.InsertNextCell(2)
                        lines.InsertCellPoint(pc-2)
                        lines.InsertCellPoint(pc-1)
                    
                    if i+1<self.dim[0] and j-1>= 0 and self.cellId[i][j] != self.cellId[i+1][j-1]:
                        points.InsertNextPoint(self.hexVerts[2][0]+hexPt[0],self.hexVerts[2][1]+hexPt[1],0)
                        points.InsertNextPoint(self.hexVerts[3][0]+hexPt[0],self.hexVerts[3][1]+hexPt[1],0)
                        pc+=2
                        lines.InsertNextCell(2)
                        lines.InsertCellPoint(pc-2)
                        lines.InsertCellPoint(pc-1)
                        
                    if j-1>=0 and self.cellId[i][j] != self.cellId[i][j-1]:
                        points.InsertNextPoint(self.hexVerts[3][0]+hexPt[0],self.hexVerts[3][1]+hexPt[1],0)
                        points.InsertNextPoint(self.hexVerts[4][0]+hexPt[0],self.hexVerts[4][1]+hexPt[1],0)
                        pc+=2
                        lines.InsertNextCell(2)
                        lines.InsertCellPoint(pc-2)
                        lines.InsertCellPoint(pc-1)
                    
        

        borders = vtk.vtkPolyData()

        borders.SetPoints(points)
        borders.SetLines(lines)
        
        self.borderMapperHex.SetInput(borders)
        self.borderActorHex.SetMapper(self.borderMapperHex)
        # self.setBorderColor() 
        self.borderActorHex.GetProperty().SetColor(1,1,1)
        if not self.currentActors.has_key("BorderActorHex"):
            self.currentActors["BorderActorHex"]=self.borderActorHex
            self.ren.AddActor(self.borderActorHex) 
        else:
            # wil ensure that borders is the last item to draw
            actorsCollection=self.ren.GetActors()
            if actorsCollection.GetLastItem()!=self.borderActorHex:
                self.ren.RemoveActor(self.borderActorHex)
                self.ren.AddActor(self.borderActorHex)                 
                
    def initCellFieldActorsData(self,_actors):
        import string
        
        dim=[self.dim[0]+1,self.dim[1]+1,self.dim[2]+1]
        
        uGridConc=vtk.vtkStructuredPoints()
        uGridConc.SetDimensions(dim[0],dim[1],dim[2])
        
        uGridConc.GetPointData().SetScalars(self.cellType)
        
        cellsPlane=vtk.vtkImageDataGeometryFilter()
        cellsPlane.SetExtent(0,dim[0],0,dim[1],0,0)
        cellsPlane.SetInput(uGridConc)
        
        # concMapper=self.cellsMapper

        self.cellsMapper.SetInputConnection(cellsPlane.GetOutputPort())
        self.cellsMapper.ScalarVisibilityOn()

        self.cellsMapper.SetLookupTable(self.lut)
        
        self.cellsMapper.SetScalarRange(0,self.lut.GetNumberOfColors()) # may manually set range so that type reassignment will not be scaled dynamically when one type is missing
        
        # self.cellsActor.SetMapper(self.cellsMapper)
        _actors[0].SetMapper(self.cellsMapper)
        
        imageViewer=vtk.vtkImageViewer2()
        
        # if not self.currentActors.has_key("CellsActor"):
            # self.currentActors["CellsActor"]=self.cellsActor  
            # self.graphicsFrameWidget.ren.AddActor(self.cellsActor) 
            # # print "\n\n\n\n added CELLS ACTOR"
        
        # self.prepareOutlineActor(dim)
        # self.showOutlineActor()
    
    def drawCellFieldHex_old(self, sim, fieldType):
        
        cellField  = sim.getPotts().getCellFieldG()
        
        # # # print "INSIDE drawCellFieldHex"
        # # # print "drawing plane ",self.plane," planePos=",self.planePos
        fieldDim = cellField.getDim()
        dimOrder    = self.dimOrder(self.plane)
        self.dim = self.planeMapper(dimOrder, (fieldDim.x, fieldDim.y, fieldDim.z))# [fieldDim.x, fieldDim.y, fieldDim.z]         
            
        self.cellType = vtk.vtkIntArray()
        self.cellType.SetName("celltype")
        self.cellTypeIntAddr=self.extractAddressIntFromVtkObject(self.cellType)
        self.hexPoints = vtk.vtkPoints()
        # self.hexPoints.SetName("hexpoints")
        self.hexPointsIntAddr=self.extractAddressIntFromVtkObject(self.hexPoints)
        
        self.parentWidget.fieldExtractor.fillCellFieldData2DHex_old(self.cellTypeIntAddr,self.hexPointsIntAddr,self.plane, self.planePos)
        # if self.parentWidget.borderAct.isChecked():
            # self.drawBorders2DHex()    
            # # self.drawBordersHex()  		
        # return
        # Python function used during prototyping
        # self.fillCellFieldData(cellField,self.plane, self.planePos)
        
        hexagonSrc=vtk.vtkRegularPolygonSource()
        from math import sqrt
        hexagonSrc.SetNumberOfSides(6)
        hexagonSrc.SetRadius(sqrt(3)/3.0)

        # creating/display the lattice verts is optional
        hexPixelsPD = vtk.vtkPolyData()
        hexPixelsPD.SetPoints(self.hexPoints)
        hexPixelsPD.GetPointData().SetScalars(self.cellType)        

        hexGlyphs = vtk.vtkGlyph3D()
        hexGlyphs.SetInput(hexPixelsPD)
        hexGlyphs.SetSource(0,hexagonSrc.GetOutput())
        hexGlyphs.SetIndexModeToScalar()
        hexGlyphs.SetScaleModeToDataScalingOff()        
        
        # hexCellsMapper = vtk.vtkPolyDataMapper()
        self.hexCellsMapper.SetInput(hexGlyphs.GetOutput())
        self.hexCellsMapper.SetLookupTable(self.lut)
        self.hexCellsMapper.SetScalarRange(0,self.lut.GetNumberOfColors())
        self.hexCellsMapper.ScalarVisibilityOn()
        
        self.hexCellsActor.SetMapper(self.hexCellsMapper)

        if self.currentActors.has_key("CellsActor"):
            self.ren.RemoveActor(self.currentActors["CellsActor"])
            del self.currentActors["CellsActor"]        

        if self.currentActors.has_key("BorderActor"):
            self.ren.RemoveActor(self.currentActors["BorderActor"])
            del self.currentActors["BorderActor"]        
        
        if not self.currentActors.has_key("HexCellsActor"):
            self.currentActors["HexCellsActor"]=self.hexCellsActor  
            self.ren.AddActor(self.hexCellsActor)         
        
        if self.parentWidget.borderAct.isChecked():
            self.drawBorders2DHex()    
        else:
            self.hideBorder()

            # self.drawBordersHex()    
            
            
        import math
        self.prepareOutlineActor([self.dim[0]+1,int(self.dim[1]*math.sqrt(3.0)/2.0)+2,1])
        self.showOutlineActor()
        
        
        # self.repaint()        
        self.Render()        