from PyQt4.QtCore import *
from PyQt4.QtGui import *

from Ui_FrequencyPage import Ui_FrequencyPage
from ConfigurationPageBase import ConfigurationPageBase
import Configuration

class FrequencyPage(ConfigurationPageBase, Ui_FrequencyPage):
    """
    Class implementing the Output frequency configuration page.
    """
    def __init__(self):
        """
        Constructor
        """
        QWidget.__init__(self)
        self.setupUi(self)
        self.setObjectName("FrequencyPage")
        self.output = {}
        self.output["NoOutputFlag"]             = Configuration.getOutputFrequency("NoOutputFlag")
        self.output["ScreenUpdateFrequency"]    = Configuration.getOutputFrequency("ScreenUpdateFrequency")
        self.output["ScreenshotFrequency"]      = Configuration.getOutputFrequency("ScreenshotFrequency")
        self.output["UseInternalConsole"]      = Configuration.getOutputFrequency("UseInternalConsole")
        self.output["ClosePlayerAfterSimulationDone"]      = Configuration.getOutputFrequency("ClosePlayerAfterSimulationDone")
        self.output["OutputLatticeDataInBinaryFormat"]      = Configuration.getOutputFrequency("OutputLatticeDataInBinaryFormat")
        
        
        
        self.setSettings()
        self.setConnects()

    def setSettings(self):
        self.updateSpinBox.setValue(self.output["ScreenUpdateFrequency"])
        self.updateSpinBox.setMinimum(1)
        self.shotSpinBox.setValue(self.output["ScreenshotFrequency"])
        self.shotSpinBox.setMinimum(1)
        self.outputCheckBox.setChecked(self.output["NoOutputFlag"])
        self.useInternalConsoleCheckBox.setChecked(self.output["UseInternalConsole"])
        self.closePlayerCheckBox.setChecked(self.output["ClosePlayerAfterSimulationDone"])
        self.outputLatticeDataCheckBox.setChecked(self.output["OutputLatticeDataInBinaryFormat"])
        
        
    def setConnects(self):
        self.connect(self.updateSpinBox,    SIGNAL("valueChanged(int)"), self.updateChanged)
        self.connect(self.shotSpinBox,      SIGNAL("valueChanged(int)"), self.shotChanged)
        self.connect(self.outputCheckBox,   SIGNAL("stateChanged(int)"), self.outputChanged)
        self.connect(self.useInternalConsoleCheckBox,   SIGNAL("stateChanged(int)"), self.useInternalConsoleChanged)
        self.connect(self.closePlayerCheckBox,   SIGNAL("stateChanged(int)"), self.closePlayerChanged)
        self.connect(self.outputLatticeDataCheckBox,   SIGNAL("stateChanged(int)"), self.outputLatticeDataChanged)
        
        
    def updateChanged(self, val):
        self.output["ScreenUpdateFrequency"] = val
    
    def shotChanged(self, val):
        self.output["ScreenshotFrequency"] = val
    
    def outputChanged(self):
        self.output["NoOutputFlag"] = self.outputCheckBox.isChecked()
        
    def useInternalConsoleChanged(self):
        self.output["UseInternalConsole"] = self.useInternalConsoleCheckBox.isChecked()
    
    def closePlayerChanged(self):
        self.output["ClosePlayerAfterSimulationDone"] = self.closePlayerCheckBox.isChecked()
        
    def outputLatticeDataChanged(self):
        self.output["OutputLatticeDataInBinaryFormat"] = self.outputLatticeDataCheckBox.isChecked()
        
    def save(self):
        """
        Public slot to save the OutputFrequency configuration.
        """
        for key in self.output.keys():
            Configuration.setOutputFrequency(key, self.output[key])
        
def create(dlg):
    """
    Module function to create the configuration page.
    
    @param dlg reference to the configuration dialog
    """
    return FrequencyPage()
