from PyQt4.QtCore import *
from PyQt4.QtGui import *

from Ui_ColormapPage import Ui_ColormapPage
from ConfigurationPageBase import ConfigurationPageBase
import Configuration

class ColormapPage(ConfigurationPageBase, Ui_ColormapPage):
    """
    Class implementing the Colormap Plot configuration page.
    """
    def __init__(self):
        """
        Constructor
        """
        QWidget.__init__(self)
        self.setupUi(self)
        self.setObjectName("ColormapPage")

        self.colormap = {}
        self.colormap["MinConcentration"]       = Configuration.getColorMapPlot("MinConcentration")
        self.colormap["MinConcentrationFixed"]  = Configuration.getColorMapPlot("MinConcentrationFixed")
        self.colormap["MaxConcentration"]       = Configuration.getColorMapPlot("MaxConcentration")
        self.colormap["MaxConcentrationFixed"]  = Configuration.getColorMapPlot("MaxConcentrationFixed")
        self.colormap["NumberOfLegendBoxes"]    = Configuration.getColorMapPlot("NumberOfLegendBoxes")
        self.colormap["NumberAccuracy"]         = Configuration.getColorMapPlot("NumberAccuracy")
        self.colormap["LegendEnable"]           = Configuration.getColorMapPlot("LegendEnable")
        self.colormap["NumberOfContourLines"]   = Configuration.getColorMapPlot("NumberOfContourLines")
        self.colormap["ContoursOn"]   = Configuration.getColorMapPlot("ContoursOn")
        
        self.setSettings()
        self.setConnects()

    def setSettings(self):
        # Set validator for self.minLineEdit
        minConValid = QDoubleValidator(self.minLineEdit)
        # minConValid.setBottom(0)
        self.minLineEdit.setValidator(minConValid)
        
        # Set validator for self.maxLineEdit
        maxConValid = QDoubleValidator(self.maxLineEdit)
        # maxConValid.setBottom(0)
        self.maxLineEdit.setValidator(maxConValid)
        
        # Set bottom values for spin boxes
        self.boxSpinBox.setMinimum(0)
        self.accuracySpinBox.setMinimum(0)
        
        self.minLineEdit    .setText(str(self.colormap["MinConcentration"]))        
        self.minFixedBox    .setChecked(self.colormap["MinConcentrationFixed"])
        self.maxLineEdit    .setText(str(self.colormap["MaxConcentration"]))
        self.maxFixedBox    .setChecked(self.colormap["MaxConcentrationFixed"])
        self.boxSpinBox     .setValue(self.colormap["NumberOfLegendBoxes"])
        self.accuracySpinBox.setValue(self.colormap["NumberAccuracy"])        
        self.showLegendBox  .setChecked(self.colormap["LegendEnable"])
        
        self.showContoursBox.setChecked(self.colormap["ContoursOn"])
        
        self.numberOfContoursLinesSpinBox.setValue(self.colormap["NumberOfContourLines"] )
        self.numberOfContoursLinesSpinBox.setMinimum(3)
        self.numberOfContoursLinesSpinBox.setMaximum(20)
        

        

    def setConnects(self):
        self.connect(self.minLineEdit,      SIGNAL("textChanged(QString)"), self.minConChanged)
        self.connect(self.minFixedBox,      SIGNAL("stateChanged(int)"),    self.minFixedChanged)
        self.connect(self.maxLineEdit,      SIGNAL("textChanged(QString)"), self.maxConChanged)     
        self.connect(self.maxFixedBox,      SIGNAL("stateChanged(int)"),    self.maxFixedChanged)
        self.connect(self.boxSpinBox,       SIGNAL("valueChanged(int)"),    self.legendBoxChanged)
        self.connect(self.accuracySpinBox,  SIGNAL("valueChanged(int)"),    self.accuracyChanged)
        self.connect(self.showLegendBox,    SIGNAL("stateChanged(int)"),    self.showLegendChanged)
        self.connect(self.showContoursBox,    SIGNAL("stateChanged(int)"),    self.showContoursChanged)
        self.connect(self.numberOfContoursLinesSpinBox,    SIGNAL("valueChanged(int)"),    self.numberOfContoursLinesChanged)
        
    def minConChanged(self):
        self.colormap["MinConcentration"]       = self.minLineEdit.text()

    def minFixedChanged(self):
        self.colormap["MinConcentrationFixed"]  = self.minFixedBox.isChecked()
         
    def maxConChanged(self):
        self.colormap["MaxConcentration"]       = self.maxLineEdit.text()
        
    def maxFixedChanged(self):
        self.colormap["MaxConcentrationFixed"]  = self.maxFixedBox.isChecked()
        
    def legendBoxChanged(self):
        self.colormap["NumberOfLegendBoxes"]    = self.boxSpinBox.value()
        
    def accuracyChanged(self):
        self.colormap["NumberAccuracy"]         = self.accuracySpinBox.value()
        
    def showLegendChanged(self):
        self.colormap["LegendEnable"]           = self.showLegendBox.isChecked()
    
    def showContoursChanged(self):
        self.colormap["ContoursOn"]           = self.showContoursBox.isChecked()
                
    def numberOfContoursLinesChanged(self):    
        self.colormap["NumberOfContourLines"]=self.numberOfContoursLinesSpinBox.value()
                
    def save(self):
        """
        Public slot to save the ThreeDViewPage configuration.
        """
        for key in self.colormap.keys():
            Configuration.setColorMapPlot(key, self.colormap[key])
        
def create(dlg):
    """
    Module function to create the configuration page.
    
    @param dlg reference to the configuration dialog
    """
    return ColormapPage()
