from PyQt4.QtCore import *
from PyQt4.QtGui import *

from Ui_CellColorsPage import Ui_CellColorsPage
from ConfigurationPageBase import ConfigurationPageBase
import Configuration # don't import everything (*)!

# BUG: Does not properly handles the data in the QTableWidget if they
# are added, edited and deleted without applying changes
# The problem occurs because of the possible unsorted values of
# Cell Type.  

class CellColorsPage(ConfigurationPageBase, Ui_CellColorsPage):
    """
    Class implementing the Cell Type Colors configuration page.
    """
    def __init__(self):
        """
        Constructor
        """
        QWidget.__init__(self)
        self.setupUi(self)
        self.setObjectName("CellColorsPage")
        
        self.cellColors = {}
        self.cellColors["TypeColorMap"]     = Configuration.getCellTypeColors("TypeColorMap")
        self.cellColors["Border"]           = self.initColor("Border", self.borderColorButton, Configuration.getCellTypeColors)
        self.cellColors["Contour"]          = self.initColor("Contour", self.contourColorButton, Configuration.getCellTypeColors)
        self.cellColors["Brush"]            = Configuration.getCellTypeColors("Brush")
        self.cellColors["Pen"]              = Configuration.getCellTypeColors("Pen")
        
        self.populateCellColors()
        self.typeColorTable.horizontalHeader().setStretchLastSection(True)
        
        # don't show the table's rown numbers in the "verticalHeader" on the left side, since its
        #   numbering is inconsistent with the 1st column, which contains cell type ID numbers:
        self.typeColorTable.verticalHeader().hide()
        
        self.delegate   = ColorDelegate(self)
        self.delegate.setColorMap(self.cellColors["TypeColorMap"])
        self.typeColorTable.setItemDelegate(self.delegate)
        # Connect cellChanged only after cell type colors are populated! 
        #self.connect( self.typeColorTable, SIGNAL("cellChanged(int, int)"), self.editCellType) 
        self.connect( self.typeColorTable, SIGNAL("itemSelectionChanged()"), self.selectionChanged )
        #self.__curType = None # Stores the current value of cell type (needed for editing)
        
    def save(self):
        """
        Public slot to save the CellColorPage configuration.
        """
        for key in self.cellColors.keys():
            Configuration.setCellTypeColors(key, self.cellColors[key])
        
    @pyqtSignature("")
    def on_borderColorButton_clicked(self):
        """
        Private slot to set the color for border
        """
        self.cellColors["Border"] = self.selectColor(self.borderColorButton, self.cellColors["Border"])
 
    @pyqtSignature("")
    def on_contourColorButton_clicked(self):
        """
        Private slot to set the color for contour
        """
        self.cellColors["Contour"] = self.selectColor(self.contourColorButton, self.cellColors["Contour"])

    def tableRowCount(self):
        return len(self.cellColors["TypeColorMap"])
    
    def populateCellColors(self):
        #print "populateCellColors: %s" % self.typeColorTable.rowCount()
        self.typeColorTable.setRowCount(self.tableRowCount())
        for i in range(self.tableRowCount()):
            keys = self.colorMapKeys()
            item = QTableWidgetItem(QString("%1").arg(keys[i]))
            self.typeColorTable.setItem(i, 0, item)
            
            item = QTableWidgetItem()
            item.setBackground(QBrush(self.cellColors["TypeColorMap"][keys[i]]))
            self.typeColorTable.setItem(i, 1, item)

    def on_typeColorTable_cellClicked(self, row, col):
        # Only color cell can be changed
        if col == 0:
            # Stores the current type
            #self.__curType = self.typeColorTable.item(row, col).data(Qt.DisplayRole).toInt()[0]
            #print "On click before: %s" % self.__curType
            return 
        
        currentColor = self.typeColorTable.item(row, col).background().color()        
        color = QColorDialog.getColor(currentColor)
        # Cell types are not changed at this time
        
        if color.isValid():
            keys = self.cellColors["TypeColorMap"].keys()
            self.cellColors["TypeColorMap"][keys[row]] = color
            self.typeColorTable.item(row, col).setBackground(QBrush(color))
            
    @pyqtSignature("")    
    def on_newCellTypeButton_clicked(self):
        keys = self.colorMapKeys()
        keys.sort(reverse=True)
        
        # Add new entry to the "TypeColorMap" dictionary with the key maxKey.
        maxKey = keys[0] + 1    
        defColor = QColor(Qt.black)
        self.cellColors["TypeColorMap"][maxKey] = defColor
        self.typeColorTable.insertRow(self.typeColorTable.rowCount())
        row     = self.typeColorTable.rowCount()-1
        
        # Cell type item
        item = QTableWidgetItem(QString("%1").arg(maxKey))  
        self.typeColorTable.setItem(row, 0, item)
        
        # Cell color item
        item    = QTableWidgetItem()                        
        item.setBackground(QBrush(defColor))
        self.typeColorTable.setItem( row, 1, item)

    def selectionChanged(self):
        sm = self.typeColorTable.selectionModel()
        if len(sm.selectedRows()):
            self.deleteCellTypeButton.setEnabled(True)
        else:
            self.deleteCellTypeButton.setEnabled(False)
        
    @pyqtSignature("")
    def on_deleteCellTypeButton_clicked(self):
        sm = self.typeColorTable.selectionModel()
        if len(sm.selectedRows()) and self.deleteCellTypeButton.isEnabled():
            rowsToBeDeleted = sm.selectedRows()
        
            rows = []
            #keys = []
            for i in range(len(rowsToBeDeleted)):
                rows.append(rowsToBeDeleted[i].row())
                #keys.append(rowsToBeDeleted[i].data().toInt()[0])
            
            # After removing the row with removeRow() 
            # function it renumerates the rows!!!
            # Moreover, the order of the elements in the 
            # list corresponds to the order in which the 
            # rows were selected!!! It means that to use 
            # them you need first to store the indexes and 
            # sort them out before using them.

            rows.sort()
            shift = 0
            keys = self.colorMapKeys()
            for i in range(len(rows)):
                # Removes row at the index rows[i]
                self.typeColorTable.removeRow(rows[i] - shift)

                #print "Keys to be deleted: %s" % keys
                # Delete entry in the "TypeColorMap" dictionary
                del(self.cellColors["TypeColorMap"][keys[rows[i]]])
                shift += 1
                #print keys[rows[i]]        
                
    def colorMapKeys(self):
        return self.cellColors["TypeColorMap"].keys()
    
    
    """    
    def editCellType(self, row, col):
        # First column cannot be edited!
        if col == 1:
            return
        
        newType, ok = self.typeColorTable.item(row, col).data(Qt.DisplayRole).toInt()
        print self.__curType
        if not ok or newType < 0:
            # If entered value is not integer or is negative:
            # - Restore data value
            # - Send warning message
            self.typeColorTable.item(row, col).setData(Qt.DisplayRole, QVariant(self.__curType))
            QMessageBox.warning(self, "Incorrect Cell Type", "Cell Type should be non-negative\n integer value")

        # If entered type already exists
        elif newType in self.colorMapKeys() and newType != self.__curType:
            self.typeColorTable.item(row, col).setData(Qt.DisplayRole, QVariant(self.__curType))
            QMessageBox.warning(self, "Cell Type Exists", "This Cell Type already exists")

        elif newType != self.__curType:
            # Change key in "TypeColorMap"
            val = self.cellColors["TypeColorMap"][self.__curType]
            del(self.cellColors["TypeColorMap"][self.__curType])
            self.cellColors["TypeColorMap"][newType] = val
    """

# Can be used for advanced editing in the Model Editor.
class ColorDelegate(QItemDelegate):

    def __init__(self, parent=None):
        QItemDelegate.__init__(self, parent)
        
    def createEditor(self, parent, option, index):
        # Create editor object of QSpinBox
        if index.column() == 0:
            editor = QSpinBox(parent)
            self.connect(editor, SIGNAL("returnPressed()"), self.commitAndCloseEditor)
            return editor
        else:
            return QItemDelegate.createEditor(self, parent, option, index)

    def commitAndCloseEditor(self):
        editor = self.sender()
        if isinstance(editor, (QSpinBox)):
            self.emit(SIGNAL("commitData(QWidget*)"), editor)
            self.emit(SIGNAL("closeEditor(QWidget*)"), editor)

    def setEditorData(self, editor, index):
        val = index.model().data(index, Qt.DisplayRole).toInt()[0]
        if index.column() == 0:
            editor.setValue(val)
        else:
            QItemDelegate.setEditorData(self, editor, index)
    
    def setModelData(self, editor, model, index):
        #print model.rowCount()

        if index.column() == 0:
            # Check if the value already exists (Cell Type) 
            if self.valueUnique(editor.value(), model):
                # Change data in colorMap
                keys = self.colorMap.keys()
                #print "setModelData keys %s" % keys
                #print "Value to be deleted: %s" % keys[index.row()]
                #print self.colorMap
                color = self.colorMap[keys[index.row()]]    # Save color
                del(self.colorMap[keys[index.row()]])       # Delete entry
                self.colorMap[editor.value()] = color       # Set color to the new entry
                
                #print self.colorMap
                #print "Value unique! colorMapCount %s" % len(self.colorMap)
                model.setData(index, QVariant(editor.value()))
        else:
            QItemDelegate.setModelData(self, editor, model, index)

    # Checks if the value is unique in the model (column = 0)
    def valueUnique(self, value, model):
        # value - integer number
        for row in range(model.rowCount()):
            if value == model.data(model.index(row, 0)).toInt()[0]:
                return False
        return True
    
    def setColorMap(self, colorMap):
        self.colorMap = colorMap
        
# Factory function
def create(dlg):
    """
    Module function to create the configuration page.
    
    @param dlg reference to the configuration dialog
    """
    return CellColorsPage()
