/*************************************************************************
*    CompuCell - A software framework for multimodel simulations of     *
* biocomplexity problems Copyright (C) 2003 University of Notre Dame,   *
*                             Indiana                                   *
*                                                                       *
* This program is free software; IF YOU AGREE TO CITE USE OF CompuCell  *
*  IN ALL RELATED RESEARCH PUBLICATIONS according to the terms of the   *
*  CompuCell GNU General Public License RIDER you can redistribute it   *
* and/or modify it under the terms of the GNU General Public License as *
*  published by the Free Software Foundation; either version 2 of the   *
*         License, or (at your option) any later version.               *
*                                                                       *
* This program is distributed in the hope that it will be useful, but   *
*      WITHOUT ANY WARRANTY; without even the implied warranty of       *
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU    *
*             General Public License for more details.                  *
*                                                                       *
*  You should have received a copy of the GNU General Public License    *
*     along with this program; if not, write to the Free Software       *
*      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.        *
*************************************************************************/

#ifndef FOCALPOINTPLACTICITYPLUGIN_H
#define FOCALPOINTPLACTICITYPLUGIN_H


#include <CompuCell3D/Potts3D/CellGChangeWatcher.h>
#include <CompuCell3D/Potts3D/EnergyFunction.h>
#include <CompuCell3D/Plugin.h>
#include "FocalPointPlasticityTracker.h"

#include <map>
#include <set>
#include <string>
#include <vector>


#include "FocalPointPlasticityDLLSpecifier.h"

class CC3DXMLElement;

//Note: Target distance is set to be 0.9 * current distance between cells. target distance from xml is ignored

namespace CompuCell3D {
	class Potts3D;
	class Automaton;
	class BoundaryStrategy;

	class FOCALPOINTPLASTICITY_EXPORT FocalPointPlasticityPlugin : public Plugin,public EnergyFunction, public CellGChangeWatcher  {

      
      BasicClassAccessor<FocalPointPlasticityTracker> focalPointPlasticityTrackerAccessor;
      
		Potts3D *potts;


		std::string autoName;
		double depth;

		Automaton *automaton;
		bool weightDistance;
		unsigned int maxNeighborIndex;
	   unsigned int maxNeighborIndexJunctionMove;
		BoundaryStrategy * boundaryStrategy;
		CC3DXMLElement *xmlData;

      std::set<std::string> plasticityTypesNames;
      std::set<unsigned char> plasticityTypes;
      std::set<unsigned char> internalPlasticityTypes;
      
		Dim3D fieldDim;
      double lambda;
		
      double activationEnergy;
      double targetDistance;
	  double maxDistance;
      double potentialFunction(double _lambda,double _offset,double _targetDistance, double _distance);
      
      bool changeOccuredFlag;
      bool returnedJunctionToPoolFlag;
      bool newJunctionInitiatedFlag;
	  bool newJunctionInitiatedFlagWithinCluster;
		CellG *newNeighbor;
		unsigned int maxNumberOfJunctions;


		enum FunctionType {GLOBAL=0,BYCELLTYPE=1,BYCELLID=2};

		FunctionType functionType;

		typedef double (FocalPointPlasticityPlugin::*diffEnergyFcnPtr_t)(float _deltaL,float _lBefore,const FocalPointPlasticityTrackerData * _plasticityTrackerData,const CellG *_cell,bool _useCluster);
		diffEnergyFcnPtr_t diffEnergyFcnPtr;
		


		double diffEnergyLocal(float _deltaL,float _lBefore,const FocalPointPlasticityTrackerData * _plasticityTrackerData,const CellG *_cell,bool _useCluster=false);
		double diffEnergyGlobal(float _deltaL,float _lBefore,const FocalPointPlasticityTrackerData * _plasticityTrackerData,const CellG *_cell,bool _useCluster=false);
		double diffEnergyByType(float _deltaL,float _lBefore,const FocalPointPlasticityTrackerData * _plasticityTrackerData,const CellG *_cell,bool _useCluster=false);

		


		double tryAddingNewJunction(const Point3D &pt,const CellG *newCell);
		double tryAddingNewJunctionWithinCluster(const Point3D &pt,const CellG *newCell);

		typedef std::map<int, FocalPointPlasticityTrackerData> plastParams_t;
		

		plastParams_t plastParams;
		plastParams_t internalPlastParams;

		plastParams_t typeSpecificPlastParams;
		plastParams_t internalTypeSpecificPlastParams;


		typedef std::vector<std::vector<FocalPointPlasticityTrackerData> > FocalPointPlasticityTrackerDataArray_t;
		typedef std::vector<FocalPointPlasticityTrackerData> FocalPointPlasticityTrackerDataVector_t;

		FocalPointPlasticityTrackerDataArray_t plastParamsArray;
		FocalPointPlasticityTrackerDataArray_t internalPlastParamsArray;

		//////FocalPointPlasticityTrackerDataVector_t typeSpecificPlastParamsVec;
		//////FocalPointPlasticityTrackerDataVector_t internalTypeSpecificPlastParamsVec;
		std::vector<int> maxNumberOfJunctionsTotalVec;
		std::vector<int> maxNumberOfJunctionsInternalTotalVec;
		int neighborOrder;

	public:
		FocalPointPlasticityPlugin();
		virtual ~FocalPointPlasticityPlugin();


		//Plugin interface
		virtual void init(Simulator *simulator, CC3DXMLElement *_xmlData);
		virtual void extraInit(Simulator *simulator);
		
		//EnergyFunction Interface
		virtual double changeEnergy(const Point3D &pt, const CellG *newCell, const CellG *oldCell);

      // Field3DChangeWatcher interface
      virtual void field3DChange(const Point3D &pt, CellG *newCell,
                                 CellG *oldCell);


		//used to manually control parameters plasticity term for pair of cells involved
		void setFocalPointPlasticityParameters(CellG * _cell1,CellG * _cell2,double _lambda, double _targetDistance=0.0,double _maxDistance=0.0);
		void setInternalFocalPointPlasticityParameters(CellG * _cell1,CellG * _cell2,double _lambda, double _targetDistance=0.0,double _maxDistance=0.0);
		double getPlasticityParametersLambdaDistance(CellG * _cell1,CellG * _cell2);
		double getPlasticityParametersTargetDistance(CellG * _cell1,CellG * _cell2);

		BasicClassAccessor<FocalPointPlasticityTracker> * getFocalPointPlasticityTrackerAccessorPtr(){return &focalPointPlasticityTrackerAccessor;}
		//had to include this function to get set inereation working properly with Python , and Player that has restart capabilities 
        FocalPointPlasticityTrackerData * getFocalPointPlasticityTrackerData(FocalPointPlasticityTrackerData * _fpsd){return _fpsd;}


		//Steerable interface
		virtual void update(CC3DXMLElement *_xmlData, bool _fullInitFlag=false);
		virtual std::string steerableName();
		virtual std::string toString();
	protected:
	int getIndex(const int type1, const int type2) const ;

	};
};
#endif
