/*************************************************************************
 *    CompuCell - A software framework for multimodel simulations of     *
 * biocomplexity problems Copyright (C) 2003 University of Notre Dame,   *
 *                             Indiana                                   *
 *                                                                       *
 * This program is free software; IF YOU AGREE TO CITE USE OF CompuCell  *
 *  IN ALL RELATED RESEARCH PUBLICATIONS according to the terms of the   *
 *  CompuCell GNU General Public License RIDER you can redistribute it   *
 * and/or modify it under the terms of the GNU General Public License as *
 *  published by the Free Software Foundation; either version 2 of the   *
 *         License, or (at your option) any later version.               *
 *                                                                       *
 * This program is distributed in the hope that it will be useful, but   *
 *      WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU    *
 *             General Public License for more details.                  *
 *                                                                       *
 *  You should have received a copy of the GNU General Public License    *
 *     along with this program; if not, write to the Free Software       *
 *      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.        *
 *************************************************************************/

#ifndef CHEMOTAXISDATA_H
#define CHEMOTAXISDATA_H

#include <string>
#include <vector>
#include <iostream>

#include <CompuCell3D/Potts3D/Cell.h>
#include "ChemotaxisDLLSpecifier.h"

namespace CompuCell3D {
	class ChemotaxisPlugin;

   class ChemotaxisData{
      public:
         ChemotaxisData(float _lambda=0.0 , float _saturationCoef=0.0 , std::string _typeName=""):
         lambda(_lambda),saturationCoef(_saturationCoef),typeName(_typeName),formulaPtr(0),formulaName("SimpleChemotaxisFormula")
         {}

         float lambda;
         float saturationCoef;
         std::string formulaName;
         typedef float (ChemotaxisPlugin::*chemotaxisEnergyFormulaFcnPtr_t)(float,float,ChemotaxisData &);
         chemotaxisEnergyFormulaFcnPtr_t  formulaPtr;

         std::string typeName;
         std::vector<unsigned char> chemotactTowardsTypesVec;
         std::string chemotactTowardsTypesString;
         

         void Lambda(float _lambda){lambda=_lambda;}
         float getLambda(){return lambda;}
         void Type(std::string _typeName){typeName=_typeName;}
         void ChemotactTowards(std::string _chemotactTowardsTypesString){
            chemotactTowardsTypesString=_chemotactTowardsTypesString;
         }

         void SaturationCoef(float _saturationCoef){
            saturationCoef=_saturationCoef;
            formulaName="SaturationChemotaxisFormula";
         }
         void SaturationLinearCoef(float _saturationCoef){
            saturationCoef=_saturationCoef;
            formulaName="SaturationLinearChemotaxisFormula";
         }

         void outScr(){
            using namespace std;
            cerr<<"**************ChemotaxisData**************"<<endl;
            cerr<<"formulaPtr="<<formulaPtr<<endl;
            cerr<<"lambda="<<lambda<<" saturationCoef="<<saturationCoef<<" typaName="<<typeName<<endl;
            cerr<<"chemotactTowards="<<chemotactTowardsTypesString<<endl;
            cerr<<"Chemotact towards types:"<<endl;
            for (int i = 0 ; i < chemotactTowardsTypesVec.size() ; ++i){
               cerr<<"chemotact Towards type id="<<(int)chemotactTowardsTypesVec[i]<<endl;
            }
            cerr<<"**************ChemotaxisData END**************"<<endl;
         }

         bool okToChemotact( const CellG * _oldCell){
            if(chemotactTowardsTypesVec.size()==0){ //chemotaxis always enabled for this cell
               return true;
            }
            //will chemotact towards only specified cell types
         
            unsigned char type= (_oldCell?_oldCell->type:0);
         
            for(unsigned int i = 0 ; i < chemotactTowardsTypesVec.size() ; ++i){
               if (type==chemotactTowardsTypesVec[i])
                  return true;
            }
         
            return false;
         }
         

   };

   class  ChemotaxisFieldData{
      public:
         ChemotaxisFieldData()
         {}
         std::string chemicalFieldSource;
         std::string chemicalFieldName;
         std::vector<ChemotaxisData> vecChemotaxisData;
         ChemotaxisData *ChemotaxisByType(){
            vecChemotaxisData.push_back(ChemotaxisData());
            return & vecChemotaxisData[vecChemotaxisData.size() -1];
         }
         void Source(std::string _chemicalFieldSource){
            chemicalFieldSource=_chemicalFieldSource;
         }
         void Name(std::string _chemicalFieldName){chemicalFieldName=_chemicalFieldName;}
         ChemotaxisData * getChemotaxisData(int _index){
            if(_index<0 || _index>vecChemotaxisData.size()-1)
               return 0;
            return &vecChemotaxisData[_index];
         }
   };
  
};

#endif
