from PyPlugins import *

class VolumeEnergyFunctionPlugin(EnergyFunctionPy):

    def __init__(self,_energyWrapper):
        EnergyFunctionPy.__init__(self)
        self.energyWrapper=_energyWrapper
        self.vt=0.0
        self.lambda_v=0.0
    def setParams(self,_lambda,_targetVolume):
        self.lambda_v=_lambda;
        self.vt=_targetVolume
    def changeEnergy(self):
        energy=0.0
        if(self.energyWrapper.newCell):
            energy+=self.lambda_v*(1+2*(self.energyWrapper.newCell.volume-self.vt))
        if(self.energyWrapper.oldCell):
            energy+=self.lambda_v*(1-2*(self.energyWrapper.oldCell.volume-self.vt))
        return energy


