from PyQt4.QtGui import *
from PyQt4.QtCore import *

(ORGANIZATION, APPLICATION) = ("Biocomplexity", "PyQtPlayer")
LATTICE_TYPES = {"Square":1,"Hexagonal":2}

maxNumberOfRecentFiles=5

MODULENAME = '------- Configuration/__init__.py: '

class Configs():
    
    # Defaults for CellTypeColors group
    colorsDefaults = {
        "TypeColorMap"  : {
            0: QColor(Qt.black),
            1: QColor(Qt.green),
            2: QColor(Qt.blue),
            3: QColor(Qt.red),
            4: QColor(Qt.darkYellow),
            5: QColor(Qt.lightGray),
            6: QColor(Qt.magenta),
            7: QColor(Qt.darkBlue),
            8: QColor(Qt.cyan),
            9: QColor(Qt.darkGreen),
            10: QColor(Qt.white),
            },
        "Border"        : QColor(Qt.yellow),
        "Contour"       : QColor(Qt.white),
        "Brush"         : QColor(Qt.white),
        "Pen"           : QColor(Qt.black),
    }
    
    viewDefaults = {
        "Types3DInvisible": "0, 4, 5"
        # There can be more parameters XYZ and rotational coordinates
    }

    colormapDefaults = {
        "MinConcentration"      : 0,
        "MinConcentrationFixed" : False,
        "MaxConcentration"      : 1,
        "MaxConcentrationFixed" : False,
        "NumberAccuracy"        : 5,
        "NumberOfLegendBoxes"   : 10,
        "LegendEnable"          : True,
        "ContoursOn"            : False,
        "NumberOfContourLines"  : 5
        
    }
    
    outputDefaults = {
        "NoOutputFlag"                  : True,
        "ScreenUpdateFrequency"         : 1,
        "ScreenshotFrequency"           : 1,
        "UseInternalConsole"            : False,
        "ClosePlayerAfterSimulationDone"    : False,
        "OutputLatticeDataInBinaryFormat"    : False
    }

    vectorDefaults = {
        "ArrowColor"            : QColor(Qt.white),
        "ArrowLength"           : 1,
        "FixedArrowColorFlag"   : False,
        "LegendEnableVector"    : True,
        "ScaleArrows"           : False,
        "NumberAccuracyVector"  : 3,
        "NumberOfLegendBoxesVector" : 10,
        "OverlayVectorCellFields"   : False,
        "MaxMagnitude"          : 1,
        "MaxMagnitudeFixed"     : False,
        "MinMagnitude"          : 0,
        "MinMagnitudeFixed"     : False
    }
    
    visualDefaults = {
        "CellsOn"               : True,
        "BordersOn"             : True,
        "CellGlyphsOn"          : False,
        "FPPLinksOn"            : False,
        "ConcentrationLimitsOn" : True,
        "ZoomFactor"            : 1
    }
    
    playerLayout = {
        "PlayerSizes"           : QByteArray(),
        "MainWindowSize"        : QSize(900, 650),
        "MainWindowPosition"    : QPoint(0,0)
    }
    
    simDefaults = {
        "FileXML"               : "",
        "PythonFileName"        : "",
        "RecentFile"            : "",
        "RecentSimulations"     :[],
        "RunPython"             : False,
        "UseXMLFileFlag"        : True
        
    }    

def getCellTypeColors(key, prefClass = Configs):
    # Returns QColor object (or dictionary of QColor for "TypeColorMap")
    # if configuration name ("key") was found, else returns None
    if key in ["Border", "Contour", "Brush", "Pen"]:
        color = prefClass.settings.value("CellTypeColors/" + key)
        if color.isValid():
            return QColor(color.toString())
        else:
            return prefClass.colorsDefaults[key]
        
    elif key in ["TypeColorMap"]:
        colorMapStr = prefClass.settings.value("CellTypeColors/" + key)

        if colorMapStr.isValid():
            colorList = colorMapStr.toStringList()
            if colorList.count() == 0:
                # colorList = prefClass.colorsDefaults[key]
                colorMapPy=prefClass.colorsDefaults[key]
                colorList = QStringList()
                
                for _key in colorMapPy.keys():
                    colorList.append(str(_key))
                    colorList.append(colorMapPy[_key].name())
                    
            import sys        
            
            # Do color dictionary                
            colorDict = {}
            k = 0
            for i in range(colorList.count()/2):
                key, ok  = colorList[k].toInt()
                k       += 1
                value   = colorList[k]
                k       += 1
                if ok:
                    colorDict[key]  = QColor(value)

            return colorDict
        else:
            return prefClass.colorsDefaults[key]

def setCellTypeColors(key, value, prefClass = Configs):    
    print "GO THIS KEY:",key, "GOT THIS VALUE",value
    if key in ["Border", "Contour", "Brush", "Pen"]:
        prefClass.settings.setValue("CellTypeColors/" + key, QVariant(value.name()))
    
    elif key in ["TypeColorMap"]:
        # value is dictionary
        penColorList = QStringList()
        for i in range(len(value)):
            keys = value.keys()
            penColorList.append(str(keys[i]))
            penColorList.append(str(value[keys[i]].name()))
            
        prefClass.settings.setValue("CellTypeColors/" + key, QVariant(penColorList))
    elif key in ["CustomTypeColorMap"]:
        colorMapStr = prefClass.settings.value("CellTypeColors/" + "TypeColorMap")
        colorDict={}
        
        if colorMapStr.isValid():
            colorList = colorMapStr.toStringList()            

            k = 0
            for i in range(colorList.count()/2):
                cellType, ok  = colorList[k].toInt()
                k       += 1
                color   = colorList[k]
                k       += 1
                if ok:
                    colorDict[cellType]  = QColor(color)    
        else:
            colorDict=prefClass.colorsDefaults["TypeColorMap"]
            
        # value is dictionary
        for newCellType in value.keys():
            colorDict[newCellType]=value[newCellType]
            
        penColorList = QStringList()
        for i in range(len(colorDict)):
            keys = colorDict.keys()
            penColorList.append(str(keys[i]))
            penColorList.append(str(colorDict[keys[i]].name()))
            # print "type=",keys[i]," color=",colorDict[keys[i]].name()
                
        prefClass.settings.setValue("CellTypeColors/" +"TypeColorMap", QVariant(penColorList))

def getThreeDView(key, prefClass = Configs):
    if key in ["Types3DInvisible"]:
        val = prefClass.settings.value("ThreeDView/" + key)
        if val.isValid():
            return val.toString()
        else:
            return prefClass.viewDefaults[key]
    
def setThreeDView(key, value, prefClass = Configs):
    if key in ["Types3DInvisible"]:
        prefClass.settings.setValue("ThreeDView/" + key, QVariant(value))

def getColorMapPlot(key, prefClass = Configs):
    if key in ["MinConcentration", "MaxConcentration"]:
        val = prefClass.settings.value("ColorMapPlot/" + key)
        if val.isValid():
            return val.toDouble()[0]
        else:
            return prefClass.colormapDefaults[key]

    elif key in ["NumberAccuracy", "NumberOfLegendBoxes","NumberOfContourLines"]:
        val = prefClass.settings.value("ColorMapPlot/" + key)
        if val.isValid():
            return val.toInt()[0]
        else:
            return prefClass.colormapDefaults[key]

    elif key in ["MinConcentrationFixed", "MaxConcentrationFixed", "LegendEnable","ContoursOn"]:
        val = prefClass.settings.value("ColorMapPlot/" + key)
        if val.isValid():
            return val.toBool()
        else:
            return prefClass.colormapDefaults[key]

    
def setColorMapPlot(key, value, prefClass = Configs):
    if key in ["MinConcentration", "MaxConcentration", 
               "NumberAccuracy", "NumberOfLegendBoxes",
               "MinConcentrationFixed", "MaxConcentrationFixed", "LegendEnable","NumberOfContourLines","ContoursOn"]:
        prefClass.settings.setValue("ColorMapPlot/" + key, QVariant(value))


def getOutputFrequency(key, prefClass = Configs):
    if key in ["NoOutputFlag","UseInternalConsole", "ScreenUpdateFrequency", "ScreenshotFrequency","ClosePlayerAfterSimulationDone","OutputLatticeDataInBinaryFormat"]:
        output = prefClass.settings.value("OutputFrequency/" + key)
        if output.isValid():
            if key in ["NoOutputFlag","UseInternalConsole","ClosePlayerAfterSimulationDone","OutputLatticeDataInBinaryFormat"]:
                return output.toBool()
            else:
                return output.toInt()[0]
        else:
            return prefClass.outputDefaults[key]
    
def setOutputFrequency(key, value, prefClass = Configs):
    if key in ["NoOutputFlag", "UseInternalConsole","ScreenUpdateFrequency", "ScreenshotFrequency",  "ClosePlayerAfterSimulationDone","OutputLatticeDataInBinaryFormat"]:
        prefClass.settings.setValue("OutputFrequency/" + key, QVariant(value))
        
def getVectorField(key, prefClass = Configs):
    if key in ["FixedArrowColorFlag", "LegendEnableVector", "ScaleArrows",
               "OverlayVectorCellFields", "MaxMagnitudeFixed", "MinMagnitudeFixed"]:
        value = prefClass.settings.value("VectorField/" + key)
        if value.isValid():
            return value.toBool()
        else:
            return prefClass.vectorDefaults[key]

    elif key in ["ArrowLength", "NumberAccuracyVector", "NumberOfLegendBoxesVector",
                 "MaxMagnitude", "MinMagnitude"]:
        value = prefClass.settings.value("VectorField/" + key)
        if value.isValid():
            return value.toInt()[0]
        else:
            return prefClass.vectorDefaults[key]

    elif key in ["ArrowColor"]:
        value = prefClass.settings.value("VectorField/" + key)
        if value.isValid():
            return QColor(value.toString())
        else:
            return prefClass.vectorDefaults[key]
        
    
def setVectorField(key, value, prefClass = Configs):
    if key in prefClass.vectorDefaults.keys() and key not in ["ArrowColor"]:
        prefClass.settings.setValue("VectorField/" + key, QVariant(value))
    elif key in ["ArrowColor"]:
        prefClass.settings.setValue("VectorField/" + key, QVariant(value.name()))


def getVisualization(key, prefClass = Configs):
    if key in ["CellsOn", "BordersOn", "CellGlyphsOn", "FPPLinksOn", "ConcentrationLimitsOn", "ZoomFactor"]:
        output = prefClass.settings.value("Visualization/" + key)
        if output.isValid():
            if key in ["ZoomFactor"]:
                return output.toInt()[0]
            else:
                return output.toBool()
        else:
            return prefClass.visualDefaults[key]
    
def setVisualization(key, value, prefClass = Configs):
    if key in ["CellsOn", "BordersOn", "CellGlyphsOn", "FPPLinksOn", "ConcentrationLimitsOn", "ZoomFactor"]:
        prefClass.settings.setValue("Visualization/" + key, QVariant(value))

def getSimulation(key, prefClass = Configs):
    if key in ["RunPython", "UseXMLFileFlag"]:
        value = prefClass.settings.value("Simulation/" + key)
        if value.isValid():
            return value.toBool()
        else:
            return prefClass.simDefaults[key]
    
    elif key in ["FileXML", "PythonFileName", "RecentFile"]:
        value = prefClass.settings.value("Simulation/" + key)
        if value.isValid():
            return value.toString()
        else:
        
            return prefClass.simDefaults[key]
            
    elif key in ["RecentSimulations"]:
    
        value=prefClass.settings.value("Simulation/" + key)
        if value.isValid():
            recentSimulationsList=value.toStringList()
            recentSimulations=[]
            for i in range(recentSimulationsList.count()):
                recentSimulations.append(str(recentSimulationsList[i]))
            
            return recentSimulations
        else:
            return prefClass.simDefaults[key]


def addNewSimulation(recentSimulationsList,value):
    if str(value)=="":
        return False
    elementExists=False
    idxFound=-1
    for idx in  range(recentSimulationsList.count()):
        print "recentSimulationsList[idx]=",recentSimulationsList[idx]
        print "value=",value
        if str(recentSimulationsList[idx])==value:
            elementExists=True
            idxFound=idx
            break
    print "elementExists=",elementExists    
    if not elementExists:    
        recentSimulationsList.prepend(value)
        return True
    else:
        # moving existing item to the beginning of the list
        fileNameTmp=recentSimulationsList[idxFound]
        recentSimulationsList.removeAt(idxFound)
        recentSimulationsList.prepend(fileNameTmp)
        return False
            
def setSimulation(key, value, prefClass = Configs):
    print "AT THE BEGINNING value=",value
    if key in ["FileXML","PythonFileName","RecentFile" ,"RunPython","UseXMLFileFlag"]:
        prefClass.settings.setValue("Simulation/" + key, QVariant(value))
        
    elif key in ["RecentSimulations"]:
        recentSimulationsVariant=prefClass.settings.value("Simulation/" + "RecentSimulations")
        if recentSimulationsVariant.isValid():
            recentSimulationsList=recentSimulationsVariant.toStringList()
            print "recentSimulationsList.count()=",recentSimulationsList.count()
            print "maxNumberOfRecentFiles=",maxNumberOfRecentFiles
            if recentSimulationsList.count() >= maxNumberOfRecentFiles:    
                addingSuccessful=addNewSimulation(recentSimulationsList,value)
                if addingSuccessful:
                    recentSimulationsList.removeAt(recentSimulationsList.count()-1)
            else:
                addingSuccessful=addNewSimulation(recentSimulationsList,value)
    
                
            prefClass.settings.setValue("Simulation/" + "RecentSimulations", QVariant(recentSimulationsList))
            # for idx in range(recentSimulationsList.count()):
                # print "READ EXISTING FILE  =",idx," file name=", recentSimulationsList[idx]
        else:
            # print "value=",value
            recentSimulationsList=QStringList()
            recentSimulationsList.prepend(QString(value))
            prefClass.settings.setValue("Simulation/" + "RecentSimulations", QVariant(recentSimulationsList))
            
            # for idx in range(recentSimulationsList.count()):
                # print "THIS IS FILE =",idx," file name=", recentSimulationsList[idx]
        
def setPlayerLayout(key, value, prefClass = Configs):
    if key in prefClass.playerLayout.keys():
        prefClass.settings.setValue("PlayerLayout/" + key, QVariant(value))

def getPlayerLayout(key,  prefClass = Configs):
    if key in prefClass.playerLayout.keys():
        if key=="PlayerSizes":
            value = prefClass.settings.value("PlayerLayout/" + key)
            if value.isValid():
                return value.toByteArray()
            else:
                return prefClass.playerLayout[key]
        elif key=="MainWindowSize":
            value = prefClass.settings.value("PlayerLayout/" + key)
            if value.isValid():
                return value.toSize()
            else:
                return prefClass.playerLayout[key]
        elif key=="MainWindowPosition":
            value = prefClass.settings.value("PlayerLayout/" + key)
            if value.isValid():
                return value.toPoint()
            else:
                return prefClass.playerLayout[key]

    else:
        return None

def initPreferences():
    """
    Module function to initialize the central configuration store. 
    """
    print "WILL READ SETTINGS"
    # import time
    # time.sleep(5)
    
    Configs.settings = QSettings(QSettings.NativeFormat, QSettings.UserScope, 
        ORGANIZATION, APPLICATION)
    
def syncPreferences(prefClass = Configs):
    """
    Module function to sync the preferences to disk.
    In addition to syncing, the central configuration store is reinitialized as well.
    @param prefClass preferences class used as the storage area
    """
    print "WILL WRITE SETTINGS"
    # import time
    # time.sleep(5)
    
    prefClass.settings.setValue("General/Configured", QVariant(1))
    initPreferences()
    
def isConfigured(prefClass = Configs):
    """
    Module function to check, if the the application has been configured.
    @param prefClass preferences class used as the storage area
    @return flag indicating the configured status (boolean)
    """
    return prefClass.settings.value("General/Configured", QVariant(0)).toInt()[0]


# Intializes the configuration
initPreferences()

"""
[General]
    Configured=0
[CellTypeColors]
    typeColorMap=0, #000000, 1, #008000, 2, #0000ff, 3, #ff0000, 4, #ff8c00, 5, #e9967a, 6, #9400d3, 7, #000080, 8, #00ffff, 9, #adff2f, 10, #ff69b4
    border=#ffff00
    contour=#ffffff
    brush=#ffffff
    pen=#000000

[ThreeDView]
    types3DInvisible=0, 4, 5

[ColorMapPlot]
    maxConcentration=1
    maxConcentrationFixed=false
    minConcentration=0
    minConcentrationFixed=false


[OutputFrequency] 
    noOutputFlag=true
    screenUpdateFrequency=1
    screenshotFrequency=1


[VectorField]
    arrowColor=#ffffff
    arrowLength=10
    fixedArrowColorFlag=false
    legendEnable=true
    legendEnableVector=true
    scaleArrows=false
    numberAccuracy=5
    numberAccuracyVector=3
    numberOfLegendBoxes=10
    numberOfLegendBoxesVector=10
    overlayVectorCellFields=false
    maxMagnitude=1
    maxMagnitudeFixed=false
    minMagnitude=0
    minMagnitudeFixed=false


[Visualization]
    cellsOn=true
    bordersOn=true
    cellGlyphsOn=false
    FPPLinksOn=false
    contoursOn=false
    concentrationLimitsOn=true
    zoomFactor=9

[Simulation]
    fileXML=/home/dexity/CompuCellBin/Demos/vectorPlot/vectorPlot.xml
    pythonFileName=/home/dexity/CompuCellBin/Demos/elongationLocalFlexTest/elongationFlexSteppables.py
    recentFile=/home/dexity/CompuCellBin/Demos/vectorPlot/vectorPlot.xml
    runPython=false
    useXMLFileFlag=true
    closePlayerAfterSimulationDone=true

"""