# -*- coding: utf-8 -*-
import os
import types

from PyQt4.QtCore import *
from PyQt4.QtGui import *

import Configuration

class ConfigurationDialog(QDialog):
   
    def __init__(self, parent = None, name = None, modal = False):
        QDialog.__init__(self, parent)
        self.setModal(modal)
        self.layout = QVBoxLayout(self)
        self.layout.setMargin(0)
        self.layout.setSpacing(0)

        self.configWidget = ConfigurationWidget(self)        
        size = self.configWidget.size()
        self.layout.addWidget(self.configWidget)
        self.resize(size)
        self.setWindowTitle(self.trUtf8("Configuration")) 
        
        self.connect(self.configWidget.buttonBox,   SIGNAL("accepted()"),       self.accept)
        self.connect(self.configWidget.buttonBox,   SIGNAL("rejected()"),       self.reject)
        self.connect(self.configWidget,             SIGNAL('configsChanged'),   self.__configsChanged)
        
    def __configsChanged(self):
        """
        Private slot to handle a change of the preferences.
        """
        pass
	# call to this function creates infinite recursion on linux and python 2.6
        #self.emit(SIGNAL('configsChanged'))
        
    def showConfigurationPageByName(self, pageName):
        """
        Public slot to show a named configuration page.
        @param pageName name of the configuration page to show (string or QString)
        """
        self.configWidget.showConfigurationPageByName(pageName)
    
        
    def setPreferences(self):
        """
        Public method called to store the selected values into the preferences storage.
        """
        self.configWidget.setPreferences()
      
class ConfigurationWidget(QWidget):
    """
    Class implementing a dialog for the configuration.
    """
    def __init__(self, parent = None):
        QWidget.__init__(self, parent)
        self.__setupUi()
        
        self.itmDict = {}   
         
        # configItems = {"key" : ["Display text", "ImageFileName.png", "ClassName", "ActiveClassName"]}
        self.configItems = {
           "cellColorsPage"     : [self.trUtf8("Cell Type Colors"),     "player/icons/cellcolors.png",   "CellColorsPage",   None],
           "colormapPage"       : [self.trUtf8("Colormap Plot"),        "player/icons/colormap.png",     "ColormapPage",     None],
           "vectorFieldPage"    : [self.trUtf8("Vector Field Plot"),    "player/icons/vectorfield.png",  "VectorFieldPage",  None],
           "threeDViewPage"     : [self.trUtf8("3D View"),              "player/icons/threedview.png",   "ThreeDViewPage",   None],
           "frequencyPage"      : [self.trUtf8("Output Settings"),     "player/icons/frequency.png",    "FrequencyPage",    None],
           #"cellGlyphsPage"      : [self.trUtf8("Cell Glyph"),          0,    "CellGlyphsPage",    None],

        }

        keys = self.configItems.keys()
        # Trying to preserve the order as it is in the dictionary self.configItems
        """        
        for i in range(len(keys)):
            pageData = self.configItems[keys[i]]
            pitm = self.configList
            self.itmDict[keys[i]] = ConfigurationPageItem(pitm, pageData[0], keys[i])
        """
        
        #keys.sort()
        for key in keys:
            pageData = self.configItems[key]
            pitm = self.configList
            self.itmDict[key] = ConfigurationPageItem(pitm, pageData[0], key, pageData[1])

        self.configList.sortItems(Qt.AscendingOrder)
        self.configSplitter.setSizes([150, 480])
        
        #self.showConfigurationPageByName(keys[0])
        #self.configStack.setCurrentWidget(QLabel("Hello world!"))

        self.connect(self.configList, SIGNAL("itemActivated(QListWidgetItem *)"),
            self.__showConfigurationPage)
        
        self.connect(self.configList, SIGNAL("itemClicked(QListWidgetItem *)"),
            self.__showConfigurationPage)

       
    def __setupUi(self):
        self.setObjectName("ConfigurationDialog")
        self.resize(630, 400)
        
        #self.setProperty("sizeGripEnabled", QVariant(True))
               
        self.verticalLayout_2 = QVBoxLayout(self)
        self.verticalLayout_2.setSpacing(6)
        self.verticalLayout_2.setMargin(6)
        self.verticalLayout_2.setObjectName("verticalLayout_2")
        
        self.configSplitter = QSplitter(self)
        self.configSplitter.setOrientation(Qt.Horizontal)
        self.configSplitter.setObjectName("configSplitter")
        
        #ttt = Ui_Dialog()
        
        self.configList = QListWidget(self.configSplitter)
        self.configList.setObjectName("configList")
        
        self.verticalLayout_2.addWidget(self.configSplitter)

        self.buttonBox = QDialogButtonBox(self)
        self.buttonBox.setOrientation(Qt.Horizontal)
        self.buttonBox.setStandardButtons(
            QDialogButtonBox.Apply | QDialogButtonBox.Cancel | \
            QDialogButtonBox.Ok | QDialogButtonBox.Reset)
        self.buttonBox.setObjectName("buttonBox")
        
        self.applyButton = self.buttonBox.button(QDialogButtonBox.Apply)
        self.resetButton = self.buttonBox.button(QDialogButtonBox.Reset)
        self.applyButton.setToolTip("Apply changes to current configuration pages")
        self.resetButton.setToolTip("Restore recent changes made to the current configuration page")
        
        self.connect(self.applyButton, SIGNAL("clicked(bool)"), self.on_applyButton_clicked)
        self.connect(self.resetButton, SIGNAL("clicked(bool)"), self.on_resetButton_clicked)

        # Disabling "Apply" and "Reset" buttons
        #self.applyButton.setEnabled(False)
        #self.resetButton.setEnabled(False)       
        self.verticalLayout_2.addWidget(self.buttonBox)

        self.scrollArea = QScrollArea(self.configSplitter)
        self.scrollArea.setFrameShape(QFrame.NoFrame)
        self.scrollArea.setWidgetResizable(False)
        self.scrollArea.setObjectName("scrollArea")        

        self.configStack = QStackedWidget()
        self.configStack.setFrameShape(QFrame.Box)
        self.configStack.setFrameShadow(QFrame.Sunken)
        self.configStack.setObjectName("configStack")
        self.scrollArea.setWidget(self.configStack) #QLabel("Hello world!"))       

    def __importConfigurationPage(self, name):
        """
        Private method to import a configuration page module.
        
        @param name name of the configuration page module (string)
        @return reference to the configuration page module
        """
        modName = "Configuration.ConfigurationPages.%s" % name
        try:
            mod = __import__(modName)
            components = modName.split('.')
            for comp in components[1:]:
                mod = getattr(mod, comp)
            return mod
        except ImportError:
            QMessageBox.critical(None,
                self.trUtf8("Configuration Page Error"),
                self.trUtf8("""<p>The configuration page <b>%1</b>"""
                            """ could not be loaded.</p>""").arg(name))
            return None

    def __showConfigurationPage(self, itm):
        """
        Private slot to show a selected configuration page.
        
        @param itm reference to the selected item (QListWidgetItem)
        @param column column that was selected (integer) (ignored)
        """
        pageName = itm.getPageName()
        self.showConfigurationPageByName(pageName)

    # Sets the pageData[3] to configuration page object
    # e.g. pageData[3] = CellColorPage()
    def __initPage(self, pageData):
        """
        Private method to initialize a configuration page.
        
        @param pageData data structure for the page to initialize
        @return reference to the initialized page
        """
        page = None

        # Import configuration page and assign it to mod (e.g. mod = CellColorsPage)
        mod = self.__importConfigurationPage(pageData[2])
        if mod:
            # Factory method that object of class pageData[2] (or self.configItems[key][2])
            page = mod.create(self)
                
        if page is not None:
            self.configStack.addWidget(page)
            pageData[3] = page
        return page

    def showConfigurationPageByName(self, pageName):
        """
        Public slot to show a named configuration page.
        
        @param pageName name of the configuration page to show (string or QString)
        """
        # Default value (first element in the list, suppose that the list is not zero)
        if pageName == "default":
            self.configList.item(0).setSelected(True)
            pageName = self.configList.item(0).getPageName()

        pageName = unicode(pageName)
        pageData = self.configItems[pageName] 
        if pageData[3] is None and pageData[2] is not None:
            # If the page was not loaded yet, create it
            page = self.__initPage(pageData)          
        else:
            page = pageData[3]
        
        
        if page is None and self.configList[0] is not None:           
            pageData = self.configItems[self.configList[0].getPageName()]
            page = self.__initPage(pageData)

        self.configStack.setCurrentWidget(page)
        
        ssize = self.scrollArea.size()
        psize = page.minimumSizeHint()
        self.configStack.resize(max(ssize.width(), psize.width()), max(ssize.height(), psize.height()))

    def getPage(self, pageName):
        """
        Public method to get a reference to the named page.
        
        @param pageName name of the configuration page (string)
        @return reference to the page or None, indicating page was not loaded yet
        """
        return self.configItems[pageName][3]

    # Applies configuration changes to all pages 
    # that have been visited (clicked)
    def setPreferences(self):
        """
        Public method called to store the selected values into the preferences storage.
        """

        for key, pageData in self.configItems.items():
            if pageData[3]:
                pageData[3].save()
                # Page was loaded (and possibly modified)
                QApplication.processEvents()    # ensure HMI is responsive

    # Applies changes to the CURRENT configuration page (not all pages)
    @pyqtSignature("")
    def on_applyButton_clicked(self):
        """
        Private slot called to apply the settings of the current page.
        """
        #print "CALLING on_applyButton_clicked"
        #print "configsChanged"
        page = self.configStack.currentWidget()
        
        
        # Saves changes only in the current configuration page
        page.save()
        self.emit(SIGNAL('configsChanged'))
    
    # Resets the configuration page to it's initial state 
    # (before changes has been applied)    
    @pyqtSignature("")
    def on_resetButton_clicked(self):
        """
        Private slot called to reset the settings of the current page.
        """
        # Remove the page from widget stack (self.configStack)
        currentPage = self.configStack.currentWidget()
        pageName = self.configList.currentItem().getPageName()
        self.configStack.removeWidget(currentPage)
        pageData = self.configItems[unicode(pageName)]
        pageData[3] = None
        
        # Add the page again
        self.showConfigurationPageByName(pageName)

class ConfigurationPageItem(QListWidgetItem):
    """
    Class implementing a QListWidgetItem holding the configuration page data.
    """
    def __init__(self, parent, text, pageName, iconFile = None):
        QListWidgetItem.__init__(self, QString(text), parent)
        self.setIcon(QIcon(iconFile))
        self.__pageName = unicode(pageName)
        
    def getPageName(self):
        """
        Public method to get the name of the associated configuration page.
        @return name of the configuration page (string)
        """
        return self.__pageName
        

