from PySteppables import *
import CompuCell
import sys





class ConcentrationFieldDumperSteppable(SteppablePy):
    def __init__(self,_simulator,_frequency=1):
        SteppablePy.__init__(self,_frequency)
        self.simulator=_simulator
        self.dim=self.simulator.getPotts().getCellFieldG().getDim()

    def setFieldName(self,_fieldName):
        self.fieldName=_fieldName

    def step(self,mcs):
        fileName=self.fieldName+"_"+str(mcs)+".dat"
        self.outputField(self.fieldName,fileName)

    def outputField(self,_fieldName,_fileName):
        field=CompuCell.getConcentrationField(self.simulator,_fieldName)
        pt=CompuCell.Point3D()
        if field:
            try:
                fileHandle=open(_fileName,"w")
            except IOError:
                print "Could not open file ", _fileName," for writing. Check if you have necessary permissions"

            print "dim.x=",self.dim.x
            for i in xrange(self.dim.x):
                for j in xrange(self.dim.y):
                    for k in xrange(self.dim.z):
                        pt.x=i
                        pt.y=j
                        pt.z=k
                        fileHandle.write("%d\t%d\t%d\t%f\n"%(pt.x,pt.y,pt.z,field.get(pt)))

