from PySteppables import *
import CompuCell
import sys

class ElongationFlexSteppable(SteppablePy):
    def __init__(self,_simulator,_frequency=10):
        SteppablePy.__init__(self,_frequency)
        self.simulator=_simulator
        self.inventory=self.simulator.getPotts().getCellInventory()
        self.cellList=CellList(self.inventory)
        self.lengthConstraintFlexPlugin=CompuCell.getLengthConstraintLocalFlexPlugin()
        self.connectivityLocalFlexPlugin=CompuCell.getConnectivityLocalFlexPlugin()
        
    def start(self):
        pass

    def step(self,mcs):
        for cell in self.cellList:
            if cell.type==1:
                self.lengthConstraintFlexPlugin.setLengthConstraintData(cell,20,20) # cell , lambdaLength, targetLength
                self.connectivityLocalFlexPlugin.setConnectivityStrength(cell,10000000) #cell, strength
                
            elif cell.type==2:
                self.lengthConstraintFlexPlugin.setLengthConstraintData(cell,20,30)  # cell , lambdaLength, targetLength
                self.connectivityLocalFlexPlugin.setConnectivityStrength(cell,10000000) #cell, strength

