     #Steppables

"This module contains examples of certain more and less useful steppables written in Python"
from CompuCell import NeighborFinderParams
import CompuCell
from random import random
from random import randint
import types
from PySteppables import *
import CompuCell
import sys
import math

class ElasticityLocalSteppable(SteppablePy):
    def __init__(self,_simulator,_frequency=10):
        SteppablePy.__init__(self,_frequency)
        self.simulator=_simulator
        self.elasticityTrackerPlugin=CompuCell.getElasticityTrackerPlugin()
        self.elasticityTrackerAccessor=self.elasticityTrackerPlugin.getElasticityTrackerAccessorPtr()
        self.inventory=self.simulator.getPotts().getCellInventory()
        self.cellList=CellList(self.inventory)

    def findElasticityNeighborData(self,_sourceCell, _targetCell):
        #because STL iterators do not work with swig we are doing linear search of a set. Since the size of a set is not large the performance
        #will not suffer too much. We also are calling method that refers to this function at most several times per simulation        
        #we search elasticityNeighbors of sourceCell in order to find such elasticityNeighbor with neighbor address == targetCell.this
        
        self.elasticityDataList=ElasticityDataList(self.elasticityTrackerPlugin,_sourceCell)
        for elasticityData in self.elasticityDataList:
            if not CompuCell.areCellsDifferent(elasticityData.neighborAddress,_targetCell):
                return elasticityData
        return None
            
    def initializeElasticityLocal(self):
        
        for cell in self.cellList:
            
            self.elasticityDataList=ElasticityDataList(self.elasticityTrackerPlugin,cell)
            for elasticityData in self.elasticityDataList:
            
                targetLength=elasticityData.targetLength
                if math.floor(targetLength)<=0.0:
                    #print "Uninitialized "," cell.id=",cell.id," math.floor(targetLength)=",math.floor(targetLength)
                
                    elasticityData.targetLength=6.0
                    elasticityData.lambdaLength=200.0
                    elasticityNeighbor=elasticityData.neighborAddress
                    elasticityDataMatchingPair=self.findElasticityNeighborData(_sourceCell=elasticityNeighbor , _targetCell=cell)
                    if elasticityDataMatchingPair is None:
                        print "None Type returned. Problems with FemDataNeighbors initialization or sets of elasticityNeighborData are corrupted"
                        sys.exit()
                    elasticityDataMatchingPair.targetLength=6.0
                    elasticityDataMatchingPair.lambdaLength=200.0
        
    def checkElasticityData(self):
        invItr=CompuCell.STLPyIteratorCINV()
        invItr.initialize(self.inventory.getContainer())
        invItr.setToBegin()
        cell=invItr.getCurrentRef()
        
        for cell in self.cellList:
            self.elasticityDataList=ElasticityDataList(self.elasticityTrackerPlugin,cell)
            for elasticityData in self.elasticityDataList:
                elasticityNeighbor=elasticityData.neighborAddress
                targetLength=elasticityData.targetLength
                lambdaLength=elasticityData.lambdaLength
                print "cell.id=",cell.id," neighbor_cell.id=",elasticityNeighbor.id," targetLength=",targetLength," lambdaLength=",lambdaLength
        
    def start(self):
        self.elasticityTrackerPlugin.initializeElasticityNeighborList() #this initializes a set of elasticity neighbors with default values for 
        self.initializeElasticityLocal()  # once set of neighbors has been initialized we need to initialize targetLength and lambda for for each pair of elasticity pairs
        self.checkElasticityData()
        
    def step(self,mcs):
        pass
	 

