from PySteppables import *
import CompuCell
import sys
from XMLUtils import dictionaryToMapStrStr as d2mss



            
class FocalPointContactSteering(SteppablePy):
    def __init__(self,_simulator,_frequency=100):
        SteppablePy.__init__(self,_frequency)
        self.simulator=_simulator

    def step(self,mcs):
        if mcs>300 and not mcs%100:
            # get <Plugin Name="ExternalPotential"> section of XML file 
            extPotXMLData=self.simulator.getCC3DModuleData("Plugin","ExternalPotential")
            # check if we were able to successfully get the section from simulator
            if extPotXMLData:
                # get <ExternalPotentialParameters CellType="Body1" x="xxx" y="xxx" z="xxx" /> element  
                extPotParametersNC=extPotXMLData.getFirstElement("ExternalPotentialParameters",d2mss({"CellType":"NonCondensing"}))
                # check if the attempt was succesful
                if extPotParametersNC:
                    # get value of the x attribute from <ExternalPotentialParameters CellType="Body1" x="xxx" y="xxx" z="xxx" /> element  
                    xValue=extPotParametersNC.getAttributeAsDouble("x")
                    #increase targetLength by 1
                    targetLength=-5
                    # update <ExternalPotentialParameters CellType="Body1" x="xxx" y="xxx" z="xxx" /> element remembering abuot converting targetLength to string
                    lextPotParametersNC.updateElementAttributes(d2mss({"x":str(xValue)}))
                # finally call simulator.updateCC3DModule(extPotXMLData) to tell simulator to update model parameters - this is actual steering        
                self.simulator.updateCC3DModule(extPotXMLData)
        # if mcs>3000:
            # # here we relax connectivity constraint at MCS>3000
            # connectivityXMLData=self.simulator.getCC3DModuleData("Plugin","Connectivity")
            # if connectivityXMLData:
                # penaltyElement=connectivityXMLData.getFirstElement("Penalty")
                # if penaltyElement:
                    # penaltyElement.updateElementValue(str(0))
                 
                # self.simulator.updateCC3DModule(connectivityXMLData)
            
        

