"This module contains definitions of basic classes that are used to construct Python based Steppables"

#steppables

class SimObjectPy:
    def __init__(self):pass
    def init(self,_simulator):
        self.simulator=_simulator
    def extraInit(self,_simulator):
        self.simulator=_simulator

class SteppablePy(SimObjectPy):
    def __init__(self,_frequency=1):
        self.frequency=_frequency
    #def __name__(self):
        #self.name="Steppable"
    def setFrequency(self,_freq):
        self.frequency=_freq
    def start(self):pass
    def step(self,_mcs):pass
    def finish(self):pass


class SteppableBasePy(SteppablePy):
    def __init__(self,_simulator,_frequency=1):
        SteppablePy.__init__(self,_frequency)
        self.simulator=_simulator
        self.potts=_simulator.getPotts()
        self.cellField=self.potts.getCellFieldG()
        self.dim=self.cellField.getDim()
        self.inventory=self.simulator.getPotts().getCellInventory()
        self.cellList=CellList(self.inventory)



class SteppableRegistry(SteppablePy):
    def __init__(self):
        self.steppableList=[]

    def registerSteppable(self,_steppable):
        self.steppableList.append(_steppable)

    def init(self,_simulator):
        for steppable in self.steppableList:
            steppable.init(_simulator)

    def extraInit(self,_simulator):
        for steppable in self.steppableList:
            steppable.extraInit(_simulator)

    def start(self):
        for steppable in self.steppableList:
            steppable.start()

    def step(self,_mcs):
        for steppable in self.steppableList:
            if not _mcs % steppable.frequency: #this executes given steppable every "frequency" Monte Carlo Steps
                steppable.step(_mcs)

    def finish(self):
        for steppable in self.steppableList:
            steppable.finish()


#this is used to iterate more easily over cells

class CellList:
    def __init__(self,_inventory):
        self.inventory = _inventory
    def __iter__(self):
        return CellListIterator(self)

class CellListIterator:
    def __init__(self, _cellList):
        import CompuCell
        self.inventory = _cellList.inventory
        self.invItr=CompuCell.STLPyIteratorCINV()
        self.invItr.initialize(self.inventory.getContainer())
        self.invItr.setToBegin()
    def next(self):
        if not self.invItr.isEnd():
            self.cell = self.invItr.getCurrentRef()
            self.invItr.next()
            return self.cell
        else:
            raise StopIteration
    def __iter__(self):
            return self

            
#this is used to iterate more easily over clusters 

class ClusterList:
    def __init__(self,_inventory):
        self.inventory = _inventory.getClusterInventory().getContainer()
    def __iter__(self):
        return ClusterListIterator(self)

class ClusterListIterator:
    def __init__(self, _cellList):
        import CompuCell
        self.inventory = _cellList.inventory
        # print "dir(self.inventory)=",dir(self.inventory)
        self.invItr=self.inventory.begin()        
        # self.invItr.initialize(self.inventory.getContainer())
        # self.invItr.setToBegin()
    def next(self):
        # if self.invItr !=  self.inventory.end():
        if not self.invItr.equal(self.inventory.end()) :
            # print "self.invItr=",dir(self.invItr)
            # print "self.invItr.next()=",self.invItr.next()
            # self.compartmentList = self.invItr.next()
            self.compartmentList = self.invItr.value() # returns tupple which is equivalent to (first, second) of the C++ map iterator - here (clusterId,map<long,CellG*>)
            self.invItr.incr()            
            return self.compartmentList[1]
        else:
            raise StopIteration
    def __iter__(self):
            return self 

            
            
# works too
# class ClusterList:
    # def __init__(self,_inventory):
        # self.inventory = _inventory.getClusterInventory()
    # def __iter__(self):
        # return ClusterListIterator(self)

# class ClusterListIterator:
    # def __init__(self, _cellList):
        # import CompuCell
        # self.inventory = _cellList.inventory
        # self.invItr=CompuCell.STLPyIteratorCOMPARTMENT()
        # self.invItr.initialize(self.inventory.getContainer())
        # self.invItr.setToBegin()
    # def next(self):
        # if not self.invItr.isEnd():
            # self.compartmentList = self.invItr.getCurrentRef()
            # self.invItr.next()
            # return self.compartmentList
        # else:
            # raise StopIteration
    # def __iter__(self):
            # return self            
            
#this is used to iterate more easily over list of compartments , notice regular map iteration will work too but this is more abstracted out and will work with other containers too
class CompartmentList:
    def __init__(self,_inventory):
        self.inventory = _inventory
    def __iter__(self):
        return CompartmentListIterator(self)

class CompartmentListIterator:
    def __init__(self, _cellList):
        import CompuCell
        self.inventory = _cellList.inventory
        # print "dir(self.inventory)=",dir(self.inventory)
        self.invItr=self.inventory.begin()        
        # self.invItr.initialize(self.inventory.getContainer())
        # self.invItr.setToBegin()
    def next(self):
        # if self.invItr !=  self.inventory.end():
        if not self.invItr.equal(self.inventory.end()) :
            # print "self.invItr=",dir(self.invItr)
            # print "self.invItr.next()=",self.invItr.next()
            # self.compartmentList = self.invItr.next()
            self.cellIDCellPtr = self.invItr.value() # returns tupple which is equivalent to (first, second) of the C++ map iterator - here (cellId, cellGPtr)
            self.invItr.incr()            
            return self.cellIDCellPtr[1]
        else:
            raise StopIteration
    def __iter__(self):
            return self 

            
class CellNeighborList:
    def __init__(self,_neighborTrackerAccessor,_cell):
        self.neighborTrackerAccessor = _neighborTrackerAccessor
        self.cell=_cell
    def __iter__(self):
        return CellNeighborIterator(self)


class CellNeighborIterator:
    def __init__(self, _cellNeighborList):
        import CompuCell
        self.neighborTrackerAccessor = _cellNeighborList.neighborTrackerAccessor
        self.cell=_cellNeighborList.cell
        self.nsdItr=CompuCell.nsdSetPyItr()
        self.nTracker=self.neighborTrackerAccessor.get(self.cell.extraAttribPtr)
        self.nsdItr.initialize(self.nTracker.cellNeighbors)
        self.nsdItr.setToBegin()

    def next(self):
        if not self.nsdItr.isEnd():
            self.neighborCell = self.nsdItr.getCurrentRef().neighborAddress
            self.nsdItr.next()
            return self.neighborCell
        else:
            raise StopIteration
    def __iter__(self):
            return self


class CellNeighborListAuto:
    def __init__(self,_neighborPlugin,_cell):
        self.neighborPlugin=_neighborPlugin
        self.neighborTrackerAccessor=self.neighborPlugin.getNeighborTrackerAccessorPtr()
        self.cell=_cell
    def __iter__(self):
        return CellNeighborIteratorAuto(self)



class CellNeighborIteratorAuto:
    def __init__(self, _cellNeighborList):
        import CompuCell
        self.neighborTrackerAccessor = _cellNeighborList.neighborTrackerAccessor
        self.cell=_cellNeighborList.cell
        self.nsdItr=CompuCell.nsdSetPyItr()
        self.nTracker=self.neighborTrackerAccessor.get(self.cell.extraAttribPtr)
        self.nsdItr.initialize(self.nTracker.cellNeighbors)
        self.nsdItr.setToBegin()


    def next(self):
        if not self.nsdItr.isEnd():
            self.neighborCell = self.nsdItr.getCurrentRef().neighborAddress
            self.currentNsdItr = self.nsdItr.current
            self.currentNeighborSurfaceData=self.nsdItr.getCurrentRef()
            self.nsdItr.next()
            return self.currentNeighborSurfaceData
        else:
            raise StopIteration

    def __iter__(self):
            return self


class CellBoundaryPixelList:

    def __init__(self,_boundaryPixelTrackerPlugin,_cell):
        self.boundaryPixelTrackerPlugin=_boundaryPixelTrackerPlugin
        self.boundaryPixelTrackerAccessor=self.boundaryPixelTrackerPlugin.getBoundaryPixelTrackerAccessorPtr()
        self.cell=_cell

    def __iter__(self):
        return CellBoundaryPixelIterator(self)

    def numberOfPixels(self):
        return self.boundaryPixelTrackerAccessor.get(self.cell.extraAttribPtr).pixelSet.size()



class CellBoundaryPixelIterator:
    def __init__(self, _cellPixelList):
        import CompuCell
        self.boundaryPixelTrackerAccessor = _cellPixelList.boundaryPixelTrackerAccessor
        self.boundaryPixelTrackerPlugin=_cellPixelList.boundaryPixelTrackerPlugin
        self.cell=_cellPixelList.cell
        self.boundaryPixelItr=CompuCell.boundaryPixelSetPyItr()
        self.boundaryPixelTracker=self.boundaryPixelTrackerAccessor.get(self.cell.extraAttribPtr)
        self.boundaryPixelItr.initialize(self.boundaryPixelTracker.pixelSet)
        self.boundaryPixelItr.setToBegin()


    def next(self):
        if not self.boundaryPixelItr.isEnd():
#             self.neighborCell = self.nsdItr.getCurrentRef().neighborAddress
#             self.currentNsdItr = self.nsdItr.current
            self.currentBoundaryPixelTrackerData=self.boundaryPixelItr.getCurrentRef()
            self.boundaryPixelItr.next()
            return self.boundaryPixelTrackerPlugin.getBoundaryPixelTrackerData(self.currentBoundaryPixelTrackerData)
#             return self.currentPixelTrackerData
        else:
            raise StopIteration

    def __iter__(self):
            return self


class CellPixelList:

    def __init__(self,_pixelTrackerPlugin,_cell):
        self.pixelTrackerPlugin=_pixelTrackerPlugin
        self.pixelTrackerAccessor=self.pixelTrackerPlugin.getPixelTrackerAccessorPtr()
        self.cell=_cell

    def __iter__(self):
        return CellPixelIterator(self)

    def numberOfPixels(self):
        return self.pixelTrackerAccessor.get(self.cell.extraAttribPtr).pixelSet.size()



class CellPixelIterator:
    def __init__(self, _cellPixelList):
        import CompuCell
        self.pixelTrackerAccessor = _cellPixelList.pixelTrackerAccessor
        self.pixelTrackerPlugin=_cellPixelList.pixelTrackerPlugin
        self.cell=_cellPixelList.cell
        self.pixelItr=CompuCell.pixelSetPyItr()
        self.pixelTracker=self.pixelTrackerAccessor.get(self.cell.extraAttribPtr)
        self.pixelItr.initialize(self.pixelTracker.pixelSet)
        self.pixelItr.setToBegin()


    def next(self):
        if not self.pixelItr.isEnd():
#             self.neighborCell = self.nsdItr.getCurrentRef().neighborAddress
#             self.currentNsdItr = self.nsdItr.current
            self.currentPixelTrackerData=self.pixelItr.getCurrentRef()
            self.pixelItr.next()
            return self.pixelTrackerPlugin.getPixelTrackerData(self.currentPixelTrackerData)
#             return self.currentPixelTrackerData
        else:
            raise StopIteration

    def __iter__(self):
            return self

class ElasticityDataList:
    def __init__(self,_elasticityTrackerPlugin,_cell):
        self.elasticityTrackerPlugin=_elasticityTrackerPlugin
        self.elasticityTrackerAccessor=self.elasticityTrackerPlugin.getElasticityTrackerAccessorPtr()
        self.cell=_cell
    def __iter__(self):
        return ElasticityDataIterator(self)


class ElasticityDataIterator:
    def __init__(self, _elasticityDataList):
        import CompuCell
        self.elasticityTrackerAccessor = _elasticityDataList.elasticityTrackerAccessor
        self.cell=_elasticityDataList.cell
        self.elasticityTrackerPlugin=_elasticityDataList.elasticityTrackerPlugin
        self.elasticityTracker=self.elasticityTrackerAccessor.get(self.cell.extraAttribPtr)
        self.elasticityDataSetItr=CompuCell.elasticitySetPyItr()
        self.elasticityDataSetItr.initialize(self.elasticityTracker.elasticityNeighbors)
        self.elasticityDataSetItr.setToBegin()

    def next(self):
        if not self.elasticityDataSetItr.isEnd():
            self.currentElasticityDataSetItr = self.elasticityDataSetItr.current
            self.elasticityData=self.elasticityDataSetItr.getCurrentRef()
            self.elasticityDataSetItr.next()
            return self.elasticityTrackerPlugin.getElasticityTrackerData(self.elasticityData)
#             return self.elasticityData
        else:
            raise StopIteration

    def __iter__(self):
            return self


class PlasticityDataList:
    def __init__(self,_plasticityTrackerPlugin,_cell):
        self.plasticityTrackerPlugin=_plasticityTrackerPlugin
        self.plasticityTrackerAccessor=self.plasticityTrackerPlugin.getPlasticityTrackerAccessorPtr()
        self.cell=_cell
    def __iter__(self):
        return PlasticityDataIterator(self)


class PlasticityDataIterator:
    def __init__(self, _plasticityDataList):
        import CompuCell
        self.plasticityTrackerAccessor = _plasticityDataList.plasticityTrackerAccessor
        self.cell=_plasticityDataList.cell
        self.plasticityTrackerPlugin=_plasticityDataList.plasticityTrackerPlugin
        self.plasticityTracker=self.plasticityTrackerAccessor.get(self.cell.extraAttribPtr)
        self.plasticityDataSetItr=CompuCell.plasticitySetPyItr()
        self.plasticityDataSetItr.initialize(self.plasticityTracker.plasticityNeighbors)
        self.plasticityDataSetItr.setToBegin()

    def next(self):
        if not self.plasticityDataSetItr.isEnd():
            self.currentPlasticityDataSetItr = self.plasticityDataSetItr.current
            self.plasticityData=self.plasticityDataSetItr.getCurrentRef()
            self.plasticityDataSetItr.next()
            return self.plasticityTrackerPlugin.getPlasticityTrackerData(self.plasticityData)
#             return self.plasticityData
        else:
            raise StopIteration

    def __iter__(self):
            return self

            
class FocalPointPlasticityDataList:
    def __init__(self,_focalPointPlasticityPlugin,_cell):
        self.focalPointPlasticityPlugin=_focalPointPlasticityPlugin
        self.focalPointPlasticityTrackerAccessor=self.focalPointPlasticityPlugin.getFocalPointPlasticityTrackerAccessorPtr()
        self.cell=_cell
    def __iter__(self):
        return FocalPointPlasticityDataIterator(self)


class FocalPointPlasticityDataIterator:
    def __init__(self, _focalPointPlasticityDataList):
        import CompuCell
        self.focalPointPlasticityTrackerAccessor = _focalPointPlasticityDataList.focalPointPlasticityTrackerAccessor
        self.cell=_focalPointPlasticityDataList.cell
        self.focalPointPlasticityPlugin=_focalPointPlasticityDataList.focalPointPlasticityPlugin
        self.focalPointPlasticityTracker=self.focalPointPlasticityTrackerAccessor.get(self.cell.extraAttribPtr)
        self.focalPointPlasticityDataSetItr=CompuCell.focalPointPlasticitySetPyItr()
        self.focalPointPlasticityDataSetItr.initialize(self.focalPointPlasticityTracker.focalPointPlasticityNeighbors)
        self.focalPointPlasticityDataSetItr.setToBegin()

    def next(self):
        if not self.focalPointPlasticityDataSetItr.isEnd():
            self.currentFocalPointPlasticityDataSetItr = self.focalPointPlasticityDataSetItr.current
            self.focalPointPlasticityData=self.focalPointPlasticityDataSetItr.getCurrentRef()
            self.focalPointPlasticityDataSetItr.next()
            return self.focalPointPlasticityPlugin.getFocalPointPlasticityTrackerData(self.focalPointPlasticityData)
#             return self.plasticityData
        else:
            raise StopIteration

    def __iter__(self):
            return self            

class InternalFocalPointPlasticityDataList:
    def __init__(self,_focalPointPlasticityPlugin,_cell):
        self.focalPointPlasticityPlugin=_focalPointPlasticityPlugin
        self.focalPointPlasticityTrackerAccessor=self.focalPointPlasticityPlugin.getFocalPointPlasticityTrackerAccessorPtr()
        self.cell=_cell
    def __iter__(self):
        return InternalFocalPointPlasticityDataIterator(self)


class InternalFocalPointPlasticityDataIterator:
    def __init__(self, _focalPointPlasticityDataList):
        import CompuCell
        self.focalPointPlasticityTrackerAccessor = _focalPointPlasticityDataList.focalPointPlasticityTrackerAccessor
        self.cell=_focalPointPlasticityDataList.cell
        self.focalPointPlasticityPlugin=_focalPointPlasticityDataList.focalPointPlasticityPlugin
        self.focalPointPlasticityTracker=self.focalPointPlasticityTrackerAccessor.get(self.cell.extraAttribPtr)
        self.focalPointPlasticityDataSetItr=CompuCell.focalPointPlasticitySetPyItr()
        self.focalPointPlasticityDataSetItr.initialize(self.focalPointPlasticityTracker.internalFocalPointPlasticityNeighbors)
        self.focalPointPlasticityDataSetItr.setToBegin()

    def next(self):
        if not self.focalPointPlasticityDataSetItr.isEnd():
            self.currentFocalPointPlasticityDataSetItr = self.focalPointPlasticityDataSetItr.current
            self.focalPointPlasticityData=self.focalPointPlasticityDataSetItr.getCurrentRef()
            self.focalPointPlasticityDataSetItr.next()
            return self.focalPointPlasticityPlugin.getFocalPointPlasticityTrackerData(self.focalPointPlasticityData)
#             return self.plasticityData
        else:
            raise StopIteration

    def __iter__(self):
            return self              
            

# forEachCellInInventory function takes as arguments inventory of cells and a function that will operate on a single cell
# It will run singleCellOperation on each cell from cell inventory
def forEachCellInInventory(inventory,singleCellOperation):
    import CompuCell
    invItr=CompuCell.STLPyIteratorCINV()
    invItr.initialize(inventory.getContainer())
    invItr.setToBegin()
    cell=invItr.getCurrentRef()
    while (not invItr.isEnd()):
        cell=invItr.getCurrentRef()
        singleCellOperation(cell)
        invItr.next()
