import sys
import os
import os.path
import cStringIO,traceback
import CMLParser


cc3dModuleDictionary={}
cc3dActiveSteerableList=[]
cc3dXML2ObjConverter=None
cc3dXML2ObjConverterAdapter=None
simulationXMLDescription=None
simulationObjectsCreated=False
simulationPythonScriptName=""
simulationFileName=""
screenshotDirectoryName=""
global simulationThreadObject
simulationThreadObject=None
global cmlParser
cmlParser=CMLParser.CMLParser()
#PERHAPS I SHOULD ADD A CLASS WHICH WOULD CONTROL CML version



global cmlFieldHandler
cmlFieldHandler=None
playerType="old"
# global cc3dXML2ObjConverter_1
# cc3dXML2ObjConverter_1=None
# cc3dXML2ObjConverter_2=None

class CC3DCPlusPlusError(Exception):
    def __init__(self, _message):
        self.message = _message
    def __str__(self):
        return repr(self.message)


# Class that handles all troubles with XML and Python files consistencies
class SimulationPaths:
    def __init__(self):
        self.lock=False

        self.playerSimulationXMLFileName=""
        self.playerSimulationPythonScriptName=""

        self.playerSimulationXMLFilePath=""
        self.playerSimulationPythonScriptPath=""

        self.pythonScriptNameFromXML=""
        self.pathToPythonScriptNameFromXML=""

        self.xmlFileNameFromPython=""
        self.pathToxmlFileNameFromPython=""

        # self.mainSimulationFile="" # this is the name of the main simulation file. It may contain references to other files. This is the file that is input from CML or from Player 
        self.simulationResultStorageDirectory="" #this is a place where the output of simulation will be written 
        self.simulationResultDescriptionFile="" #this is a place where the output of simulation is stored and where LDS file is stored 
        
        #these two variables store XML and python files that are actually used in the simulation
        self.simulationXMLFileName=""
        self.simulationPythonScriptName=""
    def setSimulationResultDescriptionFile(self,_fileName):
        self.simulationResultDescriptionFile=os.path.abspath(_fileName)
        self.simulationResultStorageDirectory=os.path.dirname(self.simulationResultDescriptionFile)
        
    def getSimulationResultStorageDirectory(self):
        return self.simulationResultStorageDirectory

    def setSimulationResultStorageDirectory(self, _path,_useTimeExtension=False):
        mainDirName=os.path.dirname(os.path.abspath(_path))
        baseName=os.path.basename(os.path.abspath(_path))
        baseName=baseName.replace('.','_')
        if not _useTimeExtension:
            self.simulationResultStorageDirectory=os.path.join(mainDirName,baseName)
        else:
            import time
            timeNameExtension="_"+time.strftime("%m",time.localtime())+"_"+time.strftime("%d",time.localtime())+"_"+time.strftime("%Y",time.localtime())\
            +"_"+time.strftime("%H",time.localtime())+"_"+time.strftime("%M",time.localtime())+"_"+time.strftime("%S",time.localtime())
        
            self.simulationResultStorageDirectory=os.path.join(mainDirName,baseName+timeNameExtension)

            
        
    def getFullFileNameAndFilePath(self,_fileName,_filePath):
        if _fileName=="":
            return "",""
        fileName=os.path.abspath(_fileName)
        filePath=os.path.dirname(_fileName)
        return fileName,filePath


    def setPlayerSimulationXMLFileName(self,_playerSimulationXMLFileName):
        if self.lock:
            return
        self.playerSimulationXMLFileName=_playerSimulationXMLFileName
        self.playerSimulationXMLFileName, self.playerSimulationXMLFilePath = self.getFullFileNameAndFilePath( self.playerSimulationXMLFileName, self.playerSimulationXMLFilePath)

        if self.playerSimulationXMLFileName != "":
            assert os.path.exists(self.playerSimulationXMLFileName),"In the Player you requested XML file: \n"+self.playerSimulationXMLFileName\
            +"\nwhich does not exist.\nPlease pick different XML file "

        self.simulationXMLFileName=self.playerSimulationXMLFileName


    def setPlayerSimulationPythonScriptName(self,_playerSimulationPythonScriptName):
        if self.lock:
            return
        self.playerSimulationPythonScriptName=_playerSimulationPythonScriptName
        self.playerSimulationPythonScriptName, self.playerSimulationPythonScriptPath = self.getFullFileNameAndFilePath(self.playerSimulationPythonScriptName,self.playerSimulationPythonScriptPath)

        if self.playerSimulationPythonScriptName !="":
            assert os.path.exists(self.playerSimulationPythonScriptName),"In the Player you requested Python script: \n"\
            +self.playerSimulationPythonScriptName+"\nwhich does not exist.\nPlease pick different script"


        self.simulationPythonScriptName=self.playerSimulationPythonScriptName

    def setPythonScriptNameFromXML(self,_pythonScriptNameFromXML):
        if self.lock:
            return
        self.pythonScriptNameFromXML=_pythonScriptNameFromXML
        self.pythonScriptNameFromXML,self.pathToPythonScriptNameFromXML = self.getFullFileNameAndFilePath(self.pythonScriptNameFromXML,self.pathToPythonScriptNameFromXML)

        if self.simulationPythonScriptName=="":
            assert os.path.exists(self.pythonScriptNameFromXML),"In the XML file you have specified Python script: \n"+self.pythonScriptNameFromXML\
            +"  which does not exist.\n Please specify different Python script"
            self.simulationPythonScriptName=self.pythonScriptNameFromXML


    def setXmlFileNameFromPython(self,_xmlFileNameFromPython):
        if self.lock:
            return
        self.xmlFileNameFromPython=_xmlFileNameFromPython
        self.xmlFileNameFromPython , self.pathToxmlFileNameFromPython = self.getFullFileNameAndFilePath(self.xmlFileNameFromPython , self.pathToxmlFileNameFromPython)

        if self.simulationXMLFileName=="":
            assert os.path.exists(self.xmlFileNameFromPython),"In the Python script you requested XML file: \n"+self.xmlFileNameFromPython\
            +"  which does not exist.\n Please specify different XML file"
            self.simulationXMLFileName=self.xmlFileNameFromPython;



    def ensurePathsConsistency(self):
        self.lock=True
        if self.playerSimulationXMLFileName!="" and self.xmlFileNameFromPython =="":
            self.simulationXMLFileName = self.playerSimulationXMLFileName
        if self.playerSimulationXMLFileName=="" and self.xmlFileNameFromPython !="":
            self.simulationXMLFileName = self.xmlFileNameFromPython
        if self.playerSimulationXMLFileName!="" and self.xmlFileNameFromPython !="":
            assert self.playerSimulationXMLFileName == self.xmlFileNameFromPython,"XML file specified in the player: \n"+self.playerSimulationXMLFileName\
            +"\nis different from XML file set in the Python script: \n"+self.xmlFileNameFromPython\
            +"\nPlease make sure the two XML files are the same\n"\
            +"You may also try removing line in the Python script where you set XML file name or unselect XML file in the Player"
            self.simulationXMLFileName = self.xmlFileNameFromPython




        if self.playerSimulationPythonScriptName !="" and self.pythonScriptNameFromXML == "":
            self.simulationPythonScriptName = self.playerSimulationPythonScriptName

        if self.playerSimulationPythonScriptName =="" and self.pythonScriptNameFromXML != "":
            self.simulationPythonScriptName = self.pythonScriptNameFromXML
        if self.playerSimulationPythonScriptName !="" and self.pythonScriptNameFromXML != "":
            assert self.playerSimulationPythonScriptName == self.pythonScriptNameFromXML,"Python script from Player: \n"+self.playerSimulationPythonScriptName\
            +"\nis different than Python script specified in XML: \n"+self.pythonScriptNameFromXML\
            +"\nPlease make sure the two scripts are the same\n"\
            +"You may also try removing <PythonScript> tag from XML or unselecting Python script in the Player"
            self.simulationPythonScriptName=self.playerSimulationPythonScriptName



        global simulationPythonScriptName
        simulationPythonScriptName=self.simulationPythonScriptName

        simulationFileName=self.simulationXMLFileName

        print "simulationPythonScriptName=",simulationPythonScriptName," simulationFileName=",simulationFileName
        assert not( simulationFileName=="" and simulationPythonScriptName==""), "You have not specified any simulation file"




simulationPaths=SimulationPaths() #will store simulation file names and paths and check if paths are correct

def setSimulationXMLFileName(_simulationFileName):
    global simulationPaths
    simulationPaths.setXmlFileNameFromPython(_simulationFileName)
#     print "\n\n\n got here ",simulationPaths.simulationXMLFileName




# Load data for Plugins, Steppables and Potts
def initModules(sim,_cc3dXML2ObjConverter):
    import XMLUtils
#     global cc3dXML2ObjConverter

    pluginDataList=XMLUtils.CC3DXMLListPy(_cc3dXML2ObjConverter.root.getElements("Plugin"))
    for pluginData in pluginDataList:
        print "Element",pluginData.name
        sim.ps.addPluginDataCC3D(pluginData)

    steppableDataList=XMLUtils.CC3DXMLListPy(_cc3dXML2ObjConverter.root.getElements("Steppable"))
    for steppableData in steppableDataList:
        print "Element",steppableData.name
        sim.ps.addSteppableDataCC3D(steppableData)

    pottsDataList=XMLUtils.CC3DXMLListPy(_cc3dXML2ObjConverter.root.getElements("Potts"))
    assert pottsDataList.getBaseClass().size()<=1, 'You have more than 1 definition of the Potts section'
    if pottsDataList.getBaseClass().size()==1:
        for pottsData in pottsDataList:
            print "Element",pottsData.name
            sim.ps.addPottsDataCC3D(pottsData)




#     print "\n\n\n\n\n ITERATION"
#     walker=XMLUtils.CC3DXMLElementWalker()
#     walker.iterateCC3DXMLElement(cc3dXML2ObjConverter.root)

def parseXML(_simulationFileName):
    global cc3dXML2ObjConverter
    import XMLUtils
    cc3dXML2ObjConverter = XMLUtils.Xml2Obj()
    root_element=cc3dXML2ObjConverter.Parse(_simulationFileName)
    
    
    
    # global cc3dXML2ObjConverter_1
    # cc3dXML2ObjConverter_1=XMLUtils.Xml2Obj()
    # root_element_1=cc3dXML2ObjConverter_1.Parse(_simulationFileName)    
    # import time
    # time.sleep(2)
    
    
    # text = raw_input(' PARSING XML->')
    
    # print "PARSED cc3dXML2ObjConverter_1"
    # print "cc3dXML2ObjConverter_1.root=",cc3dXML2ObjConverter_1.root
    
class XML2ObjConverterAdapter:
    def __init__(self):
        self.root=None
        self.xmlTree=None

def setSimulationXMLDescription(_xmlTree):
    if playerType=="CML":
        setSimulationXMLDescriptionNewPlayer(_xmlTree)
    else:
        if simulationThreadObject is None:
            setSimulationXMLDescriptionOldPlayer(_xmlTree)
        else:
            setSimulationXMLDescriptionNewPlayer(_xmlTree)
    # global cc3dXML2ObjConverterAdapter
    # cc3dXML2ObjConverterAdapter=XML2ObjConverterAdapter()
    # cc3dXML2ObjConverterAdapter.xmlTree=_xmlTree
    # cc3dXML2ObjConverterAdapter.root=_xmlTree.CC3DXMLElement

def setSimulationXMLDescriptionNewPlayer(_xmlTree):    
    global cc3dXML2ObjConverter
    cc3dXML2ObjConverter=XML2ObjConverterAdapter()
    cc3dXML2ObjConverter.xmlTree=_xmlTree
    cc3dXML2ObjConverter.root=_xmlTree.CC3DXMLElement
     
def setSimulationXMLDescriptionOldPlayer(_xmlTree):    
    global cc3dXML2ObjConverterAdapter
    cc3dXML2ObjConverterAdapter=XML2ObjConverterAdapter()
    cc3dXML2ObjConverterAdapter.xmlTree=_xmlTree
    cc3dXML2ObjConverterAdapter.root=_xmlTree.CC3DXMLElement

    
def getScreenshotDirectoryName():
    global screenshotDirectoryName
    return screenshotDirectoryName    
    
def getCoreSimulationObjectsOldPlayer(_parseOnlyFlag=False):
#     try:
    import sys
    from os import environ
    import string
    sys.path.append(environ["PYTHON_MODULE_PATH"])

    import SystemUtils
    SystemUtils.setSwigPaths()
    SystemUtils.initializeSystemResources()
    # this dummy library was necessary to get restarting of the Python interpreter from C++ to work with SWIG generated libraries
    import Example
    import PlayerPython
    import CompuCell
    CompuCell.initializePlugins()

    simthread=PlayerPython.getSimthreadBasePtr()
    sim=None

    #Here I will extract file names from the Player . Note that this is doe only if the _parseOnlyFlag is set i.e. when we determine which files to use
    if _parseOnlyFlag:
        global simulationPaths

        if simthread is not None:
             xmlfile = simthread.getSimulationFileName()
             script  = simthread.getSimulationPythonScriptName()
        else:
             xmlfile = filename
             script  = ""

        simulationPaths.setPlayerSimulationXMLFileName(xmlfile)
        simulationPaths.setPlayerSimulationPythonScriptName(script)

    if simulationPaths.simulationXMLFileName!="" and _parseOnlyFlag:

        global cc3dXML2ObjConverter
        import XMLUtils
        parseXML(simulationPaths.simulationXMLFileName)

        # will try extracting python script name from simulation description if the one from Player is = ""


        global simulationPaths
        if cc3dXML2ObjConverter.root.findElement("PythonScript"):
            simulationPaths.setPythonScriptNameFromXML(cc3dXML2ObjConverter.root.getFirstElement("PythonScript").getText())

    if not _parseOnlyFlag:
        sim=CompuCell.Simulator()
        if simthread is not None:
            simthread.setSimulator(sim)


        if simulationPaths.simulationXMLFileName!="":

            global simulationPaths
            global cc3dXML2ObjConverter
            import XMLUtils

            parseXML(simulationPaths.simulationXMLFileName)

            if cc3dXML2ObjConverter.root.findElement("PythonScript"):
                simulationPaths.setPythonScriptNameFromXML(cc3dXML2ObjConverter.root.getFirstElement("PythonScript").getText())

        simulationPaths.ensurePathsConsistency()

        #here I will append path to search paths based on the paths to XML file and Python script paths
        if simulationPaths.playerSimulationPythonScriptPath != "":
            sys.path.append(simulationPaths.playerSimulationPythonScriptPath)

        if simulationPaths.pathToPythonScriptNameFromXML !="":
            sys.path.append(simulationPaths.pathToPythonScriptNameFromXML)

        if simulationPaths.playerSimulationXMLFilePath !="":
            sys.path.append(simulationPaths.playerSimulationXMLFilePath)

        if simulationPaths.pathToxmlFileNameFromPython!="":
            sys.path.append(simulationPaths.pathToxmlFileNameFromPython)


        # initModules(sim)#extracts Plugins, Steppables and Potts XML elements and passes it to the simulator


        global simulationObjectsCreated
        simulationObjectsCreated = True




#     print "sim=",sim
    return sim,simthread



def getCoreSimulationObjectsNewPlayer(_parseOnlyFlag=False,_cmlOnly=False):

    import sys
    from os import environ
    import string
    sys.path.append(environ["PYTHON_MODULE_PATH"])

    import SystemUtils
    SystemUtils.setSwigPaths()
    SystemUtils.initializeSystemResources()
    # this dummy library was necessary to get restarting of the Python interpreter from C++ to work with SWIG generated libraries
    import Example

    import CompuCell
    CompuCell.initializePlugins()
    simthread=None
        
    sim=None

    #Here I will extract file names from the Player . Note that this is doe only if the _parseOnlyFlag is set i.e. when we determine which files to use
    # if _parseOnlyFlag:
        # global simulationPaths

        # if simthread is not None:
             # xmlfile = simthread.getSimulationFileName()
             # script  = simthread.getSimulationPythonScriptName()
        # else:
             # xmlfile = filename
             # script  = ""

        # simulationPaths.setPlayerSimulationXMLFileName(xmlfile)
        # simulationPaths.setPlayerSimulationPythonScriptName(script)

    # if simulationPaths.simulationXMLFileName!="" and _parseOnlyFlag:

        # global cc3dXML2ObjConverter
        # import XMLUtils
        # parseXML(simulationPaths.simulationXMLFileName)

        # # will try extracting python script name from simulation description if the one from Player is = ""


        # global simulationPaths
        # if cc3dXML2ObjConverter.root.findElement("PythonScript"):
            # simulationPaths.setPythonScriptNameFromXML(cc3dXML2ObjConverter.root.getFirstElement("PythonScript").getText())
    global simulationPaths
    if not _parseOnlyFlag:
        sim=CompuCell.Simulator()
        sim.setNewPlayerFlag(True);
        if simthread is not None:
            simthread.setSimulator(sim)


        if simulationPaths.simulationXMLFileName!="":

            global simulationPaths
            global cc3dXML2ObjConverter
            import XMLUtils


            
            parseXML(simulationPaths.simulationXMLFileName)

            if cc3dXML2ObjConverter.root.findElement("PythonScript"):
                simulationPaths.setPythonScriptNameFromXML(cc3dXML2ObjConverter.root.getFirstElement("PythonScript").getText())

        simulationPaths.ensurePathsConsistency()

        #here I will append path to search paths based on the paths to XML file and Python script paths
        if simulationPaths.playerSimulationPythonScriptPath != "":
            sys.path.append(simulationPaths.playerSimulationPythonScriptPath)

        if simulationPaths.pathToPythonScriptNameFromXML !="":
            sys.path.append(simulationPaths.pathToPythonScriptNameFromXML)

        if simulationPaths.playerSimulationXMLFilePath !="":
            sys.path.append(simulationPaths.playerSimulationXMLFilePath)

        if simulationPaths.pathToxmlFileNameFromPython!="":
            sys.path.append(simulationPaths.pathToxmlFileNameFromPython)


        # initModules(sim)#extracts Plugins, Steppables and Potts XML elements and passes it to the simulator


        global simulationObjectsCreated
        simulationObjectsCreated = True


    if not _cmlOnly:
        simulationThreadObject.sim=sim
        return sim,simulationThreadObject
    else:
        # global cmlFieldHandler
        # import CMLFieldHandler
        
        # cmlFieldHandler=CMLFieldHandler.CMLFieldHandler()
        # cmlFieldHandler.sim=sim
        createCMLFileHandler(sim)
        return sim,cmlFieldHandler    


def createCMLFileHandler(sim):
    global cmlFieldHandler
    import CMLFieldHandler
      
    cmlFieldHandler=CMLFieldHandler.CMLFieldHandler()
    cmlFieldHandler.sim=sim

def getCoreSimulationObjectsNewPlayerCMLReplay(_parseOnlyFlag=False,_cmlOnly=False):

    import sys
    from os import environ
    import string
    sys.path.append(environ["PYTHON_MODULE_PATH"])

    import SystemUtils
    SystemUtils.setSwigPaths()
    SystemUtils.initializeSystemResources()
    # this dummy library was necessary to get restarting of the Python interpreter from C++ to work with SWIG generated libraries
    import Example

    import CompuCell
    # CompuCell.initializePlugins()
    simthread=None
        
    sim=None


    # global cmlFieldHandler
    # import CMLResultReader
    
    # cmlFieldHandler=CMLResultReader.CMLResultReader()
    
    # return sim,cmlFieldHandler    

    return sim,simulationThreadObject

    
def getCoreSimulationObjects(_parseOnlyFlag=False):
    global playerType
    if playerType=="CML":
        return getCoreSimulationObjectsNewPlayer(_parseOnlyFlag,True) 
        
    if playerType=="CMLResultReplay":
        return getCoreSimulationObjectsNewPlayerCMLReplay(_parseOnlyFlag) 
        
    if simulationThreadObject is None:
        return getCoreSimulationObjectsOldPlayer(_parseOnlyFlag)
    else:
        return getCoreSimulationObjectsNewPlayer(_parseOnlyFlag)

def createCMLFieldHandler():
    global cmlFieldHandler
    import CMLFieldHandler
      
    cmlFieldHandler=CMLFieldHandler.CMLFieldHandler()
    # cmlFieldHandler.sim=sim
    print "created cmlFieldHandler=",cmlFieldHandler
    
def initCMLFieldHandler(sim,simulationResultStorageDirectory,_fieldStorage):    
    global cmlFieldHandler
    cmlFieldHandler.sim=sim
    # print "assignedSimulator object sim= ",cmlFieldHandler.sim
    # sys.exit()
    cmlFieldHandler.fieldWriter.init(sim)
    cmlFieldHandler.setFieldStorage(_fieldStorage)
    # cmlFieldHandler.getInfoAboutFields()
    # cmlFieldHandler.outputFrequency=cmlParser.outputFrequency
    # cmlFieldHandler.outputFileCoreName=cmlParser.outputFileCoreName
    cmlFieldHandler.prepareSimulationStorageDir(simulationResultStorageDirectory)
    cmlFieldHandler.setMaxNumberOfSteps(sim.getNumSteps()) # will determine the length text field  of the step number suffix 
    # cmlFieldHandler.writeXMLDescriptionFile() # initialization of the cmlFieldHandler is done - we can write XML description file                     
    
    # sys.exit()
    

      
def ExtractPythonScriptNameFromXML(_simulationXMLFileName):
    
    import XMLUtils
    cc3dXML2ObjConverterTmp = XMLUtils.Xml2Obj()
    root_element_tmp=cc3dXML2ObjConverterTmp.Parse(_simulationXMLFileName)
    
    # parseXML(_simulationXMLFileName)

    # will try extracting python script name from simulation description if the one from Player is = ""


    global simulationPaths
    if cc3dXML2ObjConverterTmp.root.findElement("PythonScript"):
        pythonScriptName=os.path.abspath(cc3dXML2ObjConverterTmp.root.getFirstElement("PythonScript").getText())
        return pythonScriptName
    else:
        return ""

def clearActiveSteerableList(_list):
    while len(_list):
        _list.pop()

def getModuleParseData(moduleName):
    for key in cc3dModuleDictionary.keys():
        print "This a name of a module: ",cc3dModuleDictionary[key].moduleName
    return cc3dModuleDictionary[moduleName]

def steer(_parseData):
    cc3dActiveSteerableList.append(_parseData)

def executeSteering(_sim):
    for pd in cc3dActiveSteerableList:
        module=_sim.getSteerableObject(pd.moduleName)
        module.update(pd)
    clearActiveSteerableList(cc3dActiveSteerableList)


def registerPlugin(_sim, _pd):
    _sim.ps.addPluginData(_pd)
#     _sim.ps.pluginParseDataVector.push_back(_pd)
    cc3dModuleDictionary[_pd.moduleName]=_pd

def registerSteppable(_sim, _pd):
    _sim.ps.addSteppableData(_pd)
#     _sim.ps.steppableParseDataVector.push_back(_pd)
    cc3dModuleDictionary[_pd.moduleName]=_pd

def registerPotts(_sim, _pd):
    _sim.ps.addPottsData(_pd)
    cc3dModuleDictionary[_pd.moduleName]=_pd

def getSteppableRegistry():
    from PySteppables import SteppableRegistry
    steppableRegistry=SteppableRegistry()
    return steppableRegistry

def getEnergyFunctionRegistry(sim):
    import CompuCell
    energyFunctionRegistry=CompuCell.EnergyFunctionPyWrapper()
    energyFunctionRegistry.setSimulator(sim)
    energyFunctionRegistry.setPotts(sim.getPotts())
    sim.getPotts().registerEnergyFunction(energyFunctionRegistry.getEnergyFunctionPyWrapperPtr())
    return energyFunctionRegistry
    
def getChangeWatcherRegistry(sim):
    import CompuCell
    changeWatcherRegistry=CompuCell.ChangeWatcherPyWrapper() 
    changeWatcherRegistry.setSimulator(sim)
    changeWatcherRegistry.setPotts(sim.getPotts())
    sim.getPotts().registerCellGChangeWatcher(changeWatcherRegistry.getChangeWatcherPyWrapperPtr())
    return changeWatcherRegistry

def getStepperRegistry(sim):
    import CompuCell
    stepperRegistry=CompuCell.StepperPyWrapper()
    stepperRegistry.setSimulator(sim)
    stepperRegistry.setPotts(sim.getPotts())
    sim.getPotts().registerStepper(stepperRegistry.getStepperPyWrapperPtr())
    return stepperRegistry


def ExtractLatticeType():
    global cc3dXML2ObjConverter
    if cc3dXML2ObjConverter.root.findElement("Potts"):
        if cc3dXML2ObjConverter.root.getFirstElement("Potts").findElement("LatticeType"):
            return cc3dXML2ObjConverter.root.getFirstElement("Potts").getFirstElement("LatticeType").getText()
            
    return ""

def ExtractTypeNamesAndIds():
    global cc3dXML2ObjConverter    
    pluginElements=cc3dXML2ObjConverter.root.getElements("Plugin")
    
    from XMLUtils import CC3DXMLListPy
    listPlugin=CC3DXMLListPy(pluginElements)
    typeIdTypeNameDict={}
    for element in listPlugin:
    
        if element.getAttribute("Name")=="CellType":
            cellTypesElements=element.getElements("CellType")
    
            listCellTypeElements=CC3DXMLListPy(cellTypesElements)
            for cellTypeElement in listCellTypeElements:
                typeName=""
                typeId=0
                typeName=cellTypeElement.getAttribute("TypeName")
                typeId=cellTypeElement.getAttributeAsInt("TypeId")
                typeIdTypeNameDict[typeId]=typeName
    
    
    return typeIdTypeNameDict
    
def initializeSimulationObjects(sim,simthread):
    if not playerType=="CMLResultReplay":
        global cc3dXML2ObjConverter
        global cc3dXML2ObjConverterAdapter
        if cc3dXML2ObjConverter is not None:
            initModules(sim,cc3dXML2ObjConverter)#extracts Plugins, Steppables and Potts XML elements and passes it to the simulator
        if cc3dXML2ObjConverterAdapter is not None:
            initModules(sim,cc3dXML2ObjConverterAdapter)

        sim.initializeCC3D()
    
    print "SIMTHREAD=",simthread
    if simthread is not None:
        simthread.clearGraphicsFields()


def attachDictionaryToCells(sim):
    from CompuCell import PyAttributeAdder
    from PyDictAdder import DictAdder
    #from sys import getrefcount
    adder=PyAttributeAdder()
    #adder.registerRefChecker(getrefcount)
    dictAdder=DictAdder()
    adder.registerAdder(dictAdder)
    potts=sim.getPotts()
    potts.registerAttributeAdder(adder.getPyAttributeAdderPtr())
    return adder,dictAdder #returning those two objects ensures that they will not be garbage collected. They are needed for proper functioning of the attribute adder

def attachListToCells(sim):
    from CompuCell import PyAttributeAdder
    from PyListAdder import ListAdder
    #from sys import getrefcount
    adder=PyAttributeAdder()
    #adder.registerRefChecker(getrefcount)
    listAdder=ListAdder()
    adder.registerAdder(listAdder)
    potts=sim.getPotts()
    potts.registerAttributeAdder(adder.getPyAttributeAdderPtr())
    return adder,listAdder #returning those two objects ensures that they will not be garbage collected. They are needed for proper functioning of the attribute adder

def extraInitSimulationObjects(sim,simthread):
    if playerType=="CMLResultReplay":
        simthread.preStartInit()
        simthread.postStartInit()
    else:
        
        sim.extraInit()#after all xml steppables and plugins have been loaded we call extraInit to complete initialization
        if sim.getRecentErrorMessage()!="":        
            raise CC3DCPlusPlusError(sim.getRecentErrorMessage())
    
        if simthread is not None and playerType!="CML":
            simthread.preStartInit()
        
        sim.start()
        if sim.getRecentErrorMessage()!="":        
            raise CC3DCPlusPlusError(sim.getRecentErrorMessage())
    
        if simthread is not None and playerType!="CML":
            simthread.postStartInit()
  
def createVectorFieldCellLevelPy(_fieldName):
    import string
    fieldName=string.replace(_fieldName," ","_") # replacing spaces with underscore

    if playerType=="CML":    
        field=cmlFieldHandler.fieldStorage.createVectorFieldCellLevelPy(fieldName)
        return field
    else:
        field = simulationThreadObject.callingWidget.fieldStorage.createVectorFieldCellLevelPy(fieldName)
        return field

def createVectorFieldPy(_dim,_fieldName):
    import string
    fieldName=string.replace(_fieldName," ","_") # replacing spaces with underscore

    if playerType=="CML":
        field=cmlFieldHandler.fieldStorage.createVectorFieldPy(_dim,fieldName)
        return field
    else:
        field = simulationThreadObject.callingWidget.fieldStorage.createVectorFieldPy(_dim,fieldName)
        return field

def clearVectorFieldPy(_dim, _vectorField):
    if playerType=="CML":
        cmlFieldHandler.fieldStorage.clearVectorFieldPy(_dim,_vectorField)
    else:
        simulationThreadObject.callingWidget.fieldStorage.clearVectorFieldPy(_dim,_vectorField)
    
    
def createScalarFieldPy(_dim,_fieldName):
    return createFloatFieldPy(_dim,_fieldName)
   
def createFloatFieldPy(_dim,_fieldName):
    import string
    fieldName=string.replace(_fieldName," ","_") # replacing spaces with underscore

    if playerType=="CML":
        field=cmlFieldHandler.fieldStorage.createFloatFieldPy(_dim,_fieldName)    
        return field
    else:
        # import string
        # fieldName=string.replace(_fieldName," ","_") # replacing spaces with underscore
        field = simulationThreadObject.callingWidget.fieldStorage.createFloatFieldPy(_dim,_fieldName)
        return field

def createScalarFieldCellLevelPy(_fieldName):
    import string
    fieldName=string.replace(_fieldName," ","_") # replacing spaces with underscore
    if playerType=="CML":
        field=cmlFieldHandler.fieldStorage.createScalarFieldCellLevelPy(_fieldName)    
        return field        
    else:
        field = simulationThreadObject.callingWidget.fieldStorage.createScalarFieldCellLevelPy(_fieldName)
        return field

def doNotOutputField(_fieldName):
    print "cmlFieldHandler = ",cmlFieldHandler
    if cmlFieldHandler:
        cmlFieldHandler.doNotOutputField(_fieldName) 
        print "\n\n\n\n cmlFieldHandler.doNotOutputFieldList=",cmlFieldHandler.doNotOutputFieldList,"\n\n\n"
    # sys.exit()   
    
def mainLoopOldPlayer(sim, simthread, steppableRegistry= None, _screenUpdateFrequency = None):
    extraInitSimulationObjects(sim,simthread)
    runFinishFlag = True;
    
    if not steppableRegistry is None:
        steppableRegistry.init(sim)
        steppableRegistry.start()

    screenUpdateFrequency=1

    for i in range(sim.getNumSteps()):
        if simthread is not None:
            if simthread.getStopSimulation():
                runFinishFlag=False;
                break
        sim.step(i)
    
        if not steppableRegistry is None:
            steppableRegistry.step(i)
        # steer application will only update modules that uses requested using updateCC3DModule function from simulator
        sim.steer() 

        if not i % screenUpdateFrequency and simthread is not None:
            simthread.loopWork(i)
            simthread.loopWorkPostEvent(i)
            screenUpdateFrequency = simthread.getScreenUpdateFrequency()
    if runFinishFlag:
        sim.finish()
        steppableRegistry.finish()
    else:
        sim.unloadModules()
        if simthread is not None:
            simthread.sendStopSimulationRequest()
    
    #In exception handlers you have to call sim.finish to unload the plugins .
    #We may need to introduce new funuction name (e.g. unload) because finish does more than unloading
        

def mainLoopNewPlayer(sim, simthread, steppableRegistry= None, _screenUpdateFrequency = None):
    
    extraInitSimulationObjects(sim,simthread)
    runFinishFlag = True;
    
    if not steppableRegistry is None:
        steppableRegistry.init(sim)
        steppableRegistry.start()

    screenUpdateFrequency=1
    # global cmlFieldHandler 
    # print "this is cmlFieldHandler  ",cmlFieldHandler
    # # sys.exit()
    # if cmlFieldHandler:
        # cmlFieldHandler.fieldWriter.init(sim)
        # cmlFieldHandler.getInfoAboutFields()
        # cmlFieldHandler.outputFrequency=cmlParser.outputFrequency
        # cmlFieldHandler.outputFileCoreName=cmlParser.outputFileCoreName
        # cmlFieldHandler.prepareSimulationStorageDir(simulationPaths.simulationResultStorageDirectory)
        # cmlFieldHandler.setMaxNumberOfSteps(sim.getNumSteps()) # will determine the length text field  of the step number suffix 
        # cmlFieldHandler.writeXMLDescriptionFile() # initialization of the cmlFieldHandler is done - we can write XML description file
        # sys.exit()

    xmlDescriptionFileWritten=False    
    # if simthread is not None and cmlFieldHandler is not None:
        # simthread.beforeStep(0) 
        # cmlFieldHandler.getInfoAboutFields()
        # cmlFieldHandler.writeXMLDescriptionFile()
        
    for i in range(sim.getNumSteps()):
        if simthread is not None:

        
        

                
                
            simthread.beforeStep(i)                
            # will wait until initialization of the player is finished before proceeding further
            if cmlFieldHandler and not xmlDescriptionFileWritten:
                print "BEFORE getInfoAboutFields"
                print "cmlFieldHandler.sim=",cmlFieldHandler.sim
                cmlFieldHandler.getInfoAboutFields()
                cmlFieldHandler.writeXMLDescriptionFile()
                xmlDescriptionFileWritten=True
                print cmlFieldHandler.doNotOutputFieldList            
                
            if simthread.getStopSimulation():
                runFinishFlag=False;
                break
                
        sim.step(i)#  steering using steppables     
        if sim.getRecentErrorMessage()!="":        
            raise CC3DCPlusPlusError(sim.getRecentErrorMessage())
        
        simthread.steerUsingGUI(sim) #steering using GUI. GUI steering overrides steering done in the steppables
        
    
        if not steppableRegistry is None:
            steppableRegistry.step(i)
        # steer application will only update modules that uses requested using updateCC3DModule function from simulator
        sim.steer() 
        if sim.getRecentErrorMessage()!="":        
            raise CC3DCPlusPlusError(sim.getRecentErrorMessage())

        
        screenUpdateFrequency = simthread.getScreenUpdateFrequency()
        screenshotFrequency=simthread.getScreenshotFrequency()
        # print "screenUpdateFrequency=",screenUpdateFrequency," screenshotFrequency=",screenshotFrequency
        if ((not i % screenUpdateFrequency) or (not i % screenshotFrequency)) and simthread is not None:
            simthread.loopWork(i)
            simthread.loopWorkPostEvent(i)
            screenUpdateFrequency = simthread.getScreenUpdateFrequency()
            
        if cmlFieldHandler is not None and (not i % screenshotFrequency) :
            cmlFieldHandler.writeFields(i)
        

    print "END OF SIMULATION  "
    if runFinishFlag:
        sim.finish()
        if sim.getRecentErrorMessage()!="":        
            raise CC3DCPlusPlusError(sim.getRecentErrorMessage())        
        steppableRegistry.finish()
        simthread.simulationFinishedPostEvent(True)
        print "CALLING FINISH"
    else:
        sim.unloadModules()
        print "CALLING UNLOAD MODULES"
        if simthread is not None:
            simthread.sendStopSimulationRequest()
            simthread.simulationFinishedPostEvent(True)
            
    
    #In exception handlers you have to call sim.finish to unload the plugins .
    #We may need to introduce new funuction name (e.g. unload) because finish does more than unloading

    
def mainLoopCML(sim, simthread, steppableRegistry= None, _screenUpdateFrequency = None):
    extraInitSimulationObjects(sim,simthread)
    runFinishFlag = True;
    
    if not steppableRegistry is None:
        steppableRegistry.init(sim)
        steppableRegistry.start()
    # init fieldWriter    
    if cmlFieldHandler:
        cmlFieldHandler.fieldWriter.init(sim)
        cmlFieldHandler.getInfoAboutFields()
        cmlFieldHandler.outputFrequency=cmlParser.outputFrequency
        cmlFieldHandler.outputFileCoreName=cmlParser.outputFileCoreName
        cmlFieldHandler.prepareSimulationStorageDir(simulationPaths.simulationResultStorageDirectory)
        cmlFieldHandler.setMaxNumberOfSteps(sim.getNumSteps()) # will determine the length text field  of the step number suffix 
        cmlFieldHandler.writeXMLDescriptionFile() # initialization of the cmlFieldHandler is done - we can write XML description file
                

        # self.simulationXMLFileName=""
        # self.simulationPythonScriptName=""
        
        print "simulationPaths XML=",simulationPaths.simulationXMLFileName
        print "simulationPaths PYTHON=",simulationPaths.simulationPythonScriptName
        
        
    

    for i in range(sim.getNumSteps()):
                
        sim.step(i)#  steering using steppables     
        if sim.getRecentErrorMessage()!="":        
            raise CC3DCPlusPlusError(sim.getRecentErrorMessage())
        
        
        if not steppableRegistry is None:
            steppableRegistry.step(i)
            
        if cmlFieldHandler.outputFrequency and  not (i%cmlFieldHandler.outputFrequency):
            cmlFieldHandler.writeFields(i)
            # cmlFieldHandler.fieldWriter.addCellFieldForOutput()
            # cmlFieldHandler.fieldWriter.writeFields(cmlFieldHandler.outputFileCoreName+str(i)+".vtk")
            # cmlFieldHandler.fieldWriter.clear()
            
        # steer application will only update modules that uses requested using updateCC3DModule function from simulator
        sim.steer() 
        if sim.getRecentErrorMessage()!="":        
            raise CC3DCPlusPlusError(sim.getRecentErrorMessage())

    print "END OF SIMULATION  "
    if runFinishFlag:
        sim.finish()
    else:
        sim.unloadModules()
        print "CALLING UNLOAD MODULES"
            
    
    #In exception handlers you have to call sim.finish to unload the plugins .
    #We may need to introduce new funuction name (e.g. unload) because finish does more than unloading

def mainLoopCMLReplay(sim, simthread, steppableRegistry= None, _screenUpdateFrequency = None):
    extraInitSimulationObjects(sim,simthread)
    runFinishFlag = True;
    
    if not steppableRegistry is None:
        steppableRegistry.init(sim)
        steppableRegistry.start()

    screenUpdateFrequency=1
    
    numberOfSteps=len(simthread.ldsFileList)
    
    # for i in range(numberOfSteps):
    i=0
    mcsDirectAccess=0
    directAccessFlag=False
    while i<numberOfSteps :

        
        if simthread is not None:
            mcsDirectAccess,directAccessFlag=simthread.getCurrentStepDirectAccess()
        if directAccessFlag:
            print "GOT DIRECT FLAG AND mcsDirectAccess=",mcsDirectAccess
            simthread.resetDirectAccessFlag()
            i=mcsDirectAccess
            
          
        
        # print "working on MCS " , i
        if simthread is not None:
            simthread.readSimulationData(i)    
            simthread.beforeStep(i)                
            # print "simthread=",simthread
            if simthread.getStopSimulation():
                runFinishFlag=False;
                break
        if i>=numberOfSteps:
            break                 
        # print "currentStep=",simthread.getCurrentStep()
        # if simthread.getCurrentStep() != i:
            # i=simthread.getCurrentStep()                
            
        # sim.step(i)#  steering using steppables     
        # if sim.getRecentErrorMessage()!="":        
            # raise CC3DCPlusPlusError(sim.getRecentErrorMessage())
        
        # simthread.steerUsingGUI(sim) #steering using GUI. GUI steering overrides steering done in the steppables
        
    
        # if not steppableRegistry is None:
            # steppableRegistry.step(i)
        # steer application will only update modules that uses requested using updateCC3DModule function from simulator
        # sim.steer() 
        # if sim.getRecentErrorMessage()!="":        
            # raise CC3DCPlusPlusError(sim.getRecentErrorMessage())

        
        screenUpdateFrequency = simthread.getScreenUpdateFrequency()
        screenshotFrequency=simthread.getScreenshotFrequency()
        
        # print "screenUpdateFrequency=",screenUpdateFrequency," screenshotFrequency=",screenshotFrequency
        simthread.loopWork(i)
        simthread.loopWorkPostEvent(i)
        screenUpdateFrequency = simthread.getScreenUpdateFrequency()
        i+=1
        # if ((not i % screenUpdateFrequency) or (not i % screenshotFrequency)) and simthread is not None:
            # simthread.loopWork(i)
            # simthread.loopWorkPostEvent(i)
            # screenUpdateFrequency = simthread.getScreenUpdateFrequency()

    print "END OF SIMULATION  "
    if runFinishFlag:
        # sim.finish()
        # if sim.getRecentErrorMessage()!="":        
            # raise CC3DCPlusPlusError(sim.getRecentErrorMessage())        
        # steppableRegistry.finish()
        simthread.simulationFinishedPostEvent(True)
        print "CALLING FINISH"
    else:
        # sim.unloadModules()
        print "CALLING UNLOAD MODULES"
        if simthread is not None:
            simthread.sendStopSimulationRequest()
            simthread.simulationFinishedPostEvent(True)
            
    
    #In exception handlers you have to call sim.finish to unload the plugins .
    #We may need to introduce new funuction name (e.g. unload) because finish does more than unloading

    
def mainLoop(sim, simthread, steppableRegistry= None, _screenUpdateFrequency = None):
    global playerType
    print "playerType=",playerType
    
    if playerType=="CML":
        return mainLoopCML(sim, simthread, steppableRegistry, _screenUpdateFrequency )
    if playerType=="CMLResultReplay":
        return mainLoopCMLReplay(sim, simthread, steppableRegistry, _screenUpdateFrequency )
        
    
     
    if simulationThreadObject is None:
        return mainLoopOldPlayer(sim, simthread, steppableRegistry, _screenUpdateFrequency )
    else:
        return mainLoopNewPlayer(sim, simthread, steppableRegistry, _screenUpdateFrequency )
