# -*- coding: utf-8 -*-
import os,sys
from PyQt4 import QtCore, QtGui
from PyQt4.QtCore import *


    
class SimulationThread(QtCore.QThread):

    __pyqtSignals__ = ("completedStep(int)","simulationInitialized(bool)","errorOccured(QString,QString)","simulationFinished(bool)",)

    @QtCore.pyqtSignature("emitCompletedStep(int)")
    def emitCompletedStep(self,_mcs=None):
        self.emit(SIGNAL("completedStep(int)") , _mcs)
        

    @QtCore.pyqtSignature("simulationInitialized(bool)")
    def emitSimulationInitialized(self,_flag=True):
        self.emit(SIGNAL("simulationInitialized(bool)") , _flag)
        
    @QtCore.pyqtSignature("errorOccured(QString,QString)")
    def emitErrorOccured(self,_errorType,_traceback_message):
        self.emit(SIGNAL("errorOccured(QString,QString)") , QString(_errorType),QString(_traceback_message))

    @QtCore.pyqtSignature("simulationFinished(bool)")
    def emitSimulationFinished(self,_flag=True):
        self.emit(SIGNAL("simulationFinished(bool)") , _flag)
        
    # CONSTRUCTOR 
    def __init__(self, parent=None):
        QtCore.QThread.__init__(self, parent)

        #NOTE: to implement synchronization between threads we use semaphores. If yuou use mutexes for this then if you lokc mutex in one thread and try to unlock
        # from another thread than on Linux it will not work. Semaphores are better for this
        
        self.sem=QSemaphore(1)
        self.semPause=QSemaphore(1)
        # self.mutex = QtCore.QMutex()
        self.drawMutex = QtCore.QMutex()
        # self.pauseMutex = QtCore.QMutex()
        self.simulationInitialized=False
        self.stopThreadFlag=False
        self.stopped = False
        self.runUserPythonScriptFlag=False
        self.www=21
        self.xmlFileName=""
        self.pythonFileName=""
        self.screenUpdateFrequency=100
        self.screenshotFrequency=100
        self.callingWidget=None
        self.__simModel=None
        self.__mcs=0
        self.__fileWriter=None
	
	# Python 2.6 requires importing of Example, CompuCell and Player Python modules from an instance  of QThread class (here Simulation Thread inherits from QThread)
	# Simulation Thread communicates with SimpleTabView using SignalSlot method. If we dont import the three modules then when SimulationThread emits siglan and SimpleTabView
	# processes this signal in a slot (e.g. initializeSimulationViewWidget) than calling a member function of an object from e.g. Player Python (self.fieldStorage.allocateCellField(self.fieldDim))
	# results in segfault. Python 2.5 does not have this issue. Anyway this seems to work on Linux with Python 2.6
	# This might be a problem only on Linux 
	import Example
	import CompuCell
	import PlayerPython

        
        
        # self.condition = QtCore.QWaitCondition()
    def generatePIFFromRunningSimulation(self,_pifFileName):
        if self.__fileWriter is None:
            import PlayerPython
            self.__fileWriter=PlayerPython.FieldWriter()       
            self.__fileWriter.init(self.sim)
        self.__fileWriter.generatePIFFileFromCurrentStateOfSimulation(_pifFileName)
        
    def getCurrentStep(self):
        return self.__mcs
        
    def setCurrentStep(self,_mcs):
        self.__mcs=_mcs
    
    def setCallingWidget(self,_callingWidget):
        self.callingWidget=_callingWidget
    def setGraphicsWidget(self,_graphicsWidget):
        self.graphicsWidget=_graphicsWidget
    def setSimulationXMLFileName(self,_xmlFileName):
        import CompuCellSetup
        CompuCellSetup.simulationPaths.simulationXMLFileName=_xmlFileName
        self.xmlFileName=_xmlFileName
    
    def setSimulationPythonFileName(self,_pythonFileName):
        import CompuCellSetup
        CompuCellSetup.simulationPaths.simulationPythonScriptName=_pythonFileName
        self.pythonFileName=_pythonFileName
    
    def setRunUserPythonScriptFlag(self,_flag):
        self.runUserPythonScriptFlag=_flag
        
    def clearGraphicsFields(self):#added for compatibility reasons
        pass
    def preStartInit(self):#added for compatibility reasons
        pass
    def postStartInit(self):#added for compatibility reasons
        
        self.sem.acquire()
        
        self.emitSimulationInitialized()
        
    def setStopSimulation(self,_flag):#added for compatibility reasons
        self.stopped=_flag
    
    def getStopSimulation(self):#added for compatibility reasons
        return self.stopped
    
    def simulationFinishedPostEvent(self,_flag=True):
        self.emitSimulationFinished(_flag)
        
    def loopWork(self,_mcs):#added for compatibility reasons       
        self.drawMutex.lock()
        self.drawMutex.unlock()
        
    def loopWorkPostEvent(self,_mcs):#added for compatibility reasons
        if self.getStopSimulation():
            return       
        self.sem.acquire()
        self.emitCompletedStep(_mcs)
        
    def sendStopSimulationRequest(self):#added for compatibility reasons
        pass
        
    def createVectorFieldPy(self,_dim,_fieldName):
        import CompuCellSetup
        return CompuCellSetup.createVectorFieldPy(_dim,_fieldName)
        
    
    def createVectorFieldCellLevelPy(self,_fieldName):
        import CompuCellSetup
        return CompuCellSetup.createVectorFieldCellLevelPy(_fieldName)
        
    def createFloatFieldPy(self, _dim,_fieldName):
        import CompuCellSetup
        return CompuCellSetup.createFloatFieldPy(_dim,_fieldName)
        
    def createScalarFieldCellLevelPy(self,_fieldName):
        import CompuCellSetup
        return CompuCellSetup.createScalarFieldCellLevelPy(_fieldName)
    
    def getScreenUpdateFrequency(self):
        return self.screenUpdateFrequency
        
    def getScreenshotFrequency(self):
        return self.screenshotFrequency
        
    def beforeStep(self,_mcs):

        self.sem.acquire()
        self.sem.release()            
        self.semPause.acquire()
        self.semPause.release()            

        self.__mcs=_mcs
           
    def steerUsingGUI(self,_sim):
        if self.__simModel:
            # print "self.__simModel=",self.__simModel
            
            dirtyModulesDict=self.__simModel.getDirtyModules()
            if dirtyModulesDict and len(dirtyModulesDict.keys())>0:
                if dirtyModulesDict.has_key("Potts"):
                    _sim.updateCC3DModule(_sim.getCC3DModuleData("Potts"))
                    # print "NEW Temperature=",_sim.getCC3DModuleData("Potts").getFirstElement("Temperature").getText()
                if dirtyModulesDict.has_key("Plugin"):
                    dirtyPluginDict=dirtyModulesDict["Plugin"]
                    for pluginName in dirtyPluginDict:
                        # print "pluginName=",pluginName
                        _sim.updateCC3DModule(_sim.getCC3DModuleData("Plugin",pluginName))
                        # print "TARGET VOLUME=",_sim.getCC3DModuleData("Plugin","Volume").getFirstElement("TargetVolume").getText()
                        # print "_sim.getCC3DModuleData(\"Plugin\",\"Volume\").getFirstElement(\"TargetVolume\")=",_sim.getCC3DModuleData("Plugin","Volume").getFirstElement("TargetVolume")
                if dirtyModulesDict.has_key("Steppable"):
                    dirtySteppableDict=dirtyModulesDict["Steppable"]
                    for steppableName in dirtySteppableDict:
                        _sim.updateCC3DModule(_sim.getCC3DModuleData("Steppable",steppableName))
                 
                
                _sim.steer()
                
                dirtyModulesDict.clear()
            

        
    def setSimModel(self,_simModel):
        self.__simModel=_simModel
    
    def __del__(self):
        try:
            self.sem.acquire()
            self.semPause.acquire()
            
            # # # self.mutex.lock()
            # # # self.drawMutex.lock()
            self.stopped = True
        finally:
            self.sem.release()
            self.semPause.release()()
        
            # # # self.mutex.unlock()
            # # # self.drawMutex.unlock()


        # self.mutex.lock()
        # # self.abort = True
        # # self.condition.wakeOne()
        # self.mutex.unlock()

        self.wait()

    def stop(self):
        
        self.sem.tryAcquire()
        self.sem.release()
        
        
        self.stopped = True
        self.drawMutex.tryLock()
        self.drawMutex.unlock()

        self.semPause.tryAcquire()
        self.semPause.release()
        
    def prepareSimulation(self):
        import CompuCellSetup
        # CompuCellSetup.setSimulationXMLFileName(self.xmlFileName)
        (self.sim, self.simthread) = CompuCellSetup.getCoreSimulationObjects()
        
        import CompuCell         
        CompuCellSetup.initializeSimulationObjects(self.sim, self.simthread)
        CompuCellSetup.extraInitSimulationObjects(self.sim, self.simthread)
        self.simulationInitialized=True
        self.callingWidget.sim=self.sim
        
    def handleErrorMessage(self,_errorType,_traceback_message):
        print "INSIDE handleErrorMessage"
        print "_traceback_message=",_traceback_message
        self.emitErrorOccured(_errorType,_traceback_message)
        # self.callingWidget.handleErrorMessage(_errorType,_traceback_message)
        
    def runUserPythonScript(self,_scriptFileName,_globals,_locals):

        import CompuCellSetup
        CompuCellSetup.simulationThreadObject=self
            
        execfile("pythonSetupScripts/CompuCellPythonSimulationNewPlayer.py")
        
    def run(self):

        if self.runUserPythonScriptFlag:
            # print "runUserPythonScriptFlag=",self.runUserPythonScriptFlag
            globalDict={'simTabView':20}
            localDict={}
            
            self.runUserPythonScript(self.pythonFileName,globalDict,localDict)
