import sys, os

def setVTKPaths():
   #import sys
   #from os import environ
   import string
   #import sys
   platform=sys.platform
   if platform=='win32':
      sys.path.append(os.environ["VTKPATH"])
      sys.path.append(os.environ["VTKPATH1"])
      sys.path.append(os.environ["PYQT_PATH"])
      sys.path.append(os.environ["SIP_PATH"])
      sys.path.append(os.environ["SIP_UTILS_PATH"])
#   else:
#      swig_path_list=string.split(environ["VTKPATH"])
#      for swig_path in swig_path_list:
#         sys.path.append(swig_path)


setVTKPaths()

from PyQt4.QtCore import *
from PyQt4.QtGui import *

import Graphics

from PyQt4 import QtCore, QtGui,QtOpenGL
#import vtk
import Configuration
import vtk, math
#import sys, os

from Plugins.ViewManagerPlugins.SimpleTabView import FIELD_TYPES,PLANES
from DrawingParameters import DrawingParameters

MODULENAME='----- MVCDrawViewBase.py: '

class MVCDrawViewBase():
    def __init__(self, _drawModel , graphicsFrameWidget, parent=None):
        self.legendActor    = vtk.vtkScalarBarActor()
        (self.minCon, self.maxCon) = (0, 0)
        print "graphicsFrameWidget=",graphicsFrameWidget
        print "parent=",parent
        
        self.drawModel=_drawModel
        self.parentWidget=parent
        self.graphicsFrameWidget=graphicsFrameWidget
        self.qvtkWidget=self.graphicsFrameWidget.qvtkWidget
        self.currentDrawingFunction=None
        self.currentActors={} # dictionary of current actors
        self.drawingFcnName="" # holds a string describing name of the drawing fcn . Used to determine if current actors need to be removed before next drawing
        self.drawingFcnHasChanged=True
        self.fieldTypes=None 
        self.currentDrawingParameters=DrawingParameters()
        self.currentFieldType=("Cell_Field", FIELD_TYPES[0])
        self.__initDist=0 # initial camera distance - used in zoom functions

    def setDrawingFunctionName(self,_fcnName):
        # print "\n\n\n THIS IS _fcnName=",_fcnName," self.drawingFcnName=",self.drawingFcnName
        
        if self.drawingFcnName != _fcnName:
            self.drawingFcnHasChanged=True
        else:
            self.drawingFcnHasChanged=False
        self.drawingFcnName=_fcnName
        
    def clearDisplay(self):
        # print "CLEAR DISPLAY"
        for actor in self.currentActors:
            self.graphicsFrameWidget.ren.RemoveActor(self.currentActors[actor])
            
        self.currentActors.clear()
    
    def Render(self):
        self.graphicsFrameWidget.Render()
        
    #this is an ugly solution that seems to work on 32 bit machines. We will see if it will work on other machines        
    def extractAddressIntFromVtkObject(self,_vtkObj):
        # pointer_ia=ia.__this__
        # print "pointer_ia=",pointer_ia
        # address=pointer_ia[1:9]
        # print "address=",address," int(address)=",int(address,16)
        return self.parentWidget.fieldExtractor.unmangleSWIGVktPtrAsLong(_vtkObj.__this__)
        # return int(_vtkObj.__this__[1:9],16)
                        
    def setFieldTypes(self,_fieldTypes):
        self.fieldTypes=_fieldTypes        

    def setPlotData(self,_plotData):
        self.currentFieldType=_plotData        
        
    def drawFieldLocal(self, _bsd,_useFieldComboBox=True):
        fieldType=("Cell_Field", FIELD_TYPES[0])
        # print "FIELD TYPES=",self.fieldTypes
        # print "DrawLocal"
        plane=self.getPlane()
        self.drawModel.setDrawingParameters(_bsd,plane[0],plane[1],fieldType)
        
        self.currentDrawingParameters.bsd=_bsd
        self.currentDrawingParameters.plane=plane[0]
        self.currentDrawingParameters.planePos=plane[1]
        self.currentDrawingParameters.fieldName=fieldType[0]
        self.currentDrawingParameters.fieldType=fieldType[1]        
        self.drawModel.setDrawingParametersObject(self.currentDrawingParameters)
        
        if self.fieldTypes is not None:
            if _useFieldComboBox:
                name = str(self.graphicsFrameWidget.fieldComboBox.currentText())
                # print "name=",name
                # print "self.fieldTypes=",self.fieldTypes
                fieldType=(name, self.fieldTypes[name])                                    
                self.currentFieldType=fieldType
            else:                
                name = self.currentFieldType[0]
                # print "name=",name
                # print "self.fieldTypes=",self.fieldTypes
                fieldType=(name, self.fieldTypes[name])                    
                # print "fieldType=",fieldType
                self.currentFieldType=fieldType     # this assignment seems redundent but I keep it in order to make sure nothing breaks
                
            (currentPlane, currentPlanePos)=self.getPlane()
            self.setDrawingFunctionName("draw"+fieldType[1]+currentPlane)
#            print "---- MVCDrawViewBase.py: DrawingFunctionName=","draw"+fieldType[1]+currentPlane
            
            # # self.parentWidget.setFieldType((name, self.parentWidget.fieldTypes[name])) 
            plane=(currentPlane, currentPlanePos)
            self.drawModel.setDrawingParameters(_bsd,plane[0],plane[1],fieldType)
            
            self.currentDrawingParameters.bsd=_bsd
            self.currentDrawingParameters.plane=plane[0]
            self.currentDrawingParameters.planePos=plane[1]
            self.currentDrawingParameters.fieldName=fieldType[0]
            self.currentDrawingParameters.fieldType=fieldType[1]        
            self.drawModel.setDrawingParametersObject(self.currentDrawingParameters)
            
        self.drawField(_bsd,fieldType)
        self.qvtkWidget.repaint()
        
        
    def drawField(self, _bsd, fieldType): 
        # print "\n\n\n self.drawingFcnHasChanged=",self.drawingFcnHasChanged
          
        # print "THIS IS self.drawingFcnHasChanged=",self.drawingFcnHasChanged
        if self.drawingFcnHasChanged:
            self.clearDisplay()
        
        # print "fieldType=",fieldType[1]
        drawField = getattr(self, "draw" + fieldType[1])
        
        if self.currentDrawingFunction != drawField: # changing type of drawing function - need to remove actors that are currently displayed
            for actorName in self.currentActors.keys():
                self.ren.RemoveActor(self.currentActors[actorName])
                del self.currentActors[actorName]

            self.currentDrawingFunction=drawField
            
        drawField(_bsd, fieldType)
        
    def drawCellField(self, _bsd, fieldType): pass
    
    def drawConField(self, _bsd, fieldType): pass
    
    def drawVectorFieldCellLevel(self, _bsd, fieldType): pass
    
    def drawVectorField(self, _bsd, fieldType): pass
    
    def drawScalarFieldCellLevel(self, _bsd, fieldType): pass     
    
    def drawScalarField(self, _bsd, fieldType): pass     
    
    def showContours(self, enable): pass
    
    def setPlane(self, plane, pos): pass
    
    def getPlane(self):
        return ("",0)
    
    def getCamera(self):
        return self.ren.GetActiveCamera()
        
    def initSimArea(self, _bsd):
        fieldDim   = _bsd.fieldDim
        # sim.getPotts().getCellFieldG().getDim()
        self.setCamera(fieldDim)
       
    def configsChanged(self): pass
        
    # Transforms interval [0, 255] to [0, 1]
    def toVTKColor(self, val):
        return float(val)/255

    def largestDim(self, dim):
        ldim = dim[0]
        for i in range(len(dim)):
            if dim[i] > ldim:
                ldim = dim[i]
                
        return ldim
    
    def getSim3DFlag(self):
        zdim = self.currentDrawingParameters.bsd.fieldDim.z
#        print MODULENAME,'  getSim3DFlag, zdim=',zdim
        if zdim > 1:
            return True
        else:
            return False
    
    def setParams(self):
        # You can use either Build() method (256 color by default) or
        # SetNumberOfTableValues() to allocate much more colors!
        self.lut = vtk.vtkLookupTable()
        # You need to explicitly call Build() when constructing the LUT by hand     
        self.lut.Build()
        self.populateLookupTable()
        # self.dim = [100, 100, 1] # Default values
    
    def populateLookupTable(self):
        
        self.drawModel.populateLookupTable() # have to update colors in model objects
        colorMap = Configuration.getCellTypeColors("TypeColorMap")
        for key in colorMap.keys():
            r = colorMap[key].red()
            g = colorMap[key].green()
            b = colorMap[key].blue()
            self.lut.SetTableValue(key, self.toVTKColor(r), self.toVTKColor(g), self.toVTKColor(b), 1.0)
        # self.qvtkWidget.repaint()
        
        self.graphicsFrameWidget.Render()
        
    # Do I need this method?
    # Calculates min and max concentration
    def findMinMax(self, conField, dim):
        import CompuCell
        pt = CompuCell.Point3D() 

        maxCon = 0
        minCon = 0
        for k in range(dim[2]):
            for j in range(dim[1]):
                for i in range(dim[0]):
                    pt.x = i
                    pt.y = j
                    pt.z = k
                    
                    con = float(conField.get(pt))
                    
                    if maxCon < con:
                        maxCon = con
                    
                    if minCon > con:
                        minCon = con

        # Make sure that the concentration is positive
        if minCon < 0:
            minCon = 0

        return (minCon, maxCon)

    # Just returns min and max concentration
    def conMinMax(self):
        return (self.drawModel.minCon, self.drawModel.maxCon)
    
    def frac(self, con, minCon, maxCon):
        if maxCon == minCon:
            return 0.0
        else:
            frac = (con - minCon)/(maxCon - minCon)
            
        if frac > 1.0:
            frac = 1.0
            
        if frac < 0.0:
            frac = 0.0

        return frac

    def showLegend(self, enable):
        if enable:
            if not self.currentActors.has_key("LegendActor"):
                self.currentActors["LegendActor"]=self.legendActor
                self.graphicsFrameWidget.ren.AddActor(self.legendActor)
        else:
            if self.currentActors.has_key("LegendActor"):
                del self.currentActors["LegendActor"]
                self.graphicsFrameWidget.ren.RemoveActor(self.legendActor)
        self.Render()
        self.graphicsFrameWidget.repaint()
                
        # self.repaint()
    
    def setZoomItems(self, zitems):
        self.zitems = zitems

    def showBorder(self): pass
    def hideBorder(self): pass
    
    def showCells(self): pass
    def hideCells(self): pass
    
    def __zoomStep(self, delta):
        # # # print "ZOOM STEP"
        if self.graphicsFrameWidget.ren:
            # renderer = self.GetCurrentRenderer()
            camera = self.graphicsFrameWidget.ren.GetActiveCamera()
            
            zoomFactor = math.pow(1.02,(0.5*(delta/8)))

            # I don't know why I might need the parallel projection
            if camera.GetParallelProjection(): 
                parallelScale = camera.GetParallelScale()/zoomFactor
                camera.SetParallelScale(parallelScale)
            else:
                camera.Dolly(zoomFactor)
                self.graphicsFrameWidget.ren.ResetCameraClippingRange()

            self.Render()
    
    def zoomIn(self):
        delta = 2*120
        self.__zoomStep(delta)

    def zoomOut(self):
        delta = -2*120
        self.__zoomStep(delta)

    def zoomFixed(self, val):
        print "zitems=",self.zitems
        if self.graphicsFrameWidget.ren:
            # renderer = self._CurrentRenderer
            camera = self.graphicsFrameWidget.ren.GetActiveCamera()
            self.__curDist = camera.GetDistance()
            
            # To zoom fixed, dolly should be set to initial position
            # and then moved to a new specified position!
            
            if not self.__initDist:
                # fieldDim=self.currentDrawingParameters.bsd.fieldDim
                fieldDim=self.currentDrawingParameters.bsd.fieldDim
                
                self.dim=[fieldDim.x,fieldDim.y,fieldDim.z]
                
                self.__initDist=self.largestDim(self.dim)*2
                
            if (self.__initDist != 0):
                # You might need to rewrite the fixed zoom in case if there
                # will be flickering
                camera.Dolly(self.__curDist/self.__initDist)

            camera.Dolly(self.zitems[val])
            self.graphicsFrameWidget.ren.ResetCameraClippingRange()

            self.Render()
    
    def takeShot(self): pass

    def cloneCamera(self,_camera):
        cam = self.ren.GetActiveCamera()
        # cam.ApplyTransform(_camera.GetViewTransformObject())
        cam.SetClippingRange(_camera.GetClippingRange())
        
        cam.SetFocalPoint(_camera.GetFocalPoint())
        cam.SetPosition(_camera.GetPosition())
        
        # cam.SetViewPlaneNormal(_camera.GetViewPlaneNormal())
        cam.SetViewUp(_camera.GetViewUp())
        
        # cam.SetRoll(_camera.GetRoll())
        
        # cam.SetDistance(_camera.GetDistance())
        # cam.SetViewShear(_camera.GetViewShear())
        
        
        # cam.SetDistance(_camera.GetDistance())
        
        # cam.SetViewAngle(_camera.GetViewAngle())
        
    def setCamera(self, fieldDim): 
        camera = self.GetCurrentRenderer().GetActiveCamera()
        
        #self.setDim(dim)
        # Should I specify these parameters explicitly? 
        # What if I change dimensions in XML file? 
        # The parameters should be set based on the configuration parameters!
        # Should it set depending on projection? (e.g. xy, xz, yz)
        
        distance = 200 #self.largestDim()*2 # 273.205 #
        # FIXME: Hardcoded numbers
        
        # camera.SetPosition(50, 50, distance)
        # camera.SetFocalPoint(50, 50, 0)
        # camera.SetClippingRange(distance - 100, distance + 100)
        # # self.GetCurrentRenderer().ResetCameraClippingRange()
        # self.ren.ResetCameraClippingRange()

    def startMovie(self):
        self.w = vtk.vtkWindowToImageFilter()
        self.w.SetInput(self.GetRenderWindow())
        
        self.movie = vtk.vtkMPEG2Writer() # Check is it is available.
        self.movie.SetInput(self.w.GetOutput())
        self.movie.SetFileName("cellsort2D.mpg")
        self.movie.Start()

    def writeMovie(self):
        self.movie.Write()
        self.w = vtk.vtkWindowToImageFilter()
        self.w.SetInput(self.GetRenderWindow())
        self.movie.SetInput(self.w.GetOutput())

    def endMovie(self):
        self.movie.End()

    def setStatusBar(self, statusBar):
        self._statusBar = statusBar

    # Break the settings read into groups?
    def readSettings(self):
        self.readColorsSets()
        self.readViewSets()
        self.readColormapSets()
        self.readOutputSets()
        self.readVectorSets()
        self.readVisualSets()
        # simDefaults?

    def readColorsSets(self):
        #colorsDefaults
        self._colorMap     = Configuration.getCellTypeColors("TypeColorMap")
        self._borderColor  = Configuration.getCellTypeColors("Border")
        self._contourColor = Configuration.getCellTypeColors("Contour")
        self._brushColor   = Configuration.getCellTypeColors("Brush")
        self._penColor     = Configuration.getCellTypeColors("Pen")

    def readViewSets(self):
        # For 3D only?
        # viewDefaults
        self._types3D      = Configuration.getThreeDView("Types3DInvisible")

    def readColormapSets(self):
        # colormapDefaults
        self._minCon       = Configuration.getColorMapPlot("MinConcentration")
        self._minConFixed  = Configuration.getColorMapPlot("MinConcentrationFixed")
        self._maxCon       = Configuration.getColorMapPlot("MaxConcentration")
        self._maxConFixed  = Configuration.getColorMapPlot("MaxConcentrationFixed")
        self._accuracy     = Configuration.getColorMapPlot("NumberAccuracy")
        self._numLegend    = Configuration.getColorMapPlot("NumberOfLegendBoxes")
        self._enableLegend = Configuration.getColorMapPlot("LegendEnable")
        self._contoursOn   = Configuration.getColorMapPlot("ContoursOn")
        self._numberOfContourLines   = Configuration.getColorMapPlot("NumberOfContourLines")
        
    def readOutputSets(self):
        # Should I read the settings here?
        # outputDefaults
        self._updateScreen     = Configuration.getOutputFrequency("ScreenUpdateFrequency")
        self._noOutput         = Configuration.getOutputFrequency("NoOutputFlag")
        self._shotFrequency    = Configuration.getOutputFrequency("ScreenshotFrequency")

    def readVectorSets(self):
        # vectorDefaults
        self._arrowColor   = Configuration.getVectorField("ArrowColor")
        self._arrowLength  = Configuration.getVectorField("ArrowLength")
        self._arrowColorFixed  = Configuration.getVectorField("FixedArrowColorFlag")
        self._enableLegendVec  = Configuration.getVectorField("LegendEnableVector")
        self._scaleArrows  = Configuration.getVectorField("ScaleArrows")
        self._accuracyVec  = Configuration.getVectorField("NumberAccuracyVector")
        self._numLegendVec = Configuration.getVectorField("NumberOfLegendBoxesVector")
        self._overlayVec   = Configuration.getVectorField("OverlayVectorCellFields")
        self._maxMag       = Configuration.getVectorField("MaxMagnitude")
        self._maxMagFixed  = Configuration.getVectorField("MaxMagnitudeFixed")
        self._minMag       = Configuration.getVectorField("MinMagnitude")
        self._minMagFixed  = Configuration.getVectorField("MinMagnitudeFixed")

    def readVisualSets(self):
        # visualDefaults
        self._bordersOn    = Configuration.getVisualization("BordersOn")        
        self._conLimitsOn  = Configuration.getVisualization("ConcentrationLimitsOn")
        self._zoomFactor   = Configuration.getVisualization("ZoomFactor")
        

    def setLatticeType(self, latticeType):
        self.latticeType=latticeType
     

    
