from PyQt4.QtCore import *
from PyQt4.QtGui import *

from Utilities.QVTKRenderWidget import QVTKRenderWidget

from Plugins.ViewManagerPlugins.SimpleTabView import FIELD_TYPES,PLANES

from MVCDrawModelBase import MVCDrawModelBase
import Configuration
import vtk, math
import sys, os

MODULENAME='MVCDrawModel3D.py'

class MVCDrawModel3D(MVCDrawModelBase):
    def __init__(self, qvtkWidget, parent=None):
        MVCDrawModelBase.__init__(self,qvtkWidget, parent)
        
        self.initArea()
        self.setParams()
        
        self.usedCellTypesList=None
        self.usedDraw3DFlag=False
    
    # Sets up the VTK simulation area 
    def initArea(self):
        
        # Zoom items
        self.zitems = []
        
        # self.cellTypeActors={}
        # self.outlineActor = vtk.vtkActor()
        self.outlineDim=[0,0,0]
        
        # self.invisibleCellTypes={}
        # self.typesInvisibleStr=""
        # self.set3DInvisibleTypes()
        
        
        # axesActor = vtk.vtkActor()
        # axisTextActor = vtk.vtkFollower()
        
        self.numberOfTableColors=1024
        self.clut = vtk.vtkLookupTable()
        self.clut.SetHueRange(0.67, 0.0)
        self.clut.SetSaturationRange(1.0,1.0)
        self.clut.SetValueRange(1.0,1.0)
        self.clut.SetAlphaRange(1.0,1.0)
        self.clut.SetNumberOfColors(self.numberOfTableColors)
        self.clut.Build()
        self.lowTableValue=self.clut.GetTableValue(0)
        self.highTableValue=self.clut.GetTableValue(self.numberOfTableColors-1)

        ## Set up the mapper and actor (3D) for concentration field.
        self.conMapper = vtk.vtkPolyDataMapper()
        # self.conActor = vtk.vtkActor()

        # self.glyphsActor=vtk.vtkActor()
        self.glyphsMapper=vtk.vtkPolyDataMapper()

        self.cellGlyphsMapper  = vtk.vtkPolyDataMapper()
        self.FPPLinksMapper  = vtk.vtkPolyDataMapper()

        # Weird attributes
        # self.typeActors             = {} # vtkActor
        self.smootherFilters        = {} # vtkSmoothPolyDataFilter
        self.polyDataNormals        = {} # vtkPolyDataNormals
        self.typeExtractors         = {} # vtkDiscreteMarchingCubes
        self.typeExtractorMappers   = {} # vtkPolyDataMapper
        

    def setDim(self, fieldDim):
        # self.dim = [fieldDim.x+1 , fieldDim.y+1 , fieldDim.z]
        self.dim = [fieldDim.x , fieldDim.y , fieldDim.z]
        
    def prepareOutlineActors(self,_actors):
        outlineData = vtk.vtkImageData()
        
        fieldDim = self.currentDrawingParameters.bsd.fieldDim
        
        outlineData.SetDimensions(fieldDim.x+1,fieldDim.y+1,fieldDim.z+1)
        
        # if self.parentWidget.latticeType==Configuration.LATTICE_TYPES["Hexagonal"] and self.currentDrawingParameters.plane=="XY":       
            # import math            
            # outlineData.SetDimensions(self.dim[0]+1,int(self.dim[1]*math.sqrt(3.0)/2.0)+2,1)
            # print "self.dim[0]+1,int(self.dim[1]*math.sqrt(3.0)/2.0)+2,1= ",(self.dim[0]+1,int(self.dim[1]*math.sqrt(3.0)/2.0)+2,1)
        # else:            
            # outlineData.SetDimensions(self.dim[0]+1, self.dim[1]+1, 1)

        # outlineDimTmp=_imageData.GetDimensions()
        # # print "\n\n\n this is outlineDimTmp=",outlineDimTmp," self.outlineDim=",self.outlineDim
        # if self.outlineDim[0] != outlineDimTmp[0] or self.outlineDim[1] != outlineDimTmp[1] or self.outlineDim[2] != outlineDimTmp[2]:
            # self.outlineDim=outlineDimTmp
        
        outline = vtk.vtkOutlineFilter()
        outline.SetInput(outlineData)
        outlineMapper = vtk.vtkPolyDataMapper()
        outlineMapper.SetInputConnection(outline.GetOutputPort())
    
        _actors[0].SetMapper(outlineMapper)
        _actors[0].GetProperty().SetColor(1, 1, 1)        
        # self.outlineDim=_imageData.GetDimensions()

    def showAxes(self):
        axes = vtk.vtkAxes()
        axes.SetOrigin(-1, -1, -1)
        axes.SetScaleFactor(20)
        axesMapper = vtk.vtkPolyDataMapper()
        axesMapper.SetInputConnection(axes.GetOutputPort())
        
        axesActor.SetMapper(axesMapper)
        self.ren.AddActor(axesActor)
        
        atext = vtk.vtkVectorText()
        atext.SetText("X-Axis")
        textMapper = vtk.vtkPolyDataMapper()
        textMapper.SetInputConnection(atext.GetOutputPort())
        
        axisTextActor.SetMapper(textMapper)
        #axisTextActor.SetScale(0.2, 0.2, 0.2)
        axisTextActor.SetScale(3, 3, 3)
        #axisTextActor.RotateY(90)
        axisTextActor.AddPosition(0, 0, 0)        
        
        self.graphicsFrameWidget.ren.AddActor(axisTextActor)    

    def extractCellFieldData(self):
        import CompuCell
        # potts      = sim.getPotts()
        # cellField  = potts.getCellFieldG()
        fieldDim   = self.currentDrawingParameters.bsd.fieldDim
        
        # self.usedCellTypesList=self.fillCellFieldData(cellField)
        
        self.cellType = vtk.vtkIntArray()
        self.cellType.SetName("celltype")
        self.cellTypeIntAddr=self.extractAddressIntFromVtkObject(self.cellType)
        
        self.usedCellTypesList=self.parentWidget.fieldExtractor.fillCellFieldData3D(self.cellTypeIntAddr)
        
        print MODULENAME," INSIDE DRAW 3D"
        print "    usedCellTypesList",self.usedCellTypesList
        
        # numberOfActors=len(self.usedCellTypesList)
        return self.usedCellTypesList

    def initCellFieldActors(self,_actors):
        print MODULENAME,'  initCellFieldActors'

        import CompuCell
        fieldDim   = self.currentDrawingParameters.bsd.fieldDim    
        numberOfActors=len(self.usedCellTypesList)
        cellTypeImageData=vtk.vtkImageData()
        cellTypeImageData.SetDimensions(fieldDim.x+2,fieldDim.y+2,fieldDim.z+2) # adding 1 pixel border around the lattice to make rendereing smooth at lattice borders
        cellTypeImageData.GetPointData().SetScalars(self.cellType)
        
        numberOfActors=len(self.usedCellTypesList)
        
        # creating and initializing filters, smoothers and mappers - one for each cell type

        filterList=[vtk.vtkDiscreteMarchingCubes() for i in xrange(numberOfActors)]
        smootherList=[vtk.vtkSmoothPolyDataFilter() for i in xrange(numberOfActors)]
        normalsList=[vtk.vtkPolyDataNormals() for i in xrange(numberOfActors)]
        mapperList=[vtk.vtkPolyDataMapper() for i in xrange(numberOfActors)]
        
        # actorCounter=0
        # for i in usedCellTypesList:
        for actorCounter in xrange(len(self.usedCellTypesList)):
            filterList[actorCounter].SetInput(cellTypeImageData)
            # filterList[actorCounter].SetValue(0, usedCellTypesList[actorCounter])
            
            filterList[actorCounter].SetValue(0, self.usedCellTypesList[actorCounter])
            smootherList[actorCounter].SetInputConnection(filterList[actorCounter].GetOutputPort())
            normalsList[actorCounter].SetInputConnection(smootherList[actorCounter].GetOutputPort())
            normalsList[actorCounter].SetFeatureAngle(45.0)
            mapperList[actorCounter].SetInputConnection(normalsList[actorCounter].GetOutputPort())
            mapperList[actorCounter].ScalarVisibilityOff()
            
            actorName="CellType_"+str(self.usedCellTypesList[actorCounter])
            if actorName in _actors:
                _actors[actorName].SetMapper(mapperList[actorCounter])
                _actors[actorName].GetProperty().SetDiffuseColor(self.lut.GetTableValue(self.usedCellTypesList[actorCounter])[0:3])
        
        
    def drawCellField(self, bsd, fieldType):
        import CompuCell
        # potts      = sim.getPotts()
        # cellField  = potts.getCellFieldG()
        fieldDim   = bsd.fieldDim
        
        # self.usedCellTypesList=self.fillCellFieldData(cellField)
        
        self.cellType = vtk.vtkIntArray()
        self.cellType.SetName("celltype")
        self.cellTypeIntAddr=self.extractAddressIntFromVtkObject(self.cellType)
        
        self.usedCellTypesList=self.parentWidget.fieldExtractor.fillCellFieldData3D(self.cellTypeIntAddr)
        
        print " INSIDE DRAW 3D"
        print "usedCellTypesList",self.usedCellTypesList
        
        numberOfActors=len(self.usedCellTypesList)
        # self.numberOfUsedCellTypes=len(self.usedCellTypesList)
        #each cell type will be represented by one actor
        # print "\n\n\n numberOfActors=",numberOfActors,"\n\n\n"
                
        # creating vtkImageData
        cellTypeImageData=vtk.vtkImageData()
        cellTypeImageData.SetDimensions(fieldDim.x+2,fieldDim.y+2,fieldDim.z+2) # adding 1 pixel border around the lattice to make rendereing smooth at lattice borders
        cellTypeImageData.GetPointData().SetScalars(self.cellType)
        
        self.hideAllActors()
        self.set3DInvisibleTypes()
        self.prepareOutlineActor(cellTypeImageData)
        self.showOutlineActor()
        
        self.prepareCellTypeActors()
        self.showCellTypeActors()
        
        # creating and initializing filters, smoothers and mappers - one for each cell type
        
        filterList=[vtk.vtkDiscreteMarchingCubes() for i in xrange(numberOfActors)]
        smootherList=[vtk.vtkSmoothPolyDataFilter() for i in xrange(numberOfActors)]
        normalsList=[vtk.vtkPolyDataNormals() for i in xrange(numberOfActors)]
        mapperList=[vtk.vtkPolyDataMapper() for i in xrange(numberOfActors)]
        
        # actorCounter=0
        # for i in usedCellTypesList:
        for actorCounter in xrange(len(self.usedCellTypesList)):
            filterList[actorCounter].SetInput(cellTypeImageData)
            # filterList[actorCounter].SetValue(0, usedCellTypesList[actorCounter])
            
            filterList[actorCounter].SetValue(0, self.usedCellTypesList[actorCounter])
            smootherList[actorCounter].SetInputConnection(filterList[actorCounter].GetOutputPort())
            normalsList[actorCounter].SetInputConnection(smootherList[actorCounter].GetOutputPort())
            normalsList[actorCounter].SetFeatureAngle(45.0)
            mapperList[actorCounter].SetInputConnection(normalsList[actorCounter].GetOutputPort())
            mapperList[actorCounter].ScalarVisibilityOff()
            
            actorName="CellType_"+str(self.usedCellTypesList[actorCounter])
            if actorName in self.currentActors:
                self.currentActors[actorName].SetMapper(mapperList[actorCounter])
                self.currentActors[actorName].GetProperty().SetDiffuseColor(self.lut.GetTableValue(self.usedCellTypesList[actorCounter])[0:3])
                # # # print "clut.GetTableValue(actorName)[0:3]=",self.lut.GetTableValue(self.usedCellTypesList[actorCounter])[0:3]

        self.Render()
        
    def showConActors(self):
        if not self.currentActors.has_key("ConActor"):
            self.currentActors["ConActor"]=self.conActor  
            self.graphicsFrameWidget.ren.AddActor(self.conActor) 
            # print "\n\n\n\n added CON ACTOR"        

    def hideConActors(self):
        if self.currentActors.has_key("ConActor"):
            self.graphicsFrameWidget.ren.RemoveActor(self.conActor) 
            del self.currentActors["ConActor"]  
    
    def drawConField(self, bsd, fieldType):        
        fillScalarField = getattr(self.parentWidget.fieldExtractor, "fillConFieldData3D") # this is simply a "pointer" to function self.parentWidget.fieldExtractor.fillVectorFieldData3D        
        self.drawScalarFieldData(bsd,fieldType,fillScalarField)

    def drawScalarField(self, bsd, fieldType):
        fillScalarField = getattr(self.parentWidget.fieldExtractor, "fillScalarFieldData3D") # this is simply a "pointer" to function        
        self.drawScalarFieldData(bsd,fieldType,fillScalarField)
    
    def drawScalarFieldCellLevel(self, bsd, fieldType):    
        fillScalarField = getattr(self.parentWidget.fieldExtractor, "fillScalarFieldCellLevelData3D") # this is simply a "pointer" to function         
        self.drawScalarFieldData(bsd,fieldType,fillScalarField)

    def initScalarFieldDataActors(self, _actors, _invisibleCellTypesVector, _fillScalarField):
        import CompuCell
        import PlayerPython
        # potts      = sim.getPotts()
        # cellField  = potts.getCellFieldG()
        fieldDim   = self.currentDrawingParameters.bsd.fieldDim
        # conField   = CompuCell.getConcentrationField(sim, fieldType[0])
        conFieldName=self.currentDrawingParameters.fieldName
        
        #print self._statusBar.currentMessage() 
        self.dim    = [fieldDim.x, fieldDim.y, fieldDim.z]
        field       = vtk.vtkImageDataGeometryFilter()
        contour     = vtk.vtkContourFilter()
        
        # self.fillCellFieldData(cellField)
        
        self.conArray = vtk.vtkDoubleArray()
        self.conArray.SetName("concentration")
        self.conArrayIntAddr=self.extractAddressIntFromVtkObject(self.conArray)

        self.cellTypeCon=vtk.vtkIntArray()
        self.cellTypeCon.SetName("concelltype")
        self.cellTypeConIntAddr=self.extractAddressIntFromVtkObject(self.cellTypeCon)
        
        # self.invisibleCellTypesVector=PlayerPython.vectorint()
        # for type in self.invisibleCellTypes: 
            # self.invisibleCellTypesVector.append(type)
        # # print "self.invisibleCellTypesVector=",self.invisibleCellTypesVector
        # # print "self.invisibleCellTypesVector=",self.invisibleCellTypesVector.size()
        
        fillSuccessful=_fillScalarField(self.conArrayIntAddr,self.cellTypeConIntAddr,conFieldName,_invisibleCellTypesVector)
        
        if not fillSuccessful:
            return
            
        range=self.conArray.GetRange()
        self.minCon=range[0]
        self.maxCon=range[1]
        
        if Configuration.getColorMapPlot("MinConcentrationFixed"):
            self.minCon=Configuration.getColorMapPlot("MinConcentration")            
            self.clut.SetTableValue(0,[0,0,0,1])
        else:
            self.clut.SetTableValue(0,self.lowTableValue)
                        
        if Configuration.getColorMapPlot("MaxConcentrationFixed"):
            self.maxCon=Configuration.getColorMapPlot("MaxConcentration")
            self.clut.SetTableValue(self.numberOfTableColors-1,[0,0,0,1])
        else:
            self.clut.SetTableValue(self.numberOfTableColors-1,self.highTableValue)
        
        # print "getting conField=",conField
        # (self.minCon, self.maxCon) = self.fillConFieldData( cellField, conField)
        # print "(self.minCon, self.maxCon) ",(self.minCon, self.maxCon)
        
        conc_vol=vtk.vtkImageData()
        conc_vol.GetPointData().SetScalars(self.conArray)
        conc_vol.SetDimensions(self.dim[0]+2,self.dim[1]+2,self.dim[2]+2)
        
        uGrid=vtk.vtkStructuredPoints()
        uGrid.SetDimensions(self.dim[0]+2,self.dim[1]+2,self.dim[2]+2)
        uGrid.GetPointData().SetScalars(self.cellTypeCon)
        uGrid.GetPointData().AddArray(self.conArray)        
        
        skinExtractorColor = vtk.vtkContourFilter()
        #skinExtractorColor = vtk.vtkDiscreteMarchingCubes()
        #skinExtractorColor = vtk.vtkMarchingCubes()
        skinExtractorColor.SetInput(uGrid)
        skinExtractorColor.SetValue(0, 1)
        skinExtractorColor.SetValue(1, 2)
        skinExtractorColor.SetValue(2, 3)
        skinExtractorColor.SetValue(3, 4)
        
        concLut = vtk.vtkLookupTable()
        # concLut.SetTableRange(conc_vol.GetScalarRange())
        concLut.SetTableRange([self.minCon,self.maxCon])
        concLut.SetNumberOfColors(256)
        concLut.Build()
        # concLut.SetTableValue(39,0,0,0,0)        
        
        skinColorMapper=vtk.vtkPolyDataMapper()
        #skinColorMapper.SetInputConnection(skinNormals.GetOutputPort())
        self.conMapper.SetInputConnection(skinExtractorColor.GetOutputPort())
        self.conMapper.ScalarVisibilityOn()
        self.conMapper.SetLookupTable(self.clut)
        # # # print " this is conc_vol.GetScalarRange()=",conc_vol.GetScalarRange()
        # self.conMapper.SetScalarRange(conc_vol.GetScalarRange())
        self.conMapper.SetScalarRange([self.minCon,self.maxCon])
        #self.conMapper.SetScalarRange(0,1500)
        self.conMapper.SetScalarModeToUsePointFieldData()
        self.conMapper.ColorByArrayComponent("concentration",0)
        
        print "Plotting 3D Scalar field"
        
        # self.conMapper      = vtk.vtkPolyDataMapper()
        # self.conActor       = vtk.vtkActor()        
        
        # self.conActor=vtk.vtkActor()
        # self.conActor.SetMapper(self.conMapper)     
        
        _actors[0].SetMapper(self.conMapper)

        self.Render()    
        
    # def drawScalarFieldData(self, bsd, fieldType,_fillScalarField):
        # import CompuCell
        # import PlayerPython
        # # potts      = sim.getPotts()
        # # cellField  = potts.getCellFieldG()
        # fieldDim   = bsd.fieldDim
        # # conField   = CompuCell.getConcentrationField(sim, fieldType[0])
        # conFieldName=fieldType[0]
        
        # #print self._statusBar.currentMessage() 
        # self.dim    = [fieldDim.x, fieldDim.y, fieldDim.z]
        # field       = vtk.vtkImageDataGeometryFilter()
        # contour     = vtk.vtkContourFilter()
        
        # # self.fillCellFieldData(cellField)
        
        # self.conArray = vtk.vtkDoubleArray()
        # self.conArray.SetName("concentration")
        # self.conArrayIntAddr=self.extractAddressIntFromVtkObject(self.conArray)

        # self.cellTypeCon=vtk.vtkIntArray()
        # self.cellTypeCon.SetName("concelltype")
        # self.cellTypeConIntAddr=self.extractAddressIntFromVtkObject(self.cellTypeCon)
        
        # self.invisibleCellTypesVector=PlayerPython.vectorint()
        # for type in self.invisibleCellTypes: 
            # self.invisibleCellTypesVector.append(type)
        # # print "self.invisibleCellTypesVector=",self.invisibleCellTypesVector
        # # print "self.invisibleCellTypesVector=",self.invisibleCellTypesVector.size()
        
        # fillSuccessful=_fillScalarField(self.conArrayIntAddr,self.cellTypeConIntAddr,conFieldName,self.invisibleCellTypesVector)
        
        # if not fillSuccessful:
            # return
            
        # range=self.conArray.GetRange()
        # self.minCon=range[0]
        # self.maxCon=range[1]
        
        # if Configuration.getColorMapPlot("MinConcentrationFixed"):
            # self.minCon=Configuration.getColorMapPlot("MinConcentration")
            
        # if Configuration.getColorMapPlot("MaxConcentrationFixed"):
            # self.maxCon=Configuration.getColorMapPlot("MaxConcentration")
        
        # # print "getting conField=",conField
        # # (self.minCon, self.maxCon) = self.fillConFieldData( cellField, conField)
        # # print "(self.minCon, self.maxCon) ",(self.minCon, self.maxCon)
        
        # conc_vol=vtk.vtkImageData()
        # conc_vol.GetPointData().SetScalars(self.conArray)
        # conc_vol.SetDimensions(self.dim[0]+2,self.dim[1]+2,self.dim[2]+2)
        
        # uGrid=vtk.vtkStructuredPoints()
        # uGrid.SetDimensions(self.dim[0]+2,self.dim[1]+2,self.dim[2]+2)
        # uGrid.GetPointData().SetScalars(self.cellTypeCon)
        # uGrid.GetPointData().AddArray(self.conArray)        
        
        # skinExtractorColor = vtk.vtkContourFilter()
        # #skinExtractorColor = vtk.vtkDiscreteMarchingCubes()
        # #skinExtractorColor = vtk.vtkMarchingCubes()
        # skinExtractorColor.SetInput(uGrid)
        # skinExtractorColor.SetValue(0, 1)
        # skinExtractorColor.SetValue(1, 2)
        # skinExtractorColor.SetValue(2, 3)
        # skinExtractorColor.SetValue(3, 4)

        # concLut = vtk.vtkLookupTable()
        # # concLut.SetTableRange(conc_vol.GetScalarRange())
        # concLut.SetTableRange([self.minCon,self.maxCon])        
        # concLut.SetNumberOfColors(256)
        # concLut.Build()
        # # concLut.SetTableValue(39,0,0,0,0)        
        
        # skinColorMapper=vtk.vtkPolyDataMapper()
        # #skinColorMapper.SetInputConnection(skinNormals.GetOutputPort())
        # self.conMapper.SetInputConnection(skinExtractorColor.GetOutputPort())
        # self.conMapper.ScalarVisibilityOn()
        # self.conMapper.SetLookupTable(self.clut)
        # # # # print " this is conc_vol.GetScalarRange()=",conc_vol.GetScalarRange()
        # # self.conMapper.SetScalarRange(conc_vol.GetScalarRange())
        # concLut.SetTableRange([self.minCon,self.maxCon])
        
        # #self.conMapper.SetScalarRange(0,1500)
        # self.conMapper.SetScalarModeToUsePointFieldData()
        # self.conMapper.ColorByArrayComponent("concentration",0)

        # # self.conMapper      = vtk.vtkPolyDataMapper()
        # # self.conActor       = vtk.vtkActor()        
        
        # # self.conActor=vtk.vtkActor()
        # self.conActor.SetMapper(self.conMapper)     
        # self.hideAllActors()
        # self.set3DInvisibleTypes()
        # self.prepareOutlineActor(conc_vol)
        # self.showOutlineActor()
        
        # self.showConActors()
        
        # # if Configuration.getColorMapPlot("LegendEnable"):
            # # self.drawLegend(self.conMapper)

        # if Configuration.getColorMapPlot("LegendEnable"):            
            # self.drawLegend(self.conMapper)
        # else:
            # self.showLegend(False)       
            
        # # self.repaint()            
        
        # self.Render()    

    def drawVectorField(self, bsd, fieldType):
        fillVectorField = getattr(self.parentWidget.fieldExtractor, "fillVectorFieldData3D") # this is simply a "pointer" to function self.parentWidget.fieldExtractor.fillVectorFieldData3D        
        self.drawVectorFieldData(bsd,fieldType,fillVectorField)
        
    def drawVectorFieldCellLevel(self, bsd, fieldType):        
        # # # print "INSIDE drawVectorFieldCellLevel"
        fillVectorField = getattr(self.parentWidget.fieldExtractor, "fillVectorFieldCellLevelData3D") # this is simply a "pointer" to function self.parentWidget.fieldExtractor.fillVectorFieldData3D        
        self.drawVectorFieldData(bsd,fieldType,fillVectorField)

    def initVectorFieldDataActors(self,_actors,_fillVectorFieldFcn):
        # potts      = sim.getPotts()
        # cellField  = potts.getCellFieldG()
        fieldDim   = self.currentDrawingParameters.bsd.fieldDim
        
        conFieldName=self.currentDrawingParameters.fieldName
        
        #print self._statusBar.currentMessage() 
        self.dim    = [fieldDim.x, fieldDim.y, fieldDim.z]

        vectorGrid=vtk.vtkUnstructuredGrid()

        points=vtk.vtkPoints()
        vectors=vtk.vtkFloatArray()
        vectors.SetNumberOfComponents(3)
        vectors.SetName("visVectors")

        pointsIntAddr=self.extractAddressIntFromVtkObject(points)
        vectorsIntAddr=self.extractAddressIntFromVtkObject(vectors)
        
        fillSuccessful=_fillVectorFieldFcn(pointsIntAddr,vectorsIntAddr,conFieldName)
        if not fillSuccessful:
            return
        
        vectorGrid.SetPoints(points)
        vectorGrid.GetPointData().SetVectors(vectors)

        cone=vtk.vtkConeSource()
        cone.SetResolution(5)
        cone.SetHeight(2)
        cone.SetRadius(0.5)
        #cone.SetRadius(4)

        range=vectors.GetRange(-1)
        
        self.minMagnitude=range[0]
        self.maxMagnitude=range[1]
        
        if Configuration.getVectorField("MinMagnitudeFixed"):
            self.minMagnitude=Configuration.getVectorField("MinMagnitude")
            self.clut.SetTableValue(0,[0,0,0,1])
        else:
            self.clut.SetTableValue(0,self.lowTableValue)
            
        if Configuration.getVectorField("MaxMagnitudeFixed"):
            self.maxMagnitude=Configuration.getVectorField("MaxMagnitude")
            self.clut.SetTableValue(self.numberOfTableColors-1,[0,0,0,1])
        else:
            self.clut.SetTableValue(self.numberOfTableColors-1,self.highTableValue)
            
        glyphs=vtk.vtkGlyph3D()

        glyphs.SetInput(vectorGrid)
        glyphs.SetSourceConnection(cone.GetOutputPort())
        #glyphs.SetScaleModeToScaleByVector()
        # glyphs.SetColorModeToColorByVector()

        # glyphs.SetScaleFactor(Configuration.getVectorField("ArrowLength")) # scaling arrows here ArrowLength indicates scaling factor not actual length
        
        arrowScalingFactor=Configuration.getVectorField("ArrowLength") # sscaling factor for and arrow  -  ArrowLength indicates scaling factor not actual length
        
        if Configuration.getVectorField("ScaleArrows"):
            glyphs.SetScaleModeToScaleByVector()
            rangeSpan=self.maxMagnitude-self.minMagnitude
            dataScalingFactor=max(abs(self.minMagnitude),abs(self.maxMagnitude))
            print "self.minMagnitude=",self.minMagnitude," self.maxMagnitude=",self.maxMagnitude
            
            if dataScalingFactor==0.0:
                dataScalingFactor=1.0 # in this case we are plotting 0 vectors and in this case data scaling factor will be set to 1
            glyphs.SetScaleFactor(arrowScalingFactor/dataScalingFactor)
            #coloring arrows
            
            arrowColor=Configuration.getVectorField("ArrowColor")
            r = arrowColor.red()
            g = arrowColor.green()
            b = arrowColor.blue()
            _actors[0].GetProperty().SetColor(self.toVTKColor(r), self.toVTKColor(g), self.toVTKColor(b))        
        else:
            glyphs.SetColorModeToColorByVector()
            glyphs.SetScaleFactor(arrowScalingFactor)         
        
        
        self.glyphsMapper.SetInputConnection(glyphs.GetOutputPort())
        self.glyphsMapper.SetLookupTable(self.clut)

        # # # print "vectors.GetNumberOfTuples()=",vectors.GetNumberOfTuples()    
        # self.glyphsMapper.SetScalarRange(vectors.GetRange(-1)) # this will return the range of magnitudes of all the vectors store int vtkFloatArray
        # self.glyphsMapper.SetScalarRange(range)

        self.glyphsMapper.SetScalarRange([self.minMagnitude,self.maxMagnitude])
        
        _actors[0].SetMapper(self.glyphsMapper)
        
    def __zoomStep(self, delta):
        # # # print "ZOOM STEP"
        if self.ren:
            # renderer = self.GetCurrentRenderer()
            camera = self.ren.GetActiveCamera()
            
            zoomFactor = math.pow(1.02,(0.5*(delta/8)))

            # I don't know why I might need the parallel projection
            if camera.GetParallelProjection(): 
                parallelScale = camera.GetParallelScale()/zoomFactor
                camera.SetParallelScale(parallelScale)
            else:
                camera.Dolly(zoomFactor)
                self.ren.ResetCameraClippingRange()

            self.Render()
    def zoomIn(self):
        delta = 2*120
        self.__zoomStep(delta)

    def zoomOut(self):
        delta = -2*120
        self.__zoomStep(delta)

    def zoomFixed(self, val):
        if self.ren:
            # renderer = self._CurrentRenderer
            camera = self.ren.GetActiveCamera()
            self.__curDist = camera.GetDistance()
            
            # To zoom fixed, dolly should be set to initial position
            # and then moved to a new specified position!
            if (self.__initDist != 0):
                # You might need to rewrite the fixed zoom in case if there
                # will be flickering
                camera.Dolly(self.__curDist/self.__initDist)

            camera.Dolly(self.zitems[val])
            self.ren.ResetCameraClippingRange()

            self.Render()

    def takeSimShot(self, fileName):
        renderLarge = vtk.vtkRenderLargeImage()
        renderLarge.SetInput(self.graphicsFrameWidget.ren)
        renderLarge.SetMagnification(1)

        # We write out the image which causes the rendering to occur. If you
        # watch your screen you might see the pieces being rendered right
        # after one another.
        writer = vtk.vtkPNGWriter()
        writer.SetInputConnection(renderLarge.GetOutputPort())
        # # # print "GOT HERE fileName=",fileName
        writer.SetFileName(fileName)
        
        writer.Write()

    def initSizeDim(self, dataSet, x, y, z):
        (xloc, yloc, zloc) = (x, y, z)
        if x == 1:
            xloc += 2
        if y == 1:
            yloc += 2
        if z == 1:
            zloc += 2
            
        dataSet.SetDimensions(xloc, yloc, zloc)

    # this function is used during prototyping. in production code it is replaced by C++ counterpart    
    def fillCellFieldData(self,_cellFieldG):
        import CompuCell
        
        pt = CompuCell.Point3D() 
        cell = CompuCell.CellG() 
        fieldDim = _cellFieldG.getDim()

        self.dim = [fieldDim.x , fieldDim.y , fieldDim.z]
        # # # print "FILLCELLFIELDDATA 3D"
        # # # print "self.dim=",self.dim
        offset=0

        #will add 1 pixel border to celltype vtkImage data so that rendering will look smooth at the borders
        self.cellType = vtk.vtkIntArray()
        self.cellType.SetName("celltype")
        self.cellType.SetNumberOfValues((self.dim[2]+2)*(self.dim[1]+2)*(self.dim[0]+2))
        self.cellId=[[[0 for k in range(self.dim[2])] for j in range(self.dim[1])] for i in range(self.dim[0])]
        
        usedCellTypes={}
        
        # For some reasons the points x=0 are eaten up (don't know why).
        # So we just populate empty cellIds.
        # for i in range(self.dim[0]+1):
            # self.cellType.SetValue(offset, 0)
            # offset += 1
                
        for k in range(self.dim[2]+2):
            for j in range(self.dim[1]+2):
                for i in range(self.dim[0]+2):                
        # for i in range(self.dim[0]+2):
            # for j in range(self.dim[1]+2):
                # for k in range(self.dim[2]+2):                                
                
                    if i==0 or i ==self.dim[0]+1 or j==0 or j ==self.dim[1]+1 or k==0 or k ==self.dim[2]+1:
                        self.cellType.InsertValue(offset, 0)
                        offset+=1
                    else:
                        pt.x = i-1
                        pt.y = j-1
                        pt.z = k-1
                        cell = _cellFieldG.get(pt)
                        if cell is not None:
                            type    = int(cell.type)
                            id      = int(cell.id)
                            if not type in usedCellTypes:
                                usedCellTypes[type]=0
                        else:
                            type    = 0
                            id      = 0
                        self.cellType.InsertValue(offset, type)
                        # print "inserting type ",type," offset ",offset
                        # print "pt=",pt," type=",type
                        
                        offset += 1
                        
                        self.cellId[pt.x][pt.y][pt.z] = id  

        usedCellTypesList=usedCellTypes.keys()
        usedCellTypesList.sort()
        return usedCellTypesList
        
    # this function is used during prototyping. in production code it is replaced by C++ counterpart            
    def fillConFieldData(self,_cellFieldG,_conField):
        import CompuCell
        
        pt = CompuCell.Point3D(0,0,0) 
        cell = CompuCell.CellG() 
        fieldDim = _cellFieldG.getDim()

        self.dim  = [fieldDim.x, fieldDim.y, fieldDim.z]         

        # # # print "FILL CONFIELDDATA 3D"
        # # # print "self.dim=",self.dim

        self.conArray = vtk.vtkDoubleArray()
        self.conArray.SetName("concentration")
        self.conArray.SetNumberOfValues((self.dim[2]+2)*(self.dim[1]+2)*(self.dim[0]+2))

        self.cellTypeCon=vtk.vtkIntArray()
        self.cellTypeCon.SetName("concelltype")
        self.cellTypeCon.SetNumberOfValues((self.dim[2]+2)*(self.dim[1]+2)*(self.dim[0]+2))
        
        offset=0        
        # # For some reasons the points x=0 are eaten up (don't know why).
        # # So we just populate empty cellIds.
        # for i in range(self.dim[0]+1):
            # self.conArray.SetValue(offset, 0.0)    
            # offset += 1
        
        
        maxCon = float(_conField.get(pt)) # concentration at pt=0,0,0
        minCon = float(_conField.get(pt)) # concentration at pt=0,0,0
        
        con=0.0
        for k in range(self.dim[2]+2):
            for j in range(self.dim[1]+2):
                for i in range(self.dim[0]+2):                
                
                    if i==0 or i ==self.dim[0]+1 or j==0 or j ==self.dim[1]+1 or k==0 or k ==self.dim[2]+1:
                        con=0.0
                        self.conArray.SetValue(offset, con)
                        type=0
                        self.cellTypeCon.SetValue(offset,type)
                    else:
                        pt.x = i-1
                        pt.y = j-1
                        pt.z = k-1
                        
                        # con = float(_conField.get(pt))
                        # con = float((self.dim[1]-pt.y)*(self.dim[0]-pt.x))
                        con = float(pt.y*pt.x)
                        self.conArray.SetValue(offset, con)
                        
                        cell= _cellFieldG.get(pt)
                        
                        if cell is not None:
                     
                            type    = int(cell.type)
                            if type in self.invisibleCellTypes:
                                type=0
                        else:
                            type    = 0
                     
                        self.cellTypeCon.SetValue(offset,type)
                        
                        if maxCon < con:
                            maxCon = con
                        
                        if minCon > con:
                            minCon = con
                        
                    offset += 1
        
        return (minCon, maxCon)

    def initCellGlyphsActor3D(self, _glyphActor, _invisibleCellTypes):
        print MODULENAME,'  initCellGlyphsActor3D'
        print '    _invisibleCellTypes=', _invisibleCellTypes

        from PySteppables import CellList

        fieldDim=self.currentDrawingParameters.bsd.fieldDim
        sim = self.currentDrawingParameters.bsd.sim
        if (sim == None):
          print 'MVCDrawModel3D.py: initCellGlyphsActor3D(),  sim is empty'
          return

        cellField = self.currentDrawingParameters.bsd.sim.getPotts().getCellFieldG()
        inventory = self.currentDrawingParameters.bsd.sim.getPotts().getCellInventory()
        #print 'inventory=',type(inventory)  # = <class 'CompuCell.CellInventory'>
        cellList=CellList(inventory)
        centroidPoints = vtk.vtkPoints()
        cellTypes = vtk.vtkIntArray()
        cellTypes.SetName("CellTypes")

        cellVolumes = vtk.vtkIntArray()
        cellVolumes.SetName("CellVolumes")

        cellCount = 0
        offset = 1.0
        for cell in cellList:
          if cell.type in _invisibleCellTypes: continue   # skip invisible cell types

          #print 'cell.id=',cell.id  # = 2,3,4,...
          #print 'cell.type=',cell.type
          #print 'cell.volume=',cell.volume
          xmid = float(cell.xCM) / cell.volume + offset
          ymid = float(cell.yCM) / cell.volume + offset
          zmid = float(cell.zCM) / cell.volume + offset
#          if cellCount < 50:  print cellCount,' glyph x,y,z,vol=',xmid,ymid,zmid,cell.volume
#          if cell.volume > 1: print cellCount,' ** glyph x,y,z,vol=',xmid,ymid,zmid,cell.volume
          cellCount += 1
          centroidPoints.InsertNextPoint(xmid,ymid,zmid)
          cellTypes.InsertNextValue(cell.type)

          cellVolumes.InsertNextValue(cell.volume)

        centroidsPD = vtk.vtkPolyData()
        centroidsPD.SetPoints(centroidPoints)
        centroidsPD.GetPointData().SetScalars(cellTypes)

        centroidsPD.GetPointData().AddArray(cellVolumes)

        centroidGS = vtk.vtkSphereSource()
        centroidGS.SetThetaResolution(4)  # increase these values for a higher-res sphere glyph
        centroidGS.SetPhiResolution(4)

        centroidGlyph = vtk.vtkGlyph3D()
        centroidGlyph.SetInput(centroidsPD)
        centroidGlyph.SetSource(centroidGS.GetOutput())
        centroidGlyph.SetScaleFactor( 1.0 )   #rwh
        centroidGlyph.SetIndexModeToScalar()
        centroidGlyph.SetRange(0,7)

        centroidGlyph.SetColorModeToColorByScalar()
        centroidGlyph.SetScaleModeToScaleByScalar()
        centroidGlyph.SetScaleModeToDataScalingOff()

        centroidGlyph.SetInputArrayToProcess(3,0,0,0,"CellTypes")
        centroidGlyph.SetInputArrayToProcess(0,0,0,0,"CellVolumes")

        self.cellGlyphsMapper.SetInput(centroidGlyph.GetOutput())
        self.cellGlyphsMapper.SetScalarRange(0,7)
        self.cellGlyphsMapper.ScalarVisibilityOn()
        self.cellGlyphsMapper.SetLookupTable(self.clut)
        print ' usedCellTypesList=' ,self.usedCellTypesList

#        self.cellGlyphsMapper.SetLookupTable(self.usedCellTypesList)
#        GetTableValue(self.usedCellTypesList[actorCounter])[0:3])
        
        #_actors[0].SetMapper(self.cellGlyphsMapper)
        _glyphActor.SetMapper(self.cellGlyphsMapper)

#---------------------------------------------------------------------------
    # Note: this method only handles periodicity in x & y, not z (Abbas-model specific :)
    def initFPPLinksActor3D(self, _fppActor, _invisibleCellTypes):
#        print MODULENAME,'  initFPPLinksActor3D'

        from PySteppables import CellList, FocalPointPlasticityDataList
        import CompuCell
        
        fppPlugin = CompuCell.getFocalPointPlasticityPlugin()
#        print '    initFPPLinksActor3D:  fppPlugin=',fppPlugin
        if (fppPlugin == 0):  # bogus check
          print '    fppPlugin is null, returning'
          return

        fieldDim=self.currentDrawingParameters.bsd.fieldDim
        print 'fieldDim, fieldDim.x =',fieldDim,fieldDim.x
        xdim = fieldDim.x
        ydim = fieldDim.y
        cellField = self.currentDrawingParameters.bsd.sim.getPotts().getCellFieldG()
        inventory = self.currentDrawingParameters.bsd.sim.getPotts().getCellInventory()
        #print 'inventory=',type(inventory)  # = <class 'CompuCell.CellInventory'>
        cellList=CellList(inventory)
        
        points = vtk.vtkPoints()
        lines = vtk.vtkCellArray()
        colorScalars = vtk.vtkFloatArray()
        colorScalars.SetName("fpp_scalar")

#        cellTypes = vtk.vtkIntArray()
#        cellTypes.SetName("CellTypes")
#        cellVolumes = vtk.vtkIntArray()
#        cellVolumes.SetName("CellVolumes")

        beginPt = 0
#        numCells = sum(1 for _ in cellList)
#        print MODULENAME,'  numCell=',numCells
        offset = 1.0
        lineNum = 0
        scalarValMin = 1000.0
        scalarValMax = -scalarValMin

        for cell in cellList:
          if cell.type in _invisibleCellTypes: continue   # skip invisible cell types

#          print MODULENAME,'--cell (addr) = ',cell
          #print 'cell.id=',cell.id  # = 2,3,4,...
          #print 'cell.type=',cell.type
          #print 'cell.volume=',cell.volume
          vol = cell.volume
          xmid0 = float(cell.xCM) / vol + offset
          ymid0 = float(cell.yCM) / vol + offset
          zmid0 = float(cell.zCM) / vol + offset
#          print 'cell.id=',cell.id,'  x,y,z (begin)=',xmid0,ymid0,zmid0
          points.InsertNextPoint(xmid0,ymid0,zmid0)
          
          endPt = beginPt + 1
          for fppd in FocalPointPlasticityDataList(fppPlugin, cell):
#            print '   nbrId=',fppd.neighborAddress.id
#           if beginPt < 10:  
#             print 'targetDistance,maxDistance=',fppd.targetDistance,fppd.maxDistance
#targetDistance,maxDistance= 3.0 6.0
#targetDistance,maxDistance= 2.0 4.0
            vol = fppd.neighborAddress.volume
            xmid=float(fppd.neighborAddress.xCM) / vol + offset
            ymid=float(fppd.neighborAddress.yCM) / vol + offset
            zmid=float(fppd.neighborAddress.zCM) / vol + offset
#            print '    x,y,z (end)=',xmid,ymid,zmid
#            points.InsertNextPoint(xmid,ymid,zmid)
            xdiff = xmid-xmid0
            ydiff = ymid-ymid0
            zdiff = zmid-zmid0
#            d2 = math.sqrt((xdiff*xdiff)+(ydiff*ydiff)+(zdiff*zdiff)  # compute dist^2 and avoid sqrt
            actualDist = math.sqrt((xdiff*xdiff)+(ydiff*ydiff)+(zdiff*zdiff))  
#            if beginPt < 10:  
#              print beginPt,')----- actualDist, maxDist= ',actualDist, fppd.maxDistance
#            if d2 > fppd.maxDistance*fppd.maxDistance:   # implies we have wraparound (via periodic BCs)
            if actualDist  > fppd.maxDistance:   # implies we have wraparound (via periodic BCs)
#                print '>>>>>> wraparound w/ beginPt=',beginPt
                # add dangling "out" line to beginning cell
                zmid0end = zmid0 
                if abs(xdiff) > abs(ydiff):   # wraps around in x-direction
#                    print '>>>>>> wraparound X'
                    if xdiff < 0:
                      xmid0end = xmid0 + 3.0
                    else:
                      xmid0end = xmid0 - 3.0
                    ymid0end = ymid0
                    points.InsertNextPoint(xmid0end,ymid0end,zmid0end)
                    lines.InsertNextCell(2)  # our line has 2 points
                    lines.InsertCellPoint(beginPt)
                    lines.InsertCellPoint(endPt)

                    # coloring the FPP links
                    actualDist = xdim - actualDist   # compute (approximate) real actualDist
#                    targetDist2 = fppd.targetDistance * fppd.targetDistance   # targetDist^2
#                    scalarVal = d2/targetDist2    # actual^2/target^2
                    scalarVal = actualDist / fppd.targetDistance    # actual/target
#                    scalarVal = actualDist 
                    if scalarVal < scalarValMin: scalarValMin = scalarVal
                    if scalarVal > scalarValMax: scalarValMax = scalarVal
#                    colorScalars.SetValue(lineNum, scalarVal)
                    colorScalars.InsertNextValue(scalarVal)
                    lineNum += 1

                    endPt += 1
                else:   # wraps around in y-direction
#                    print '>>>>>> wraparound Y'
                    xmid0end = xmid0
                    if ydiff < 0:
                      ymid0end = ymid0 + 3.0
                    else:
                      ymid0end = ymid0 - 3.0
                    points.InsertNextPoint(xmid0end,ymid0end,zmid0end)
                    lines.InsertNextCell(2)  # our line has 2 points
                    lines.InsertCellPoint(beginPt)
                    lines.InsertCellPoint(endPt)

                    # coloring the FPP links
                    actualDist = ydim - actualDist   # compute (approximate) real actualDist
#                    targetDist2 = fppd.targetDistance * fppd.targetDistance   # targetDist^2
#                    scalarVal = d2/targetDist2    # actual^2/target^2
                    scalarVal = actualDist / fppd.targetDistance    # actual/target
#                    scalarVal = actualDist 
                    if scalarVal < scalarValMin: scalarValMin = scalarVal
                    if scalarVal > scalarValMax: scalarValMax = scalarVal
                    colorScalars.InsertNextValue(scalarVal)
                    lineNum += 1

                    endPt += 1

                    # add dangling "in" line to end cell
#                    beginPt = endPt 
#                    lines.InsertNextCell(2)  # our line has 2 points
#                    lines.InsertCellPoint(beginPt)
#                    lines.InsertCellPoint(endPt)


            else:   # link didn't wrap around on lattice
#                print '>>> No wraparound'
                points.InsertNextPoint(xmid,ymid,zmid)
                lines.InsertNextCell(2)  # our line has 2 points
#                print beginPt,' -----> ',endPt
                lines.InsertCellPoint(beginPt)
                lines.InsertCellPoint(endPt)

                # coloring the FPP links
#                targetDist2 = fppd.targetDistance * fppd.targetDistance   # targetDist^2
#                scalarVal = d2/targetDist2    # actual^2/target^2
                scalarVal = actualDist / fppd.targetDistance    # actual/target
#                scalarVal = actualDist 
                if scalarVal < scalarValMin: scalarValMin = scalarVal
                if scalarVal > scalarValMax: scalarValMax = scalarVal
                colorScalars.InsertNextValue(scalarVal)
                lineNum += 1

                endPt += 1

          beginPt = endPt  # update point index 
            

        # create Blue-Red LUT
        lutBlueRed = vtk.vtkLookupTable()
        lutBlueRed.SetHueRange(0.667,0.0)
        lutBlueRed.Build()

        print '---------- # links,scalarValMin,Max =',lineNum,scalarValMin,scalarValMax
        FPPLinksPD = vtk.vtkPolyData()
        FPPLinksPD.SetPoints(points)
        FPPLinksPD.SetLines(lines)

        FPPLinksPD.Update()
        FPPLinksPD.GetCellData().SetScalars(colorScalars)
        
        self.FPPLinksMapper.SetInput(FPPLinksPD)

        self.FPPLinksMapper.SetScalarModeToUseCellFieldData()
        self.FPPLinksMapper.SelectColorArray("fpp_scalar")
        self.FPPLinksMapper.SetScalarRange(scalarValMin,scalarValMax)

        self.FPPLinksMapper.SetLookupTable(lutBlueRed)
        
        _fppActor.SetMapper(self.FPPLinksMapper)

        scalarBar = vtk.vtkScalarBarActor()
        scalarBar.SetLookupTable(lutBlueRed)
        #scalarBar.SetTitle("Stress")
        scalarBar.GetPositionCoordinate().SetCoordinateSystemToNormalizedViewport()
        #scalarBar.GetPositionCoordinate().SetValue(0.8,0.05)
        scalarBar.SetOrientationToVertical()
        scalarBar.SetWidth(0.1)
        scalarBar.SetHeight(0.9)
        scalarBar.SetPosition(0.88,0.1)
        #scalarBar.SetLabelFormat("%-#6.3f")
        scalarBar.SetLabelFormat("%-#3.1f")
        scalarBar.GetLabelTextProperty().SetColor(1,1,1)
        #scalarBar.GetTitleTextProperty().SetColor(1,0,0)

#        self.graphicsFrameWidget.ren.AddActor2D(scalarBar)    

    def configsChanged(self):
        self.populateLookupTable()
        #reassign which types are invisible        
        self.set3DInvisibleTypes()
        self.parentWidget.requestRedraw()
