from PyQt4.QtCore import *
from PyQt4.QtGui import *

from Ui_VectorFieldPage import Ui_VectorFieldPage
from ConfigurationPageBase import ConfigurationPageBase
import Configuration

class VectorFieldPage(ConfigurationPageBase, Ui_VectorFieldPage):
    """
    Class implementing the Vector Field Plot configuration page.
    """
    def __init__(self):
        """
        Constructor
        """
        QWidget.__init__(self)
        self.setupUi(self)
        self.setObjectName("VectorFieldPage")
        self.vector = {}
        self.vector["ArrowColor"]                   = self.initColor("ArrowColor", self.arrowColorButton, Configuration.getVectorField)
        self.vector["ArrowLength"]                  = Configuration.getVectorField("ArrowLength")
        self.vector["FixedArrowColorFlag"]          = Configuration.getVectorField("FixedArrowColorFlag")
        self.vector["LegendEnableVector"]           = Configuration.getVectorField("LegendEnableVector")
        self.vector["ScaleArrows"]                  = Configuration.getVectorField("ScaleArrows")
        self.vector["NumberAccuracyVector"]         = Configuration.getVectorField("NumberAccuracyVector")
        self.vector["NumberOfLegendBoxesVector"]    = Configuration.getVectorField("NumberOfLegendBoxesVector")
        self.vector["OverlayVectorCellFields"]      = Configuration.getVectorField("OverlayVectorCellFields")
        self.vector["MaxMagnitude"]                 = Configuration.getVectorField("MaxMagnitude")
        self.vector["MaxMagnitudeFixed"]            = Configuration.getVectorField("MaxMagnitudeFixed")
        self.vector["MinMagnitude"]                 = Configuration.getVectorField("MinMagnitude")
        self.vector["MinMagnitudeFixed"]            = Configuration.getVectorField("MinMagnitudeFixed")

        self.setSettings()
        self.setConnects()

    def setSettings(self):
        # Set validator for self.minLineEdit
        minConValid = QIntValidator(self.minLineEdit)
        minConValid.setBottom(0)
        self.minLineEdit.setValidator(minConValid)
        
        # Set validator for self.maxLineEdit
        maxConValid = QIntValidator(self.maxLineEdit)
        maxConValid.setBottom(0)
        self.maxLineEdit.setValidator(maxConValid)
        
        # Set bottom values for spin boxes
        self.boxSpinBox.setMinimum(0)
        self.accuracySpinBox.setMinimum(0)
        
        self.minLineEdit    .setText(str(self.vector["MinMagnitude"]))        
        self.minFixedBox    .setChecked(self.vector["MinMagnitudeFixed"])
        self.maxLineEdit    .setText(str(self.vector["MaxMagnitude"]))
        self.maxFixedBox    .setChecked(self.vector["MaxMagnitudeFixed"])
        self.boxSpinBox     .setValue(self.vector["NumberOfLegendBoxesVector"])
        self.accuracySpinBox.setValue(self.vector["NumberAccuracyVector"])
        self.showLegendBox  .setChecked(self.vector["LegendEnableVector"])
        self.arrowLengthSpinBox         .setValue(self.vector["ArrowLength"]) 
        self.scaleArrowsCheckBox        .setChecked(self.vector["ScaleArrows"])
        self.fixedArrowColorCheckBox    .setChecked(self.vector["FixedArrowColorFlag"])
        self.overlayCheckBox            .setChecked(self.vector["OverlayVectorCellFields"])
    
    def setConnects(self):
        self.connect(self.minLineEdit,      SIGNAL("textChanged(QString)"), self.minMagnitudeChanged)
        self.connect(self.minFixedBox,      SIGNAL("stateChanged(int)"),    self.minFixedChanged)
        self.connect(self.maxLineEdit,      SIGNAL("textChanged(QString)"), self.maxMagnitudeChanged)     
        self.connect(self.maxFixedBox,      SIGNAL("stateChanged(int)"),    self.maxFixedChanged)
        self.connect(self.boxSpinBox,       SIGNAL("valueChanged(int)"),    self.legendBoxChanged)
        self.connect(self.accuracySpinBox,  SIGNAL("valueChanged(int)"),    self.accuracyChanged)
        self.connect(self.showLegendBox,    SIGNAL("stateChanged(int)"),    self.showLegendChanged)
        self.connect(self.arrowLengthSpinBox,       SIGNAL("valueChanged(int)"),    self.arrowLengthChanged)
        self.connect(self.scaleArrowsCheckBox,      SIGNAL("stateChanged(int)"),    self.scaleArrowsChanged)
        self.connect(self.fixedArrowColorCheckBox,  SIGNAL("stateChanged(int)"),    self.fixedArrowColorChanged)
        self.connect(self.overlayCheckBox,          SIGNAL("stateChanged(int)"),    self.overlayChanged)
        self.connect(self.arrowColorButton,         SIGNAL("clicked(bool)"),    self.arrowColorChanged)


    def minMagnitudeChanged(self):
        self.vector["MinMagnitude"]       = self.minLineEdit.text()

    def minFixedChanged(self):
        self.vector["MinMagnitudeFixed"]  = self.minFixedBox.isChecked()
         
    def maxMagnitudeChanged(self):
        self.vector["MaxMagnitude"]       = self.maxLineEdit.text()
        
    def maxFixedChanged(self):
        self.vector["MaxMagnitudeFixed"]  = self.maxFixedBox.isChecked()
        
    def legendBoxChanged(self):
        self.vector["NumberOfLegendBoxesVector"] = self.boxSpinBox.value()
        
    def accuracyChanged(self):
        self.vector["NumberAccuracyVector"]      = self.accuracySpinBox.value()
        
    def showLegendChanged(self):
        self.vector["LegendEnableVector"]        = self.showLegendBox.isChecked()

    def arrowLengthChanged(self):
        self.vector["ArrowLength"]          = self.arrowLengthSpinBox.value()
    
    def scaleArrowsChanged(self):
        self.vector["ScaleArrows"]          = self.scaleArrowsCheckBox.isChecked()
    
    def fixedArrowColorChanged(self):
        self.vector["FixedArrowColorFlag"]  = self.fixedArrowColorCheckBox.isChecked()
    
    def overlayChanged(self):
        self.vector["OverlayVectorCellFields"]  = self.overlayCheckBox .isChecked()
    
    def arrowColorChanged(self):
        self.vector["ArrowColor"]           = self.selectColor(self.arrowColorButton, self.vector["ArrowColor"])
        
    def save(self):
        """
        Public slot to save the OutputFrequency configuration.
        """
        for key in self.vector.keys():
            Configuration.setVectorField(key, self.vector[key])
        
def create(dlg):
    """
    Module function to create the configuration page.
    
    @param dlg reference to the configuration dialog
    """
    return VectorFieldPage()
